// MIT License
//
// Copyright (c) 2021-2022 Bosch Rexroth AG
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Code generated by vfsgen; DO NOT EDIT.

package datalayer

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"
	"os"
	pathpkg "path"
	"time"
)

// bfbsFS implements statically the virtual filesystem provided to vfsgen.
var bfbsFS = func() http.FileSystem {
	fs := vfsgen۰FS{
		"/": &vfsgen۰DirInfo{
			name:    "/",
			modTime: time.Date(2021, 3, 13, 14, 17, 57, 495595100, time.UTC),
		},
		"/sub_properties.bfbs": &vfsgen۰CompressedFileInfo{
			name:             "sub_properties.bfbs",
			modTime:          time.Date(2021, 3, 3, 12, 39, 58, 0, time.UTC),
			uncompressedSize: 2312,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x02\xff\x84\x55\x3b\x6c\x1c\x55\x14\x3d\xb3\xbb\xde\x1d\x9c\x89\x3d\x44\xa3\xb0\x84\x05\x52\x04\x11\x45\x28\x72\x91\x92\x22\xda\x90\x28\x48\x91\x63\xb4\x56\x44\x81\x44\xc6\x9e\x87\x3d\x62\x76\x76\x99\xcf\x46\x46\x88\x82\x8a\x22\x65\x0a\x0a\x2a\xea\x14\x88\x2a\x35\x42\x88\x82\x82\x22\x15\x45\x8a\x28\x42\x16\x15\xa5\xf3\xf1\x5e\x74\xdf\xbb\x33\xfb\xec\x5d\x48\x22\xd9\x9e\x99\x77\xee\x3d\xe7\x7e\xce\xeb\x02\xe8\x5f\xeb\x0f\x7c\xf4\xd0\x82\x0b\x0f\x3e\x02\x74\xe1\x03\x78\x1f\xc0\x79\x00\x3d\x40\x3f\xdf\x6b\x02\x2d\x2c\xfe\xd7\x04\xf0\xc4\x01\x2e\x01\xf8\xb1\x01\x74\x00\x04\x6d\xe0\xfe\x12\xb0\xdf\x06\x0e\x5a\xc0\x66\x07\x08\x5c\xe0\x46\x13\xf0\x10\xe8\x6c\x1d\xf8\xf0\x4c\x08\x87\xb1\x01\x4c\x8e\x6f\x0e\x88\xf8\x9d\x03\xa0\x0d\x20\xe1\xd8\x0e\xf0\x0f\x80\xfb\x00\x6e\x03\x38\x07\xe0\x75\x00\xdb\xa3\xe1\xf0\x62\x14\x16\x61\x12\xee\xa9\xec\xe2\x46\x36\x1a\xab\xac\x88\x55\x0e\xe0\x2e\x11\xf1\xb9\x73\x4b\x46\xc3\x92\xc5\xf9\x2f\x93\x63\x95\x73\xb8\x00\xae\x8c\xca\xb4\x88\xd3\x1d\xfe\xf6\x8b\xe0\x36\x04\x67\xeb\x7e\xeb\xa9\xc1\xf1\xdf\xcc\xfd\xca\x6e\x98\xee\xa8\xab\x13\x95\x16\xb9\x79\xc7\xb5\xf4\xb5\x3e\x4f\x78\x3e\x91\x38\x4d\x2b\xce\x67\x12\xa7\x21\xf5\xfd\x20\x2c\x42\x13\xeb\x5a\x9c\x14\x2a\xe3\x33\xbf\x13\xd1\x59\x00\xdd\xb6\xc9\xd5\x10\xec\x0f\x82\x6d\x09\xf7\x8f\x4a\x55\x2a\xe1\xee\xa1\x7b\x24\x3f\xe3\xbf\x17\xbc\x23\xf8\xc7\x82\x5f\x12\xfc\x20\x1c\x8e\x13\xc1\x7f\x3b\x25\xf2\x44\xf3\x57\x53\x22\xfe\xbd\x7e\x73\xfd\x2a\x7f\x7b\xf0\x94\xe8\xbc\xd5\xa7\x0b\xcf\x74\x9c\x4e\x35\x03\xdf\x01\xd8\x05\xf0\x9e\xe4\x3d\xd6\x9b\x99\xc4\xcd\x2c\xde\xd9\x31\x1a\x2f\x11\x51\x57\x6a\xd0\xb0\xea\x73\x30\x25\xe2\x3c\x83\x22\x2c\xca\xfc\x56\x98\x94\x6a\x33\x1e\xaa\xbc\x08\x87\x63\xfe\x9e\x58\x38\xc7\xc2\xad\x11\xd1\x89\xa3\x38\x7c\x42\x33\x4d\x1b\x44\xd4\xae\xbf\x03\x77\x9f\x99\x5e\x57\x9a\xa6\xa2\xa9\x21\x7c\x0a\x98\xb9\x7e\x73\x5e\x8f\x2e\x7b\x5f\xed\x86\x93\x78\x54\x66\x75\xed\x3d\x5d\x55\xfe\xb9\x88\xdf\x1f\x44\x74\x92\xfb\x1d\xe7\xdb\x61\x16\xad\xab\x3b\x2a\x2f\x34\xd6\x93\x39\x33\x58\x5f\x7a\xd3\xd2\xff\x01\x0b\x73\x33\x89\x0c\xe6\xfa\x73\xc3\xdd\x95\x1c\xdc\xcf\x1b\xdc\x03\x07\x08\x1c\xe0\x37\xde\x01\x00\xef\xcc\x73\x1f\x94\x5b\xf9\x76\x16\x8f\x8b\x78\x94\x5a\x3b\xb3\x82\xae\xce\xdf\x42\x1b\x3e\x56\x74\x7e\x4f\xeb\xd0\x9c\xde\x35\x1a\x6e\x3d\xd7\x35\x72\x99\x93\xca\xb2\x51\xf6\x61\x5a\xa8\x6c\x12\x26\xda\x2f\x4e\x6b\x1f\x71\xb1\x7c\xcc\x25\x3a\xda\x4b\x98\x6a\x13\xcb\x7a\x3e\x7c\xfd\xb8\x0c\x0f\x6d\x74\x6a\xc4\xca\x6a\x53\xb4\x64\x65\xa2\xf7\xf8\x57\x22\x6a\xc0\xad\xbd\x68\xdf\x5a\xa4\xc7\xc2\x85\x17\x72\x5c\x6e\x25\x71\xbe\x6b\xb1\x59\x41\xef\x98\x1e\x07\xed\x3a\xce\xed\xbf\x67\x71\x2e\xbc\x30\x71\x5e\x05\xf0\xb9\x52\xe3\x30\x89\x27\xca\x8a\x14\xc8\x4e\x19\x47\x82\x66\x18\x68\x35\xad\xda\x23\x52\x13\xe3\x24\xcf\x4d\x1c\x01\xfb\x2f\xcc\x8c\x56\xfd\xe1\xf7\x97\x65\x47\x5e\xfb\x4f\xef\xda\x43\x0f\xc1\x4b\x6b\xc8\x3a\xaa\x99\xfd\xe9\x50\xe7\xf5\x1d\x79\xe6\xba\xf1\xa1\x8f\xa7\xfc\xbe\x55\x9f\xfb\xf3\x70\xe6\xab\xaf\xc8\xb9\x4f\x8b\xbd\x31\x1f\xbe\x77\x68\xf6\xad\xe2\xea\xc8\x0e\x2f\xe0\x59\x5b\xe5\x03\x89\x5f\xeb\x37\xf1\x1b\xa7\x34\xa6\x4c\x0b\x7b\xca\x72\xe0\xe0\x90\xa8\x67\xe5\xe0\x36\x46\x72\xcf\xf0\x9c\xbe\xb1\x20\x97\x6d\xaf\x0f\x65\x0e\xaa\x7c\x8f\x24\x1f\xf7\x75\xa8\x8a\x30\xaa\x0d\x06\x52\x3f\xd3\x79\x4f\xfa\x5e\xe1\x4e\x4f\x0d\x8e\x9f\xb7\xb2\xd1\x9d\x5c\x25\x71\x5e\x54\x48\xe0\x91\xe8\xea\xe1\xa8\x6f\x9e\xa1\x99\xdf\xb1\xc7\x4c\xd8\x5d\x04\xf6\x70\x3a\x5f\x3f\xf6\x8d\xb7\xff\xcf\x07\xc5\xea\x3d\x6b\xb6\xcc\x7d\x38\xab\xe9\xcf\x86\xeb\x09\xde\xb5\x48\x85\x51\x3f\x4c\x23\xe3\x6a\xc0\x75\x9a\x9f\xaf\x35\xde\x83\xc5\x7d\xab\xaf\x09\x0f\xa7\xe6\x6a\x73\x74\x1f\x3b\x3a\xaa\x4c\x9f\xf6\x42\x9e\x97\xad\xda\xeb\x2a\x9f\x40\xbd\x57\xcc\xb6\xf2\x89\x6a\x6a\xbf\x36\xf5\x72\x19\xfb\x05\x27\x1f\xc4\x5f\x2a\x98\xde\xb4\x34\x6b\x73\x47\x1d\xaf\xdb\xda\x62\xfe\xd6\x35\xb5\x82\x33\x0b\xf2\x9f\x95\x58\x97\xfb\xab\xc2\xa0\x0d\x17\x9d\x6a\x63\x97\x59\x5f\x2e\x41\xac\xd5\xc6\xbf\x01\x00\x00\xff\xff\x5a\x37\x17\x6b\x08\x09\x00\x00"),
		},
	}
	fs["/"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/sub_properties.bfbs"].(os.FileInfo),
	}

	return fs
}()

type vfsgen۰FS map[string]interface{}

func (fs vfsgen۰FS) Open(path string) (http.File, error) {
	path = pathpkg.Clean("/" + path)
	f, ok := fs[path]
	if !ok {
		return nil, &os.PathError{Op: "open", Path: path, Err: os.ErrNotExist}
	}

	switch f := f.(type) {
	case *vfsgen۰CompressedFileInfo:
		gr, err := gzip.NewReader(bytes.NewReader(f.compressedContent))
		if err != nil {
			// This should never happen because we generate the gzip bytes such that they are always valid.
			panic("unexpected error reading own gzip compressed bytes: " + err.Error())
		}
		return &vfsgen۰CompressedFile{
			vfsgen۰CompressedFileInfo: f,
			gr:                        gr,
		}, nil
	case *vfsgen۰DirInfo:
		return &vfsgen۰Dir{
			vfsgen۰DirInfo: f,
		}, nil
	default:
		// This should never happen because we generate only the above types.
		panic(fmt.Sprintf("unexpected type %T", f))
	}
}

// vfsgen۰CompressedFileInfo is a static definition of a gzip compressed file.
type vfsgen۰CompressedFileInfo struct {
	name              string
	modTime           time.Time
	compressedContent []byte
	uncompressedSize  int64
}

func (f *vfsgen۰CompressedFileInfo) Readdir(count int) ([]os.FileInfo, error) {
	return nil, fmt.Errorf("cannot Readdir from file %s", f.name)
}
func (f *vfsgen۰CompressedFileInfo) Stat() (os.FileInfo, error) { return f, nil }

func (f *vfsgen۰CompressedFileInfo) GzipBytes() []byte {
	return f.compressedContent
}

func (f *vfsgen۰CompressedFileInfo) Name() string       { return f.name }
func (f *vfsgen۰CompressedFileInfo) Size() int64        { return f.uncompressedSize }
func (f *vfsgen۰CompressedFileInfo) Mode() os.FileMode  { return 0444 }
func (f *vfsgen۰CompressedFileInfo) ModTime() time.Time { return f.modTime }
func (f *vfsgen۰CompressedFileInfo) IsDir() bool        { return false }
func (f *vfsgen۰CompressedFileInfo) Sys() interface{}   { return nil }

// vfsgen۰CompressedFile is an opened compressedFile instance.
type vfsgen۰CompressedFile struct {
	*vfsgen۰CompressedFileInfo
	gr      *gzip.Reader
	grPos   int64 // Actual gr uncompressed position.
	seekPos int64 // Seek uncompressed position.
}

func (f *vfsgen۰CompressedFile) Read(p []byte) (n int, err error) {
	if f.grPos > f.seekPos {
		// Rewind to beginning.
		err = f.gr.Reset(bytes.NewReader(f.compressedContent))
		if err != nil {
			return 0, err
		}
		f.grPos = 0
	}
	if f.grPos < f.seekPos {
		// Fast-forward.
		_, err = io.CopyN(ioutil.Discard, f.gr, f.seekPos-f.grPos)
		if err != nil {
			return 0, err
		}
		f.grPos = f.seekPos
	}
	n, err = f.gr.Read(p)
	f.grPos += int64(n)
	f.seekPos = f.grPos
	return n, err
}
func (f *vfsgen۰CompressedFile) Seek(offset int64, whence int) (int64, error) {
	switch whence {
	case io.SeekStart:
		f.seekPos = 0 + offset
	case io.SeekCurrent:
		f.seekPos += offset
	case io.SeekEnd:
		f.seekPos = f.uncompressedSize + offset
	default:
		panic(fmt.Errorf("invalid whence value: %v", whence))
	}
	return f.seekPos, nil
}
func (f *vfsgen۰CompressedFile) Close() error {
	return f.gr.Close()
}

// vfsgen۰DirInfo is a static definition of a directory.
type vfsgen۰DirInfo struct {
	name    string
	modTime time.Time
	entries []os.FileInfo
}

func (d *vfsgen۰DirInfo) Read([]byte) (int, error) {
	return 0, fmt.Errorf("cannot Read from directory %s", d.name)
}
func (d *vfsgen۰DirInfo) Close() error               { return nil }
func (d *vfsgen۰DirInfo) Stat() (os.FileInfo, error) { return d, nil }

func (d *vfsgen۰DirInfo) Name() string       { return d.name }
func (d *vfsgen۰DirInfo) Size() int64        { return 0 }
func (d *vfsgen۰DirInfo) Mode() os.FileMode  { return 0755 | os.ModeDir }
func (d *vfsgen۰DirInfo) ModTime() time.Time { return d.modTime }
func (d *vfsgen۰DirInfo) IsDir() bool        { return true }
func (d *vfsgen۰DirInfo) Sys() interface{}   { return nil }

// vfsgen۰Dir is an opened dir instance.
type vfsgen۰Dir struct {
	*vfsgen۰DirInfo
	pos int // Position within entries for Seek and Readdir.
}

func (d *vfsgen۰Dir) Seek(offset int64, whence int) (int64, error) {
	if offset == 0 && whence == io.SeekStart {
		d.pos = 0
		return 0, nil
	}
	return 0, fmt.Errorf("unsupported Seek in directory %s", d.name)
}

func (d *vfsgen۰Dir) Readdir(count int) ([]os.FileInfo, error) {
	if d.pos >= len(d.entries) && count > 0 {
		return nil, io.EOF
	}
	if count <= 0 || count > len(d.entries)-d.pos {
		count = len(d.entries) - d.pos
	}
	e := d.entries[d.pos : d.pos+count]
	d.pos += count
	return e, nil
}
