// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/datacatalog/v1/policytagmanager.proto

package datacatalogpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	PolicyTagManager_CreateTaxonomy_FullMethodName     = "/google.cloud.datacatalog.v1.PolicyTagManager/CreateTaxonomy"
	PolicyTagManager_DeleteTaxonomy_FullMethodName     = "/google.cloud.datacatalog.v1.PolicyTagManager/DeleteTaxonomy"
	PolicyTagManager_UpdateTaxonomy_FullMethodName     = "/google.cloud.datacatalog.v1.PolicyTagManager/UpdateTaxonomy"
	PolicyTagManager_ListTaxonomies_FullMethodName     = "/google.cloud.datacatalog.v1.PolicyTagManager/ListTaxonomies"
	PolicyTagManager_GetTaxonomy_FullMethodName        = "/google.cloud.datacatalog.v1.PolicyTagManager/GetTaxonomy"
	PolicyTagManager_CreatePolicyTag_FullMethodName    = "/google.cloud.datacatalog.v1.PolicyTagManager/CreatePolicyTag"
	PolicyTagManager_DeletePolicyTag_FullMethodName    = "/google.cloud.datacatalog.v1.PolicyTagManager/DeletePolicyTag"
	PolicyTagManager_UpdatePolicyTag_FullMethodName    = "/google.cloud.datacatalog.v1.PolicyTagManager/UpdatePolicyTag"
	PolicyTagManager_ListPolicyTags_FullMethodName     = "/google.cloud.datacatalog.v1.PolicyTagManager/ListPolicyTags"
	PolicyTagManager_GetPolicyTag_FullMethodName       = "/google.cloud.datacatalog.v1.PolicyTagManager/GetPolicyTag"
	PolicyTagManager_GetIamPolicy_FullMethodName       = "/google.cloud.datacatalog.v1.PolicyTagManager/GetIamPolicy"
	PolicyTagManager_SetIamPolicy_FullMethodName       = "/google.cloud.datacatalog.v1.PolicyTagManager/SetIamPolicy"
	PolicyTagManager_TestIamPermissions_FullMethodName = "/google.cloud.datacatalog.v1.PolicyTagManager/TestIamPermissions"
)

// PolicyTagManagerClient is the client API for PolicyTagManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PolicyTagManagerClient interface {
	// Creates a taxonomy in a specified project.
	//
	// The taxonomy is initially empty, that is, it doesn't contain policy tags.
	CreateTaxonomy(ctx context.Context, in *CreateTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error)
	// Deletes a taxonomy, including all policy tags in this
	// taxonomy, their associated policies, and the policy tags references from
	// BigQuery columns.
	DeleteTaxonomy(ctx context.Context, in *DeleteTaxonomyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a taxonomy, including its display name,
	// description, and activated policy types.
	UpdateTaxonomy(ctx context.Context, in *UpdateTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error)
	// Lists all taxonomies in a project in a particular location that you
	// have a permission to view.
	ListTaxonomies(ctx context.Context, in *ListTaxonomiesRequest, opts ...grpc.CallOption) (*ListTaxonomiesResponse, error)
	// Gets a taxonomy.
	GetTaxonomy(ctx context.Context, in *GetTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error)
	// Creates a policy tag in a taxonomy.
	CreatePolicyTag(ctx context.Context, in *CreatePolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error)
	// Deletes a policy tag together with the following:
	//
	//   - All of its descendant policy tags, if any
	//   - Policies associated with the policy tag and its descendants
	//   - References from BigQuery table schema of the policy tag and its
	//     descendants
	DeletePolicyTag(ctx context.Context, in *DeletePolicyTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a policy tag, including its display
	// name, description, and parent policy tag.
	UpdatePolicyTag(ctx context.Context, in *UpdatePolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error)
	// Lists all policy tags in a taxonomy.
	ListPolicyTags(ctx context.Context, in *ListPolicyTagsRequest, opts ...grpc.CallOption) (*ListPolicyTagsResponse, error)
	// Gets a policy tag.
	GetPolicyTag(ctx context.Context, in *GetPolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error)
	// Gets the IAM policy for a policy tag or a taxonomy.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the IAM policy for a policy tag or a taxonomy.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns your permissions on a specified policy tag or
	// taxonomy.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type policyTagManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewPolicyTagManagerClient(cc grpc.ClientConnInterface) PolicyTagManagerClient {
	return &policyTagManagerClient{cc}
}

func (c *policyTagManagerClient) CreateTaxonomy(ctx context.Context, in *CreateTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error) {
	out := new(Taxonomy)
	err := c.cc.Invoke(ctx, PolicyTagManager_CreateTaxonomy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) DeleteTaxonomy(ctx context.Context, in *DeleteTaxonomyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, PolicyTagManager_DeleteTaxonomy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) UpdateTaxonomy(ctx context.Context, in *UpdateTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error) {
	out := new(Taxonomy)
	err := c.cc.Invoke(ctx, PolicyTagManager_UpdateTaxonomy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) ListTaxonomies(ctx context.Context, in *ListTaxonomiesRequest, opts ...grpc.CallOption) (*ListTaxonomiesResponse, error) {
	out := new(ListTaxonomiesResponse)
	err := c.cc.Invoke(ctx, PolicyTagManager_ListTaxonomies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) GetTaxonomy(ctx context.Context, in *GetTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error) {
	out := new(Taxonomy)
	err := c.cc.Invoke(ctx, PolicyTagManager_GetTaxonomy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) CreatePolicyTag(ctx context.Context, in *CreatePolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error) {
	out := new(PolicyTag)
	err := c.cc.Invoke(ctx, PolicyTagManager_CreatePolicyTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) DeletePolicyTag(ctx context.Context, in *DeletePolicyTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, PolicyTagManager_DeletePolicyTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) UpdatePolicyTag(ctx context.Context, in *UpdatePolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error) {
	out := new(PolicyTag)
	err := c.cc.Invoke(ctx, PolicyTagManager_UpdatePolicyTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) ListPolicyTags(ctx context.Context, in *ListPolicyTagsRequest, opts ...grpc.CallOption) (*ListPolicyTagsResponse, error) {
	out := new(ListPolicyTagsResponse)
	err := c.cc.Invoke(ctx, PolicyTagManager_ListPolicyTags_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) GetPolicyTag(ctx context.Context, in *GetPolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error) {
	out := new(PolicyTag)
	err := c.cc.Invoke(ctx, PolicyTagManager_GetPolicyTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, PolicyTagManager_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, PolicyTagManager_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, PolicyTagManager_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PolicyTagManagerServer is the server API for PolicyTagManager service.
// All implementations should embed UnimplementedPolicyTagManagerServer
// for forward compatibility
type PolicyTagManagerServer interface {
	// Creates a taxonomy in a specified project.
	//
	// The taxonomy is initially empty, that is, it doesn't contain policy tags.
	CreateTaxonomy(context.Context, *CreateTaxonomyRequest) (*Taxonomy, error)
	// Deletes a taxonomy, including all policy tags in this
	// taxonomy, their associated policies, and the policy tags references from
	// BigQuery columns.
	DeleteTaxonomy(context.Context, *DeleteTaxonomyRequest) (*emptypb.Empty, error)
	// Updates a taxonomy, including its display name,
	// description, and activated policy types.
	UpdateTaxonomy(context.Context, *UpdateTaxonomyRequest) (*Taxonomy, error)
	// Lists all taxonomies in a project in a particular location that you
	// have a permission to view.
	ListTaxonomies(context.Context, *ListTaxonomiesRequest) (*ListTaxonomiesResponse, error)
	// Gets a taxonomy.
	GetTaxonomy(context.Context, *GetTaxonomyRequest) (*Taxonomy, error)
	// Creates a policy tag in a taxonomy.
	CreatePolicyTag(context.Context, *CreatePolicyTagRequest) (*PolicyTag, error)
	// Deletes a policy tag together with the following:
	//
	//   - All of its descendant policy tags, if any
	//   - Policies associated with the policy tag and its descendants
	//   - References from BigQuery table schema of the policy tag and its
	//     descendants
	DeletePolicyTag(context.Context, *DeletePolicyTagRequest) (*emptypb.Empty, error)
	// Updates a policy tag, including its display
	// name, description, and parent policy tag.
	UpdatePolicyTag(context.Context, *UpdatePolicyTagRequest) (*PolicyTag, error)
	// Lists all policy tags in a taxonomy.
	ListPolicyTags(context.Context, *ListPolicyTagsRequest) (*ListPolicyTagsResponse, error)
	// Gets a policy tag.
	GetPolicyTag(context.Context, *GetPolicyTagRequest) (*PolicyTag, error)
	// Gets the IAM policy for a policy tag or a taxonomy.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the IAM policy for a policy tag or a taxonomy.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns your permissions on a specified policy tag or
	// taxonomy.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedPolicyTagManagerServer should be embedded to have forward compatible implementations.
type UnimplementedPolicyTagManagerServer struct {
}

func (UnimplementedPolicyTagManagerServer) CreateTaxonomy(context.Context, *CreateTaxonomyRequest) (*Taxonomy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTaxonomy not implemented")
}
func (UnimplementedPolicyTagManagerServer) DeleteTaxonomy(context.Context, *DeleteTaxonomyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTaxonomy not implemented")
}
func (UnimplementedPolicyTagManagerServer) UpdateTaxonomy(context.Context, *UpdateTaxonomyRequest) (*Taxonomy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTaxonomy not implemented")
}
func (UnimplementedPolicyTagManagerServer) ListTaxonomies(context.Context, *ListTaxonomiesRequest) (*ListTaxonomiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTaxonomies not implemented")
}
func (UnimplementedPolicyTagManagerServer) GetTaxonomy(context.Context, *GetTaxonomyRequest) (*Taxonomy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTaxonomy not implemented")
}
func (UnimplementedPolicyTagManagerServer) CreatePolicyTag(context.Context, *CreatePolicyTagRequest) (*PolicyTag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePolicyTag not implemented")
}
func (UnimplementedPolicyTagManagerServer) DeletePolicyTag(context.Context, *DeletePolicyTagRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePolicyTag not implemented")
}
func (UnimplementedPolicyTagManagerServer) UpdatePolicyTag(context.Context, *UpdatePolicyTagRequest) (*PolicyTag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePolicyTag not implemented")
}
func (UnimplementedPolicyTagManagerServer) ListPolicyTags(context.Context, *ListPolicyTagsRequest) (*ListPolicyTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPolicyTags not implemented")
}
func (UnimplementedPolicyTagManagerServer) GetPolicyTag(context.Context, *GetPolicyTagRequest) (*PolicyTag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPolicyTag not implemented")
}
func (UnimplementedPolicyTagManagerServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedPolicyTagManagerServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedPolicyTagManagerServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafePolicyTagManagerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PolicyTagManagerServer will
// result in compilation errors.
type UnsafePolicyTagManagerServer interface {
	mustEmbedUnimplementedPolicyTagManagerServer()
}

func RegisterPolicyTagManagerServer(s grpc.ServiceRegistrar, srv PolicyTagManagerServer) {
	s.RegisterService(&PolicyTagManager_ServiceDesc, srv)
}

func _PolicyTagManager_CreateTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).CreateTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTagManager_CreateTaxonomy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).CreateTaxonomy(ctx, req.(*CreateTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_DeleteTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).DeleteTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTagManager_DeleteTaxonomy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).DeleteTaxonomy(ctx, req.(*DeleteTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_UpdateTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).UpdateTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTagManager_UpdateTaxonomy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).UpdateTaxonomy(ctx, req.(*UpdateTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_ListTaxonomies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTaxonomiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).ListTaxonomies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTagManager_ListTaxonomies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).ListTaxonomies(ctx, req.(*ListTaxonomiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_GetTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).GetTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTagManager_GetTaxonomy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).GetTaxonomy(ctx, req.(*GetTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_CreatePolicyTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePolicyTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).CreatePolicyTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTagManager_CreatePolicyTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).CreatePolicyTag(ctx, req.(*CreatePolicyTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_DeletePolicyTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePolicyTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).DeletePolicyTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTagManager_DeletePolicyTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).DeletePolicyTag(ctx, req.(*DeletePolicyTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_UpdatePolicyTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePolicyTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).UpdatePolicyTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTagManager_UpdatePolicyTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).UpdatePolicyTag(ctx, req.(*UpdatePolicyTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_ListPolicyTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPolicyTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).ListPolicyTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTagManager_ListPolicyTags_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).ListPolicyTags(ctx, req.(*ListPolicyTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_GetPolicyTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPolicyTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).GetPolicyTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTagManager_GetPolicyTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).GetPolicyTag(ctx, req.(*GetPolicyTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTagManager_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTagManager_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTagManager_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PolicyTagManager_ServiceDesc is the grpc.ServiceDesc for PolicyTagManager service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PolicyTagManager_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datacatalog.v1.PolicyTagManager",
	HandlerType: (*PolicyTagManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTaxonomy",
			Handler:    _PolicyTagManager_CreateTaxonomy_Handler,
		},
		{
			MethodName: "DeleteTaxonomy",
			Handler:    _PolicyTagManager_DeleteTaxonomy_Handler,
		},
		{
			MethodName: "UpdateTaxonomy",
			Handler:    _PolicyTagManager_UpdateTaxonomy_Handler,
		},
		{
			MethodName: "ListTaxonomies",
			Handler:    _PolicyTagManager_ListTaxonomies_Handler,
		},
		{
			MethodName: "GetTaxonomy",
			Handler:    _PolicyTagManager_GetTaxonomy_Handler,
		},
		{
			MethodName: "CreatePolicyTag",
			Handler:    _PolicyTagManager_CreatePolicyTag_Handler,
		},
		{
			MethodName: "DeletePolicyTag",
			Handler:    _PolicyTagManager_DeletePolicyTag_Handler,
		},
		{
			MethodName: "UpdatePolicyTag",
			Handler:    _PolicyTagManager_UpdatePolicyTag_Handler,
		},
		{
			MethodName: "ListPolicyTags",
			Handler:    _PolicyTagManager_ListPolicyTags_Handler,
		},
		{
			MethodName: "GetPolicyTag",
			Handler:    _PolicyTagManager_GetPolicyTag_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _PolicyTagManager_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _PolicyTagManager_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _PolicyTagManager_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datacatalog/v1/policytagmanager.proto",
}
