// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/datacatalog/v1beta1/datacatalog.proto

package datacatalogpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DataCatalog_SearchCatalog_FullMethodName                   = "/google.cloud.datacatalog.v1beta1.DataCatalog/SearchCatalog"
	DataCatalog_CreateEntryGroup_FullMethodName                = "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateEntryGroup"
	DataCatalog_UpdateEntryGroup_FullMethodName                = "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateEntryGroup"
	DataCatalog_GetEntryGroup_FullMethodName                   = "/google.cloud.datacatalog.v1beta1.DataCatalog/GetEntryGroup"
	DataCatalog_DeleteEntryGroup_FullMethodName                = "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteEntryGroup"
	DataCatalog_ListEntryGroups_FullMethodName                 = "/google.cloud.datacatalog.v1beta1.DataCatalog/ListEntryGroups"
	DataCatalog_CreateEntry_FullMethodName                     = "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateEntry"
	DataCatalog_UpdateEntry_FullMethodName                     = "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateEntry"
	DataCatalog_DeleteEntry_FullMethodName                     = "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteEntry"
	DataCatalog_GetEntry_FullMethodName                        = "/google.cloud.datacatalog.v1beta1.DataCatalog/GetEntry"
	DataCatalog_LookupEntry_FullMethodName                     = "/google.cloud.datacatalog.v1beta1.DataCatalog/LookupEntry"
	DataCatalog_ListEntries_FullMethodName                     = "/google.cloud.datacatalog.v1beta1.DataCatalog/ListEntries"
	DataCatalog_CreateTagTemplate_FullMethodName               = "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateTagTemplate"
	DataCatalog_GetTagTemplate_FullMethodName                  = "/google.cloud.datacatalog.v1beta1.DataCatalog/GetTagTemplate"
	DataCatalog_UpdateTagTemplate_FullMethodName               = "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateTagTemplate"
	DataCatalog_DeleteTagTemplate_FullMethodName               = "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteTagTemplate"
	DataCatalog_CreateTagTemplateField_FullMethodName          = "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateTagTemplateField"
	DataCatalog_UpdateTagTemplateField_FullMethodName          = "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateTagTemplateField"
	DataCatalog_RenameTagTemplateField_FullMethodName          = "/google.cloud.datacatalog.v1beta1.DataCatalog/RenameTagTemplateField"
	DataCatalog_RenameTagTemplateFieldEnumValue_FullMethodName = "/google.cloud.datacatalog.v1beta1.DataCatalog/RenameTagTemplateFieldEnumValue"
	DataCatalog_DeleteTagTemplateField_FullMethodName          = "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteTagTemplateField"
	DataCatalog_CreateTag_FullMethodName                       = "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateTag"
	DataCatalog_UpdateTag_FullMethodName                       = "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateTag"
	DataCatalog_DeleteTag_FullMethodName                       = "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteTag"
	DataCatalog_ListTags_FullMethodName                        = "/google.cloud.datacatalog.v1beta1.DataCatalog/ListTags"
	DataCatalog_SetIamPolicy_FullMethodName                    = "/google.cloud.datacatalog.v1beta1.DataCatalog/SetIamPolicy"
	DataCatalog_GetIamPolicy_FullMethodName                    = "/google.cloud.datacatalog.v1beta1.DataCatalog/GetIamPolicy"
	DataCatalog_TestIamPermissions_FullMethodName              = "/google.cloud.datacatalog.v1beta1.DataCatalog/TestIamPermissions"
)

// DataCatalogClient is the client API for DataCatalog service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Deprecated: Do not use.
type DataCatalogClient interface {
	// Deprecated: Do not use.
	// Searches Data Catalog for multiple resources like entries, tags that
	// match a query.
	//
	// This is a custom method
	// (https://cloud.google.com/apis/design/custom_methods) and does not return
	// the complete resource, only the resource identifier and high level
	// fields. Clients can subsequently call `Get` methods.
	//
	// Note that Data Catalog search queries do not guarantee full recall. Query
	// results that match your query may not be returned, even in subsequent
	// result pages. Also note that results returned (and not returned) can vary
	// across repeated search queries.
	//
	// See [Data Catalog Search
	// Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference)
	// for more information.
	SearchCatalog(ctx context.Context, in *SearchCatalogRequest, opts ...grpc.CallOption) (*SearchCatalogResponse, error)
	// Deprecated: Do not use.
	// A maximum of 10,000 entry groups may be created per organization across all
	// locations.
	//
	// Users should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Deprecated: Do not use.
	// Updates an EntryGroup. The user should enable the Data Catalog API in the
	// project identified by the `entry_group.name` parameter (see [Data Catalog
	// Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateEntryGroup(ctx context.Context, in *UpdateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Deprecated: Do not use.
	// Gets an EntryGroup.
	GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Deprecated: Do not use.
	// Deletes an EntryGroup. Only entry groups that do not contain entries can be
	// deleted. Users should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Lists entry groups.
	ListEntryGroups(ctx context.Context, in *ListEntryGroupsRequest, opts ...grpc.CallOption) (*ListEntryGroupsResponse, error)
	// Deprecated: Do not use.
	// Creates an entry. Only entries of 'FILESET' type or user-specified type can
	// be created.
	//
	// Users should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	//
	// A maximum of 100,000 entries may be created per entry group.
	CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Deprecated: Do not use.
	// Updates an existing entry.
	// Users should enable the Data Catalog API in the project identified by
	// the `entry.name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Deprecated: Do not use.
	// Deletes an existing entry. Only entries created through
	// [CreateEntry][google.cloud.datacatalog.v1beta1.DataCatalog.CreateEntry]
	// method can be deleted.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Gets an entry.
	GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Deprecated: Do not use.
	// Get an entry by target resource name. This method allows clients to use
	// the resource name from the source Google Cloud Platform service to get the
	// Data Catalog Entry.
	LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Deprecated: Do not use.
	// Lists entries.
	ListEntries(ctx context.Context, in *ListEntriesRequest, opts ...grpc.CallOption) (*ListEntriesResponse, error)
	// Deprecated: Do not use.
	// Creates a tag template. The user should enable the Data Catalog API in
	// the project identified by the `parent` parameter (see [Data Catalog
	// Resource
	// Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project)
	// for more information).
	CreateTagTemplate(ctx context.Context, in *CreateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Deprecated: Do not use.
	// Gets a tag template.
	GetTagTemplate(ctx context.Context, in *GetTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Deprecated: Do not use.
	// Updates a tag template. This method cannot be used to update the fields of
	// a template. The tag template fields are represented as separate resources
	// and should be updated using their own create/update/delete methods.
	// Users should enable the Data Catalog API in the project identified by
	// the `tag_template.name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateTagTemplate(ctx context.Context, in *UpdateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Deprecated: Do not use.
	// Deletes a tag template and all tags using the template.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteTagTemplate(ctx context.Context, in *DeleteTagTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Creates a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `parent` parameter (see
	// [Data Catalog Resource
	// Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project)
	// for more information).
	CreateTagTemplateField(ctx context.Context, in *CreateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Updates a field in a tag template. This method cannot be used to update the
	// field type. Users should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateTagTemplateField(ctx context.Context, in *UpdateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Renames a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `name` parameter (see [Data Catalog
	// Resource
	// Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project)
	// for more information).
	RenameTagTemplateField(ctx context.Context, in *RenameTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Renames an enum value in a tag template. The enum values have to be unique
	// within one enum field. Thus, an enum value cannot be renamed with a name
	// used in any other enum value within the same enum field.
	RenameTagTemplateFieldEnumValue(ctx context.Context, in *RenameTagTemplateFieldEnumValueRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Deletes a field in a tag template and all uses of that field.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteTagTemplateField(ctx context.Context, in *DeleteTagTemplateFieldRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Creates a tag on an [Entry][google.cloud.datacatalog.v1beta1.Entry].
	// Note: The project identified by the `parent` parameter for the
	// [tag](https://cloud.google.com/data-catalog/docs/reference/rest/v1beta1/projects.locations.entryGroups.entries.tags/create#path-parameters)
	// and the
	// [tag
	// template](https://cloud.google.com/data-catalog/docs/reference/rest/v1beta1/projects.locations.tagTemplates/create#path-parameters)
	// used to create the tag must be from the same organization.
	CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Deprecated: Do not use.
	// Updates an existing tag.
	UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Deprecated: Do not use.
	// Deletes a tag.
	DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Lists tags assigned to an [Entry][google.cloud.datacatalog.v1beta1.Entry].
	// The [columns][google.cloud.datacatalog.v1beta1.Tag.column] in the response
	// are lowercased.
	ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error)
	// Deprecated: Do not use.
	// Sets the access control policy for a resource. Replaces any existing
	// policy.
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	//
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
	//     templates.
	//   - `datacatalog.entries.setIamPolicy` to set policies on entries.
	//   - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Deprecated: Do not use.
	// Gets the access control policy for a resource. A `NOT_FOUND` error
	// is returned if the resource does not exist. An empty policy is returned
	// if the resource exists but does not have a policy set on it.
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	//
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
	//     templates.
	//   - `datacatalog.entries.getIamPolicy` to get policies on entries.
	//   - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Deprecated: Do not use.
	// Returns the caller's permissions on a resource.
	// If the resource does not exist, an empty set of permissions is returned
	// (We don't return a `NOT_FOUND` error).
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	//
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// A caller is not required to have Google IAM permission to make this
	// request.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type dataCatalogClient struct {
	cc grpc.ClientConnInterface
}

// Deprecated: Do not use.
func NewDataCatalogClient(cc grpc.ClientConnInterface) DataCatalogClient {
	return &dataCatalogClient{cc}
}

// Deprecated: Do not use.
func (c *dataCatalogClient) SearchCatalog(ctx context.Context, in *SearchCatalogRequest, opts ...grpc.CallOption) (*SearchCatalogResponse, error) {
	out := new(SearchCatalogResponse)
	err := c.cc.Invoke(ctx, DataCatalog_SearchCatalog_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, DataCatalog_CreateEntryGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) UpdateEntryGroup(ctx context.Context, in *UpdateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, DataCatalog_UpdateEntryGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, DataCatalog_GetEntryGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataCatalog_DeleteEntryGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) ListEntryGroups(ctx context.Context, in *ListEntryGroupsRequest, opts ...grpc.CallOption) (*ListEntryGroupsResponse, error) {
	out := new(ListEntryGroupsResponse)
	err := c.cc.Invoke(ctx, DataCatalog_ListEntryGroups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, DataCatalog_CreateEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, DataCatalog_UpdateEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataCatalog_DeleteEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, DataCatalog_GetEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, DataCatalog_LookupEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) ListEntries(ctx context.Context, in *ListEntriesRequest, opts ...grpc.CallOption) (*ListEntriesResponse, error) {
	out := new(ListEntriesResponse)
	err := c.cc.Invoke(ctx, DataCatalog_ListEntries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) CreateTagTemplate(ctx context.Context, in *CreateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, DataCatalog_CreateTagTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) GetTagTemplate(ctx context.Context, in *GetTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, DataCatalog_GetTagTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) UpdateTagTemplate(ctx context.Context, in *UpdateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, DataCatalog_UpdateTagTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) DeleteTagTemplate(ctx context.Context, in *DeleteTagTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataCatalog_DeleteTagTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) CreateTagTemplateField(ctx context.Context, in *CreateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, DataCatalog_CreateTagTemplateField_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) UpdateTagTemplateField(ctx context.Context, in *UpdateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, DataCatalog_UpdateTagTemplateField_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) RenameTagTemplateField(ctx context.Context, in *RenameTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, DataCatalog_RenameTagTemplateField_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) RenameTagTemplateFieldEnumValue(ctx context.Context, in *RenameTagTemplateFieldEnumValueRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, DataCatalog_RenameTagTemplateFieldEnumValue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) DeleteTagTemplateField(ctx context.Context, in *DeleteTagTemplateFieldRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataCatalog_DeleteTagTemplateField_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, DataCatalog_CreateTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, DataCatalog_UpdateTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataCatalog_DeleteTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error) {
	out := new(ListTagsResponse)
	err := c.cc.Invoke(ctx, DataCatalog_ListTags_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, DataCatalog_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, DataCatalog_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, DataCatalog_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataCatalogServer is the server API for DataCatalog service.
// All implementations should embed UnimplementedDataCatalogServer
// for forward compatibility
//
// Deprecated: Do not use.
type DataCatalogServer interface {
	// Deprecated: Do not use.
	// Searches Data Catalog for multiple resources like entries, tags that
	// match a query.
	//
	// This is a custom method
	// (https://cloud.google.com/apis/design/custom_methods) and does not return
	// the complete resource, only the resource identifier and high level
	// fields. Clients can subsequently call `Get` methods.
	//
	// Note that Data Catalog search queries do not guarantee full recall. Query
	// results that match your query may not be returned, even in subsequent
	// result pages. Also note that results returned (and not returned) can vary
	// across repeated search queries.
	//
	// See [Data Catalog Search
	// Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference)
	// for more information.
	SearchCatalog(context.Context, *SearchCatalogRequest) (*SearchCatalogResponse, error)
	// Deprecated: Do not use.
	// A maximum of 10,000 entry groups may be created per organization across all
	// locations.
	//
	// Users should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	CreateEntryGroup(context.Context, *CreateEntryGroupRequest) (*EntryGroup, error)
	// Deprecated: Do not use.
	// Updates an EntryGroup. The user should enable the Data Catalog API in the
	// project identified by the `entry_group.name` parameter (see [Data Catalog
	// Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateEntryGroup(context.Context, *UpdateEntryGroupRequest) (*EntryGroup, error)
	// Deprecated: Do not use.
	// Gets an EntryGroup.
	GetEntryGroup(context.Context, *GetEntryGroupRequest) (*EntryGroup, error)
	// Deprecated: Do not use.
	// Deletes an EntryGroup. Only entry groups that do not contain entries can be
	// deleted. Users should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteEntryGroup(context.Context, *DeleteEntryGroupRequest) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Lists entry groups.
	ListEntryGroups(context.Context, *ListEntryGroupsRequest) (*ListEntryGroupsResponse, error)
	// Deprecated: Do not use.
	// Creates an entry. Only entries of 'FILESET' type or user-specified type can
	// be created.
	//
	// Users should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	//
	// A maximum of 100,000 entries may be created per entry group.
	CreateEntry(context.Context, *CreateEntryRequest) (*Entry, error)
	// Deprecated: Do not use.
	// Updates an existing entry.
	// Users should enable the Data Catalog API in the project identified by
	// the `entry.name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateEntry(context.Context, *UpdateEntryRequest) (*Entry, error)
	// Deprecated: Do not use.
	// Deletes an existing entry. Only entries created through
	// [CreateEntry][google.cloud.datacatalog.v1beta1.DataCatalog.CreateEntry]
	// method can be deleted.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteEntry(context.Context, *DeleteEntryRequest) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Gets an entry.
	GetEntry(context.Context, *GetEntryRequest) (*Entry, error)
	// Deprecated: Do not use.
	// Get an entry by target resource name. This method allows clients to use
	// the resource name from the source Google Cloud Platform service to get the
	// Data Catalog Entry.
	LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error)
	// Deprecated: Do not use.
	// Lists entries.
	ListEntries(context.Context, *ListEntriesRequest) (*ListEntriesResponse, error)
	// Deprecated: Do not use.
	// Creates a tag template. The user should enable the Data Catalog API in
	// the project identified by the `parent` parameter (see [Data Catalog
	// Resource
	// Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project)
	// for more information).
	CreateTagTemplate(context.Context, *CreateTagTemplateRequest) (*TagTemplate, error)
	// Deprecated: Do not use.
	// Gets a tag template.
	GetTagTemplate(context.Context, *GetTagTemplateRequest) (*TagTemplate, error)
	// Deprecated: Do not use.
	// Updates a tag template. This method cannot be used to update the fields of
	// a template. The tag template fields are represented as separate resources
	// and should be updated using their own create/update/delete methods.
	// Users should enable the Data Catalog API in the project identified by
	// the `tag_template.name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateTagTemplate(context.Context, *UpdateTagTemplateRequest) (*TagTemplate, error)
	// Deprecated: Do not use.
	// Deletes a tag template and all tags using the template.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteTagTemplate(context.Context, *DeleteTagTemplateRequest) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Creates a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `parent` parameter (see
	// [Data Catalog Resource
	// Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project)
	// for more information).
	CreateTagTemplateField(context.Context, *CreateTagTemplateFieldRequest) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Updates a field in a tag template. This method cannot be used to update the
	// field type. Users should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateTagTemplateField(context.Context, *UpdateTagTemplateFieldRequest) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Renames a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `name` parameter (see [Data Catalog
	// Resource
	// Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project)
	// for more information).
	RenameTagTemplateField(context.Context, *RenameTagTemplateFieldRequest) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Renames an enum value in a tag template. The enum values have to be unique
	// within one enum field. Thus, an enum value cannot be renamed with a name
	// used in any other enum value within the same enum field.
	RenameTagTemplateFieldEnumValue(context.Context, *RenameTagTemplateFieldEnumValueRequest) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Deletes a field in a tag template and all uses of that field.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteTagTemplateField(context.Context, *DeleteTagTemplateFieldRequest) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Creates a tag on an [Entry][google.cloud.datacatalog.v1beta1.Entry].
	// Note: The project identified by the `parent` parameter for the
	// [tag](https://cloud.google.com/data-catalog/docs/reference/rest/v1beta1/projects.locations.entryGroups.entries.tags/create#path-parameters)
	// and the
	// [tag
	// template](https://cloud.google.com/data-catalog/docs/reference/rest/v1beta1/projects.locations.tagTemplates/create#path-parameters)
	// used to create the tag must be from the same organization.
	CreateTag(context.Context, *CreateTagRequest) (*Tag, error)
	// Deprecated: Do not use.
	// Updates an existing tag.
	UpdateTag(context.Context, *UpdateTagRequest) (*Tag, error)
	// Deprecated: Do not use.
	// Deletes a tag.
	DeleteTag(context.Context, *DeleteTagRequest) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Lists tags assigned to an [Entry][google.cloud.datacatalog.v1beta1.Entry].
	// The [columns][google.cloud.datacatalog.v1beta1.Tag.column] in the response
	// are lowercased.
	ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error)
	// Deprecated: Do not use.
	// Sets the access control policy for a resource. Replaces any existing
	// policy.
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	//
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
	//     templates.
	//   - `datacatalog.entries.setIamPolicy` to set policies on entries.
	//   - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Deprecated: Do not use.
	// Gets the access control policy for a resource. A `NOT_FOUND` error
	// is returned if the resource does not exist. An empty policy is returned
	// if the resource exists but does not have a policy set on it.
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	//
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
	//     templates.
	//   - `datacatalog.entries.getIamPolicy` to get policies on entries.
	//   - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Deprecated: Do not use.
	// Returns the caller's permissions on a resource.
	// If the resource does not exist, an empty set of permissions is returned
	// (We don't return a `NOT_FOUND` error).
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	//
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// A caller is not required to have Google IAM permission to make this
	// request.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedDataCatalogServer should be embedded to have forward compatible implementations.
type UnimplementedDataCatalogServer struct {
}

func (UnimplementedDataCatalogServer) SearchCatalog(context.Context, *SearchCatalogRequest) (*SearchCatalogResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchCatalog not implemented")
}
func (UnimplementedDataCatalogServer) CreateEntryGroup(context.Context, *CreateEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntryGroup not implemented")
}
func (UnimplementedDataCatalogServer) UpdateEntryGroup(context.Context, *UpdateEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntryGroup not implemented")
}
func (UnimplementedDataCatalogServer) GetEntryGroup(context.Context, *GetEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntryGroup not implemented")
}
func (UnimplementedDataCatalogServer) DeleteEntryGroup(context.Context, *DeleteEntryGroupRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntryGroup not implemented")
}
func (UnimplementedDataCatalogServer) ListEntryGroups(context.Context, *ListEntryGroupsRequest) (*ListEntryGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntryGroups not implemented")
}
func (UnimplementedDataCatalogServer) CreateEntry(context.Context, *CreateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntry not implemented")
}
func (UnimplementedDataCatalogServer) UpdateEntry(context.Context, *UpdateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntry not implemented")
}
func (UnimplementedDataCatalogServer) DeleteEntry(context.Context, *DeleteEntryRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntry not implemented")
}
func (UnimplementedDataCatalogServer) GetEntry(context.Context, *GetEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntry not implemented")
}
func (UnimplementedDataCatalogServer) LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupEntry not implemented")
}
func (UnimplementedDataCatalogServer) ListEntries(context.Context, *ListEntriesRequest) (*ListEntriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntries not implemented")
}
func (UnimplementedDataCatalogServer) CreateTagTemplate(context.Context, *CreateTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTagTemplate not implemented")
}
func (UnimplementedDataCatalogServer) GetTagTemplate(context.Context, *GetTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTagTemplate not implemented")
}
func (UnimplementedDataCatalogServer) UpdateTagTemplate(context.Context, *UpdateTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTagTemplate not implemented")
}
func (UnimplementedDataCatalogServer) DeleteTagTemplate(context.Context, *DeleteTagTemplateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTagTemplate not implemented")
}
func (UnimplementedDataCatalogServer) CreateTagTemplateField(context.Context, *CreateTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTagTemplateField not implemented")
}
func (UnimplementedDataCatalogServer) UpdateTagTemplateField(context.Context, *UpdateTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTagTemplateField not implemented")
}
func (UnimplementedDataCatalogServer) RenameTagTemplateField(context.Context, *RenameTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameTagTemplateField not implemented")
}
func (UnimplementedDataCatalogServer) RenameTagTemplateFieldEnumValue(context.Context, *RenameTagTemplateFieldEnumValueRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameTagTemplateFieldEnumValue not implemented")
}
func (UnimplementedDataCatalogServer) DeleteTagTemplateField(context.Context, *DeleteTagTemplateFieldRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTagTemplateField not implemented")
}
func (UnimplementedDataCatalogServer) CreateTag(context.Context, *CreateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTag not implemented")
}
func (UnimplementedDataCatalogServer) UpdateTag(context.Context, *UpdateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTag not implemented")
}
func (UnimplementedDataCatalogServer) DeleteTag(context.Context, *DeleteTagRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTag not implemented")
}
func (UnimplementedDataCatalogServer) ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTags not implemented")
}
func (UnimplementedDataCatalogServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedDataCatalogServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedDataCatalogServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeDataCatalogServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataCatalogServer will
// result in compilation errors.
type UnsafeDataCatalogServer interface {
	mustEmbedUnimplementedDataCatalogServer()
}

// Deprecated: Do not use.
func RegisterDataCatalogServer(s grpc.ServiceRegistrar, srv DataCatalogServer) {
	s.RegisterService(&DataCatalog_ServiceDesc, srv)
}

func _DataCatalog_SearchCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).SearchCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_SearchCatalog_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).SearchCatalog(ctx, req.(*SearchCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_CreateEntryGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateEntryGroup(ctx, req.(*CreateEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_UpdateEntryGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateEntryGroup(ctx, req.(*UpdateEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_GetEntryGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetEntryGroup(ctx, req.(*GetEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_DeleteEntryGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteEntryGroup(ctx, req.(*DeleteEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListEntryGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntryGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListEntryGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_ListEntryGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListEntryGroups(ctx, req.(*ListEntryGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_CreateEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateEntry(ctx, req.(*CreateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_UpdateEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateEntry(ctx, req.(*UpdateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_DeleteEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteEntry(ctx, req.(*DeleteEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_GetEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetEntry(ctx, req.(*GetEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_LookupEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).LookupEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_LookupEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).LookupEntry(ctx, req.(*LookupEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_ListEntries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListEntries(ctx, req.(*ListEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_CreateTagTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTagTemplate(ctx, req.(*CreateTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_GetTagTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetTagTemplate(ctx, req.(*GetTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_UpdateTagTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTagTemplate(ctx, req.(*UpdateTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_DeleteTagTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTagTemplate(ctx, req.(*DeleteTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_CreateTagTemplateField_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTagTemplateField(ctx, req.(*CreateTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_UpdateTagTemplateField_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTagTemplateField(ctx, req.(*UpdateTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_RenameTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).RenameTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_RenameTagTemplateField_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).RenameTagTemplateField(ctx, req.(*RenameTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_RenameTagTemplateFieldEnumValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameTagTemplateFieldEnumValueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).RenameTagTemplateFieldEnumValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_RenameTagTemplateFieldEnumValue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).RenameTagTemplateFieldEnumValue(ctx, req.(*RenameTagTemplateFieldEnumValueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_DeleteTagTemplateField_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTagTemplateField(ctx, req.(*DeleteTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_CreateTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTag(ctx, req.(*CreateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_UpdateTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTag(ctx, req.(*UpdateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_DeleteTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTag(ctx, req.(*DeleteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_ListTags_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListTags(ctx, req.(*ListTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DataCatalog_ServiceDesc is the grpc.ServiceDesc for DataCatalog service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DataCatalog_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datacatalog.v1beta1.DataCatalog",
	HandlerType: (*DataCatalogServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchCatalog",
			Handler:    _DataCatalog_SearchCatalog_Handler,
		},
		{
			MethodName: "CreateEntryGroup",
			Handler:    _DataCatalog_CreateEntryGroup_Handler,
		},
		{
			MethodName: "UpdateEntryGroup",
			Handler:    _DataCatalog_UpdateEntryGroup_Handler,
		},
		{
			MethodName: "GetEntryGroup",
			Handler:    _DataCatalog_GetEntryGroup_Handler,
		},
		{
			MethodName: "DeleteEntryGroup",
			Handler:    _DataCatalog_DeleteEntryGroup_Handler,
		},
		{
			MethodName: "ListEntryGroups",
			Handler:    _DataCatalog_ListEntryGroups_Handler,
		},
		{
			MethodName: "CreateEntry",
			Handler:    _DataCatalog_CreateEntry_Handler,
		},
		{
			MethodName: "UpdateEntry",
			Handler:    _DataCatalog_UpdateEntry_Handler,
		},
		{
			MethodName: "DeleteEntry",
			Handler:    _DataCatalog_DeleteEntry_Handler,
		},
		{
			MethodName: "GetEntry",
			Handler:    _DataCatalog_GetEntry_Handler,
		},
		{
			MethodName: "LookupEntry",
			Handler:    _DataCatalog_LookupEntry_Handler,
		},
		{
			MethodName: "ListEntries",
			Handler:    _DataCatalog_ListEntries_Handler,
		},
		{
			MethodName: "CreateTagTemplate",
			Handler:    _DataCatalog_CreateTagTemplate_Handler,
		},
		{
			MethodName: "GetTagTemplate",
			Handler:    _DataCatalog_GetTagTemplate_Handler,
		},
		{
			MethodName: "UpdateTagTemplate",
			Handler:    _DataCatalog_UpdateTagTemplate_Handler,
		},
		{
			MethodName: "DeleteTagTemplate",
			Handler:    _DataCatalog_DeleteTagTemplate_Handler,
		},
		{
			MethodName: "CreateTagTemplateField",
			Handler:    _DataCatalog_CreateTagTemplateField_Handler,
		},
		{
			MethodName: "UpdateTagTemplateField",
			Handler:    _DataCatalog_UpdateTagTemplateField_Handler,
		},
		{
			MethodName: "RenameTagTemplateField",
			Handler:    _DataCatalog_RenameTagTemplateField_Handler,
		},
		{
			MethodName: "RenameTagTemplateFieldEnumValue",
			Handler:    _DataCatalog_RenameTagTemplateFieldEnumValue_Handler,
		},
		{
			MethodName: "DeleteTagTemplateField",
			Handler:    _DataCatalog_DeleteTagTemplateField_Handler,
		},
		{
			MethodName: "CreateTag",
			Handler:    _DataCatalog_CreateTag_Handler,
		},
		{
			MethodName: "UpdateTag",
			Handler:    _DataCatalog_UpdateTag_Handler,
		},
		{
			MethodName: "DeleteTag",
			Handler:    _DataCatalog_DeleteTag_Handler,
		},
		{
			MethodName: "ListTags",
			Handler:    _DataCatalog_ListTags_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DataCatalog_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DataCatalog_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DataCatalog_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datacatalog/v1beta1/datacatalog.proto",
}
