/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.app.data.project;

import com.dtolabs.rundeck.core.authorization.AuthContext;
import com.dtolabs.rundeck.core.authorization.AuthContextProcessor;
import com.dtolabs.rundeck.core.authorization.UserAndRolesAuthContext;
import com.dtolabs.rundeck.plugins.scm.ScmExportSynchState;
import com.dtolabs.rundeck.plugins.scm.ScmImportSynchState;
import com.dtolabs.rundeck.plugins.scm.ScmPluginException;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.rundeck.app.components.jobs.ComponentMeta;
import org.rundeck.app.components.project.ProjectMetadataComponent;
import org.rundeck.core.auth.AuthConstants;
import org.springframework.beans.factory.annotation.Autowired;
import rundeck.services.ScmService;
import rundeck.services.scm.ScmPluginConfigData;

public class ProjectScmMetadataComponent
implements ProjectMetadataComponent,
GroovyObject {
    public static final String SCM_EXPORT = "scmExport";
    public static final String SCM_IMPORT = "scmImport";
    @Autowired
    private ScmService scmService;
    @Autowired
    private AuthContextProcessor rundeckAuthContextProcessor;
    private final Set<String> availableMetadataNames;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public ProjectScmMetadataComponent() {
        MetaClass metaClass;
        Set set;
        this.availableMetadataNames = set = Collections.unmodifiableSet(new HashSet(ScriptBytecodeAdapter.createList((Object[])new Object[]{SCM_EXPORT, SCM_IMPORT})));
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Optional<List<ComponentMeta>> getMetadataForProject(String project, Set<String> names, UserAndRolesAuthContext authContext) {
        ArrayList<ComponentMeta> arrayList;
        ArrayList<ComponentMeta> metaItems = new ArrayList<ComponentMeta>();
        if ((names.contains(SCM_EXPORT) || names.contains("*")) && this.checkAuth(authContext, project, ScriptBytecodeAdapter.createList((Object[])new Object[]{AuthConstants.ACTION_EXPORT, AuthConstants.ACTION_SCM_EXPORT}))) {
            HashMap results;
            block15: {
                results = new HashMap();
                try {
                    ScmPluginConfigData ePluginConfig = this.scmService.loadScmConfig(project, ScmService.EXPORT);
                    if (DefaultTypeTransformation.booleanUnbox((Object)ePluginConfig)) {
                        boolean bl = true;
                        ScriptBytecodeAdapter.setProperty((Object)bl, null, results, (String)"configured");
                    }
                    if (!DefaultTypeTransformation.booleanUnbox((Object)this.scmService.projectHasConfiguredExportPlugin(project))) break block15;
                    ScmPluginConfigData scmPluginConfigData = this.scmService.loadScmConfig(project, ScmService.EXPORT);
                    Boolean bl = scmPluginConfigData != null ? Boolean.valueOf(scmPluginConfigData.getEnabled()) : null;
                    ScriptBytecodeAdapter.setProperty((Object)bl, null, results, (String)"enabled");
                    if (!DefaultTypeTransformation.booleanUnbox(results.get("enabled"))) break block15;
                    boolean validation = this.scmService.userHasAccessToScmConfiguredKeyOrPassword(authContext, ScmService.EXPORT, project);
                    if (validation) {
                        ScmExportSynchState scmExportSynchState = this.scmService.exportPluginStatus(authContext, project);
                        ScriptBytecodeAdapter.setProperty((Object)scmExportSynchState, null, results, (String)"status");
                        List list = this.scmService.exportPluginActions(authContext, project);
                        ScriptBytecodeAdapter.setProperty((Object)list, null, results, (String)"actions");
                        Map map = this.scmService.getRenamedJobPathsForProject(project);
                        ScriptBytecodeAdapter.setProperty((Object)map, null, results, (String)"renamed");
                        break block15;
                    }
                    boolean bl2 = false;
                    ScriptBytecodeAdapter.setProperty((Object)bl2, null, results, (String)"valid");
                    String string = "scm.export.auth.key.noAccess";
                    ScriptBytecodeAdapter.setProperty((Object)string, null, results, (String)"validationErrorCode");
                }
                catch (ScmPluginException e) {
                    boolean bl = false;
                    ScriptBytecodeAdapter.setProperty((Object)bl, null, results, (String)"valid");
                    String string = e.getMessage();
                    ScriptBytecodeAdapter.setProperty((Object)string, null, results, (String)"validationError");
                }
            }
            metaItems.add(ComponentMeta.with((String)SCM_EXPORT, results));
        }
        if ((names.contains(SCM_IMPORT) || names.contains("*")) && this.checkAuth(authContext, project, ScriptBytecodeAdapter.createList((Object[])new Object[]{AuthConstants.ACTION_IMPORT, AuthConstants.ACTION_SCM_IMPORT}))) {
            HashMap results;
            block16: {
                results = new HashMap();
                try {
                    ScmPluginConfigData pluginConfig = this.scmService.loadScmConfig(project, ScmService.IMPORT);
                    if (DefaultTypeTransformation.booleanUnbox((Object)pluginConfig)) {
                        boolean bl = true;
                        ScriptBytecodeAdapter.setProperty((Object)bl, null, results, (String)"configured");
                    }
                    if (!DefaultTypeTransformation.booleanUnbox((Object)this.scmService.projectHasConfiguredImportPlugin(project))) break block16;
                    ScmPluginConfigData scmPluginConfigData = this.scmService.loadScmConfig(project, ScmService.IMPORT);
                    Boolean bl = scmPluginConfigData != null ? Boolean.valueOf(scmPluginConfigData.getEnabled()) : null;
                    ScriptBytecodeAdapter.setProperty((Object)bl, null, results, (String)"enabled");
                    if (!DefaultTypeTransformation.booleanUnbox(results.get("enabled"))) break block16;
                    boolean validation = this.scmService.userHasAccessToScmConfiguredKeyOrPassword(authContext, ScmService.IMPORT, project);
                    if (validation) {
                        ScmImportSynchState status = this.scmService.importPluginStatus(authContext, project);
                        ScmImportSynchState scmImportSynchState = status;
                        ScriptBytecodeAdapter.setProperty((Object)scmImportSynchState, null, results, (String)"status");
                        List list = this.scmService.importPluginActions(authContext, project, status);
                        ScriptBytecodeAdapter.setProperty((Object)list, null, results, (String)"actions");
                        break block16;
                    }
                    boolean bl3 = false;
                    ScriptBytecodeAdapter.setProperty((Object)bl3, null, results, (String)"valid");
                    String string = "scm.import.auth.key.noAccess";
                    ScriptBytecodeAdapter.setProperty((Object)string, null, results, (String)"validationErrorCode");
                }
                catch (ScmPluginException e) {
                    boolean bl = false;
                    ScriptBytecodeAdapter.setProperty((Object)bl, null, results, (String)"valid");
                    String string = e.getMessage();
                    ScriptBytecodeAdapter.setProperty((Object)string, null, results, (String)"validationError");
                }
            }
            metaItems.add(ComponentMeta.with((String)SCM_IMPORT, results));
        }
        if (DefaultTypeTransformation.booleanUnbox((arrayList = metaItems) != null ? Integer.valueOf(arrayList.size()) : null)) {
            return Optional.of(metaItems);
        }
        return Optional.empty();
    }

    private boolean checkAuth(UserAndRolesAuthContext authContext, String project, List<String> actions) {
        return this.rundeckAuthContextProcessor.authorizeApplicationResourceAny((AuthContext)authContext, this.rundeckAuthContextProcessor.authResourceForProject(project), DefaultGroovyMethods.plus((List)ScriptBytecodeAdapter.createList((Object[])new Object[]{AuthConstants.ACTION_ADMIN, AuthConstants.ACTION_APP_ADMIN}), actions));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProjectScmMetadataComponent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public ScmService getScmService() {
        return this.scmService;
    }

    @Generated
    public void setScmService(ScmService scmService) {
        this.scmService = scmService;
    }

    @Generated
    public AuthContextProcessor getRundeckAuthContextProcessor() {
        return this.rundeckAuthContextProcessor;
    }

    @Generated
    public void setRundeckAuthContextProcessor(AuthContextProcessor authContextProcessor) {
        this.rundeckAuthContextProcessor = authContextProcessor;
    }

    @Generated
    public final Set<String> getAvailableMetadataNames() {
        return this.availableMetadataNames;
    }
}

