/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.jaas;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.rundeck.jaas.AbstractBaseLoginModule;
import org.rundeck.jaas.SharedLoginCreds;

public abstract class AbstractSharedLoginModule
extends AbstractBaseLoginModule {
    private Map<String, ?> sharedState;
    private SharedLoginCreds sharedLoginCreds;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.sharedState = sharedState;
        this.sharedLoginCreds = new SharedLoginCreds(sharedState, options);
    }

    public boolean login() throws LoginException {
        if ((this.getSharedLoginCreds().isUseFirstPass() || this.getSharedLoginCreds().isTryFirstPass()) && this.getSharedLoginCreds().isHasSharedAuth()) {
            this.debug(String.format("AbstractSharedLoginModule: login with sharedLoginState auth, try? %s, use? %s", this.getSharedLoginCreds().isTryFirstPass(), this.getSharedLoginCreds().isUseFirstPass()));
            this.setAuthenticated(this.authenticate(this.getSharedLoginCreds().getSharedUserName(), this.getSharedLoginCreds().getSharedUserPass().toString().toCharArray()));
        }
        if (this.getSharedLoginCreds().isUseFirstPass() && this.getSharedLoginCreds().isHasSharedAuth()) {
            this.debug(String.format("AbstractSharedLoginModule: using login result: %s", this.isAuthenticated()));
            if (this.isAuthenticated()) {
                this.wasAuthenticated(this.getSharedLoginCreds().getSharedUserName(), this.getSharedLoginCreds().getSharedUserPass());
            }
            return this.isAuthenticated();
        }
        if (this.getSharedLoginCreds().isHasSharedAuth()) {
            this.debug(String.format("AbstractSharedLoginModule: sharedLoginState auth failed, now trying callback auth.", new Object[0]));
        }
        Object[] userPass = new Object[]{};
        try {
            userPass = this.getCallBackAuth();
        }
        catch (IOException e) {
            if (this.isDebug()) {
                e.printStackTrace();
            }
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e) {
            if (this.isDebug()) {
                e.printStackTrace();
            }
            throw new LoginException(e.toString());
        }
        if (null == userPass || userPass.length < 2 || null == userPass[0] && null == userPass[1]) {
            this.setAuthenticated(false);
        } else {
            String name = (String)userPass[0];
            char[] password = (char[])userPass[1];
            this.setAuthenticated(this.authenticate(name, password));
            if (this.isAuthenticated()) {
                this.wasAuthenticated(name, (Object)password);
            }
        }
        return this.isAuthenticated();
    }

    protected void wasAuthenticated(String user, Object pass) {
        if (this.isAuthenticated() && this.getSharedLoginCreds().isStorePass() && !this.getSharedLoginCreds().isHasSharedAuth()) {
            this.getSharedLoginCreds().storeLoginCreds(user, pass);
        }
        this.wasAuthenticated();
    }

    public boolean commit() throws LoginException {
        if (this.getSharedLoginCreds().isClearPass() && this.getSharedLoginCreds().isHasSharedAuth()) {
            this.getSharedLoginCreds().clear();
        }
        return super.commit();
    }

    protected abstract Object[] getCallBackAuth() throws IOException, UnsupportedCallbackException, LoginException;

    protected abstract boolean authenticate(String var1, char[] var2) throws LoginException;

    protected SharedLoginCreds getSharedLoginCreds() {
        return this.sharedLoginCreds;
    }
}

