/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.jaas;

import java.util.Map;

public class SharedLoginCreds {
    public static final String SHARED_LOGIN_NAME = "javax.security.auth.login.name";
    public static final String SHARED_LOGIN_PASSWORD = "javax.security.auth.login.password";
    private boolean useFirstPass;
    private boolean tryFirstPass;
    private boolean storePass;
    private boolean clearPass;
    private Map<String, Object> sharedState;

    public SharedLoginCreds(boolean useFirstPass, boolean tryFirstPass, boolean storePass, boolean clearPass, Map<String, Object> sharedState) {
        this.useFirstPass = useFirstPass;
        this.tryFirstPass = tryFirstPass;
        this.storePass = storePass;
        this.clearPass = clearPass;
        this.sharedState = sharedState;
    }

    public SharedLoginCreds(Map sharedState, Map options) {
        this.sharedState = sharedState;
        if (options.get("useFirstPass") != null) {
            this.useFirstPass = Boolean.parseBoolean(options.get("useFirstPass").toString());
        }
        if (options.get("tryFirstPass") != null) {
            this.tryFirstPass = Boolean.parseBoolean(options.get("tryFirstPass").toString());
        }
        if (options.get("storePass") != null) {
            this.storePass = Boolean.parseBoolean(options.get("storePass").toString());
        }
        if (options.get("clearPass") != null) {
            this.clearPass = Boolean.parseBoolean(options.get("clearPass").toString());
        }
    }

    public void storeLoginCreds(String user, Object pass) {
        this.sharedState.put(SHARED_LOGIN_PASSWORD, pass);
        this.sharedState.put(SHARED_LOGIN_NAME, user);
    }

    public void clear() {
        this.clearUser();
        this.clearPassword();
    }

    private void clearPassword() {
        this.sharedState.remove(SHARED_LOGIN_PASSWORD);
    }

    private void clearUser() {
        this.sharedState.remove(SHARED_LOGIN_NAME);
    }

    public boolean isHasSharedAuth() {
        return null != this.sharedState.get(SHARED_LOGIN_NAME) && null != this.sharedState.get(SHARED_LOGIN_PASSWORD);
    }

    public String getSharedUserName() {
        return this.sharedState.get(SHARED_LOGIN_NAME).toString();
    }

    public Object getSharedUserPass() {
        return this.sharedState.get(SHARED_LOGIN_PASSWORD);
    }

    public boolean isUseFirstPass() {
        return this.useFirstPass;
    }

    public boolean isTryFirstPass() {
        return this.tryFirstPass;
    }

    public boolean isStorePass() {
        return this.storePass;
    }

    public boolean isClearPass() {
        return this.clearPass;
    }
}

