/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.jaas.jetty;

import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.jaas.spi.UserInfo;
import org.rundeck.jaas.AbstractSharedLoginModule;
import org.rundeck.jaas.jetty.JettySupport;
import org.rundeck.jaas.jetty.ReloadablePropertyFileLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyAuthPropertyFileLoginModule
extends AbstractSharedLoginModule {
    public static final Logger logger = LoggerFactory.getLogger((String)JettyAuthPropertyFileLoginModule.class.getName());
    ReloadablePropertyFileLoginModule module = new ReloadablePropertyFileLoginModule();
    UserInfo userInfo;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map shared, Map options) {
        super.initialize(subject, callbackHandler, shared, options);
        if (!options.containsKey("hotReload") || !options.get("hotReload").equals("true")) {
            this.module.setReloadEnabled(false);
        }
        this.module.initialize(subject, callbackHandler, shared, options);
    }

    protected Object[] getCallBackAuth() throws IOException, UnsupportedCallbackException, LoginException {
        return JettySupport.performCallbacks((CallbackHandler)this.getCallbackHandler());
    }

    protected Principal createUserPrincipal() {
        return JettySupport.createUserPrincipal((String)this.userInfo.getUserName());
    }

    protected List<Principal> createRolePrincipals() {
        return null;
    }

    protected boolean authenticate(String userName, char[] chars) throws LoginException {
        try {
            this.userInfo = this.module.getUserInfo(userName);
            if (null == this.userInfo) {
                this.debug(String.format("JettyAuthPropertyFileLoginModule: userInfo not found for %s", userName));
                return false;
            }
            boolean b = this.userInfo.checkCredential((Object)new String(chars));
            this.debug(String.format("JettyAuthPropertyFileLoginModule: checkCredential? %s", b));
            return b;
        }
        catch (Exception e) {
            if (this.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public boolean commit() throws LoginException {
        if (!this.isAuthenticated()) {
            this.userInfo = null;
        }
        return super.commit();
    }

    public boolean abort() throws LoginException {
        this.userInfo = null;
        return super.abort();
    }

    public boolean logout() throws LoginException {
        this.userInfo = null;
        return super.logout();
    }
}

