/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.jaas.jetty;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.jaas.spi.UserInfo;
import org.rundeck.jaas.AbstractSharedLoginModule;
import org.rundeck.jaas.jetty.JettySupport;
import org.rundeck.jaas.jetty.ReloadablePropertyFileLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyRolePropertyFileLoginModule
extends AbstractSharedLoginModule {
    public static final Logger logger = LoggerFactory.getLogger((String)JettyRolePropertyFileLoginModule.class.getName());
    ReloadablePropertyFileLoginModule module = new ReloadablePropertyFileLoginModule();
    UserInfo userInfo;
    boolean caseInsensitive = true;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> shared, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, shared, options);
        if (!this.getSharedLoginCreds().isUseFirstPass() && !this.getSharedLoginCreds().isTryFirstPass()) {
            throw new IllegalStateException("JettyRolePropertyFileLoginModule must have useFirstPass or tryFirstPass set to true");
        }
        Object caseInsensitiveStr = options.get("caseInsensitive");
        if (null != caseInsensitiveStr) {
            this.caseInsensitive = Boolean.parseBoolean(caseInsensitiveStr.toString());
        }
        if (!options.containsKey("hotReload") || !options.get("hotReload").equals("true")) {
            this.module.setReloadEnabled(false);
        }
        this.module.initialize(subject, callbackHandler, shared, options);
    }

    protected Object[] getCallBackAuth() throws IOException, UnsupportedCallbackException, LoginException {
        if (this.getSharedLoginCreds().isHasSharedAuth()) {
            return new Object[]{this.getSharedLoginCreds().getSharedUserName(), this.getSharedLoginCreds().getSharedUserPass().toString().toCharArray()};
        }
        return new Object[]{null, null};
    }

    protected Principal createUserPrincipal() {
        return null;
    }

    protected List<Principal> createRolePrincipals() {
        ArrayList<Principal> roles = new ArrayList<Principal>();
        if (null != this.userInfo) {
            List roleNames = this.userInfo.getRoleNames();
            this.debug(String.format("role names: %s", roleNames));
            for (Object roleName : roleNames) {
                roles.add(this.createRolePrincipal(roleName.toString()));
            }
        }
        return roles;
    }

    protected Principal createRolePrincipal(String role) {
        return JettySupport.createRolePrincipal((String)role);
    }

    protected boolean authenticate(String sharedUserName, char[] chars) throws LoginException {
        block3: {
            if (!this.getSharedLoginCreds().isHasSharedAuth()) {
                this.debug("JettyRolePropertyFileLoginModule: no shared auth, skipping.");
                return false;
            }
            try {
                this.userInfo = this.module.getUserInfo(this.caseInsensitive ? sharedUserName.toLowerCase() : sharedUserName);
                this.debug(String.format("JettyRolePropertyFileLoginModule: userInfo found for %s? %s", sharedUserName, this.userInfo != null));
            }
            catch (Exception e) {
                if (!this.isDebug()) break block3;
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (!this.isAuthenticated()) {
            this.userInfo = null;
        }
        return super.commit();
    }

    public boolean abort() throws LoginException {
        this.userInfo = null;
        return super.abort();
    }

    public boolean logout() throws LoginException {
        this.userInfo = null;
        return super.logout();
    }
}

