// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/run/v2/worker_pool.proto

package runpb

import (
	context "context"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	WorkerPools_CreateWorkerPool_FullMethodName   = "/google.cloud.run.v2.WorkerPools/CreateWorkerPool"
	WorkerPools_GetWorkerPool_FullMethodName      = "/google.cloud.run.v2.WorkerPools/GetWorkerPool"
	WorkerPools_ListWorkerPools_FullMethodName    = "/google.cloud.run.v2.WorkerPools/ListWorkerPools"
	WorkerPools_UpdateWorkerPool_FullMethodName   = "/google.cloud.run.v2.WorkerPools/UpdateWorkerPool"
	WorkerPools_DeleteWorkerPool_FullMethodName   = "/google.cloud.run.v2.WorkerPools/DeleteWorkerPool"
	WorkerPools_GetIamPolicy_FullMethodName       = "/google.cloud.run.v2.WorkerPools/GetIamPolicy"
	WorkerPools_SetIamPolicy_FullMethodName       = "/google.cloud.run.v2.WorkerPools/SetIamPolicy"
	WorkerPools_TestIamPermissions_FullMethodName = "/google.cloud.run.v2.WorkerPools/TestIamPermissions"
)

// WorkerPoolsClient is the client API for WorkerPools service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type WorkerPoolsClient interface {
	// Creates a new WorkerPool in a given project and location.
	CreateWorkerPool(ctx context.Context, in *CreateWorkerPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets information about a WorkerPool.
	GetWorkerPool(ctx context.Context, in *GetWorkerPoolRequest, opts ...grpc.CallOption) (*WorkerPool, error)
	// Lists WorkerPools. Results are sorted by creation time, descending.
	ListWorkerPools(ctx context.Context, in *ListWorkerPoolsRequest, opts ...grpc.CallOption) (*ListWorkerPoolsResponse, error)
	// Updates a WorkerPool.
	UpdateWorkerPool(ctx context.Context, in *UpdateWorkerPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a WorkerPool.
	DeleteWorkerPool(ctx context.Context, in *DeleteWorkerPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the IAM Access Control policy currently in effect for the given
	// Cloud Run WorkerPool. This result does not include any inherited policies.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the IAM Access control policy for the specified WorkerPool. Overwrites
	// any existing policy.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns permissions that a caller has on the specified Project.
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type workerPoolsClient struct {
	cc grpc.ClientConnInterface
}

func NewWorkerPoolsClient(cc grpc.ClientConnInterface) WorkerPoolsClient {
	return &workerPoolsClient{cc}
}

func (c *workerPoolsClient) CreateWorkerPool(ctx context.Context, in *CreateWorkerPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, WorkerPools_CreateWorkerPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerPoolsClient) GetWorkerPool(ctx context.Context, in *GetWorkerPoolRequest, opts ...grpc.CallOption) (*WorkerPool, error) {
	out := new(WorkerPool)
	err := c.cc.Invoke(ctx, WorkerPools_GetWorkerPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerPoolsClient) ListWorkerPools(ctx context.Context, in *ListWorkerPoolsRequest, opts ...grpc.CallOption) (*ListWorkerPoolsResponse, error) {
	out := new(ListWorkerPoolsResponse)
	err := c.cc.Invoke(ctx, WorkerPools_ListWorkerPools_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerPoolsClient) UpdateWorkerPool(ctx context.Context, in *UpdateWorkerPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, WorkerPools_UpdateWorkerPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerPoolsClient) DeleteWorkerPool(ctx context.Context, in *DeleteWorkerPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, WorkerPools_DeleteWorkerPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerPoolsClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, WorkerPools_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerPoolsClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, WorkerPools_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerPoolsClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, WorkerPools_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WorkerPoolsServer is the server API for WorkerPools service.
// All implementations should embed UnimplementedWorkerPoolsServer
// for forward compatibility
type WorkerPoolsServer interface {
	// Creates a new WorkerPool in a given project and location.
	CreateWorkerPool(context.Context, *CreateWorkerPoolRequest) (*longrunningpb.Operation, error)
	// Gets information about a WorkerPool.
	GetWorkerPool(context.Context, *GetWorkerPoolRequest) (*WorkerPool, error)
	// Lists WorkerPools. Results are sorted by creation time, descending.
	ListWorkerPools(context.Context, *ListWorkerPoolsRequest) (*ListWorkerPoolsResponse, error)
	// Updates a WorkerPool.
	UpdateWorkerPool(context.Context, *UpdateWorkerPoolRequest) (*longrunningpb.Operation, error)
	// Deletes a WorkerPool.
	DeleteWorkerPool(context.Context, *DeleteWorkerPoolRequest) (*longrunningpb.Operation, error)
	// Gets the IAM Access Control policy currently in effect for the given
	// Cloud Run WorkerPool. This result does not include any inherited policies.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the IAM Access control policy for the specified WorkerPool. Overwrites
	// any existing policy.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns permissions that a caller has on the specified Project.
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedWorkerPoolsServer should be embedded to have forward compatible implementations.
type UnimplementedWorkerPoolsServer struct {
}

func (UnimplementedWorkerPoolsServer) CreateWorkerPool(context.Context, *CreateWorkerPoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWorkerPool not implemented")
}
func (UnimplementedWorkerPoolsServer) GetWorkerPool(context.Context, *GetWorkerPoolRequest) (*WorkerPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkerPool not implemented")
}
func (UnimplementedWorkerPoolsServer) ListWorkerPools(context.Context, *ListWorkerPoolsRequest) (*ListWorkerPoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkerPools not implemented")
}
func (UnimplementedWorkerPoolsServer) UpdateWorkerPool(context.Context, *UpdateWorkerPoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWorkerPool not implemented")
}
func (UnimplementedWorkerPoolsServer) DeleteWorkerPool(context.Context, *DeleteWorkerPoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWorkerPool not implemented")
}
func (UnimplementedWorkerPoolsServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedWorkerPoolsServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedWorkerPoolsServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeWorkerPoolsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to WorkerPoolsServer will
// result in compilation errors.
type UnsafeWorkerPoolsServer interface {
	mustEmbedUnimplementedWorkerPoolsServer()
}

func RegisterWorkerPoolsServer(s grpc.ServiceRegistrar, srv WorkerPoolsServer) {
	s.RegisterService(&WorkerPools_ServiceDesc, srv)
}

func _WorkerPools_CreateWorkerPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkerPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerPoolsServer).CreateWorkerPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerPools_CreateWorkerPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerPoolsServer).CreateWorkerPool(ctx, req.(*CreateWorkerPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerPools_GetWorkerPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkerPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerPoolsServer).GetWorkerPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerPools_GetWorkerPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerPoolsServer).GetWorkerPool(ctx, req.(*GetWorkerPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerPools_ListWorkerPools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkerPoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerPoolsServer).ListWorkerPools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerPools_ListWorkerPools_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerPoolsServer).ListWorkerPools(ctx, req.(*ListWorkerPoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerPools_UpdateWorkerPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkerPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerPoolsServer).UpdateWorkerPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerPools_UpdateWorkerPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerPoolsServer).UpdateWorkerPool(ctx, req.(*UpdateWorkerPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerPools_DeleteWorkerPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkerPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerPoolsServer).DeleteWorkerPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerPools_DeleteWorkerPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerPoolsServer).DeleteWorkerPool(ctx, req.(*DeleteWorkerPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerPools_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerPoolsServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerPools_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerPoolsServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerPools_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerPoolsServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerPools_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerPoolsServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkerPools_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerPoolsServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WorkerPools_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerPoolsServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// WorkerPools_ServiceDesc is the grpc.ServiceDesc for WorkerPools service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var WorkerPools_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.run.v2.WorkerPools",
	HandlerType: (*WorkerPoolsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateWorkerPool",
			Handler:    _WorkerPools_CreateWorkerPool_Handler,
		},
		{
			MethodName: "GetWorkerPool",
			Handler:    _WorkerPools_GetWorkerPool_Handler,
		},
		{
			MethodName: "ListWorkerPools",
			Handler:    _WorkerPools_ListWorkerPools_Handler,
		},
		{
			MethodName: "UpdateWorkerPool",
			Handler:    _WorkerPools_UpdateWorkerPool_Handler,
		},
		{
			MethodName: "DeleteWorkerPool",
			Handler:    _WorkerPools_DeleteWorkerPool_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _WorkerPools_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _WorkerPools_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _WorkerPools_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/run/v2/worker_pool.proto",
}
