// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/edgecontainer/v1/service.proto

package edgecontainerpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	EdgeContainer_ListClusters_FullMethodName              = "/google.cloud.edgecontainer.v1.EdgeContainer/ListClusters"
	EdgeContainer_GetCluster_FullMethodName                = "/google.cloud.edgecontainer.v1.EdgeContainer/GetCluster"
	EdgeContainer_CreateCluster_FullMethodName             = "/google.cloud.edgecontainer.v1.EdgeContainer/CreateCluster"
	EdgeContainer_UpdateCluster_FullMethodName             = "/google.cloud.edgecontainer.v1.EdgeContainer/UpdateCluster"
	EdgeContainer_UpgradeCluster_FullMethodName            = "/google.cloud.edgecontainer.v1.EdgeContainer/UpgradeCluster"
	EdgeContainer_DeleteCluster_FullMethodName             = "/google.cloud.edgecontainer.v1.EdgeContainer/DeleteCluster"
	EdgeContainer_GenerateAccessToken_FullMethodName       = "/google.cloud.edgecontainer.v1.EdgeContainer/GenerateAccessToken"
	EdgeContainer_GenerateOfflineCredential_FullMethodName = "/google.cloud.edgecontainer.v1.EdgeContainer/GenerateOfflineCredential"
	EdgeContainer_ListNodePools_FullMethodName             = "/google.cloud.edgecontainer.v1.EdgeContainer/ListNodePools"
	EdgeContainer_GetNodePool_FullMethodName               = "/google.cloud.edgecontainer.v1.EdgeContainer/GetNodePool"
	EdgeContainer_CreateNodePool_FullMethodName            = "/google.cloud.edgecontainer.v1.EdgeContainer/CreateNodePool"
	EdgeContainer_UpdateNodePool_FullMethodName            = "/google.cloud.edgecontainer.v1.EdgeContainer/UpdateNodePool"
	EdgeContainer_DeleteNodePool_FullMethodName            = "/google.cloud.edgecontainer.v1.EdgeContainer/DeleteNodePool"
	EdgeContainer_ListMachines_FullMethodName              = "/google.cloud.edgecontainer.v1.EdgeContainer/ListMachines"
	EdgeContainer_GetMachine_FullMethodName                = "/google.cloud.edgecontainer.v1.EdgeContainer/GetMachine"
	EdgeContainer_ListVpnConnections_FullMethodName        = "/google.cloud.edgecontainer.v1.EdgeContainer/ListVpnConnections"
	EdgeContainer_GetVpnConnection_FullMethodName          = "/google.cloud.edgecontainer.v1.EdgeContainer/GetVpnConnection"
	EdgeContainer_CreateVpnConnection_FullMethodName       = "/google.cloud.edgecontainer.v1.EdgeContainer/CreateVpnConnection"
	EdgeContainer_DeleteVpnConnection_FullMethodName       = "/google.cloud.edgecontainer.v1.EdgeContainer/DeleteVpnConnection"
	EdgeContainer_GetServerConfig_FullMethodName           = "/google.cloud.edgecontainer.v1.EdgeContainer/GetServerConfig"
)

// EdgeContainerClient is the client API for EdgeContainer service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type EdgeContainerClient interface {
	// Lists Clusters in a given project and location.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets details of a single Cluster.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Creates a new Cluster in a given project and location.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Cluster.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Upgrades a single cluster.
	UpgradeCluster(ctx context.Context, in *UpgradeClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Cluster.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Generates an access token for a Cluster.
	GenerateAccessToken(ctx context.Context, in *GenerateAccessTokenRequest, opts ...grpc.CallOption) (*GenerateAccessTokenResponse, error)
	// Generates an offline credential for a Cluster.
	GenerateOfflineCredential(ctx context.Context, in *GenerateOfflineCredentialRequest, opts ...grpc.CallOption) (*GenerateOfflineCredentialResponse, error)
	// Lists NodePools in a given project and location.
	ListNodePools(ctx context.Context, in *ListNodePoolsRequest, opts ...grpc.CallOption) (*ListNodePoolsResponse, error)
	// Gets details of a single NodePool.
	GetNodePool(ctx context.Context, in *GetNodePoolRequest, opts ...grpc.CallOption) (*NodePool, error)
	// Creates a new NodePool in a given project and location.
	CreateNodePool(ctx context.Context, in *CreateNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single NodePool.
	UpdateNodePool(ctx context.Context, in *UpdateNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single NodePool.
	DeleteNodePool(ctx context.Context, in *DeleteNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists Machines in a given project and location.
	ListMachines(ctx context.Context, in *ListMachinesRequest, opts ...grpc.CallOption) (*ListMachinesResponse, error)
	// Gets details of a single Machine.
	GetMachine(ctx context.Context, in *GetMachineRequest, opts ...grpc.CallOption) (*Machine, error)
	// Lists VPN connections in a given project and location.
	ListVpnConnections(ctx context.Context, in *ListVpnConnectionsRequest, opts ...grpc.CallOption) (*ListVpnConnectionsResponse, error)
	// Gets details of a single VPN connection.
	GetVpnConnection(ctx context.Context, in *GetVpnConnectionRequest, opts ...grpc.CallOption) (*VpnConnection, error)
	// Creates a new VPN connection in a given project and location.
	CreateVpnConnection(ctx context.Context, in *CreateVpnConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single VPN connection.
	DeleteVpnConnection(ctx context.Context, in *DeleteVpnConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the server config.
	GetServerConfig(ctx context.Context, in *GetServerConfigRequest, opts ...grpc.CallOption) (*ServerConfig, error)
}

type edgeContainerClient struct {
	cc grpc.ClientConnInterface
}

func NewEdgeContainerClient(cc grpc.ClientConnInterface) EdgeContainerClient {
	return &edgeContainerClient{cc}
}

func (c *edgeContainerClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, EdgeContainer_ListClusters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, EdgeContainer_GetCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EdgeContainer_CreateCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EdgeContainer_UpdateCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) UpgradeCluster(ctx context.Context, in *UpgradeClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EdgeContainer_UpgradeCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EdgeContainer_DeleteCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) GenerateAccessToken(ctx context.Context, in *GenerateAccessTokenRequest, opts ...grpc.CallOption) (*GenerateAccessTokenResponse, error) {
	out := new(GenerateAccessTokenResponse)
	err := c.cc.Invoke(ctx, EdgeContainer_GenerateAccessToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) GenerateOfflineCredential(ctx context.Context, in *GenerateOfflineCredentialRequest, opts ...grpc.CallOption) (*GenerateOfflineCredentialResponse, error) {
	out := new(GenerateOfflineCredentialResponse)
	err := c.cc.Invoke(ctx, EdgeContainer_GenerateOfflineCredential_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) ListNodePools(ctx context.Context, in *ListNodePoolsRequest, opts ...grpc.CallOption) (*ListNodePoolsResponse, error) {
	out := new(ListNodePoolsResponse)
	err := c.cc.Invoke(ctx, EdgeContainer_ListNodePools_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) GetNodePool(ctx context.Context, in *GetNodePoolRequest, opts ...grpc.CallOption) (*NodePool, error) {
	out := new(NodePool)
	err := c.cc.Invoke(ctx, EdgeContainer_GetNodePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) CreateNodePool(ctx context.Context, in *CreateNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EdgeContainer_CreateNodePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) UpdateNodePool(ctx context.Context, in *UpdateNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EdgeContainer_UpdateNodePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) DeleteNodePool(ctx context.Context, in *DeleteNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EdgeContainer_DeleteNodePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) ListMachines(ctx context.Context, in *ListMachinesRequest, opts ...grpc.CallOption) (*ListMachinesResponse, error) {
	out := new(ListMachinesResponse)
	err := c.cc.Invoke(ctx, EdgeContainer_ListMachines_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) GetMachine(ctx context.Context, in *GetMachineRequest, opts ...grpc.CallOption) (*Machine, error) {
	out := new(Machine)
	err := c.cc.Invoke(ctx, EdgeContainer_GetMachine_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) ListVpnConnections(ctx context.Context, in *ListVpnConnectionsRequest, opts ...grpc.CallOption) (*ListVpnConnectionsResponse, error) {
	out := new(ListVpnConnectionsResponse)
	err := c.cc.Invoke(ctx, EdgeContainer_ListVpnConnections_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) GetVpnConnection(ctx context.Context, in *GetVpnConnectionRequest, opts ...grpc.CallOption) (*VpnConnection, error) {
	out := new(VpnConnection)
	err := c.cc.Invoke(ctx, EdgeContainer_GetVpnConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) CreateVpnConnection(ctx context.Context, in *CreateVpnConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EdgeContainer_CreateVpnConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) DeleteVpnConnection(ctx context.Context, in *DeleteVpnConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EdgeContainer_DeleteVpnConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *edgeContainerClient) GetServerConfig(ctx context.Context, in *GetServerConfigRequest, opts ...grpc.CallOption) (*ServerConfig, error) {
	out := new(ServerConfig)
	err := c.cc.Invoke(ctx, EdgeContainer_GetServerConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EdgeContainerServer is the server API for EdgeContainer service.
// All implementations should embed UnimplementedEdgeContainerServer
// for forward compatibility
type EdgeContainerServer interface {
	// Lists Clusters in a given project and location.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets details of a single Cluster.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Creates a new Cluster in a given project and location.
	CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Cluster.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error)
	// Upgrades a single cluster.
	UpgradeCluster(context.Context, *UpgradeClusterRequest) (*longrunningpb.Operation, error)
	// Deletes a single Cluster.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error)
	// Generates an access token for a Cluster.
	GenerateAccessToken(context.Context, *GenerateAccessTokenRequest) (*GenerateAccessTokenResponse, error)
	// Generates an offline credential for a Cluster.
	GenerateOfflineCredential(context.Context, *GenerateOfflineCredentialRequest) (*GenerateOfflineCredentialResponse, error)
	// Lists NodePools in a given project and location.
	ListNodePools(context.Context, *ListNodePoolsRequest) (*ListNodePoolsResponse, error)
	// Gets details of a single NodePool.
	GetNodePool(context.Context, *GetNodePoolRequest) (*NodePool, error)
	// Creates a new NodePool in a given project and location.
	CreateNodePool(context.Context, *CreateNodePoolRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single NodePool.
	UpdateNodePool(context.Context, *UpdateNodePoolRequest) (*longrunningpb.Operation, error)
	// Deletes a single NodePool.
	DeleteNodePool(context.Context, *DeleteNodePoolRequest) (*longrunningpb.Operation, error)
	// Lists Machines in a given project and location.
	ListMachines(context.Context, *ListMachinesRequest) (*ListMachinesResponse, error)
	// Gets details of a single Machine.
	GetMachine(context.Context, *GetMachineRequest) (*Machine, error)
	// Lists VPN connections in a given project and location.
	ListVpnConnections(context.Context, *ListVpnConnectionsRequest) (*ListVpnConnectionsResponse, error)
	// Gets details of a single VPN connection.
	GetVpnConnection(context.Context, *GetVpnConnectionRequest) (*VpnConnection, error)
	// Creates a new VPN connection in a given project and location.
	CreateVpnConnection(context.Context, *CreateVpnConnectionRequest) (*longrunningpb.Operation, error)
	// Deletes a single VPN connection.
	DeleteVpnConnection(context.Context, *DeleteVpnConnectionRequest) (*longrunningpb.Operation, error)
	// Gets the server config.
	GetServerConfig(context.Context, *GetServerConfigRequest) (*ServerConfig, error)
}

// UnimplementedEdgeContainerServer should be embedded to have forward compatible implementations.
type UnimplementedEdgeContainerServer struct {
}

func (UnimplementedEdgeContainerServer) ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (UnimplementedEdgeContainerServer) GetCluster(context.Context, *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (UnimplementedEdgeContainerServer) CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (UnimplementedEdgeContainerServer) UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (UnimplementedEdgeContainerServer) UpgradeCluster(context.Context, *UpgradeClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpgradeCluster not implemented")
}
func (UnimplementedEdgeContainerServer) DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (UnimplementedEdgeContainerServer) GenerateAccessToken(context.Context, *GenerateAccessTokenRequest) (*GenerateAccessTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateAccessToken not implemented")
}
func (UnimplementedEdgeContainerServer) GenerateOfflineCredential(context.Context, *GenerateOfflineCredentialRequest) (*GenerateOfflineCredentialResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateOfflineCredential not implemented")
}
func (UnimplementedEdgeContainerServer) ListNodePools(context.Context, *ListNodePoolsRequest) (*ListNodePoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNodePools not implemented")
}
func (UnimplementedEdgeContainerServer) GetNodePool(context.Context, *GetNodePoolRequest) (*NodePool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNodePool not implemented")
}
func (UnimplementedEdgeContainerServer) CreateNodePool(context.Context, *CreateNodePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNodePool not implemented")
}
func (UnimplementedEdgeContainerServer) UpdateNodePool(context.Context, *UpdateNodePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNodePool not implemented")
}
func (UnimplementedEdgeContainerServer) DeleteNodePool(context.Context, *DeleteNodePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNodePool not implemented")
}
func (UnimplementedEdgeContainerServer) ListMachines(context.Context, *ListMachinesRequest) (*ListMachinesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMachines not implemented")
}
func (UnimplementedEdgeContainerServer) GetMachine(context.Context, *GetMachineRequest) (*Machine, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMachine not implemented")
}
func (UnimplementedEdgeContainerServer) ListVpnConnections(context.Context, *ListVpnConnectionsRequest) (*ListVpnConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVpnConnections not implemented")
}
func (UnimplementedEdgeContainerServer) GetVpnConnection(context.Context, *GetVpnConnectionRequest) (*VpnConnection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVpnConnection not implemented")
}
func (UnimplementedEdgeContainerServer) CreateVpnConnection(context.Context, *CreateVpnConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVpnConnection not implemented")
}
func (UnimplementedEdgeContainerServer) DeleteVpnConnection(context.Context, *DeleteVpnConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVpnConnection not implemented")
}
func (UnimplementedEdgeContainerServer) GetServerConfig(context.Context, *GetServerConfigRequest) (*ServerConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServerConfig not implemented")
}

// UnsafeEdgeContainerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EdgeContainerServer will
// result in compilation errors.
type UnsafeEdgeContainerServer interface {
	mustEmbedUnimplementedEdgeContainerServer()
}

func RegisterEdgeContainerServer(s grpc.ServiceRegistrar, srv EdgeContainerServer) {
	s.RegisterService(&EdgeContainer_ServiceDesc, srv)
}

func _EdgeContainer_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_ListClusters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_GetCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_CreateCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_UpdateCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_UpgradeCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpgradeClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).UpgradeCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_UpgradeCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).UpgradeCluster(ctx, req.(*UpgradeClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_DeleteCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_GenerateAccessToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAccessTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).GenerateAccessToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_GenerateAccessToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).GenerateAccessToken(ctx, req.(*GenerateAccessTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_GenerateOfflineCredential_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateOfflineCredentialRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).GenerateOfflineCredential(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_GenerateOfflineCredential_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).GenerateOfflineCredential(ctx, req.(*GenerateOfflineCredentialRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_ListNodePools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodePoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).ListNodePools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_ListNodePools_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).ListNodePools(ctx, req.(*ListNodePoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_GetNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).GetNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_GetNodePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).GetNodePool(ctx, req.(*GetNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_CreateNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).CreateNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_CreateNodePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).CreateNodePool(ctx, req.(*CreateNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_UpdateNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).UpdateNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_UpdateNodePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).UpdateNodePool(ctx, req.(*UpdateNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_DeleteNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).DeleteNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_DeleteNodePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).DeleteNodePool(ctx, req.(*DeleteNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_ListMachines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMachinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).ListMachines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_ListMachines_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).ListMachines(ctx, req.(*ListMachinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_GetMachine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMachineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).GetMachine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_GetMachine_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).GetMachine(ctx, req.(*GetMachineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_ListVpnConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVpnConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).ListVpnConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_ListVpnConnections_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).ListVpnConnections(ctx, req.(*ListVpnConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_GetVpnConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVpnConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).GetVpnConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_GetVpnConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).GetVpnConnection(ctx, req.(*GetVpnConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_CreateVpnConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVpnConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).CreateVpnConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_CreateVpnConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).CreateVpnConnection(ctx, req.(*CreateVpnConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_DeleteVpnConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVpnConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).DeleteVpnConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_DeleteVpnConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).DeleteVpnConnection(ctx, req.(*DeleteVpnConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EdgeContainer_GetServerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EdgeContainerServer).GetServerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EdgeContainer_GetServerConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EdgeContainerServer).GetServerConfig(ctx, req.(*GetServerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// EdgeContainer_ServiceDesc is the grpc.ServiceDesc for EdgeContainer service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var EdgeContainer_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.edgecontainer.v1.EdgeContainer",
	HandlerType: (*EdgeContainerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListClusters",
			Handler:    _EdgeContainer_ListClusters_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _EdgeContainer_GetCluster_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _EdgeContainer_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _EdgeContainer_UpdateCluster_Handler,
		},
		{
			MethodName: "UpgradeCluster",
			Handler:    _EdgeContainer_UpgradeCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _EdgeContainer_DeleteCluster_Handler,
		},
		{
			MethodName: "GenerateAccessToken",
			Handler:    _EdgeContainer_GenerateAccessToken_Handler,
		},
		{
			MethodName: "GenerateOfflineCredential",
			Handler:    _EdgeContainer_GenerateOfflineCredential_Handler,
		},
		{
			MethodName: "ListNodePools",
			Handler:    _EdgeContainer_ListNodePools_Handler,
		},
		{
			MethodName: "GetNodePool",
			Handler:    _EdgeContainer_GetNodePool_Handler,
		},
		{
			MethodName: "CreateNodePool",
			Handler:    _EdgeContainer_CreateNodePool_Handler,
		},
		{
			MethodName: "UpdateNodePool",
			Handler:    _EdgeContainer_UpdateNodePool_Handler,
		},
		{
			MethodName: "DeleteNodePool",
			Handler:    _EdgeContainer_DeleteNodePool_Handler,
		},
		{
			MethodName: "ListMachines",
			Handler:    _EdgeContainer_ListMachines_Handler,
		},
		{
			MethodName: "GetMachine",
			Handler:    _EdgeContainer_GetMachine_Handler,
		},
		{
			MethodName: "ListVpnConnections",
			Handler:    _EdgeContainer_ListVpnConnections_Handler,
		},
		{
			MethodName: "GetVpnConnection",
			Handler:    _EdgeContainer_GetVpnConnection_Handler,
		},
		{
			MethodName: "CreateVpnConnection",
			Handler:    _EdgeContainer_CreateVpnConnection_Handler,
		},
		{
			MethodName: "DeleteVpnConnection",
			Handler:    _EdgeContainer_DeleteVpnConnection_Handler,
		},
		{
			MethodName: "GetServerConfig",
			Handler:    _EdgeContainer_GetServerConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/edgecontainer/v1/service.proto",
}
