// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/mediatranslation/v1beta1/media_translation.proto

package mediatranslationpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	SpeechTranslationService_StreamingTranslateSpeech_FullMethodName = "/google.cloud.mediatranslation.v1beta1.SpeechTranslationService/StreamingTranslateSpeech"
)

// SpeechTranslationServiceClient is the client API for SpeechTranslationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SpeechTranslationServiceClient interface {
	// Performs bidirectional streaming speech translation: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingTranslateSpeech(ctx context.Context, opts ...grpc.CallOption) (SpeechTranslationService_StreamingTranslateSpeechClient, error)
}

type speechTranslationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSpeechTranslationServiceClient(cc grpc.ClientConnInterface) SpeechTranslationServiceClient {
	return &speechTranslationServiceClient{cc}
}

func (c *speechTranslationServiceClient) StreamingTranslateSpeech(ctx context.Context, opts ...grpc.CallOption) (SpeechTranslationService_StreamingTranslateSpeechClient, error) {
	stream, err := c.cc.NewStream(ctx, &SpeechTranslationService_ServiceDesc.Streams[0], SpeechTranslationService_StreamingTranslateSpeech_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &speechTranslationServiceStreamingTranslateSpeechClient{stream}
	return x, nil
}

type SpeechTranslationService_StreamingTranslateSpeechClient interface {
	Send(*StreamingTranslateSpeechRequest) error
	Recv() (*StreamingTranslateSpeechResponse, error)
	grpc.ClientStream
}

type speechTranslationServiceStreamingTranslateSpeechClient struct {
	grpc.ClientStream
}

func (x *speechTranslationServiceStreamingTranslateSpeechClient) Send(m *StreamingTranslateSpeechRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *speechTranslationServiceStreamingTranslateSpeechClient) Recv() (*StreamingTranslateSpeechResponse, error) {
	m := new(StreamingTranslateSpeechResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SpeechTranslationServiceServer is the server API for SpeechTranslationService service.
// All implementations should embed UnimplementedSpeechTranslationServiceServer
// for forward compatibility
type SpeechTranslationServiceServer interface {
	// Performs bidirectional streaming speech translation: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingTranslateSpeech(SpeechTranslationService_StreamingTranslateSpeechServer) error
}

// UnimplementedSpeechTranslationServiceServer should be embedded to have forward compatible implementations.
type UnimplementedSpeechTranslationServiceServer struct {
}

func (UnimplementedSpeechTranslationServiceServer) StreamingTranslateSpeech(SpeechTranslationService_StreamingTranslateSpeechServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingTranslateSpeech not implemented")
}

// UnsafeSpeechTranslationServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SpeechTranslationServiceServer will
// result in compilation errors.
type UnsafeSpeechTranslationServiceServer interface {
	mustEmbedUnimplementedSpeechTranslationServiceServer()
}

func RegisterSpeechTranslationServiceServer(s grpc.ServiceRegistrar, srv SpeechTranslationServiceServer) {
	s.RegisterService(&SpeechTranslationService_ServiceDesc, srv)
}

func _SpeechTranslationService_StreamingTranslateSpeech_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SpeechTranslationServiceServer).StreamingTranslateSpeech(&speechTranslationServiceStreamingTranslateSpeechServer{stream})
}

type SpeechTranslationService_StreamingTranslateSpeechServer interface {
	Send(*StreamingTranslateSpeechResponse) error
	Recv() (*StreamingTranslateSpeechRequest, error)
	grpc.ServerStream
}

type speechTranslationServiceStreamingTranslateSpeechServer struct {
	grpc.ServerStream
}

func (x *speechTranslationServiceStreamingTranslateSpeechServer) Send(m *StreamingTranslateSpeechResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *speechTranslationServiceStreamingTranslateSpeechServer) Recv() (*StreamingTranslateSpeechRequest, error) {
	m := new(StreamingTranslateSpeechRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SpeechTranslationService_ServiceDesc is the grpc.ServiceDesc for SpeechTranslationService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SpeechTranslationService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.mediatranslation.v1beta1.SpeechTranslationService",
	HandlerType: (*SpeechTranslationServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingTranslateSpeech",
			Handler:       _SpeechTranslationService_StreamingTranslateSpeech_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/mediatranslation/v1beta1/media_translation.proto",
}
