// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/v2/conversation.proto

package dialogflowpb

import (
	context "context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enumeration of the completion status of the conversation.
type Conversation_LifecycleState int32

const (
	// Unknown.
	Conversation_LIFECYCLE_STATE_UNSPECIFIED Conversation_LifecycleState = 0
	// Conversation is currently open for media analysis.
	Conversation_IN_PROGRESS Conversation_LifecycleState = 1
	// Conversation has been completed.
	Conversation_COMPLETED Conversation_LifecycleState = 2
)

// Enum value maps for Conversation_LifecycleState.
var (
	Conversation_LifecycleState_name = map[int32]string{
		0: "LIFECYCLE_STATE_UNSPECIFIED",
		1: "IN_PROGRESS",
		2: "COMPLETED",
	}
	Conversation_LifecycleState_value = map[string]int32{
		"LIFECYCLE_STATE_UNSPECIFIED": 0,
		"IN_PROGRESS":                 1,
		"COMPLETED":                   2,
	}
)

func (x Conversation_LifecycleState) Enum() *Conversation_LifecycleState {
	p := new(Conversation_LifecycleState)
	*p = x
	return p
}

func (x Conversation_LifecycleState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Conversation_LifecycleState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[0].Descriptor()
}

func (Conversation_LifecycleState) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[0]
}

func (x Conversation_LifecycleState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Conversation_LifecycleState.Descriptor instead.
func (Conversation_LifecycleState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{0, 0}
}

// Enumeration of the different conversation stages a conversation can be in.
// Reference:
// https://cloud.google.com/agent-assist/docs/basics#conversation_stages
type Conversation_ConversationStage int32

const (
	// Unknown. Should never be used after a conversation is successfully
	// created.
	Conversation_CONVERSATION_STAGE_UNSPECIFIED Conversation_ConversationStage = 0
	// The conversation should return virtual agent responses into the
	// conversation.
	Conversation_VIRTUAL_AGENT_STAGE Conversation_ConversationStage = 1
	// The conversation should not provide responses, just listen and provide
	// suggestions.
	Conversation_HUMAN_ASSIST_STAGE Conversation_ConversationStage = 2
)

// Enum value maps for Conversation_ConversationStage.
var (
	Conversation_ConversationStage_name = map[int32]string{
		0: "CONVERSATION_STAGE_UNSPECIFIED",
		1: "VIRTUAL_AGENT_STAGE",
		2: "HUMAN_ASSIST_STAGE",
	}
	Conversation_ConversationStage_value = map[string]int32{
		"CONVERSATION_STAGE_UNSPECIFIED": 0,
		"VIRTUAL_AGENT_STAGE":            1,
		"HUMAN_ASSIST_STAGE":             2,
	}
)

func (x Conversation_ConversationStage) Enum() *Conversation_ConversationStage {
	p := new(Conversation_ConversationStage)
	*p = x
	return p
}

func (x Conversation_ConversationStage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Conversation_ConversationStage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[1].Descriptor()
}

func (Conversation_ConversationStage) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[1]
}

func (x Conversation_ConversationStage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Conversation_ConversationStage.Descriptor instead.
func (Conversation_ConversationStage) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{0, 1}
}

// Represents the mode in which context reference contents are updated.
type Conversation_ContextReference_UpdateMode int32

const (
	// Unspecified update mode.
	Conversation_ContextReference_UPDATE_MODE_UNSPECIFIED Conversation_ContextReference_UpdateMode = 0
	// Context content updates are applied in append mode.
	Conversation_ContextReference_APPEND Conversation_ContextReference_UpdateMode = 1
	// Context content updates are applied in overwrite mode.
	Conversation_ContextReference_OVERWRITE Conversation_ContextReference_UpdateMode = 2
)

// Enum value maps for Conversation_ContextReference_UpdateMode.
var (
	Conversation_ContextReference_UpdateMode_name = map[int32]string{
		0: "UPDATE_MODE_UNSPECIFIED",
		1: "APPEND",
		2: "OVERWRITE",
	}
	Conversation_ContextReference_UpdateMode_value = map[string]int32{
		"UPDATE_MODE_UNSPECIFIED": 0,
		"APPEND":                  1,
		"OVERWRITE":               2,
	}
)

func (x Conversation_ContextReference_UpdateMode) Enum() *Conversation_ContextReference_UpdateMode {
	p := new(Conversation_ContextReference_UpdateMode)
	*p = x
	return p
}

func (x Conversation_ContextReference_UpdateMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Conversation_ContextReference_UpdateMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[2].Descriptor()
}

func (Conversation_ContextReference_UpdateMode) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[2]
}

func (x Conversation_ContextReference_UpdateMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Conversation_ContextReference_UpdateMode.Descriptor instead.
func (Conversation_ContextReference_UpdateMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{0, 1, 0}
}

// Represents the format of the ingested string.
type Conversation_ContextReference_ContextContent_ContentFormat int32

const (
	// Unspecified content format.
	Conversation_ContextReference_ContextContent_CONTENT_FORMAT_UNSPECIFIED Conversation_ContextReference_ContextContent_ContentFormat = 0
	// Content was provided in JSON format.
	Conversation_ContextReference_ContextContent_JSON Conversation_ContextReference_ContextContent_ContentFormat = 1
	// Content was provided as plain text.
	Conversation_ContextReference_ContextContent_PLAIN_TEXT Conversation_ContextReference_ContextContent_ContentFormat = 2
)

// Enum value maps for Conversation_ContextReference_ContextContent_ContentFormat.
var (
	Conversation_ContextReference_ContextContent_ContentFormat_name = map[int32]string{
		0: "CONTENT_FORMAT_UNSPECIFIED",
		1: "JSON",
		2: "PLAIN_TEXT",
	}
	Conversation_ContextReference_ContextContent_ContentFormat_value = map[string]int32{
		"CONTENT_FORMAT_UNSPECIFIED": 0,
		"JSON":                       1,
		"PLAIN_TEXT":                 2,
	}
)

func (x Conversation_ContextReference_ContextContent_ContentFormat) Enum() *Conversation_ContextReference_ContextContent_ContentFormat {
	p := new(Conversation_ContextReference_ContextContent_ContentFormat)
	*p = x
	return p
}

func (x Conversation_ContextReference_ContextContent_ContentFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Conversation_ContextReference_ContextContent_ContentFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[3].Descriptor()
}

func (Conversation_ContextReference_ContextContent_ContentFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[3]
}

func (x Conversation_ContextReference_ContextContent_ContentFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Conversation_ContextReference_ContextContent_ContentFormat.Descriptor instead.
func (Conversation_ContextReference_ContextContent_ContentFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{0, 1, 0, 0}
}

// The source of the query. We use QuerySource to distinguish queries directly
// entered by agents and suggested queries from
// [Participants.SuggestKnowledgeAssist][google.cloud.dialogflow.v2.Participants.SuggestKnowledgeAssist].
// If SUGGESTED_QUERY source is specified, we will treat it as a continuation
// of a SuggestKnowledgeAssist call.
type SearchKnowledgeRequest_QuerySource int32

const (
	// Unknown query source.
	SearchKnowledgeRequest_QUERY_SOURCE_UNSPECIFIED SearchKnowledgeRequest_QuerySource = 0
	// The query is from agents.
	SearchKnowledgeRequest_AGENT_QUERY SearchKnowledgeRequest_QuerySource = 1
	// The query is a suggested query from
	// [Participants.SuggestKnowledgeAssist][google.cloud.dialogflow.v2.Participants.SuggestKnowledgeAssist].
	SearchKnowledgeRequest_SUGGESTED_QUERY SearchKnowledgeRequest_QuerySource = 2
)

// Enum value maps for SearchKnowledgeRequest_QuerySource.
var (
	SearchKnowledgeRequest_QuerySource_name = map[int32]string{
		0: "QUERY_SOURCE_UNSPECIFIED",
		1: "AGENT_QUERY",
		2: "SUGGESTED_QUERY",
	}
	SearchKnowledgeRequest_QuerySource_value = map[string]int32{
		"QUERY_SOURCE_UNSPECIFIED": 0,
		"AGENT_QUERY":              1,
		"SUGGESTED_QUERY":          2,
	}
)

func (x SearchKnowledgeRequest_QuerySource) Enum() *SearchKnowledgeRequest_QuerySource {
	p := new(SearchKnowledgeRequest_QuerySource)
	*p = x
	return p
}

func (x SearchKnowledgeRequest_QuerySource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchKnowledgeRequest_QuerySource) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[4].Descriptor()
}

func (SearchKnowledgeRequest_QuerySource) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[4]
}

func (x SearchKnowledgeRequest_QuerySource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchKnowledgeRequest_QuerySource.Descriptor instead.
func (SearchKnowledgeRequest_QuerySource) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{17, 0}
}

// The attribute(or function) for which the custom ranking is to be
// applied.
type SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType int32

const (
	// Unspecified AttributeType.
	SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_ATTRIBUTE_TYPE_UNSPECIFIED SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType = 0
	// The value of the numerical field will be used to dynamically
	// update the boost amount. In this case, the attribute_value (the
	// x value) of the control point will be the actual value of the
	// numerical field for which the boost_amount is specified.
	SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_NUMERICAL SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType = 1
	// For the freshness use case the attribute value will be the
	// duration between the current time and the date in the datetime
	// field specified. The value must be formatted as an XSD
	// `dayTimeDuration` value (a restricted subset of an ISO 8601
	// duration value). The pattern for this is:
	// `[nD][T[nH][nM][nS]]`. E.g. `5D`, `3DT12H30M`, `T24H`.
	SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_FRESHNESS SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType = 2
)

// Enum value maps for SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType.
var (
	SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType_name = map[int32]string{
		0: "ATTRIBUTE_TYPE_UNSPECIFIED",
		1: "NUMERICAL",
		2: "FRESHNESS",
	}
	SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType_value = map[string]int32{
		"ATTRIBUTE_TYPE_UNSPECIFIED": 0,
		"NUMERICAL":                  1,
		"FRESHNESS":                  2,
	}
)

func (x SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType) Enum() *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType {
	p := new(SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType)
	*p = x
	return p
}

func (x SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[5].Descriptor()
}

func (SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[5]
}

func (x SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType.Descriptor instead.
func (SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{17, 0, 0, 0, 0, 0, 0}
}

// The interpolation type to be applied. Default will be linear
// (Piecewise Linear).
type SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType int32

const (
	// Interpolation type is unspecified. In this case, it defaults to
	// Linear.
	SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_INTERPOLATION_TYPE_UNSPECIFIED SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType = 0
	// Piecewise linear interpolation will be applied.
	SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_LINEAR SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType = 1
)

// Enum value maps for SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType.
var (
	SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType_name = map[int32]string{
		0: "INTERPOLATION_TYPE_UNSPECIFIED",
		1: "LINEAR",
	}
	SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType_value = map[string]int32{
		"INTERPOLATION_TYPE_UNSPECIFIED": 0,
		"LINEAR":                         1,
	}
)

func (x SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType) Enum() *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType {
	p := new(SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType)
	*p = x
	return p
}

func (x SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[6].Descriptor()
}

func (SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[6]
}

func (x SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType.Descriptor instead.
func (SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{17, 0, 0, 0, 0, 0, 1}
}

// The type of the answer.
type SearchKnowledgeAnswer_AnswerType int32

const (
	// The answer has a unspecified type.
	SearchKnowledgeAnswer_ANSWER_TYPE_UNSPECIFIED SearchKnowledgeAnswer_AnswerType = 0
	// The answer is from FAQ documents.
	SearchKnowledgeAnswer_FAQ SearchKnowledgeAnswer_AnswerType = 1
	// The answer is from generative model.
	SearchKnowledgeAnswer_GENERATIVE SearchKnowledgeAnswer_AnswerType = 2
	// The answer is from intent matching.
	SearchKnowledgeAnswer_INTENT SearchKnowledgeAnswer_AnswerType = 3
)

// Enum value maps for SearchKnowledgeAnswer_AnswerType.
var (
	SearchKnowledgeAnswer_AnswerType_name = map[int32]string{
		0: "ANSWER_TYPE_UNSPECIFIED",
		1: "FAQ",
		2: "GENERATIVE",
		3: "INTENT",
	}
	SearchKnowledgeAnswer_AnswerType_value = map[string]int32{
		"ANSWER_TYPE_UNSPECIFIED": 0,
		"FAQ":                     1,
		"GENERATIVE":              2,
		"INTENT":                  3,
	}
)

func (x SearchKnowledgeAnswer_AnswerType) Enum() *SearchKnowledgeAnswer_AnswerType {
	p := new(SearchKnowledgeAnswer_AnswerType)
	*p = x
	return p
}

func (x SearchKnowledgeAnswer_AnswerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchKnowledgeAnswer_AnswerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[7].Descriptor()
}

func (SearchKnowledgeAnswer_AnswerType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_conversation_proto_enumTypes[7]
}

func (x SearchKnowledgeAnswer_AnswerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchKnowledgeAnswer_AnswerType.Descriptor instead.
func (SearchKnowledgeAnswer_AnswerType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{19, 0}
}

// Represents a conversation.
// A conversation is an interaction between an agent, including live agents
// and Dialogflow agents, and a support customer. Conversations can
// include phone calls and text-based chat sessions.
type Conversation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The unique identifier of this conversation.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The current state of the Conversation.
	LifecycleState Conversation_LifecycleState `protobuf:"varint,2,opt,name=lifecycle_state,json=lifecycleState,proto3,enum=google.cloud.dialogflow.v2.Conversation_LifecycleState" json:"lifecycle_state,omitempty"`
	// Required. The Conversation Profile to be used to configure this
	// Conversation. This field cannot be updated.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversationProfiles/<Conversation Profile ID>`.
	ConversationProfile string `protobuf:"bytes,3,opt,name=conversation_profile,json=conversationProfile,proto3" json:"conversation_profile,omitempty"`
	// Output only. It will not be empty if the conversation is to be connected
	// over telephony.
	PhoneNumber *ConversationPhoneNumber `protobuf:"bytes,4,opt,name=phone_number,json=phoneNumber,proto3" json:"phone_number,omitempty"`
	// Output only. The time the conversation was started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The time the conversation was finished.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Optional. The stage of a conversation. It indicates whether the virtual
	// agent or a human agent is handling the conversation.
	//
	// If the conversation is created with the conversation profile that has
	// Dialogflow config set, defaults to
	// [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE];
	// Otherwise, defaults to
	// [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
	//
	// If the conversation is created with the conversation profile that has
	// Dialogflow config set but explicitly sets conversation_stage to
	// [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2.Conversation.ConversationStage.HUMAN_ASSIST_STAGE],
	// it skips
	// [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE]
	// stage and directly goes to
	// [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
	ConversationStage Conversation_ConversationStage `protobuf:"varint,7,opt,name=conversation_stage,json=conversationStage,proto3,enum=google.cloud.dialogflow.v2.Conversation_ConversationStage" json:"conversation_stage,omitempty"`
	// Output only. The telephony connection information.
	TelephonyConnectionInfo *Conversation_TelephonyConnectionInfo `protobuf:"bytes,10,opt,name=telephony_connection_info,json=telephonyConnectionInfo,proto3" json:"telephony_connection_info,omitempty"`
	// Output only. The context reference updates provided by external systems.
	IngestedContextReferences map[string]*Conversation_ContextReference `protobuf:"bytes,17,rep,name=ingested_context_references,json=ingestedContextReferences,proto3" json:"ingested_context_references,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Conversation) Reset() {
	*x = Conversation{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Conversation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation) ProtoMessage() {}

func (x *Conversation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation.ProtoReflect.Descriptor instead.
func (*Conversation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{0}
}

func (x *Conversation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Conversation) GetLifecycleState() Conversation_LifecycleState {
	if x != nil {
		return x.LifecycleState
	}
	return Conversation_LIFECYCLE_STATE_UNSPECIFIED
}

func (x *Conversation) GetConversationProfile() string {
	if x != nil {
		return x.ConversationProfile
	}
	return ""
}

func (x *Conversation) GetPhoneNumber() *ConversationPhoneNumber {
	if x != nil {
		return x.PhoneNumber
	}
	return nil
}

func (x *Conversation) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Conversation) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Conversation) GetConversationStage() Conversation_ConversationStage {
	if x != nil {
		return x.ConversationStage
	}
	return Conversation_CONVERSATION_STAGE_UNSPECIFIED
}

func (x *Conversation) GetTelephonyConnectionInfo() *Conversation_TelephonyConnectionInfo {
	if x != nil {
		return x.TelephonyConnectionInfo
	}
	return nil
}

func (x *Conversation) GetIngestedContextReferences() map[string]*Conversation_ContextReference {
	if x != nil {
		return x.IngestedContextReferences
	}
	return nil
}

// The request message for
// [Conversations.CreateConversation][google.cloud.dialogflow.v2.Conversations.CreateConversation].
type CreateConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource identifier of the project creating the conversation.
	// Format: `projects/<Project ID>/locations/<Location ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The conversation to create.
	Conversation *Conversation `protobuf:"bytes,2,opt,name=conversation,proto3" json:"conversation,omitempty"`
	// Optional. Identifier of the conversation. Generally it's auto generated by
	// Google. Only set it if you cannot wait for the response to return a
	// auto-generated one to you.
	//
	// The conversation ID must be compliant with the regression formula
	// `[a-zA-Z][a-zA-Z0-9_-]*` with the characters length in range of [3,64].
	// If the field is provided, the caller is responsible for
	// 1. the uniqueness of the ID, otherwise the request will be rejected.
	// 2. the consistency for whether to use custom ID or not under a project to
	// better ensure uniqueness.
	ConversationId string `protobuf:"bytes,3,opt,name=conversation_id,json=conversationId,proto3" json:"conversation_id,omitempty"`
}

func (x *CreateConversationRequest) Reset() {
	*x = CreateConversationRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversationRequest) ProtoMessage() {}

func (x *CreateConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversationRequest.ProtoReflect.Descriptor instead.
func (*CreateConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{1}
}

func (x *CreateConversationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConversationRequest) GetConversation() *Conversation {
	if x != nil {
		return x.Conversation
	}
	return nil
}

func (x *CreateConversationRequest) GetConversationId() string {
	if x != nil {
		return x.ConversationId
	}
	return ""
}

// The request message for
// [Conversations.ListConversations][google.cloud.dialogflow.v2.Conversations.ListConversations].
type ListConversationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project from which to list all conversation.
	// Format: `projects/<Project ID>/locations/<Location ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter expression that filters conversations listed in the
	// response. Only `lifecycle_state` can be filtered on in this way. For
	// example, the following expression only returns `COMPLETED` conversations:
	//
	// `lifecycle_state = "COMPLETED"`
	//
	// For more information about filtering, see
	// [API Filtering](https://aip.dev/160).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListConversationsRequest) Reset() {
	*x = ListConversationsRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListConversationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationsRequest) ProtoMessage() {}

func (x *ListConversationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationsRequest.ProtoReflect.Descriptor instead.
func (*ListConversationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{2}
}

func (x *ListConversationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConversationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConversationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListConversationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response message for
// [Conversations.ListConversations][google.cloud.dialogflow.v2.Conversations.ListConversations].
type ListConversationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of conversations. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Conversations []*Conversation `protobuf:"bytes,1,rep,name=conversations,proto3" json:"conversations,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConversationsResponse) Reset() {
	*x = ListConversationsResponse{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListConversationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationsResponse) ProtoMessage() {}

func (x *ListConversationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationsResponse.ProtoReflect.Descriptor instead.
func (*ListConversationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{3}
}

func (x *ListConversationsResponse) GetConversations() []*Conversation {
	if x != nil {
		return x.Conversations
	}
	return nil
}

func (x *ListConversationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Conversations.GetConversation][google.cloud.dialogflow.v2.Conversations.GetConversation].
type GetConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the conversation. Format:
	// `projects/<Project ID>/locations/<Location ID>/conversations/<Conversation
	// ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConversationRequest) Reset() {
	*x = GetConversationRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationRequest) ProtoMessage() {}

func (x *GetConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationRequest.ProtoReflect.Descriptor instead.
func (*GetConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{4}
}

func (x *GetConversationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Conversations.CompleteConversation][google.cloud.dialogflow.v2.Conversations.CompleteConversation].
type CompleteConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource identifier of the conversation to close.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CompleteConversationRequest) Reset() {
	*x = CompleteConversationRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CompleteConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteConversationRequest) ProtoMessage() {}

func (x *CompleteConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteConversationRequest.ProtoReflect.Descriptor instead.
func (*CompleteConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{5}
}

func (x *CompleteConversationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Conversations.ListMessages][google.cloud.dialogflow.v2.Conversations.ListMessages].
type ListMessagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the conversation to list messages for.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Filter on message fields. Currently predicates on `create_time`
	// and `create_time_epoch_microseconds` are supported. `create_time` only
	// support milliseconds accuracy. E.g.,
	// `create_time_epoch_microseconds > 1551790877964485` or
	// `create_time > 2017-01-15T01:30:15.01Z`.
	//
	// For more information about filtering, see
	// [API Filtering](https://aip.dev/160).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListMessagesRequest) Reset() {
	*x = ListMessagesRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMessagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMessagesRequest) ProtoMessage() {}

func (x *ListMessagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMessagesRequest.ProtoReflect.Descriptor instead.
func (*ListMessagesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{6}
}

func (x *ListMessagesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMessagesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListMessagesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMessagesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Conversations.ListMessages][google.cloud.dialogflow.v2.Conversations.ListMessages].
type ListMessagesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of messages. There will be a maximum number of items
	// returned based on the page_size field in the request.
	// `messages` is sorted by `create_time` in descending order.
	Messages []*Message `protobuf:"bytes,1,rep,name=messages,proto3" json:"messages,omitempty"`
	// Token to retrieve the next page of results, or empty if there are
	// no more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMessagesResponse) Reset() {
	*x = ListMessagesResponse{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMessagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMessagesResponse) ProtoMessage() {}

func (x *ListMessagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMessagesResponse.ProtoReflect.Descriptor instead.
func (*ListMessagesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{7}
}

func (x *ListMessagesResponse) GetMessages() []*Message {
	if x != nil {
		return x.Messages
	}
	return nil
}

func (x *ListMessagesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Represents a phone number for telephony integration. It allows for connecting
// a particular conversation over telephony.
type ConversationPhoneNumber struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Desired country code for the phone number.
	CountryCode int32 `protobuf:"varint,2,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// Output only. The phone number to connect to this conversation.
	PhoneNumber string `protobuf:"bytes,3,opt,name=phone_number,json=phoneNumber,proto3" json:"phone_number,omitempty"`
}

func (x *ConversationPhoneNumber) Reset() {
	*x = ConversationPhoneNumber{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationPhoneNumber) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationPhoneNumber) ProtoMessage() {}

func (x *ConversationPhoneNumber) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationPhoneNumber.ProtoReflect.Descriptor instead.
func (*ConversationPhoneNumber) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{8}
}

func (x *ConversationPhoneNumber) GetCountryCode() int32 {
	if x != nil {
		return x.CountryCode
	}
	return 0
}

func (x *ConversationPhoneNumber) GetPhoneNumber() string {
	if x != nil {
		return x.PhoneNumber
	}
	return ""
}

// The request message for [ConversationsService.IngestContextReferences][].
type IngestContextReferencesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource identifier of the conversation to ingest context
	// information for. Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>`.
	Conversation string `protobuf:"bytes,1,opt,name=conversation,proto3" json:"conversation,omitempty"`
	// Required. The context references to ingest. The key is the name of the
	// context reference and the value contains the contents of the context
	// reference. The key is used to incorporate ingested context references to
	// enhance the generator.
	ContextReferences map[string]*Conversation_ContextReference `protobuf:"bytes,2,rep,name=context_references,json=contextReferences,proto3" json:"context_references,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *IngestContextReferencesRequest) Reset() {
	*x = IngestContextReferencesRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestContextReferencesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestContextReferencesRequest) ProtoMessage() {}

func (x *IngestContextReferencesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestContextReferencesRequest.ProtoReflect.Descriptor instead.
func (*IngestContextReferencesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{9}
}

func (x *IngestContextReferencesRequest) GetConversation() string {
	if x != nil {
		return x.Conversation
	}
	return ""
}

func (x *IngestContextReferencesRequest) GetContextReferences() map[string]*Conversation_ContextReference {
	if x != nil {
		return x.ContextReferences
	}
	return nil
}

// The response message for [ConversationsService.IngestContextReferences][].
type IngestContextReferencesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All context references ingested.
	IngestedContextReferences map[string]*Conversation_ContextReference `protobuf:"bytes,1,rep,name=ingested_context_references,json=ingestedContextReferences,proto3" json:"ingested_context_references,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *IngestContextReferencesResponse) Reset() {
	*x = IngestContextReferencesResponse{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestContextReferencesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestContextReferencesResponse) ProtoMessage() {}

func (x *IngestContextReferencesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestContextReferencesResponse.ProtoReflect.Descriptor instead.
func (*IngestContextReferencesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{10}
}

func (x *IngestContextReferencesResponse) GetIngestedContextReferences() map[string]*Conversation_ContextReference {
	if x != nil {
		return x.IngestedContextReferences
	}
	return nil
}

// The request message for
// [Conversations.SuggestConversationSummary][google.cloud.dialogflow.v2.Conversations.SuggestConversationSummary].
type SuggestConversationSummaryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversation to fetch suggestion for.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>`.
	Conversation string `protobuf:"bytes,1,opt,name=conversation,proto3" json:"conversation,omitempty"`
	// Optional. The name of the latest conversation message used as context for
	// compiling suggestion. If empty, the latest message of the conversation will
	// be used.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,3,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Optional. Max number of messages prior to and including
	// [latest_message] to use as context when compiling the
	// suggestion. By default 500 and at most 1000.
	ContextSize int32 `protobuf:"varint,4,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
	// Optional. Parameters for a human assist query. Only used for POC/demo
	// purpose.
	AssistQueryParams *AssistQueryParameters `protobuf:"bytes,5,opt,name=assist_query_params,json=assistQueryParams,proto3" json:"assist_query_params,omitempty"`
}

func (x *SuggestConversationSummaryRequest) Reset() {
	*x = SuggestConversationSummaryRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestConversationSummaryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestConversationSummaryRequest) ProtoMessage() {}

func (x *SuggestConversationSummaryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestConversationSummaryRequest.ProtoReflect.Descriptor instead.
func (*SuggestConversationSummaryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{11}
}

func (x *SuggestConversationSummaryRequest) GetConversation() string {
	if x != nil {
		return x.Conversation
	}
	return ""
}

func (x *SuggestConversationSummaryRequest) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SuggestConversationSummaryRequest) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

func (x *SuggestConversationSummaryRequest) GetAssistQueryParams() *AssistQueryParameters {
	if x != nil {
		return x.AssistQueryParams
	}
	return nil
}

// The response message for
// [Conversations.SuggestConversationSummary][google.cloud.dialogflow.v2.Conversations.SuggestConversationSummary].
type SuggestConversationSummaryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Generated summary.
	Summary *SuggestConversationSummaryResponse_Summary `protobuf:"bytes,1,opt,name=summary,proto3" json:"summary,omitempty"`
	// The name of the latest conversation message used as context for
	// compiling suggestion.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Number of messages prior to and including
	// [latest_message][google.cloud.dialogflow.v2.SuggestConversationSummaryResponse.latest_message]
	// used to compile the suggestion. It may be smaller than the
	// [SuggestConversationSummaryRequest.context_size][google.cloud.dialogflow.v2.SuggestConversationSummaryRequest.context_size]
	// field in the request if there weren't that many messages in the
	// conversation.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
}

func (x *SuggestConversationSummaryResponse) Reset() {
	*x = SuggestConversationSummaryResponse{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestConversationSummaryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestConversationSummaryResponse) ProtoMessage() {}

func (x *SuggestConversationSummaryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestConversationSummaryResponse.ProtoReflect.Descriptor instead.
func (*SuggestConversationSummaryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{12}
}

func (x *SuggestConversationSummaryResponse) GetSummary() *SuggestConversationSummaryResponse_Summary {
	if x != nil {
		return x.Summary
	}
	return nil
}

func (x *SuggestConversationSummaryResponse) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SuggestConversationSummaryResponse) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

// The request message for
// [Conversations.GenerateStatelessSummary][google.cloud.dialogflow.v2.Conversations.GenerateStatelessSummary].
type GenerateStatelessSummaryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversation to suggest a summary for.
	StatelessConversation *GenerateStatelessSummaryRequest_MinimalConversation `protobuf:"bytes,1,opt,name=stateless_conversation,json=statelessConversation,proto3" json:"stateless_conversation,omitempty"`
	// Required. A ConversationProfile containing information required for Summary
	// generation.
	// Required fields: {language_code, security_settings}
	// Optional fields: {agent_assistant_config}
	ConversationProfile *ConversationProfile `protobuf:"bytes,2,opt,name=conversation_profile,json=conversationProfile,proto3" json:"conversation_profile,omitempty"`
	// Optional. The name of the latest conversation message used as context for
	// generating a Summary. If empty, the latest message of the conversation will
	// be used. The format is specific to the user and the names of the messages
	// provided.
	LatestMessage string `protobuf:"bytes,3,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Optional. Max number of messages prior to and including
	// [latest_message] to use as context when compiling the
	// suggestion. By default 500 and at most 1000.
	MaxContextSize int32 `protobuf:"varint,4,opt,name=max_context_size,json=maxContextSize,proto3" json:"max_context_size,omitempty"`
}

func (x *GenerateStatelessSummaryRequest) Reset() {
	*x = GenerateStatelessSummaryRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateStatelessSummaryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateStatelessSummaryRequest) ProtoMessage() {}

func (x *GenerateStatelessSummaryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateStatelessSummaryRequest.ProtoReflect.Descriptor instead.
func (*GenerateStatelessSummaryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{13}
}

func (x *GenerateStatelessSummaryRequest) GetStatelessConversation() *GenerateStatelessSummaryRequest_MinimalConversation {
	if x != nil {
		return x.StatelessConversation
	}
	return nil
}

func (x *GenerateStatelessSummaryRequest) GetConversationProfile() *ConversationProfile {
	if x != nil {
		return x.ConversationProfile
	}
	return nil
}

func (x *GenerateStatelessSummaryRequest) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *GenerateStatelessSummaryRequest) GetMaxContextSize() int32 {
	if x != nil {
		return x.MaxContextSize
	}
	return 0
}

// The response message for
// [Conversations.GenerateStatelessSummary][google.cloud.dialogflow.v2.Conversations.GenerateStatelessSummary].
type GenerateStatelessSummaryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Generated summary.
	Summary *GenerateStatelessSummaryResponse_Summary `protobuf:"bytes,1,opt,name=summary,proto3" json:"summary,omitempty"`
	// The name of the latest conversation message used as context for
	// compiling suggestion. The format is specific to the user and the names of
	// the messages provided.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Number of messages prior to and including
	// [latest_message][google.cloud.dialogflow.v2.GenerateStatelessSummaryResponse.latest_message]
	// used to compile the suggestion. It may be smaller than the
	// [GenerateStatelessSummaryRequest.max_context_size][google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.max_context_size]
	// field in the request if there weren't that many messages in the
	// conversation.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
}

func (x *GenerateStatelessSummaryResponse) Reset() {
	*x = GenerateStatelessSummaryResponse{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateStatelessSummaryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateStatelessSummaryResponse) ProtoMessage() {}

func (x *GenerateStatelessSummaryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateStatelessSummaryResponse.ProtoReflect.Descriptor instead.
func (*GenerateStatelessSummaryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{14}
}

func (x *GenerateStatelessSummaryResponse) GetSummary() *GenerateStatelessSummaryResponse_Summary {
	if x != nil {
		return x.Summary
	}
	return nil
}

func (x *GenerateStatelessSummaryResponse) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *GenerateStatelessSummaryResponse) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

// The request message for
// [Conversations.GenerateStatelessSuggestion][google.cloud.dialogflow.v2.Conversations.GenerateStatelessSuggestion].
type GenerateStatelessSuggestionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource to charge for the Suggestion's generation.
	// Format: `projects/<Project ID>/locations/<Location ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Generator.
	//
	// Types that are assignable to GeneratorResource:
	//
	//	*GenerateStatelessSuggestionRequest_Generator
	//	*GenerateStatelessSuggestionRequest_GeneratorName
	GeneratorResource isGenerateStatelessSuggestionRequest_GeneratorResource `protobuf_oneof:"generator_resource"`
	// Optional. A section of ingested context information. The key is the name of
	// the context reference and the value contains the contents of the context
	// reference. The key is used to incorporate ingested context references to
	// enhance the generator.
	ContextReferences map[string]*Conversation_ContextReference `protobuf:"bytes,4,rep,name=context_references,json=contextReferences,proto3" json:"context_references,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Context of the conversation, including transcripts.
	ConversationContext *ConversationContext `protobuf:"bytes,5,opt,name=conversation_context,json=conversationContext,proto3" json:"conversation_context,omitempty"`
	// Optional. A list of trigger events. Generator will be triggered only if
	// it's trigger event is included here.
	TriggerEvents []TriggerEvent `protobuf:"varint,6,rep,packed,name=trigger_events,json=triggerEvents,proto3,enum=google.cloud.dialogflow.v2.TriggerEvent" json:"trigger_events,omitempty"`
}

func (x *GenerateStatelessSuggestionRequest) Reset() {
	*x = GenerateStatelessSuggestionRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateStatelessSuggestionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateStatelessSuggestionRequest) ProtoMessage() {}

func (x *GenerateStatelessSuggestionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateStatelessSuggestionRequest.ProtoReflect.Descriptor instead.
func (*GenerateStatelessSuggestionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{15}
}

func (x *GenerateStatelessSuggestionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *GenerateStatelessSuggestionRequest) GetGeneratorResource() isGenerateStatelessSuggestionRequest_GeneratorResource {
	if m != nil {
		return m.GeneratorResource
	}
	return nil
}

func (x *GenerateStatelessSuggestionRequest) GetGenerator() *Generator {
	if x, ok := x.GetGeneratorResource().(*GenerateStatelessSuggestionRequest_Generator); ok {
		return x.Generator
	}
	return nil
}

func (x *GenerateStatelessSuggestionRequest) GetGeneratorName() string {
	if x, ok := x.GetGeneratorResource().(*GenerateStatelessSuggestionRequest_GeneratorName); ok {
		return x.GeneratorName
	}
	return ""
}

func (x *GenerateStatelessSuggestionRequest) GetContextReferences() map[string]*Conversation_ContextReference {
	if x != nil {
		return x.ContextReferences
	}
	return nil
}

func (x *GenerateStatelessSuggestionRequest) GetConversationContext() *ConversationContext {
	if x != nil {
		return x.ConversationContext
	}
	return nil
}

func (x *GenerateStatelessSuggestionRequest) GetTriggerEvents() []TriggerEvent {
	if x != nil {
		return x.TriggerEvents
	}
	return nil
}

type isGenerateStatelessSuggestionRequest_GeneratorResource interface {
	isGenerateStatelessSuggestionRequest_GeneratorResource()
}

type GenerateStatelessSuggestionRequest_Generator struct {
	// Uncreated generator. It should be a complete generator that includes all
	// information about the generator.
	Generator *Generator `protobuf:"bytes,2,opt,name=generator,proto3,oneof"`
}

type GenerateStatelessSuggestionRequest_GeneratorName struct {
	// The resource name of the existing created generator. Format:
	// `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>`
	GeneratorName string `protobuf:"bytes,3,opt,name=generator_name,json=generatorName,proto3,oneof"`
}

func (*GenerateStatelessSuggestionRequest_Generator) isGenerateStatelessSuggestionRequest_GeneratorResource() {
}

func (*GenerateStatelessSuggestionRequest_GeneratorName) isGenerateStatelessSuggestionRequest_GeneratorResource() {
}

// The response message for
// [Conversations.GenerateStatelessSuggestion][google.cloud.dialogflow.v2.Conversations.GenerateStatelessSuggestion].
type GenerateStatelessSuggestionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Generated suggestion for a conversation.
	GeneratorSuggestion *GeneratorSuggestion `protobuf:"bytes,1,opt,name=generator_suggestion,json=generatorSuggestion,proto3" json:"generator_suggestion,omitempty"`
}

func (x *GenerateStatelessSuggestionResponse) Reset() {
	*x = GenerateStatelessSuggestionResponse{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateStatelessSuggestionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateStatelessSuggestionResponse) ProtoMessage() {}

func (x *GenerateStatelessSuggestionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateStatelessSuggestionResponse.ProtoReflect.Descriptor instead.
func (*GenerateStatelessSuggestionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{16}
}

func (x *GenerateStatelessSuggestionResponse) GetGeneratorSuggestion() *GeneratorSuggestion {
	if x != nil {
		return x.GeneratorSuggestion
	}
	return nil
}

// The request message for
// [Conversations.SearchKnowledge][google.cloud.dialogflow.v2.Conversations.SearchKnowledge].
type SearchKnowledgeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource contains the conversation profile
	// Format: 'projects/<Project ID>' or `projects/<Project
	// ID>/locations/<Location ID>`.
	Parent string `protobuf:"bytes,6,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The natural language text query for knowledge search.
	Query *TextInput `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Required. The conversation profile used to configure the search.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversationProfiles/<Conversation Profile ID>`.
	ConversationProfile string `protobuf:"bytes,2,opt,name=conversation_profile,json=conversationProfile,proto3" json:"conversation_profile,omitempty"`
	// Required. The ID of the search session.
	// The session_id can be combined with Dialogflow V3 Agent ID retrieved from
	// conversation profile or on its own to identify a search session. The search
	// history of the same session will impact the search result. It's up to the
	// API caller to choose an appropriate `Session ID`. It can be a random number
	// or some type of session identifiers (preferably hashed). The length must
	// not exceed 36 characters.
	SessionId string `protobuf:"bytes,3,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	// Optional. The conversation (between human agent and end user) where the
	// search request is triggered. Format: `projects/<Project
	// ID>/locations/<Location ID>/conversations/<Conversation ID>`.
	Conversation string `protobuf:"bytes,4,opt,name=conversation,proto3" json:"conversation,omitempty"`
	// Optional. The name of the latest conversation message when the request is
	// triggered.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,5,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Optional. The source of the query in the request.
	QuerySource SearchKnowledgeRequest_QuerySource `protobuf:"varint,7,opt,name=query_source,json=querySource,proto3,enum=google.cloud.dialogflow.v2.SearchKnowledgeRequest_QuerySource" json:"query_source,omitempty"`
	// Optional. Information about the end-user to improve the relevance and
	// accuracy of generative answers.
	//
	// This will be interpreted and used by a language model, so, for good
	// results, the data should be self-descriptive, and in a simple structure.
	//
	// Example:
	//
	// ```json
	//
	//	{
	//	  "subscription plan": "Business Premium Plus",
	//	  "devices owned": [
	//	    {"model": "Google Pixel 7"},
	//	    {"model": "Google Pixel Tablet"}
	//	  ]
	//	}
	//
	// ```
	EndUserMetadata *structpb.Struct `protobuf:"bytes,9,opt,name=end_user_metadata,json=endUserMetadata,proto3" json:"end_user_metadata,omitempty"`
	// Optional. Configuration specific to search queries with data stores.
	SearchConfig *SearchKnowledgeRequest_SearchConfig `protobuf:"bytes,11,opt,name=search_config,json=searchConfig,proto3" json:"search_config,omitempty"`
	// Optional. Whether to search the query exactly without query rewrite.
	ExactSearch bool `protobuf:"varint,14,opt,name=exact_search,json=exactSearch,proto3" json:"exact_search,omitempty"`
}

func (x *SearchKnowledgeRequest) Reset() {
	*x = SearchKnowledgeRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchKnowledgeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchKnowledgeRequest) ProtoMessage() {}

func (x *SearchKnowledgeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchKnowledgeRequest.ProtoReflect.Descriptor instead.
func (*SearchKnowledgeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{17}
}

func (x *SearchKnowledgeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchKnowledgeRequest) GetQuery() *TextInput {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *SearchKnowledgeRequest) GetConversationProfile() string {
	if x != nil {
		return x.ConversationProfile
	}
	return ""
}

func (x *SearchKnowledgeRequest) GetSessionId() string {
	if x != nil {
		return x.SessionId
	}
	return ""
}

func (x *SearchKnowledgeRequest) GetConversation() string {
	if x != nil {
		return x.Conversation
	}
	return ""
}

func (x *SearchKnowledgeRequest) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SearchKnowledgeRequest) GetQuerySource() SearchKnowledgeRequest_QuerySource {
	if x != nil {
		return x.QuerySource
	}
	return SearchKnowledgeRequest_QUERY_SOURCE_UNSPECIFIED
}

func (x *SearchKnowledgeRequest) GetEndUserMetadata() *structpb.Struct {
	if x != nil {
		return x.EndUserMetadata
	}
	return nil
}

func (x *SearchKnowledgeRequest) GetSearchConfig() *SearchKnowledgeRequest_SearchConfig {
	if x != nil {
		return x.SearchConfig
	}
	return nil
}

func (x *SearchKnowledgeRequest) GetExactSearch() bool {
	if x != nil {
		return x.ExactSearch
	}
	return false
}

// The response message for
// [Conversations.SearchKnowledge][google.cloud.dialogflow.v2.Conversations.SearchKnowledge].
type SearchKnowledgeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Most relevant snippets extracted from articles in the given knowledge base,
	// ordered by confidence.
	Answers []*SearchKnowledgeAnswer `protobuf:"bytes,2,rep,name=answers,proto3" json:"answers,omitempty"`
	// The rewritten query used to search knowledge.
	RewrittenQuery string `protobuf:"bytes,3,opt,name=rewritten_query,json=rewrittenQuery,proto3" json:"rewritten_query,omitempty"`
}

func (x *SearchKnowledgeResponse) Reset() {
	*x = SearchKnowledgeResponse{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchKnowledgeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchKnowledgeResponse) ProtoMessage() {}

func (x *SearchKnowledgeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchKnowledgeResponse.ProtoReflect.Descriptor instead.
func (*SearchKnowledgeResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{18}
}

func (x *SearchKnowledgeResponse) GetAnswers() []*SearchKnowledgeAnswer {
	if x != nil {
		return x.Answers
	}
	return nil
}

func (x *SearchKnowledgeResponse) GetRewrittenQuery() string {
	if x != nil {
		return x.RewrittenQuery
	}
	return ""
}

// Represents a SearchKnowledge answer.
type SearchKnowledgeAnswer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The piece of text from the knowledge base documents that answers
	// the search query
	Answer string `protobuf:"bytes,1,opt,name=answer,proto3" json:"answer,omitempty"`
	// The type of the answer.
	AnswerType SearchKnowledgeAnswer_AnswerType `protobuf:"varint,2,opt,name=answer_type,json=answerType,proto3,enum=google.cloud.dialogflow.v2.SearchKnowledgeAnswer_AnswerType" json:"answer_type,omitempty"`
	// All sources used to generate the answer.
	AnswerSources []*SearchKnowledgeAnswer_AnswerSource `protobuf:"bytes,3,rep,name=answer_sources,json=answerSources,proto3" json:"answer_sources,omitempty"`
	// The name of the answer record.
	// Format: `projects/<Project ID>/locations/<location ID>/answer
	// Records/<Answer Record ID>`
	AnswerRecord string `protobuf:"bytes,5,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
}

func (x *SearchKnowledgeAnswer) Reset() {
	*x = SearchKnowledgeAnswer{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchKnowledgeAnswer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchKnowledgeAnswer) ProtoMessage() {}

func (x *SearchKnowledgeAnswer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchKnowledgeAnswer.ProtoReflect.Descriptor instead.
func (*SearchKnowledgeAnswer) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{19}
}

func (x *SearchKnowledgeAnswer) GetAnswer() string {
	if x != nil {
		return x.Answer
	}
	return ""
}

func (x *SearchKnowledgeAnswer) GetAnswerType() SearchKnowledgeAnswer_AnswerType {
	if x != nil {
		return x.AnswerType
	}
	return SearchKnowledgeAnswer_ANSWER_TYPE_UNSPECIFIED
}

func (x *SearchKnowledgeAnswer) GetAnswerSources() []*SearchKnowledgeAnswer_AnswerSource {
	if x != nil {
		return x.AnswerSources
	}
	return nil
}

func (x *SearchKnowledgeAnswer) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

// The request message for
// [Conversations.GenerateSuggestions][google.cloud.dialogflow.v2.Conversations.GenerateSuggestions].
type GenerateSuggestionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversation for which the suggestions are generated. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>`.
	//
	// The conversation must be created with a conversation profile which has
	// generators configured in it to be able to get suggestions.
	Conversation string `protobuf:"bytes,1,opt,name=conversation,proto3" json:"conversation,omitempty"`
	// Optional. The name of the latest conversation message for which the request
	// is triggered. Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Optional. A list of trigger events. Only generators configured in the
	// conversation_profile whose trigger_event is listed here will be triggered.
	TriggerEvents []TriggerEvent `protobuf:"varint,3,rep,packed,name=trigger_events,json=triggerEvents,proto3,enum=google.cloud.dialogflow.v2.TriggerEvent" json:"trigger_events,omitempty"`
}

func (x *GenerateSuggestionsRequest) Reset() {
	*x = GenerateSuggestionsRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateSuggestionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateSuggestionsRequest) ProtoMessage() {}

func (x *GenerateSuggestionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateSuggestionsRequest.ProtoReflect.Descriptor instead.
func (*GenerateSuggestionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{20}
}

func (x *GenerateSuggestionsRequest) GetConversation() string {
	if x != nil {
		return x.Conversation
	}
	return ""
}

func (x *GenerateSuggestionsRequest) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *GenerateSuggestionsRequest) GetTriggerEvents() []TriggerEvent {
	if x != nil {
		return x.TriggerEvents
	}
	return nil
}

// The information about phone calls connected via phone gateway to the
// conversation.
type Conversation_TelephonyConnectionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The number dialed to connect this call in E.164 format.
	DialedNumber string `protobuf:"bytes,2,opt,name=dialed_number,json=dialedNumber,proto3" json:"dialed_number,omitempty"`
	// Optional. SDP of the call. It's initially the SDP answer to the endpoint,
	// but maybe later updated for the purpose of making the link active, etc.
	Sdp string `protobuf:"bytes,5,opt,name=sdp,proto3" json:"sdp,omitempty"`
	// Output only. The SIP headers from the initial SIP INVITE.
	SipHeaders []*Conversation_TelephonyConnectionInfo_SipHeader `protobuf:"bytes,12,rep,name=sip_headers,json=sipHeaders,proto3" json:"sip_headers,omitempty"`
	// Output only. The mime content from the initial SIP INVITE.
	ExtraMimeContents []*Conversation_TelephonyConnectionInfo_MimeContent `protobuf:"bytes,13,rep,name=extra_mime_contents,json=extraMimeContents,proto3" json:"extra_mime_contents,omitempty"`
}

func (x *Conversation_TelephonyConnectionInfo) Reset() {
	*x = Conversation_TelephonyConnectionInfo{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Conversation_TelephonyConnectionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation_TelephonyConnectionInfo) ProtoMessage() {}

func (x *Conversation_TelephonyConnectionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation_TelephonyConnectionInfo.ProtoReflect.Descriptor instead.
func (*Conversation_TelephonyConnectionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Conversation_TelephonyConnectionInfo) GetDialedNumber() string {
	if x != nil {
		return x.DialedNumber
	}
	return ""
}

func (x *Conversation_TelephonyConnectionInfo) GetSdp() string {
	if x != nil {
		return x.Sdp
	}
	return ""
}

func (x *Conversation_TelephonyConnectionInfo) GetSipHeaders() []*Conversation_TelephonyConnectionInfo_SipHeader {
	if x != nil {
		return x.SipHeaders
	}
	return nil
}

func (x *Conversation_TelephonyConnectionInfo) GetExtraMimeContents() []*Conversation_TelephonyConnectionInfo_MimeContent {
	if x != nil {
		return x.ExtraMimeContents
	}
	return nil
}

// Represents a section of ingested context information.
type Conversation_ContextReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The list of content updates for a context reference.
	ContextContents []*Conversation_ContextReference_ContextContent `protobuf:"bytes,1,rep,name=context_contents,json=contextContents,proto3" json:"context_contents,omitempty"`
	// Required. The mode in which context reference contents are updated.
	UpdateMode Conversation_ContextReference_UpdateMode `protobuf:"varint,2,opt,name=update_mode,json=updateMode,proto3,enum=google.cloud.dialogflow.v2.Conversation_ContextReference_UpdateMode" json:"update_mode,omitempty"`
	// Optional. The language of the information ingested, defaults to "en-US"
	// if not set.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Output only. The time the context reference was first created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *Conversation_ContextReference) Reset() {
	*x = Conversation_ContextReference{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Conversation_ContextReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation_ContextReference) ProtoMessage() {}

func (x *Conversation_ContextReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation_ContextReference.ProtoReflect.Descriptor instead.
func (*Conversation_ContextReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Conversation_ContextReference) GetContextContents() []*Conversation_ContextReference_ContextContent {
	if x != nil {
		return x.ContextContents
	}
	return nil
}

func (x *Conversation_ContextReference) GetUpdateMode() Conversation_ContextReference_UpdateMode {
	if x != nil {
		return x.UpdateMode
	}
	return Conversation_ContextReference_UPDATE_MODE_UNSPECIFIED
}

func (x *Conversation_ContextReference) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *Conversation_ContextReference) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// The SIP headers from the initial SIP INVITE.
type Conversation_TelephonyConnectionInfo_SipHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the header.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The value of the header.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Conversation_TelephonyConnectionInfo_SipHeader) Reset() {
	*x = Conversation_TelephonyConnectionInfo_SipHeader{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Conversation_TelephonyConnectionInfo_SipHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation_TelephonyConnectionInfo_SipHeader) ProtoMessage() {}

func (x *Conversation_TelephonyConnectionInfo_SipHeader) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation_TelephonyConnectionInfo_SipHeader.ProtoReflect.Descriptor instead.
func (*Conversation_TelephonyConnectionInfo_SipHeader) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *Conversation_TelephonyConnectionInfo_SipHeader) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Conversation_TelephonyConnectionInfo_SipHeader) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// The mime content from the initial SIP INVITE.
type Conversation_TelephonyConnectionInfo_MimeContent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The mime type of the content.
	MimeType string `protobuf:"bytes,1,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Optional. The content payload.
	Content []byte `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *Conversation_TelephonyConnectionInfo_MimeContent) Reset() {
	*x = Conversation_TelephonyConnectionInfo_MimeContent{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Conversation_TelephonyConnectionInfo_MimeContent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation_TelephonyConnectionInfo_MimeContent) ProtoMessage() {}

func (x *Conversation_TelephonyConnectionInfo_MimeContent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation_TelephonyConnectionInfo_MimeContent.ProtoReflect.Descriptor instead.
func (*Conversation_TelephonyConnectionInfo_MimeContent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{0, 0, 1}
}

func (x *Conversation_TelephonyConnectionInfo_MimeContent) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *Conversation_TelephonyConnectionInfo_MimeContent) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

// Contents ingested.
type Conversation_ContextReference_ContextContent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The information ingested in a single request.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Required. The format of the ingested string.
	ContentFormat Conversation_ContextReference_ContextContent_ContentFormat `protobuf:"varint,2,opt,name=content_format,json=contentFormat,proto3,enum=google.cloud.dialogflow.v2.Conversation_ContextReference_ContextContent_ContentFormat" json:"content_format,omitempty"`
	// Output only. The time when this information was incorporated into the
	// relevant context reference.
	IngestionTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=ingestion_time,json=ingestionTime,proto3" json:"ingestion_time,omitempty"`
}

func (x *Conversation_ContextReference_ContextContent) Reset() {
	*x = Conversation_ContextReference_ContextContent{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Conversation_ContextReference_ContextContent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation_ContextReference_ContextContent) ProtoMessage() {}

func (x *Conversation_ContextReference_ContextContent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation_ContextReference_ContextContent.ProtoReflect.Descriptor instead.
func (*Conversation_ContextReference_ContextContent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *Conversation_ContextReference_ContextContent) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *Conversation_ContextReference_ContextContent) GetContentFormat() Conversation_ContextReference_ContextContent_ContentFormat {
	if x != nil {
		return x.ContentFormat
	}
	return Conversation_ContextReference_ContextContent_CONTENT_FORMAT_UNSPECIFIED
}

func (x *Conversation_ContextReference_ContextContent) GetIngestionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.IngestionTime
	}
	return nil
}

// Generated summary for a conversation.
type SuggestConversationSummaryResponse_Summary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The summary content that is concatenated into one string.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// The summary content that is divided into sections. The key is the
	// section's name and the value is the section's content. There is no
	// specific format for the key or value.
	TextSections map[string]string `protobuf:"bytes,4,rep,name=text_sections,json=textSections,proto3" json:"text_sections,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of the answer record. Format:
	// "projects/<Project ID>/answerRecords/<Answer Record ID>"
	AnswerRecord string `protobuf:"bytes,3,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
	// The baseline model version used to generate this summary. It is empty if
	// a baseline model was not used to generate this summary.
	BaselineModelVersion string `protobuf:"bytes,5,opt,name=baseline_model_version,json=baselineModelVersion,proto3" json:"baseline_model_version,omitempty"`
}

func (x *SuggestConversationSummaryResponse_Summary) Reset() {
	*x = SuggestConversationSummaryResponse_Summary{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestConversationSummaryResponse_Summary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestConversationSummaryResponse_Summary) ProtoMessage() {}

func (x *SuggestConversationSummaryResponse_Summary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestConversationSummaryResponse_Summary.ProtoReflect.Descriptor instead.
func (*SuggestConversationSummaryResponse_Summary) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{12, 0}
}

func (x *SuggestConversationSummaryResponse_Summary) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *SuggestConversationSummaryResponse_Summary) GetTextSections() map[string]string {
	if x != nil {
		return x.TextSections
	}
	return nil
}

func (x *SuggestConversationSummaryResponse_Summary) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

func (x *SuggestConversationSummaryResponse_Summary) GetBaselineModelVersion() string {
	if x != nil {
		return x.BaselineModelVersion
	}
	return ""
}

// The minimum amount of information required to generate a Summary without
// having a Conversation resource created.
type GenerateStatelessSummaryRequest_MinimalConversation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The messages that the Summary will be generated from. It is
	// expected that this message content is already redacted and does not
	// contain any PII. Required fields: {content, language_code, participant,
	// participant_role} Optional fields: {send_time} If send_time is not
	// provided, then the messages must be provided in chronological order.
	Messages []*Message `protobuf:"bytes,1,rep,name=messages,proto3" json:"messages,omitempty"`
	// Required. The parent resource to charge for the Summary's generation.
	// Format: `projects/<Project ID>/locations/<Location ID>`.
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *GenerateStatelessSummaryRequest_MinimalConversation) Reset() {
	*x = GenerateStatelessSummaryRequest_MinimalConversation{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateStatelessSummaryRequest_MinimalConversation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateStatelessSummaryRequest_MinimalConversation) ProtoMessage() {}

func (x *GenerateStatelessSummaryRequest_MinimalConversation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateStatelessSummaryRequest_MinimalConversation.ProtoReflect.Descriptor instead.
func (*GenerateStatelessSummaryRequest_MinimalConversation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{13, 0}
}

func (x *GenerateStatelessSummaryRequest_MinimalConversation) GetMessages() []*Message {
	if x != nil {
		return x.Messages
	}
	return nil
}

func (x *GenerateStatelessSummaryRequest_MinimalConversation) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Generated summary for a conversation.
type GenerateStatelessSummaryResponse_Summary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The summary content that is concatenated into one string.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// The summary content that is divided into sections. The key is the
	// section's name and the value is the section's content. There is no
	// specific format for the key or value.
	TextSections map[string]string `protobuf:"bytes,2,rep,name=text_sections,json=textSections,proto3" json:"text_sections,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The baseline model version used to generate this summary. It is empty if
	// a baseline model was not used to generate this summary.
	BaselineModelVersion string `protobuf:"bytes,4,opt,name=baseline_model_version,json=baselineModelVersion,proto3" json:"baseline_model_version,omitempty"`
}

func (x *GenerateStatelessSummaryResponse_Summary) Reset() {
	*x = GenerateStatelessSummaryResponse_Summary{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateStatelessSummaryResponse_Summary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateStatelessSummaryResponse_Summary) ProtoMessage() {}

func (x *GenerateStatelessSummaryResponse_Summary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateStatelessSummaryResponse_Summary.ProtoReflect.Descriptor instead.
func (*GenerateStatelessSummaryResponse_Summary) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{14, 0}
}

func (x *GenerateStatelessSummaryResponse_Summary) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *GenerateStatelessSummaryResponse_Summary) GetTextSections() map[string]string {
	if x != nil {
		return x.TextSections
	}
	return nil
}

func (x *GenerateStatelessSummaryResponse_Summary) GetBaselineModelVersion() string {
	if x != nil {
		return x.BaselineModelVersion
	}
	return ""
}

// Configuration specific to search queries with data stores.
type SearchKnowledgeRequest_SearchConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Boost specifications for data stores.
	//
	// Maps from datastore name to their boost configuration. Do not specify
	// more than one BoostSpecs for each datastore name. If multiple BoostSpecs
	// are provided for the same datastore name, the behavior is undefined.
	BoostSpecs []*SearchKnowledgeRequest_SearchConfig_BoostSpecs `protobuf:"bytes,1,rep,name=boost_specs,json=boostSpecs,proto3" json:"boost_specs,omitempty"`
	// Optional. Filter specification for data store queries.
	//
	// TMaps from datastore name to the filter expression for that datastore. Do
	// not specify more than one FilterSpecs for each datastore name. If
	// multiple FilterSpecs are provided for the same datastore name, the
	// behavior is undefined.
	FilterSpecs []*SearchKnowledgeRequest_SearchConfig_FilterSpecs `protobuf:"bytes,2,rep,name=filter_specs,json=filterSpecs,proto3" json:"filter_specs,omitempty"`
}

func (x *SearchKnowledgeRequest_SearchConfig) Reset() {
	*x = SearchKnowledgeRequest_SearchConfig{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchKnowledgeRequest_SearchConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchKnowledgeRequest_SearchConfig) ProtoMessage() {}

func (x *SearchKnowledgeRequest_SearchConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchKnowledgeRequest_SearchConfig.ProtoReflect.Descriptor instead.
func (*SearchKnowledgeRequest_SearchConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{17, 0}
}

func (x *SearchKnowledgeRequest_SearchConfig) GetBoostSpecs() []*SearchKnowledgeRequest_SearchConfig_BoostSpecs {
	if x != nil {
		return x.BoostSpecs
	}
	return nil
}

func (x *SearchKnowledgeRequest_SearchConfig) GetFilterSpecs() []*SearchKnowledgeRequest_SearchConfig_FilterSpecs {
	if x != nil {
		return x.FilterSpecs
	}
	return nil
}

// Boost specifications for data stores.
type SearchKnowledgeRequest_SearchConfig_BoostSpecs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Data Stores where the boosting configuration is applied. The
	// full names of the referenced data stores. Formats:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
	// `projects/{project}/locations/{location}/dataStores/{data_store}`
	DataStores []string `protobuf:"bytes,1,rep,name=data_stores,json=dataStores,proto3" json:"data_stores,omitempty"`
	// Optional. A list of boosting specifications.
	Spec []*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec `protobuf:"bytes,2,rep,name=spec,proto3" json:"spec,omitempty"`
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs) Reset() {
	*x = SearchKnowledgeRequest_SearchConfig_BoostSpecs{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchKnowledgeRequest_SearchConfig_BoostSpecs) ProtoMessage() {}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchKnowledgeRequest_SearchConfig_BoostSpecs.ProtoReflect.Descriptor instead.
func (*SearchKnowledgeRequest_SearchConfig_BoostSpecs) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{17, 0, 0}
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs) GetDataStores() []string {
	if x != nil {
		return x.DataStores
	}
	return nil
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs) GetSpec() []*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

// Filter specification for data store queries.
type SearchKnowledgeRequest_SearchConfig_FilterSpecs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The data store where the filter configuration is applied.
	// Full resource name of data store, such as
	// projects/{project}/locations/{location}/collections/{collectionId}/
	// dataStores/{dataStoreId}.
	DataStores []string `protobuf:"bytes,1,rep,name=data_stores,json=dataStores,proto3" json:"data_stores,omitempty"`
	// Optional. The filter expression to be applied.
	// Expression syntax is documented at
	// https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *SearchKnowledgeRequest_SearchConfig_FilterSpecs) Reset() {
	*x = SearchKnowledgeRequest_SearchConfig_FilterSpecs{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchKnowledgeRequest_SearchConfig_FilterSpecs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchKnowledgeRequest_SearchConfig_FilterSpecs) ProtoMessage() {}

func (x *SearchKnowledgeRequest_SearchConfig_FilterSpecs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchKnowledgeRequest_SearchConfig_FilterSpecs.ProtoReflect.Descriptor instead.
func (*SearchKnowledgeRequest_SearchConfig_FilterSpecs) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{17, 0, 1}
}

func (x *SearchKnowledgeRequest_SearchConfig_FilterSpecs) GetDataStores() []string {
	if x != nil {
		return x.DataStores
	}
	return nil
}

func (x *SearchKnowledgeRequest_SearchConfig_FilterSpecs) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Boost specification to boost certain documents.
// A copy of google.cloud.discoveryengine.v1main.BoostSpec, field
// documentation is available at
// https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1alpha/BoostSpec
type SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Condition boost specifications. If a document matches
	// multiple conditions in the specifications, boost scores from these
	// specifications are all applied and combined in a non-linear way.
	// Maximum number of specifications is 20.
	ConditionBoostSpecs []*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec `protobuf:"bytes,1,rep,name=condition_boost_specs,json=conditionBoostSpecs,proto3" json:"condition_boost_specs,omitempty"`
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec) Reset() {
	*x = SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec) ProtoMessage() {}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec.ProtoReflect.Descriptor instead.
func (*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{17, 0, 0, 0}
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec) GetConditionBoostSpecs() []*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec {
	if x != nil {
		return x.ConditionBoostSpecs
	}
	return nil
}

// Boost applies to documents which match a condition.
type SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. An expression which specifies a boost condition. The
	// syntax and supported fields are the same as a filter expression.
	// Examples:
	//
	// * To boost documents with document ID "doc_1" or "doc_2", and
	// color
	//
	//	"Red" or "Blue":
	//	  * (id: ANY("doc_1", "doc_2")) AND (color: ANY("Red","Blue"))
	Condition string `protobuf:"bytes,1,opt,name=condition,proto3" json:"condition,omitempty"`
	// Optional. Strength of the condition boost, which should be in [-1,
	// 1]. Negative boost means demotion. Default is 0.0.
	//
	// Setting to 1.0 gives the document a big promotion. However, it does
	// not necessarily mean that the boosted document will be the top
	// result at all times, nor that other documents will be excluded.
	// Results could still be shown even when none of them matches the
	// condition. And results that are significantly more relevant to the
	// search query can still trump your heavily favored but irrelevant
	// documents.
	//
	// Setting to -1.0 gives the document a big demotion. However, results
	// that are deeply relevant might still be shown. The document will
	// have an upstream battle to get a fairly high ranking, but it is not
	// blocked out completely.
	//
	// Setting to 0.0 means no boost applied. The boosting condition is
	// ignored.
	Boost float32 `protobuf:"fixed32,2,opt,name=boost,proto3" json:"boost,omitempty"`
	// Optional. Complex specification for custom ranking based on
	// customer defined attribute value.
	BoostControlSpec *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec `protobuf:"bytes,4,opt,name=boost_control_spec,json=boostControlSpec,proto3" json:"boost_control_spec,omitempty"`
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec) Reset() {
	*x = SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec) ProtoMessage() {}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec.ProtoReflect.Descriptor instead.
func (*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{17, 0, 0, 0, 0}
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec) GetBoost() float32 {
	if x != nil {
		return x.Boost
	}
	return 0
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec) GetBoostControlSpec() *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec {
	if x != nil {
		return x.BoostControlSpec
	}
	return nil
}

// Specification for custom ranking based on customer specified
// attribute
// value. It provides more controls for customized ranking than the
// simple (condition, boost) combination above.
type SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the field whose value will be used to
	// determine the boost amount.
	FieldName string `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// Optional. The attribute type to be used to determine the boost
	// amount. The attribute value can be derived from the field value
	// of the specified field_name. In the case of numerical it is
	// straightforward i.e. attribute_value = numerical_field_value. In
	// the case of freshness however, attribute_value = (time.now() -
	// datetime_field_value).
	AttributeType SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType `protobuf:"varint,2,opt,name=attribute_type,json=attributeType,proto3,enum=google.cloud.dialogflow.v2.SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType" json:"attribute_type,omitempty"`
	// Optional. The interpolation type to be applied to connect the
	// control points listed below.
	InterpolationType SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType `protobuf:"varint,3,opt,name=interpolation_type,json=interpolationType,proto3,enum=google.cloud.dialogflow.v2.SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType" json:"interpolation_type,omitempty"`
	// Optional. The control points used to define the curve. The
	// monotonic function (defined through the interpolation_type above)
	// passes through the control points listed here.
	ControlPoints []*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint `protobuf:"bytes,4,rep,name=control_points,json=controlPoints,proto3" json:"control_points,omitempty"`
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec) Reset() {
	*x = SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec) ProtoMessage() {
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec.ProtoReflect.Descriptor instead.
func (*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{17, 0, 0, 0, 0, 0}
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec) GetAttributeType() SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType {
	if x != nil {
		return x.AttributeType
	}
	return SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_ATTRIBUTE_TYPE_UNSPECIFIED
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec) GetInterpolationType() SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType {
	if x != nil {
		return x.InterpolationType
	}
	return SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_INTERPOLATION_TYPE_UNSPECIFIED
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec) GetControlPoints() []*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint {
	if x != nil {
		return x.ControlPoints
	}
	return nil
}

// The control points used to define the curve. The curve defined
// through these control points can only be monotonically increasing
// or decreasing(constant values are acceptable).
type SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Can be one of:
	// 1. The numerical field value.
	// 2. The duration spec for freshness:
	// The value must be formatted as an XSD `dayTimeDuration` value
	// (a restricted subset of an ISO 8601 duration value). The
	// pattern for this is: `[nD][T[nH][nM][nS]]`.
	AttributeValue string `protobuf:"bytes,1,opt,name=attribute_value,json=attributeValue,proto3" json:"attribute_value,omitempty"`
	// Optional. The value between -1 to 1 by which to boost the score
	// if the attribute_value evaluates to the value specified above.
	BoostAmount float32 `protobuf:"fixed32,2,opt,name=boost_amount,json=boostAmount,proto3" json:"boost_amount,omitempty"`
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint) Reset() {
	*x = SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint) ProtoMessage() {
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint.ProtoReflect.Descriptor instead.
func (*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{17, 0, 0, 0, 0, 0, 0}
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint) GetAttributeValue() string {
	if x != nil {
		return x.AttributeValue
	}
	return ""
}

func (x *SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint) GetBoostAmount() float32 {
	if x != nil {
		return x.BoostAmount
	}
	return 0
}

// The sources of the answers.
type SearchKnowledgeAnswer_AnswerSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The title of the article.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// The URI of the article.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// The relevant snippet of the article.
	Snippet string `protobuf:"bytes,3,opt,name=snippet,proto3" json:"snippet,omitempty"`
	// Metadata associated with the article.
	Metadata *structpb.Struct `protobuf:"bytes,5,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *SearchKnowledgeAnswer_AnswerSource) Reset() {
	*x = SearchKnowledgeAnswer_AnswerSource{}
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchKnowledgeAnswer_AnswerSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchKnowledgeAnswer_AnswerSource) ProtoMessage() {}

func (x *SearchKnowledgeAnswer_AnswerSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchKnowledgeAnswer_AnswerSource.ProtoReflect.Descriptor instead.
func (*SearchKnowledgeAnswer_AnswerSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP(), []int{19, 0}
}

func (x *SearchKnowledgeAnswer_AnswerSource) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *SearchKnowledgeAnswer_AnswerSource) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *SearchKnowledgeAnswer_AnswerSource) GetSnippet() string {
	if x != nil {
		return x.Snippet
	}
	return ""
}

func (x *SearchKnowledgeAnswer_AnswerSource) GetMetadata() *structpb.Struct {
	if x != nil {
		return x.Metadata
	}
	return nil
}

var File_google_cloud_dialogflow_v2_conversation_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2_conversation_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76,
	0x32, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbc, 0x14, 0x0a, 0x0c, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x65, 0x0a, 0x0f, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63,
	0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63,
	0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c, 0x69,
	0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x68, 0x0a, 0x14,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x5b, 0x0a, 0x0c, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x68, 0x6f, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x4e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x6e, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x74, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12,
	0x81, 0x01, 0x0a, 0x19, 0x74, 0x65, 0x6c, 0x65, 0x70, 0x68, 0x6f, 0x6e, 0x79, 0x5f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65,
	0x6c, 0x65, 0x70, 0x68, 0x6f, 0x6e, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x74, 0x65, 0x6c, 0x65,
	0x70, 0x68, 0x6f, 0x6e, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x8c, 0x01, 0x0a, 0x1b, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x1a, 0xe1, 0x03, 0x0a, 0x17, 0x54, 0x65, 0x6c, 0x65, 0x70, 0x68, 0x6f, 0x6e, 0x79,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x28,
	0x0a, 0x0d, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x64, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x64, 0x69, 0x61, 0x6c,
	0x65, 0x64, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x15, 0x0a, 0x03, 0x73, 0x64, 0x70, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x03, 0x73, 0x64, 0x70, 0x12,
	0x70, 0x0a, 0x0b, 0x73, 0x69, 0x70, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x0c,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54,
	0x65, 0x6c, 0x65, 0x70, 0x68, 0x6f, 0x6e, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x53, 0x69, 0x70, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x73, 0x69, 0x70, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x12, 0x81, 0x01, 0x0a, 0x13, 0x65, 0x78, 0x74, 0x72, 0x61, 0x5f, 0x6d, 0x69, 0x6d, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6c, 0x65, 0x70, 0x68,
	0x6f, 0x6e, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x2e, 0x4d, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x11, 0x65, 0x78, 0x74, 0x72, 0x61, 0x4d, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x3f, 0x0a, 0x09, 0x53, 0x69, 0x70, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x4e, 0x0a, 0x0b, 0x4d, 0x69, 0x6d, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d,
	0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x1a, 0xf4, 0x05, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x78, 0x0a, 0x10, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x6a, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0xc7, 0x02,
	0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x1d, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12,
	0x82, 0x01, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x12, 0x46, 0x0a, 0x0e, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x69,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x49, 0x0a, 0x0d,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1e, 0x0a,
	0x1a, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x4a, 0x53, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x4c, 0x41, 0x49, 0x4e,
	0x5f, 0x54, 0x45, 0x58, 0x54, 0x10, 0x02, 0x22, 0x44, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f,
	0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x50, 0x50, 0x45, 0x4e, 0x44, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x4f, 0x56, 0x45, 0x52, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x02, 0x1a, 0x87, 0x01,
	0x0a, 0x1e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x4f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x51, 0x0a, 0x0e, 0x4c, 0x69, 0x66, 0x65, 0x63,
	0x79, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x4c, 0x49, 0x46,
	0x45, 0x43, 0x59, 0x43, 0x4c, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e,
	0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x43,
	0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x02, 0x22, 0x68, 0x0a, 0x11, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12,
	0x22, 0x0a, 0x1e, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x53, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x53, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x56, 0x49, 0x52, 0x54, 0x55, 0x41, 0x4c, 0x5f, 0x41,
	0x47, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x47, 0x45, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12,
	0x48, 0x55, 0x4d, 0x41, 0x4e, 0x5f, 0x41, 0x53, 0x53, 0x49, 0x53, 0x54, 0x5f, 0x53, 0x54, 0x41,
	0x47, 0x45, 0x10, 0x02, 0x3a, 0xc0, 0x01, 0xea, 0x41, 0xbc, 0x01, 0x0a, 0x26, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x12, 0x44, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2a, 0x0d, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe4, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x51, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2c, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xc5,
	0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x28, 0x12, 0x26, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x93, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5c, 0x0a, 0x16,
	0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x61, 0x0a, 0x1b, 0x43, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a,
	0x26, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbb, 0x01,
	0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7f, 0x0a, 0x14, 0x4c,
	0x69, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x08, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x69, 0x0a, 0x17,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x68, 0x6f, 0x6e,
	0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x26, 0x0a, 0x0c, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x70, 0x68, 0x6f, 0x6e,
	0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22, 0xfd, 0x02, 0x0a, 0x1e, 0x49, 0x6e, 0x67, 0x65,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x0c, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x85,
	0x01, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x1a, 0x7f, 0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x4f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xc8, 0x02, 0x0a, 0x1f, 0x49, 0x6e, 0x67, 0x65,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x9a, 0x01, 0x0a, 0x1b,
	0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x19, 0x69,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x1a, 0x87, 0x01, 0x0a, 0x1e, 0x49, 0x6e, 0x67,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4f, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xd9, 0x02, 0x0a, 0x21, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0e,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x26,
	0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x66, 0x0a, 0x13, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x61, 0x73, 0x73,
	0x69, 0x73, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xe0,
	0x04, 0x0a, 0x22, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x07,
	0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x4d, 0x0a, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x1a, 0xe5, 0x02, 0x0a, 0x07, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x7d, 0x0a, 0x0d, 0x74, 0x65, 0x78,
	0x74, 0x5f, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x74, 0x65, 0x78, 0x74,
	0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x50, 0x0a, 0x0d, 0x61, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2b, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x52, 0x0c, 0x61, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x34, 0x0a, 0x16, 0x62, 0x61,
	0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x62, 0x61, 0x73, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x1a, 0x3f, 0x0a, 0x11, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xba, 0x04, 0x0a, 0x1f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x8b, 0x01, 0x0a, 0x16, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6c,
	0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x6c, 0x65, 0x73, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x4d, 0x69, 0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x50, 0x0a, 0x0e,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x2d,
	0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6d,
	0x61, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x1a, 0x9e, 0x01,
	0x0a, 0x13, 0x4d, 0x69, 0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x88,
	0x04, 0x0a, 0x20, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x6c, 0x65, 0x73, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6c,
	0x65, 0x73, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x12, 0x4d, 0x0a, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x53, 0x69, 0x7a, 0x65, 0x1a, 0x91, 0x02, 0x0a, 0x07, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x7b, 0x0a, 0x0d, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x74, 0x65, 0x78, 0x74, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x14, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x3f, 0x0a, 0x11, 0x54, 0x65, 0x78, 0x74,
	0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xb9, 0x05, 0x0a, 0x22, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x53,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x09, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x48, 0x00, 0x52,
	0x09, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x27, 0x0a, 0x0e, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x89, 0x01, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x53,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12,
	0x67, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x74, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0d, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x7f,
	0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4f, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42,
	0x14, 0x0a, 0x12, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x8e, 0x01, 0x0a, 0x23, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x67, 0x0a,
	0x14, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x13, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xf2, 0x14, 0x0a, 0x16, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x40,
	0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x68, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x52,
	0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x66, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e,
	0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x48, 0x0a, 0x11,
	0x65, 0x6e, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x65, 0x6e, 0x64, 0x55, 0x73, 0x65, 0x72, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x69, 0x0a, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x26, 0x0a, 0x0c, 0x65, 0x78, 0x61, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x65, 0x78,
	0x61, 0x63, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x1a, 0xac, 0x0e, 0x0a, 0x0c, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x70, 0x0a, 0x0b, 0x62, 0x6f,
	0x6f, 0x73, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x73, 0x0a, 0x0c,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63,
	0x73, 0x1a, 0xe2, 0x0b, 0x0a, 0x0a, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73,
	0x12, 0x51, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x73, 0x12, 0x6d, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x2e, 0x42, 0x6f,
	0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x73, 0x70,
	0x65, 0x63, 0x1a, 0x91, 0x0a, 0x0a, 0x09, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x12, 0xa0, 0x01, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62,
	0x6f, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x2e, 0x42, 0x6f, 0x6f,
	0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70,
	0x65, 0x63, 0x73, 0x1a, 0xe0, 0x08, 0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x21, 0x0a, 0x09, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a,
	0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x12, 0xab, 0x01, 0x0a, 0x12, 0x62, 0x6f, 0x6f,
	0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
	0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x73, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x42,
	0x6f, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x1a, 0xdd, 0x06, 0x0a, 0x10, 0x42, 0x6f, 0x6f, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x12, 0x22, 0x0a, 0x0a, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0xb3, 0x01, 0x0a, 0x0e, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x86, 0x01, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74,
	0x53, 0x70, 0x65, 0x63, 0x73, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70,
	0x65, 0x63, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0xbf, 0x01, 0x0a, 0x12, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x8a, 0x01, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x2e,
	0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x42, 0x6f, 0x6f,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x6f, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0xb2, 0x01, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x85, 0x01, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x2e, 0x42, 0x6f,
	0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x1a, 0x64, 0x0a, 0x0c,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x0f,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x62, 0x6f,
	0x6f, 0x73, 0x74, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x41, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x22, 0x4d, 0x0a, 0x0d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x54, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x45,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x41, 0x4c,
	0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x46, 0x52, 0x45, 0x53, 0x48, 0x4e, 0x45, 0x53, 0x53, 0x10,
	0x02, 0x22, 0x43, 0x0a, 0x11, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x6f, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x50,
	0x4f, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x49,
	0x4e, 0x45, 0x41, 0x52, 0x10, 0x01, 0x1a, 0x50, 0x0a, 0x0b, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x51, 0x0a, 0x0b, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x51, 0x55, 0x45, 0x52, 0x59,
	0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x51,
	0x55, 0x45, 0x52, 0x59, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x55, 0x47, 0x47, 0x45, 0x53,
	0x54, 0x45, 0x44, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x02, 0x22, 0x8f, 0x01, 0x0a, 0x17,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x07, 0x61, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77,
	0x6c, 0x65, 0x64, 0x67, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x07, 0x61, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65,
	0x6e, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72,
	0x65, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x22, 0x9f, 0x04,
	0x0a, 0x15, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67,
	0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12,
	0x5d, 0x0a, 0x0b, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67,
	0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0a, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x65,
	0x0a, 0x0e, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65,
	0x64, 0x67, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0d, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x50, 0x0a, 0x0d, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f,
	0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xfa, 0x41,
	0x28, 0x0a, 0x26, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x52, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x1a, 0x85, 0x01, 0x0a, 0x0c, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69,
	0x12, 0x18, 0x0a, 0x07, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x12, 0x33, 0x0a, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22,
	0x4e, 0x0a, 0x0a, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a,
	0x17, 0x41, 0x4e, 0x53, 0x57, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x46, 0x41,
	0x51, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x41, 0x54, 0x49, 0x56,
	0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x03, 0x22,
	0x98, 0x02, 0x0a, 0x1a, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52,
	0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x54, 0x0a, 0x0e, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x32, 0xa6, 0x1a, 0x0a, 0x0d, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x8c, 0x02, 0x0a,
	0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x94, 0x01, 0xda, 0x41, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x78, 0x3a, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5a, 0x41, 0x3a, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x31, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0x25, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xed, 0x01, 0x0a, 0x11,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6b,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5c, 0x5a,
	0x33, 0x12, 0x31, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xda, 0x01, 0x0a, 0x0f,
	0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x69, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5c, 0x5a, 0x33, 0x12, 0x31,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0x25, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfd, 0x01, 0x0a, 0x14, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x81, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x74, 0x3a, 0x01, 0x2a, 0x5a, 0x3f, 0x3a, 0x01, 0x2a, 0x22, 0x3a, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x22, 0x2e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x92, 0x02, 0x0a, 0x17, 0x49, 0x6e, 0x67,
	0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e,
	0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7e, 0xda,
	0x41, 0x1f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x3a, 0x01, 0x2a, 0x22, 0x51, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0xf5, 0x01,
	0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x81, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x72, 0x5a, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x73, 0x12, 0x30, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0xf4, 0x02, 0x0a, 0x1a, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x79, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0xd6, 0x01, 0xda, 0x41, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xc0, 0x01, 0x3a, 0x01, 0x2a, 0x5a,
	0x65, 0x3a, 0x01, 0x2a, 0x22, 0x60, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x22, 0x54, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x3a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0xdd, 0x02, 0x0a,
	0x18, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6c, 0x65,
	0x73, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x6c, 0x65, 0x73, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc5, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xbe, 0x01, 0x3a, 0x01,
	0x2a, 0x5a, 0x64, 0x3a, 0x01, 0x2a, 0x22, 0x5f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6c, 0x65, 0x73, 0x73,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x22, 0x53, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x6c, 0x65, 0x73, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0xeb, 0x01, 0x0a,
	0x1b, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6c, 0x65,
	0x73, 0x73, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a, 0x01, 0x2a, 0x22, 0x40, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x12, 0xae, 0x03, 0x0a, 0x0f, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x12, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb1, 0x02, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xaa,
	0x02, 0x3a, 0x01, 0x2a, 0x5a, 0x44, 0x3a, 0x01, 0x2a, 0x22, 0x3f, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x5a, 0x4e, 0x3a, 0x01, 0x2a, 0x22,
	0x49, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x5a, 0x5a, 0x3a, 0x01, 0x2a, 0x22,
	0x55, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x22, 0x33, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x12, 0xbb, 0x02, 0x0a, 0x13,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb2, 0x01, 0xda, 0x41, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9c, 0x01, 0x3a, 0x01, 0x2a,
	0x5a, 0x53, 0x3a, 0x01, 0x2a, 0x22, 0x4e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x22, 0x42, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x42, 0xe0, 0x02, 0xea, 0x41, 0xc5, 0x01, 0x0a, 0x28, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x12, 0x58, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x12, 0x3f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x0a,
	0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x42,
	0x11, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x70, 0x62, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_v2_conversation_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2_conversation_proto_rawDescData = file_google_cloud_dialogflow_v2_conversation_proto_rawDesc
)

func file_google_cloud_dialogflow_v2_conversation_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2_conversation_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2_conversation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2_conversation_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2_conversation_proto_rawDescData
}

var file_google_cloud_dialogflow_v2_conversation_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_google_cloud_dialogflow_v2_conversation_proto_msgTypes = make([]protoimpl.MessageInfo, 43)
var file_google_cloud_dialogflow_v2_conversation_proto_goTypes = []any{
	(Conversation_LifecycleState)(0),                                // 0: google.cloud.dialogflow.v2.Conversation.LifecycleState
	(Conversation_ConversationStage)(0),                             // 1: google.cloud.dialogflow.v2.Conversation.ConversationStage
	(Conversation_ContextReference_UpdateMode)(0),                   // 2: google.cloud.dialogflow.v2.Conversation.ContextReference.UpdateMode
	(Conversation_ContextReference_ContextContent_ContentFormat)(0), // 3: google.cloud.dialogflow.v2.Conversation.ContextReference.ContextContent.ContentFormat
	(SearchKnowledgeRequest_QuerySource)(0),                         // 4: google.cloud.dialogflow.v2.SearchKnowledgeRequest.QuerySource
	(SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType)(0),     // 5: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType
	(SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType)(0), // 6: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType
	(SearchKnowledgeAnswer_AnswerType)(0),                    // 7: google.cloud.dialogflow.v2.SearchKnowledgeAnswer.AnswerType
	(*Conversation)(nil),                                     // 8: google.cloud.dialogflow.v2.Conversation
	(*CreateConversationRequest)(nil),                        // 9: google.cloud.dialogflow.v2.CreateConversationRequest
	(*ListConversationsRequest)(nil),                         // 10: google.cloud.dialogflow.v2.ListConversationsRequest
	(*ListConversationsResponse)(nil),                        // 11: google.cloud.dialogflow.v2.ListConversationsResponse
	(*GetConversationRequest)(nil),                           // 12: google.cloud.dialogflow.v2.GetConversationRequest
	(*CompleteConversationRequest)(nil),                      // 13: google.cloud.dialogflow.v2.CompleteConversationRequest
	(*ListMessagesRequest)(nil),                              // 14: google.cloud.dialogflow.v2.ListMessagesRequest
	(*ListMessagesResponse)(nil),                             // 15: google.cloud.dialogflow.v2.ListMessagesResponse
	(*ConversationPhoneNumber)(nil),                          // 16: google.cloud.dialogflow.v2.ConversationPhoneNumber
	(*IngestContextReferencesRequest)(nil),                   // 17: google.cloud.dialogflow.v2.IngestContextReferencesRequest
	(*IngestContextReferencesResponse)(nil),                  // 18: google.cloud.dialogflow.v2.IngestContextReferencesResponse
	(*SuggestConversationSummaryRequest)(nil),                // 19: google.cloud.dialogflow.v2.SuggestConversationSummaryRequest
	(*SuggestConversationSummaryResponse)(nil),               // 20: google.cloud.dialogflow.v2.SuggestConversationSummaryResponse
	(*GenerateStatelessSummaryRequest)(nil),                  // 21: google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest
	(*GenerateStatelessSummaryResponse)(nil),                 // 22: google.cloud.dialogflow.v2.GenerateStatelessSummaryResponse
	(*GenerateStatelessSuggestionRequest)(nil),               // 23: google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest
	(*GenerateStatelessSuggestionResponse)(nil),              // 24: google.cloud.dialogflow.v2.GenerateStatelessSuggestionResponse
	(*SearchKnowledgeRequest)(nil),                           // 25: google.cloud.dialogflow.v2.SearchKnowledgeRequest
	(*SearchKnowledgeResponse)(nil),                          // 26: google.cloud.dialogflow.v2.SearchKnowledgeResponse
	(*SearchKnowledgeAnswer)(nil),                            // 27: google.cloud.dialogflow.v2.SearchKnowledgeAnswer
	(*GenerateSuggestionsRequest)(nil),                       // 28: google.cloud.dialogflow.v2.GenerateSuggestionsRequest
	(*Conversation_TelephonyConnectionInfo)(nil),             // 29: google.cloud.dialogflow.v2.Conversation.TelephonyConnectionInfo
	(*Conversation_ContextReference)(nil),                    // 30: google.cloud.dialogflow.v2.Conversation.ContextReference
	nil,                                                      // 31: google.cloud.dialogflow.v2.Conversation.IngestedContextReferencesEntry
	(*Conversation_TelephonyConnectionInfo_SipHeader)(nil),   // 32: google.cloud.dialogflow.v2.Conversation.TelephonyConnectionInfo.SipHeader
	(*Conversation_TelephonyConnectionInfo_MimeContent)(nil), // 33: google.cloud.dialogflow.v2.Conversation.TelephonyConnectionInfo.MimeContent
	(*Conversation_ContextReference_ContextContent)(nil),     // 34: google.cloud.dialogflow.v2.Conversation.ContextReference.ContextContent
	nil, // 35: google.cloud.dialogflow.v2.IngestContextReferencesRequest.ContextReferencesEntry
	nil, // 36: google.cloud.dialogflow.v2.IngestContextReferencesResponse.IngestedContextReferencesEntry
	(*SuggestConversationSummaryResponse_Summary)(nil), // 37: google.cloud.dialogflow.v2.SuggestConversationSummaryResponse.Summary
	nil, // 38: google.cloud.dialogflow.v2.SuggestConversationSummaryResponse.Summary.TextSectionsEntry
	(*GenerateStatelessSummaryRequest_MinimalConversation)(nil), // 39: google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
	(*GenerateStatelessSummaryResponse_Summary)(nil),            // 40: google.cloud.dialogflow.v2.GenerateStatelessSummaryResponse.Summary
	nil, // 41: google.cloud.dialogflow.v2.GenerateStatelessSummaryResponse.Summary.TextSectionsEntry
	nil, // 42: google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest.ContextReferencesEntry
	(*SearchKnowledgeRequest_SearchConfig)(nil),                                                                       // 43: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig
	(*SearchKnowledgeRequest_SearchConfig_BoostSpecs)(nil),                                                            // 44: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs
	(*SearchKnowledgeRequest_SearchConfig_FilterSpecs)(nil),                                                           // 45: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.FilterSpecs
	(*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec)(nil),                                                  // 46: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec
	(*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec)(nil),                               // 47: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec.ConditionBoostSpec
	(*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec)(nil),              // 48: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec.ConditionBoostSpec.BoostControlSpec
	(*SearchKnowledgeRequest_SearchConfig_BoostSpecs_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint)(nil), // 49: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint
	(*SearchKnowledgeAnswer_AnswerSource)(nil),                                                                        // 50: google.cloud.dialogflow.v2.SearchKnowledgeAnswer.AnswerSource
	(*timestamppb.Timestamp)(nil),                                                                                     // 51: google.protobuf.Timestamp
	(*Message)(nil),                                                                                                   // 52: google.cloud.dialogflow.v2.Message
	(*AssistQueryParameters)(nil),                                                                                     // 53: google.cloud.dialogflow.v2.AssistQueryParameters
	(*ConversationProfile)(nil),                                                                                       // 54: google.cloud.dialogflow.v2.ConversationProfile
	(*Generator)(nil),                                                                                                 // 55: google.cloud.dialogflow.v2.Generator
	(*ConversationContext)(nil),                                                                                       // 56: google.cloud.dialogflow.v2.ConversationContext
	(TriggerEvent)(0),                                                                                                 // 57: google.cloud.dialogflow.v2.TriggerEvent
	(*GeneratorSuggestion)(nil),                                                                                       // 58: google.cloud.dialogflow.v2.GeneratorSuggestion
	(*TextInput)(nil),                                                                                                 // 59: google.cloud.dialogflow.v2.TextInput
	(*structpb.Struct)(nil),                                                                                           // 60: google.protobuf.Struct
	(*GenerateSuggestionsResponse)(nil),                                                                               // 61: google.cloud.dialogflow.v2.GenerateSuggestionsResponse
}
var file_google_cloud_dialogflow_v2_conversation_proto_depIdxs = []int32{
	0,  // 0: google.cloud.dialogflow.v2.Conversation.lifecycle_state:type_name -> google.cloud.dialogflow.v2.Conversation.LifecycleState
	16, // 1: google.cloud.dialogflow.v2.Conversation.phone_number:type_name -> google.cloud.dialogflow.v2.ConversationPhoneNumber
	51, // 2: google.cloud.dialogflow.v2.Conversation.start_time:type_name -> google.protobuf.Timestamp
	51, // 3: google.cloud.dialogflow.v2.Conversation.end_time:type_name -> google.protobuf.Timestamp
	1,  // 4: google.cloud.dialogflow.v2.Conversation.conversation_stage:type_name -> google.cloud.dialogflow.v2.Conversation.ConversationStage
	29, // 5: google.cloud.dialogflow.v2.Conversation.telephony_connection_info:type_name -> google.cloud.dialogflow.v2.Conversation.TelephonyConnectionInfo
	31, // 6: google.cloud.dialogflow.v2.Conversation.ingested_context_references:type_name -> google.cloud.dialogflow.v2.Conversation.IngestedContextReferencesEntry
	8,  // 7: google.cloud.dialogflow.v2.CreateConversationRequest.conversation:type_name -> google.cloud.dialogflow.v2.Conversation
	8,  // 8: google.cloud.dialogflow.v2.ListConversationsResponse.conversations:type_name -> google.cloud.dialogflow.v2.Conversation
	52, // 9: google.cloud.dialogflow.v2.ListMessagesResponse.messages:type_name -> google.cloud.dialogflow.v2.Message
	35, // 10: google.cloud.dialogflow.v2.IngestContextReferencesRequest.context_references:type_name -> google.cloud.dialogflow.v2.IngestContextReferencesRequest.ContextReferencesEntry
	36, // 11: google.cloud.dialogflow.v2.IngestContextReferencesResponse.ingested_context_references:type_name -> google.cloud.dialogflow.v2.IngestContextReferencesResponse.IngestedContextReferencesEntry
	53, // 12: google.cloud.dialogflow.v2.SuggestConversationSummaryRequest.assist_query_params:type_name -> google.cloud.dialogflow.v2.AssistQueryParameters
	37, // 13: google.cloud.dialogflow.v2.SuggestConversationSummaryResponse.summary:type_name -> google.cloud.dialogflow.v2.SuggestConversationSummaryResponse.Summary
	39, // 14: google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.stateless_conversation:type_name -> google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
	54, // 15: google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.conversation_profile:type_name -> google.cloud.dialogflow.v2.ConversationProfile
	40, // 16: google.cloud.dialogflow.v2.GenerateStatelessSummaryResponse.summary:type_name -> google.cloud.dialogflow.v2.GenerateStatelessSummaryResponse.Summary
	55, // 17: google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest.generator:type_name -> google.cloud.dialogflow.v2.Generator
	42, // 18: google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest.context_references:type_name -> google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest.ContextReferencesEntry
	56, // 19: google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest.conversation_context:type_name -> google.cloud.dialogflow.v2.ConversationContext
	57, // 20: google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest.trigger_events:type_name -> google.cloud.dialogflow.v2.TriggerEvent
	58, // 21: google.cloud.dialogflow.v2.GenerateStatelessSuggestionResponse.generator_suggestion:type_name -> google.cloud.dialogflow.v2.GeneratorSuggestion
	59, // 22: google.cloud.dialogflow.v2.SearchKnowledgeRequest.query:type_name -> google.cloud.dialogflow.v2.TextInput
	4,  // 23: google.cloud.dialogflow.v2.SearchKnowledgeRequest.query_source:type_name -> google.cloud.dialogflow.v2.SearchKnowledgeRequest.QuerySource
	60, // 24: google.cloud.dialogflow.v2.SearchKnowledgeRequest.end_user_metadata:type_name -> google.protobuf.Struct
	43, // 25: google.cloud.dialogflow.v2.SearchKnowledgeRequest.search_config:type_name -> google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig
	27, // 26: google.cloud.dialogflow.v2.SearchKnowledgeResponse.answers:type_name -> google.cloud.dialogflow.v2.SearchKnowledgeAnswer
	7,  // 27: google.cloud.dialogflow.v2.SearchKnowledgeAnswer.answer_type:type_name -> google.cloud.dialogflow.v2.SearchKnowledgeAnswer.AnswerType
	50, // 28: google.cloud.dialogflow.v2.SearchKnowledgeAnswer.answer_sources:type_name -> google.cloud.dialogflow.v2.SearchKnowledgeAnswer.AnswerSource
	57, // 29: google.cloud.dialogflow.v2.GenerateSuggestionsRequest.trigger_events:type_name -> google.cloud.dialogflow.v2.TriggerEvent
	32, // 30: google.cloud.dialogflow.v2.Conversation.TelephonyConnectionInfo.sip_headers:type_name -> google.cloud.dialogflow.v2.Conversation.TelephonyConnectionInfo.SipHeader
	33, // 31: google.cloud.dialogflow.v2.Conversation.TelephonyConnectionInfo.extra_mime_contents:type_name -> google.cloud.dialogflow.v2.Conversation.TelephonyConnectionInfo.MimeContent
	34, // 32: google.cloud.dialogflow.v2.Conversation.ContextReference.context_contents:type_name -> google.cloud.dialogflow.v2.Conversation.ContextReference.ContextContent
	2,  // 33: google.cloud.dialogflow.v2.Conversation.ContextReference.update_mode:type_name -> google.cloud.dialogflow.v2.Conversation.ContextReference.UpdateMode
	51, // 34: google.cloud.dialogflow.v2.Conversation.ContextReference.create_time:type_name -> google.protobuf.Timestamp
	30, // 35: google.cloud.dialogflow.v2.Conversation.IngestedContextReferencesEntry.value:type_name -> google.cloud.dialogflow.v2.Conversation.ContextReference
	3,  // 36: google.cloud.dialogflow.v2.Conversation.ContextReference.ContextContent.content_format:type_name -> google.cloud.dialogflow.v2.Conversation.ContextReference.ContextContent.ContentFormat
	51, // 37: google.cloud.dialogflow.v2.Conversation.ContextReference.ContextContent.ingestion_time:type_name -> google.protobuf.Timestamp
	30, // 38: google.cloud.dialogflow.v2.IngestContextReferencesRequest.ContextReferencesEntry.value:type_name -> google.cloud.dialogflow.v2.Conversation.ContextReference
	30, // 39: google.cloud.dialogflow.v2.IngestContextReferencesResponse.IngestedContextReferencesEntry.value:type_name -> google.cloud.dialogflow.v2.Conversation.ContextReference
	38, // 40: google.cloud.dialogflow.v2.SuggestConversationSummaryResponse.Summary.text_sections:type_name -> google.cloud.dialogflow.v2.SuggestConversationSummaryResponse.Summary.TextSectionsEntry
	52, // 41: google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation.messages:type_name -> google.cloud.dialogflow.v2.Message
	41, // 42: google.cloud.dialogflow.v2.GenerateStatelessSummaryResponse.Summary.text_sections:type_name -> google.cloud.dialogflow.v2.GenerateStatelessSummaryResponse.Summary.TextSectionsEntry
	30, // 43: google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest.ContextReferencesEntry.value:type_name -> google.cloud.dialogflow.v2.Conversation.ContextReference
	44, // 44: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.boost_specs:type_name -> google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs
	45, // 45: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.filter_specs:type_name -> google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.FilterSpecs
	46, // 46: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.spec:type_name -> google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec
	47, // 47: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec.condition_boost_specs:type_name -> google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec.ConditionBoostSpec
	48, // 48: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec.ConditionBoostSpec.boost_control_spec:type_name -> google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec.ConditionBoostSpec.BoostControlSpec
	5,  // 49: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec.ConditionBoostSpec.BoostControlSpec.attribute_type:type_name -> google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType
	6,  // 50: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec.ConditionBoostSpec.BoostControlSpec.interpolation_type:type_name -> google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType
	49, // 51: google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec.ConditionBoostSpec.BoostControlSpec.control_points:type_name -> google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig.BoostSpecs.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint
	60, // 52: google.cloud.dialogflow.v2.SearchKnowledgeAnswer.AnswerSource.metadata:type_name -> google.protobuf.Struct
	9,  // 53: google.cloud.dialogflow.v2.Conversations.CreateConversation:input_type -> google.cloud.dialogflow.v2.CreateConversationRequest
	10, // 54: google.cloud.dialogflow.v2.Conversations.ListConversations:input_type -> google.cloud.dialogflow.v2.ListConversationsRequest
	12, // 55: google.cloud.dialogflow.v2.Conversations.GetConversation:input_type -> google.cloud.dialogflow.v2.GetConversationRequest
	13, // 56: google.cloud.dialogflow.v2.Conversations.CompleteConversation:input_type -> google.cloud.dialogflow.v2.CompleteConversationRequest
	17, // 57: google.cloud.dialogflow.v2.Conversations.IngestContextReferences:input_type -> google.cloud.dialogflow.v2.IngestContextReferencesRequest
	14, // 58: google.cloud.dialogflow.v2.Conversations.ListMessages:input_type -> google.cloud.dialogflow.v2.ListMessagesRequest
	19, // 59: google.cloud.dialogflow.v2.Conversations.SuggestConversationSummary:input_type -> google.cloud.dialogflow.v2.SuggestConversationSummaryRequest
	21, // 60: google.cloud.dialogflow.v2.Conversations.GenerateStatelessSummary:input_type -> google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest
	23, // 61: google.cloud.dialogflow.v2.Conversations.GenerateStatelessSuggestion:input_type -> google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest
	25, // 62: google.cloud.dialogflow.v2.Conversations.SearchKnowledge:input_type -> google.cloud.dialogflow.v2.SearchKnowledgeRequest
	28, // 63: google.cloud.dialogflow.v2.Conversations.GenerateSuggestions:input_type -> google.cloud.dialogflow.v2.GenerateSuggestionsRequest
	8,  // 64: google.cloud.dialogflow.v2.Conversations.CreateConversation:output_type -> google.cloud.dialogflow.v2.Conversation
	11, // 65: google.cloud.dialogflow.v2.Conversations.ListConversations:output_type -> google.cloud.dialogflow.v2.ListConversationsResponse
	8,  // 66: google.cloud.dialogflow.v2.Conversations.GetConversation:output_type -> google.cloud.dialogflow.v2.Conversation
	8,  // 67: google.cloud.dialogflow.v2.Conversations.CompleteConversation:output_type -> google.cloud.dialogflow.v2.Conversation
	18, // 68: google.cloud.dialogflow.v2.Conversations.IngestContextReferences:output_type -> google.cloud.dialogflow.v2.IngestContextReferencesResponse
	15, // 69: google.cloud.dialogflow.v2.Conversations.ListMessages:output_type -> google.cloud.dialogflow.v2.ListMessagesResponse
	20, // 70: google.cloud.dialogflow.v2.Conversations.SuggestConversationSummary:output_type -> google.cloud.dialogflow.v2.SuggestConversationSummaryResponse
	22, // 71: google.cloud.dialogflow.v2.Conversations.GenerateStatelessSummary:output_type -> google.cloud.dialogflow.v2.GenerateStatelessSummaryResponse
	24, // 72: google.cloud.dialogflow.v2.Conversations.GenerateStatelessSuggestion:output_type -> google.cloud.dialogflow.v2.GenerateStatelessSuggestionResponse
	26, // 73: google.cloud.dialogflow.v2.Conversations.SearchKnowledge:output_type -> google.cloud.dialogflow.v2.SearchKnowledgeResponse
	61, // 74: google.cloud.dialogflow.v2.Conversations.GenerateSuggestions:output_type -> google.cloud.dialogflow.v2.GenerateSuggestionsResponse
	64, // [64:75] is the sub-list for method output_type
	53, // [53:64] is the sub-list for method input_type
	53, // [53:53] is the sub-list for extension type_name
	53, // [53:53] is the sub-list for extension extendee
	0,  // [0:53] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2_conversation_proto_init() }
func file_google_cloud_dialogflow_v2_conversation_proto_init() {
	if File_google_cloud_dialogflow_v2_conversation_proto != nil {
		return
	}
	file_google_cloud_dialogflow_v2_conversation_profile_proto_init()
	file_google_cloud_dialogflow_v2_generator_proto_init()
	file_google_cloud_dialogflow_v2_participant_proto_init()
	file_google_cloud_dialogflow_v2_session_proto_init()
	file_google_cloud_dialogflow_v2_conversation_proto_msgTypes[15].OneofWrappers = []any{
		(*GenerateStatelessSuggestionRequest_Generator)(nil),
		(*GenerateStatelessSuggestionRequest_GeneratorName)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2_conversation_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   43,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_v2_conversation_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2_conversation_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2_conversation_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2_conversation_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2_conversation_proto = out.File
	file_google_cloud_dialogflow_v2_conversation_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2_conversation_proto_goTypes = nil
	file_google_cloud_dialogflow_v2_conversation_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConversationsClient is the client API for Conversations service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConversationsClient interface {
	// Creates a new conversation. Conversations are auto-completed after 24
	// hours.
	//
	// Conversation Lifecycle:
	// There are two stages during a conversation: Automated Agent Stage and
	// Assist Stage.
	//
	// For Automated Agent Stage, there will be a dialogflow agent responding to
	// user queries.
	//
	// For Assist Stage, there's no dialogflow agent responding to user queries.
	// But we will provide suggestions which are generated from conversation.
	//
	// If
	// [Conversation.conversation_profile][google.cloud.dialogflow.v2.Conversation.conversation_profile]
	// is configured for a dialogflow agent, conversation will start from
	// `Automated Agent Stage`, otherwise, it will start from `Assist Stage`. And
	// during `Automated Agent Stage`, once an
	// [Intent][google.cloud.dialogflow.v2.Intent] with
	// [Intent.live_agent_handoff][google.cloud.dialogflow.v2.Intent.live_agent_handoff]
	// is triggered, conversation will transfer to Assist Stage.
	CreateConversation(ctx context.Context, in *CreateConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Returns the list of all conversations in the specified project.
	ListConversations(ctx context.Context, in *ListConversationsRequest, opts ...grpc.CallOption) (*ListConversationsResponse, error)
	// Retrieves the specific conversation.
	GetConversation(ctx context.Context, in *GetConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Completes the specified conversation. Finished conversations are purged
	// from the database after 30 days.
	CompleteConversation(ctx context.Context, in *CompleteConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Data ingestion API.
	// Ingests context references for an existing conversation.
	IngestContextReferences(ctx context.Context, in *IngestContextReferencesRequest, opts ...grpc.CallOption) (*IngestContextReferencesResponse, error)
	// Lists messages that belong to a given conversation.
	// `messages` are ordered by `create_time` in descending order. To fetch
	// updates without duplication, send request with filter
	// `create_time_epoch_microseconds >
	// [first item's create_time of previous request]` and empty page_token.
	ListMessages(ctx context.Context, in *ListMessagesRequest, opts ...grpc.CallOption) (*ListMessagesResponse, error)
	// Suggests summary for a conversation based on specific historical messages.
	// The range of the messages to be used for summary can be specified in the
	// request.
	SuggestConversationSummary(ctx context.Context, in *SuggestConversationSummaryRequest, opts ...grpc.CallOption) (*SuggestConversationSummaryResponse, error)
	// Generates and returns a summary for a conversation that does not have a
	// resource created for it.
	GenerateStatelessSummary(ctx context.Context, in *GenerateStatelessSummaryRequest, opts ...grpc.CallOption) (*GenerateStatelessSummaryResponse, error)
	// Generates and returns a suggestion for a conversation that does not have a
	// resource created for it.
	GenerateStatelessSuggestion(ctx context.Context, in *GenerateStatelessSuggestionRequest, opts ...grpc.CallOption) (*GenerateStatelessSuggestionResponse, error)
	// Get answers for the given query based on knowledge documents.
	SearchKnowledge(ctx context.Context, in *SearchKnowledgeRequest, opts ...grpc.CallOption) (*SearchKnowledgeResponse, error)
	// Generates all the suggestions using generators configured in the
	// conversation profile. A generator is used only if its trigger event is
	// matched.
	GenerateSuggestions(ctx context.Context, in *GenerateSuggestionsRequest, opts ...grpc.CallOption) (*GenerateSuggestionsResponse, error)
}

type conversationsClient struct {
	cc grpc.ClientConnInterface
}

func NewConversationsClient(cc grpc.ClientConnInterface) ConversationsClient {
	return &conversationsClient{cc}
}

func (c *conversationsClient) CreateConversation(ctx context.Context, in *CreateConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Conversations/CreateConversation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) ListConversations(ctx context.Context, in *ListConversationsRequest, opts ...grpc.CallOption) (*ListConversationsResponse, error) {
	out := new(ListConversationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Conversations/ListConversations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) GetConversation(ctx context.Context, in *GetConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Conversations/GetConversation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) CompleteConversation(ctx context.Context, in *CompleteConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Conversations/CompleteConversation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) IngestContextReferences(ctx context.Context, in *IngestContextReferencesRequest, opts ...grpc.CallOption) (*IngestContextReferencesResponse, error) {
	out := new(IngestContextReferencesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Conversations/IngestContextReferences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) ListMessages(ctx context.Context, in *ListMessagesRequest, opts ...grpc.CallOption) (*ListMessagesResponse, error) {
	out := new(ListMessagesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Conversations/ListMessages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) SuggestConversationSummary(ctx context.Context, in *SuggestConversationSummaryRequest, opts ...grpc.CallOption) (*SuggestConversationSummaryResponse, error) {
	out := new(SuggestConversationSummaryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Conversations/SuggestConversationSummary", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) GenerateStatelessSummary(ctx context.Context, in *GenerateStatelessSummaryRequest, opts ...grpc.CallOption) (*GenerateStatelessSummaryResponse, error) {
	out := new(GenerateStatelessSummaryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Conversations/GenerateStatelessSummary", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) GenerateStatelessSuggestion(ctx context.Context, in *GenerateStatelessSuggestionRequest, opts ...grpc.CallOption) (*GenerateStatelessSuggestionResponse, error) {
	out := new(GenerateStatelessSuggestionResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Conversations/GenerateStatelessSuggestion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) SearchKnowledge(ctx context.Context, in *SearchKnowledgeRequest, opts ...grpc.CallOption) (*SearchKnowledgeResponse, error) {
	out := new(SearchKnowledgeResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Conversations/SearchKnowledge", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) GenerateSuggestions(ctx context.Context, in *GenerateSuggestionsRequest, opts ...grpc.CallOption) (*GenerateSuggestionsResponse, error) {
	out := new(GenerateSuggestionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Conversations/GenerateSuggestions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConversationsServer is the server API for Conversations service.
type ConversationsServer interface {
	// Creates a new conversation. Conversations are auto-completed after 24
	// hours.
	//
	// Conversation Lifecycle:
	// There are two stages during a conversation: Automated Agent Stage and
	// Assist Stage.
	//
	// For Automated Agent Stage, there will be a dialogflow agent responding to
	// user queries.
	//
	// For Assist Stage, there's no dialogflow agent responding to user queries.
	// But we will provide suggestions which are generated from conversation.
	//
	// If
	// [Conversation.conversation_profile][google.cloud.dialogflow.v2.Conversation.conversation_profile]
	// is configured for a dialogflow agent, conversation will start from
	// `Automated Agent Stage`, otherwise, it will start from `Assist Stage`. And
	// during `Automated Agent Stage`, once an
	// [Intent][google.cloud.dialogflow.v2.Intent] with
	// [Intent.live_agent_handoff][google.cloud.dialogflow.v2.Intent.live_agent_handoff]
	// is triggered, conversation will transfer to Assist Stage.
	CreateConversation(context.Context, *CreateConversationRequest) (*Conversation, error)
	// Returns the list of all conversations in the specified project.
	ListConversations(context.Context, *ListConversationsRequest) (*ListConversationsResponse, error)
	// Retrieves the specific conversation.
	GetConversation(context.Context, *GetConversationRequest) (*Conversation, error)
	// Completes the specified conversation. Finished conversations are purged
	// from the database after 30 days.
	CompleteConversation(context.Context, *CompleteConversationRequest) (*Conversation, error)
	// Data ingestion API.
	// Ingests context references for an existing conversation.
	IngestContextReferences(context.Context, *IngestContextReferencesRequest) (*IngestContextReferencesResponse, error)
	// Lists messages that belong to a given conversation.
	// `messages` are ordered by `create_time` in descending order. To fetch
	// updates without duplication, send request with filter
	// `create_time_epoch_microseconds >
	// [first item's create_time of previous request]` and empty page_token.
	ListMessages(context.Context, *ListMessagesRequest) (*ListMessagesResponse, error)
	// Suggests summary for a conversation based on specific historical messages.
	// The range of the messages to be used for summary can be specified in the
	// request.
	SuggestConversationSummary(context.Context, *SuggestConversationSummaryRequest) (*SuggestConversationSummaryResponse, error)
	// Generates and returns a summary for a conversation that does not have a
	// resource created for it.
	GenerateStatelessSummary(context.Context, *GenerateStatelessSummaryRequest) (*GenerateStatelessSummaryResponse, error)
	// Generates and returns a suggestion for a conversation that does not have a
	// resource created for it.
	GenerateStatelessSuggestion(context.Context, *GenerateStatelessSuggestionRequest) (*GenerateStatelessSuggestionResponse, error)
	// Get answers for the given query based on knowledge documents.
	SearchKnowledge(context.Context, *SearchKnowledgeRequest) (*SearchKnowledgeResponse, error)
	// Generates all the suggestions using generators configured in the
	// conversation profile. A generator is used only if its trigger event is
	// matched.
	GenerateSuggestions(context.Context, *GenerateSuggestionsRequest) (*GenerateSuggestionsResponse, error)
}

// UnimplementedConversationsServer can be embedded to have forward compatible implementations.
type UnimplementedConversationsServer struct {
}

func (*UnimplementedConversationsServer) CreateConversation(context.Context, *CreateConversationRequest) (*Conversation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversation not implemented")
}
func (*UnimplementedConversationsServer) ListConversations(context.Context, *ListConversationsRequest) (*ListConversationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversations not implemented")
}
func (*UnimplementedConversationsServer) GetConversation(context.Context, *GetConversationRequest) (*Conversation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversation not implemented")
}
func (*UnimplementedConversationsServer) CompleteConversation(context.Context, *CompleteConversationRequest) (*Conversation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CompleteConversation not implemented")
}
func (*UnimplementedConversationsServer) IngestContextReferences(context.Context, *IngestContextReferencesRequest) (*IngestContextReferencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IngestContextReferences not implemented")
}
func (*UnimplementedConversationsServer) ListMessages(context.Context, *ListMessagesRequest) (*ListMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMessages not implemented")
}
func (*UnimplementedConversationsServer) SuggestConversationSummary(context.Context, *SuggestConversationSummaryRequest) (*SuggestConversationSummaryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SuggestConversationSummary not implemented")
}
func (*UnimplementedConversationsServer) GenerateStatelessSummary(context.Context, *GenerateStatelessSummaryRequest) (*GenerateStatelessSummaryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateStatelessSummary not implemented")
}
func (*UnimplementedConversationsServer) GenerateStatelessSuggestion(context.Context, *GenerateStatelessSuggestionRequest) (*GenerateStatelessSuggestionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateStatelessSuggestion not implemented")
}
func (*UnimplementedConversationsServer) SearchKnowledge(context.Context, *SearchKnowledgeRequest) (*SearchKnowledgeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchKnowledge not implemented")
}
func (*UnimplementedConversationsServer) GenerateSuggestions(context.Context, *GenerateSuggestionsRequest) (*GenerateSuggestionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateSuggestions not implemented")
}

func RegisterConversationsServer(s *grpc.Server, srv ConversationsServer) {
	s.RegisterService(&_Conversations_serviceDesc, srv)
}

func _Conversations_CreateConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).CreateConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Conversations/CreateConversation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).CreateConversation(ctx, req.(*CreateConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_ListConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).ListConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Conversations/ListConversations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).ListConversations(ctx, req.(*ListConversationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_GetConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).GetConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Conversations/GetConversation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).GetConversation(ctx, req.(*GetConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_CompleteConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).CompleteConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Conversations/CompleteConversation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).CompleteConversation(ctx, req.(*CompleteConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_IngestContextReferences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IngestContextReferencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).IngestContextReferences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Conversations/IngestContextReferences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).IngestContextReferences(ctx, req.(*IngestContextReferencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_ListMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).ListMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Conversations/ListMessages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).ListMessages(ctx, req.(*ListMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_SuggestConversationSummary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuggestConversationSummaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).SuggestConversationSummary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Conversations/SuggestConversationSummary",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).SuggestConversationSummary(ctx, req.(*SuggestConversationSummaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_GenerateStatelessSummary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateStatelessSummaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).GenerateStatelessSummary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Conversations/GenerateStatelessSummary",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).GenerateStatelessSummary(ctx, req.(*GenerateStatelessSummaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_GenerateStatelessSuggestion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateStatelessSuggestionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).GenerateStatelessSuggestion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Conversations/GenerateStatelessSuggestion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).GenerateStatelessSuggestion(ctx, req.(*GenerateStatelessSuggestionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_SearchKnowledge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchKnowledgeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).SearchKnowledge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Conversations/SearchKnowledge",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).SearchKnowledge(ctx, req.(*SearchKnowledgeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_GenerateSuggestions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateSuggestionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).GenerateSuggestions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Conversations/GenerateSuggestions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).GenerateSuggestions(ctx, req.(*GenerateSuggestionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Conversations_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.Conversations",
	HandlerType: (*ConversationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConversation",
			Handler:    _Conversations_CreateConversation_Handler,
		},
		{
			MethodName: "ListConversations",
			Handler:    _Conversations_ListConversations_Handler,
		},
		{
			MethodName: "GetConversation",
			Handler:    _Conversations_GetConversation_Handler,
		},
		{
			MethodName: "CompleteConversation",
			Handler:    _Conversations_CompleteConversation_Handler,
		},
		{
			MethodName: "IngestContextReferences",
			Handler:    _Conversations_IngestContextReferences_Handler,
		},
		{
			MethodName: "ListMessages",
			Handler:    _Conversations_ListMessages_Handler,
		},
		{
			MethodName: "SuggestConversationSummary",
			Handler:    _Conversations_SuggestConversationSummary_Handler,
		},
		{
			MethodName: "GenerateStatelessSummary",
			Handler:    _Conversations_GenerateStatelessSummary_Handler,
		},
		{
			MethodName: "GenerateStatelessSuggestion",
			Handler:    _Conversations_GenerateStatelessSuggestion_Handler,
		},
		{
			MethodName: "SearchKnowledge",
			Handler:    _Conversations_SearchKnowledge_Handler,
		},
		{
			MethodName: "GenerateSuggestions",
			Handler:    _Conversations_GenerateSuggestions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/conversation.proto",
}
