// Code generated by 'ccgo -o vfs_openbsd_amd64.go c/vfs.c -I../testdata/sqlite-amalgamation-3380500 -lmodernc.org/sqlite/lib -pkgname vfs -nocapi -export-externs X -D SQLITE_OS_UNIX -hide=vfsFullPathname -hide=vfsOpen -hide=vfsRead -hide=vfsAccess -hide=vfsFileSize -hide=vfsClose', DO NOT EDIT.

package vfs

import (
	"math"
	"reflect"
	"sync/atomic"
	"unsafe"

	"modernc.org/libc"
	"modernc.org/libc/sys/types"
	"modernc.org/sqlite/lib"
)

var _ = math.Pi
var _ reflect.Kind
var _ atomic.Value
var _ unsafe.Pointer
var _ *libc.TLS
var _ types.Size_t

type ptrdiff_t = int64 /* <builtin>:3:26 */

type size_t = uint64 /* <builtin>:9:23 */

type wchar_t = int32 /* <builtin>:15:24 */

// Note that the type used in va_arg is supposed to match the
//    actual type **after default promotions**.
//    Thus, va_arg (..., short) is not valid.

type va_list = uintptr /* stdarg.h:39:24 */

// CAPI3REF: 64-Bit Integer Types
// KEYWORDS: sqlite_int64 sqlite_uint64
//
// Because there is no cross-platform way to specify 64-bit integer types
// SQLite includes typedefs for 64-bit signed and unsigned integers.
//
// The sqlite3_int64 and sqlite3_uint64 are the preferred type definitions.
// The sqlite_int64 and sqlite_uint64 types are supported for backwards
// compatibility only.
//
// ^The sqlite3_int64 and sqlite_int64 types can store integer values
// between -9223372036854775808 and +9223372036854775807 inclusive.  ^The
// sqlite3_uint64 and sqlite_uint64 types can store integer values
// between 0 and +18446744073709551615 inclusive.
type sqlite_int64 = int64           /* sqlite3.h:301:25 */
type sqlite_uint64 = uint64         /* sqlite3.h:302:34 */
type sqlite3_int64 = sqlite_int64   /* sqlite3.h:304:22 */
type sqlite3_uint64 = sqlite_uint64 /* sqlite3.h:305:23 */

// The type for a callback function.
// This is legacy and deprecated.  It is included for historical
// compatibility and is not documented.
type sqlite3_callback = uintptr /* sqlite3.h:361:13 */

// CAPI3REF: Result Codes
// KEYWORDS: {result code definitions}
//
// Many SQLite functions return an integer result code from the set shown
// here in order to indicate success or failure.
//
// New error codes may be added in future versions of SQLite.
//
// See also: [extended result code definitions]
// beginning-of-error-codes
// end-of-error-codes

// CAPI3REF: Extended Result Codes
// KEYWORDS: {extended result code definitions}
//
// In its default configuration, SQLite API routines return one of 30 integer
// [result codes].  However, experience has shown that many of
// these result codes are too coarse-grained.  They do not provide as
// much information about problems as programmers might like.  In an effort to
// address this, newer versions of SQLite (version 3.3.8 [dateof:3.3.8]
// and later) include
// support for additional result codes that provide more detailed information
// about errors. These [extended result codes] are enabled or disabled
// on a per database connection basis using the
// [sqlite3_extended_result_codes()] API.  Or, the extended code for
// the most recent error can be obtained using
// [sqlite3_extended_errcode()].

// CAPI3REF: Flags For File Open Operations
//
// These bit values are intended for use in the
// 3rd parameter to the [sqlite3_open_v2()] interface and
// in the 4th parameter to the [sqlite3_vfs.xOpen] method.
//
// Only those flags marked as "Ok for sqlite3_open_v2()" may be
// used as the third argument to the [sqlite3_open_v2()] interface.
// The other flags have historically been ignored by sqlite3_open_v2(),
// though future versions of SQLite might change so that an error is
// raised if any of the disallowed bits are passed into sqlite3_open_v2().
// Applications should not depend on the historical behavior.
//
// Note in particular that passing the SQLITE_OPEN_EXCLUSIVE flag into
// [sqlite3_open_v2()] does *not* cause the underlying database file
// to be opened using O_EXCL.  Passing SQLITE_OPEN_EXCLUSIVE into
// [sqlite3_open_v2()] has historically be a no-op and might become an
// error in future versions of SQLite.

// Reserved:                         0x00F00000
// Legacy compatibility:

// CAPI3REF: Device Characteristics
//
// The xDeviceCharacteristics method of the [sqlite3_io_methods]
// object returns an integer which is a vector of these
// bit values expressing I/O characteristics of the mass storage
// device that holds the file that the [sqlite3_io_methods]
// refers to.
//
// The SQLITE_IOCAP_ATOMIC property means that all writes of
// any size are atomic.  The SQLITE_IOCAP_ATOMICnnn values
// mean that writes of blocks that are nnn bytes in size and
// are aligned to an address which is an integer multiple of
// nnn are atomic.  The SQLITE_IOCAP_SAFE_APPEND value means
// that when data is appended to a file, the data is appended
// first then the size of the file is extended, never the other
// way around.  The SQLITE_IOCAP_SEQUENTIAL property means that
// information is written to disk in the same order as calls
// to xWrite().  The SQLITE_IOCAP_POWERSAFE_OVERWRITE property means that
// after reboot following a crash or power loss, the only bytes in a
// file that were written at the application level might have changed
// and that adjacent bytes, even bytes within the same sector are
// guaranteed to be unchanged.  The SQLITE_IOCAP_UNDELETABLE_WHEN_OPEN
// flag indicates that a file cannot be deleted when open.  The
// SQLITE_IOCAP_IMMUTABLE flag indicates that the file is on
// read-only media and cannot be changed even by processes with
// elevated privileges.
//
// The SQLITE_IOCAP_BATCH_ATOMIC property means that the underlying
// filesystem supports doing multiple write operations atomically when those
// write operations are bracketed by [SQLITE_FCNTL_BEGIN_ATOMIC_WRITE] and
// [SQLITE_FCNTL_COMMIT_ATOMIC_WRITE].

// CAPI3REF: File Locking Levels
//
// SQLite uses one of these integer values as the second
// argument to calls it makes to the xLock() and xUnlock() methods
// of an [sqlite3_io_methods] object.

// CAPI3REF: Synchronization Type Flags
//
// When SQLite invokes the xSync() method of an
// [sqlite3_io_methods] object it uses a combination of
// these integer values as the second argument.
//
// When the SQLITE_SYNC_DATAONLY flag is used, it means that the
// sync operation only needs to flush data to mass storage.  Inode
// information need not be flushed. If the lower four bits of the flag
// equal SQLITE_SYNC_NORMAL, that means to use normal fsync() semantics.
// If the lower four bits equal SQLITE_SYNC_FULL, that means
// to use Mac OS X style fullsync instead of fsync().
//
// Do not confuse the SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL flags
// with the [PRAGMA synchronous]=NORMAL and [PRAGMA synchronous]=FULL
// settings.  The [synchronous pragma] determines when calls to the
// xSync VFS method occur and applies uniformly across all platforms.
// The SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL flags determine how
// energetic or rigorous or forceful the sync operations are and
// only make a difference on Mac OSX for the default SQLite code.
// (Third-party VFS implementations might also make the distinction
// between SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL, but among the
// operating systems natively supported by SQLite, only Mac OSX
// cares about the difference.)

// CAPI3REF: OS Interface Open File Handle
//
// An [sqlite3_file] object represents an open file in the
// [sqlite3_vfs | OS interface layer].  Individual OS interface
// implementations will
// want to subclass this object by appending additional fields
// for their own use.  The pMethods entry is a pointer to an
// [sqlite3_io_methods] object that defines methods for performing
// I/O operations on the open file.
type sqlite3_file1 = struct{ pMethods uintptr } /* sqlite3.h:722:9 */

// CAPI3REF: Result Codes
// KEYWORDS: {result code definitions}
//
// Many SQLite functions return an integer result code from the set shown
// here in order to indicate success or failure.
//
// New error codes may be added in future versions of SQLite.
//
// See also: [extended result code definitions]
// beginning-of-error-codes
// end-of-error-codes

// CAPI3REF: Extended Result Codes
// KEYWORDS: {extended result code definitions}
//
// In its default configuration, SQLite API routines return one of 30 integer
// [result codes].  However, experience has shown that many of
// these result codes are too coarse-grained.  They do not provide as
// much information about problems as programmers might like.  In an effort to
// address this, newer versions of SQLite (version 3.3.8 [dateof:3.3.8]
// and later) include
// support for additional result codes that provide more detailed information
// about errors. These [extended result codes] are enabled or disabled
// on a per database connection basis using the
// [sqlite3_extended_result_codes()] API.  Or, the extended code for
// the most recent error can be obtained using
// [sqlite3_extended_errcode()].

// CAPI3REF: Flags For File Open Operations
//
// These bit values are intended for use in the
// 3rd parameter to the [sqlite3_open_v2()] interface and
// in the 4th parameter to the [sqlite3_vfs.xOpen] method.
//
// Only those flags marked as "Ok for sqlite3_open_v2()" may be
// used as the third argument to the [sqlite3_open_v2()] interface.
// The other flags have historically been ignored by sqlite3_open_v2(),
// though future versions of SQLite might change so that an error is
// raised if any of the disallowed bits are passed into sqlite3_open_v2().
// Applications should not depend on the historical behavior.
//
// Note in particular that passing the SQLITE_OPEN_EXCLUSIVE flag into
// [sqlite3_open_v2()] does *not* cause the underlying database file
// to be opened using O_EXCL.  Passing SQLITE_OPEN_EXCLUSIVE into
// [sqlite3_open_v2()] has historically be a no-op and might become an
// error in future versions of SQLite.

// Reserved:                         0x00F00000
// Legacy compatibility:

// CAPI3REF: Device Characteristics
//
// The xDeviceCharacteristics method of the [sqlite3_io_methods]
// object returns an integer which is a vector of these
// bit values expressing I/O characteristics of the mass storage
// device that holds the file that the [sqlite3_io_methods]
// refers to.
//
// The SQLITE_IOCAP_ATOMIC property means that all writes of
// any size are atomic.  The SQLITE_IOCAP_ATOMICnnn values
// mean that writes of blocks that are nnn bytes in size and
// are aligned to an address which is an integer multiple of
// nnn are atomic.  The SQLITE_IOCAP_SAFE_APPEND value means
// that when data is appended to a file, the data is appended
// first then the size of the file is extended, never the other
// way around.  The SQLITE_IOCAP_SEQUENTIAL property means that
// information is written to disk in the same order as calls
// to xWrite().  The SQLITE_IOCAP_POWERSAFE_OVERWRITE property means that
// after reboot following a crash or power loss, the only bytes in a
// file that were written at the application level might have changed
// and that adjacent bytes, even bytes within the same sector are
// guaranteed to be unchanged.  The SQLITE_IOCAP_UNDELETABLE_WHEN_OPEN
// flag indicates that a file cannot be deleted when open.  The
// SQLITE_IOCAP_IMMUTABLE flag indicates that the file is on
// read-only media and cannot be changed even by processes with
// elevated privileges.
//
// The SQLITE_IOCAP_BATCH_ATOMIC property means that the underlying
// filesystem supports doing multiple write operations atomically when those
// write operations are bracketed by [SQLITE_FCNTL_BEGIN_ATOMIC_WRITE] and
// [SQLITE_FCNTL_COMMIT_ATOMIC_WRITE].

// CAPI3REF: File Locking Levels
//
// SQLite uses one of these integer values as the second
// argument to calls it makes to the xLock() and xUnlock() methods
// of an [sqlite3_io_methods] object.

// CAPI3REF: Synchronization Type Flags
//
// When SQLite invokes the xSync() method of an
// [sqlite3_io_methods] object it uses a combination of
// these integer values as the second argument.
//
// When the SQLITE_SYNC_DATAONLY flag is used, it means that the
// sync operation only needs to flush data to mass storage.  Inode
// information need not be flushed. If the lower four bits of the flag
// equal SQLITE_SYNC_NORMAL, that means to use normal fsync() semantics.
// If the lower four bits equal SQLITE_SYNC_FULL, that means
// to use Mac OS X style fullsync instead of fsync().
//
// Do not confuse the SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL flags
// with the [PRAGMA synchronous]=NORMAL and [PRAGMA synchronous]=FULL
// settings.  The [synchronous pragma] determines when calls to the
// xSync VFS method occur and applies uniformly across all platforms.
// The SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL flags determine how
// energetic or rigorous or forceful the sync operations are and
// only make a difference on Mac OSX for the default SQLite code.
// (Third-party VFS implementations might also make the distinction
// between SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL, but among the
// operating systems natively supported by SQLite, only Mac OSX
// cares about the difference.)

// CAPI3REF: OS Interface Open File Handle
//
// An [sqlite3_file] object represents an open file in the
// [sqlite3_vfs | OS interface layer].  Individual OS interface
// implementations will
// want to subclass this object by appending additional fields
// for their own use.  The pMethods entry is a pointer to an
// [sqlite3_io_methods] object that defines methods for performing
// I/O operations on the open file.
type sqlite3_file = sqlite3_file1 /* sqlite3.h:722:29 */
type sqlite3_io_methods1 = struct {
	iVersion               int32
	_                      [4]byte
	xClose                 uintptr
	xRead                  uintptr
	xWrite                 uintptr
	xTruncate              uintptr
	xSync                  uintptr
	xFileSize              uintptr
	xLock                  uintptr
	xUnlock                uintptr
	xCheckReservedLock     uintptr
	xFileControl           uintptr
	xSectorSize            uintptr
	xDeviceCharacteristics uintptr
	xShmMap                uintptr
	xShmLock               uintptr
	xShmBarrier            uintptr
	xShmUnmap              uintptr
	xFetch                 uintptr
	xUnfetch               uintptr
} /* sqlite3.h:722:9 */

// CAPI3REF: OS Interface File Virtual Methods Object
//
// Every file opened by the [sqlite3_vfs.xOpen] method populates an
// [sqlite3_file] object (or, more commonly, a subclass of the
// [sqlite3_file] object) with a pointer to an instance of this object.
// This object defines the methods used to perform various operations
// against the open file represented by the [sqlite3_file] object.
//
// If the [sqlite3_vfs.xOpen] method sets the sqlite3_file.pMethods element
// to a non-NULL pointer, then the sqlite3_io_methods.xClose method
// may be invoked even if the [sqlite3_vfs.xOpen] reported that it failed.  The
// only way to prevent a call to xClose following a failed [sqlite3_vfs.xOpen]
// is for the [sqlite3_vfs.xOpen] to set the sqlite3_file.pMethods element
// to NULL.
//
// The flags argument to xSync may be one of [SQLITE_SYNC_NORMAL] or
// [SQLITE_SYNC_FULL].  The first choice is the normal fsync().
// The second choice is a Mac OS X style fullsync.  The [SQLITE_SYNC_DATAONLY]
// flag may be ORed in to indicate that only the data of the file
// and not its inode needs to be synced.
//
// The integer values to xLock() and xUnlock() are one of
// <ul>
// <li> [SQLITE_LOCK_NONE],
// <li> [SQLITE_LOCK_SHARED],
// <li> [SQLITE_LOCK_RESERVED],
// <li> [SQLITE_LOCK_PENDING], or
// <li> [SQLITE_LOCK_EXCLUSIVE].
// </ul>
// xLock() increases the lock. xUnlock() decreases the lock.
// The xCheckReservedLock() method checks whether any database connection,
// either in this process or in some other process, is holding a RESERVED,
// PENDING, or EXCLUSIVE lock on the file.  It returns true
// if such a lock exists and false otherwise.
//
// The xFileControl() method is a generic interface that allows custom
// VFS implementations to directly control an open file using the
// [sqlite3_file_control()] interface.  The second "op" argument is an
// integer opcode.  The third argument is a generic pointer intended to
// point to a structure that may contain arguments or space in which to
// write return values.  Potential uses for xFileControl() might be
// functions to enable blocking locks with timeouts, to change the
// locking strategy (for example to use dot-file locks), to inquire
// about the status of a lock, or to break stale locks.  The SQLite
// core reserves all opcodes less than 100 for its own use.
// A [file control opcodes | list of opcodes] less than 100 is available.
// Applications that define a custom xFileControl method should use opcodes
// greater than 100 to avoid conflicts.  VFS implementations should
// return [SQLITE_NOTFOUND] for file control opcodes that they do not
// recognize.
//
// The xSectorSize() method returns the sector size of the
// device that underlies the file.  The sector size is the
// minimum write that can be performed without disturbing
// other bytes in the file.  The xDeviceCharacteristics()
// method returns a bit vector describing behaviors of the
// underlying device:
//
// <ul>
// <li> [SQLITE_IOCAP_ATOMIC]
// <li> [SQLITE_IOCAP_ATOMIC512]
// <li> [SQLITE_IOCAP_ATOMIC1K]
// <li> [SQLITE_IOCAP_ATOMIC2K]
// <li> [SQLITE_IOCAP_ATOMIC4K]
// <li> [SQLITE_IOCAP_ATOMIC8K]
// <li> [SQLITE_IOCAP_ATOMIC16K]
// <li> [SQLITE_IOCAP_ATOMIC32K]
// <li> [SQLITE_IOCAP_ATOMIC64K]
// <li> [SQLITE_IOCAP_SAFE_APPEND]
// <li> [SQLITE_IOCAP_SEQUENTIAL]
// <li> [SQLITE_IOCAP_UNDELETABLE_WHEN_OPEN]
// <li> [SQLITE_IOCAP_POWERSAFE_OVERWRITE]
// <li> [SQLITE_IOCAP_IMMUTABLE]
// <li> [SQLITE_IOCAP_BATCH_ATOMIC]
// </ul>
//
// The SQLITE_IOCAP_ATOMIC property means that all writes of
// any size are atomic.  The SQLITE_IOCAP_ATOMICnnn values
// mean that writes of blocks that are nnn bytes in size and
// are aligned to an address which is an integer multiple of
// nnn are atomic.  The SQLITE_IOCAP_SAFE_APPEND value means
// that when data is appended to a file, the data is appended
// first then the size of the file is extended, never the other
// way around.  The SQLITE_IOCAP_SEQUENTIAL property means that
// information is written to disk in the same order as calls
// to xWrite().
//
// If xRead() returns SQLITE_IOERR_SHORT_READ it must also fill
// in the unread portions of the buffer with zeros.  A VFS that
// fails to zero-fill short reads might seem to work.  However,
// failure to zero-fill short reads will eventually lead to
// database corruption.
type sqlite3_io_methods = sqlite3_io_methods1 /* sqlite3.h:821:35 */

// CAPI3REF: OS Interface Object
//
// An instance of the sqlite3_vfs object defines the interface between
// the SQLite core and the underlying operating system.  The "vfs"
// in the name of the object stands for "virtual file system".  See
// the [VFS | VFS documentation] for further information.
//
// The VFS interface is sometimes extended by adding new methods onto
// the end.  Each time such an extension occurs, the iVersion field
// is incremented.  The iVersion value started out as 1 in
// SQLite [version 3.5.0] on [dateof:3.5.0], then increased to 2
// with SQLite [version 3.7.0] on [dateof:3.7.0], and then increased
// to 3 with SQLite [version 3.7.6] on [dateof:3.7.6].  Additional fields
// may be appended to the sqlite3_vfs object and the iVersion value
// may increase again in future versions of SQLite.
// Note that due to an oversight, the structure
// of the sqlite3_vfs object changed in the transition from
// SQLite [version 3.5.9] to [version 3.6.0] on [dateof:3.6.0]
// and yet the iVersion field was not increased.
//
// The szOsFile field is the size of the subclassed [sqlite3_file]
// structure used by this VFS.  mxPathname is the maximum length of
// a pathname in this VFS.
//
// Registered sqlite3_vfs objects are kept on a linked list formed by
// the pNext pointer.  The [sqlite3_vfs_register()]
// and [sqlite3_vfs_unregister()] interfaces manage this list
// in a thread-safe way.  The [sqlite3_vfs_find()] interface
// searches the list.  Neither the application code nor the VFS
// implementation should use the pNext pointer.
//
// The pNext field is the only field in the sqlite3_vfs
// structure that SQLite will ever modify.  SQLite will only access
// or modify this field while holding a particular static mutex.
// The application should never modify anything within the sqlite3_vfs
// object once the object has been registered.
//
// The zName field holds the name of the VFS module.  The name must
// be unique across all VFS modules.
//
// [[sqlite3_vfs.xOpen]]
// ^SQLite guarantees that the zFilename parameter to xOpen
// is either a NULL pointer or string obtained
// from xFullPathname() with an optional suffix added.
// ^If a suffix is added to the zFilename parameter, it will
// consist of a single "-" character followed by no more than
// 11 alphanumeric and/or "-" characters.
// ^SQLite further guarantees that
// the string will be valid and unchanged until xClose() is
// called. Because of the previous sentence,
// the [sqlite3_file] can safely store a pointer to the
// filename if it needs to remember the filename for some reason.
// If the zFilename parameter to xOpen is a NULL pointer then xOpen
// must invent its own temporary name for the file.  ^Whenever the
// xFilename parameter is NULL it will also be the case that the
// flags parameter will include [SQLITE_OPEN_DELETEONCLOSE].
//
// The flags argument to xOpen() includes all bits set in
// the flags argument to [sqlite3_open_v2()].  Or if [sqlite3_open()]
// or [sqlite3_open16()] is used, then flags includes at least
// [SQLITE_OPEN_READWRITE] | [SQLITE_OPEN_CREATE].
// If xOpen() opens a file read-only then it sets *pOutFlags to
// include [SQLITE_OPEN_READONLY].  Other bits in *pOutFlags may be set.
//
// ^(SQLite will also add one of the following flags to the xOpen()
// call, depending on the object being opened:
//
// <ul>
// <li>  [SQLITE_OPEN_MAIN_DB]
// <li>  [SQLITE_OPEN_MAIN_JOURNAL]
// <li>  [SQLITE_OPEN_TEMP_DB]
// <li>  [SQLITE_OPEN_TEMP_JOURNAL]
// <li>  [SQLITE_OPEN_TRANSIENT_DB]
// <li>  [SQLITE_OPEN_SUBJOURNAL]
// <li>  [SQLITE_OPEN_SUPER_JOURNAL]
// <li>  [SQLITE_OPEN_WAL]
// </ul>)^
//
// The file I/O implementation can use the object type flags to
// change the way it deals with files.  For example, an application
// that does not care about crash recovery or rollback might make
// the open of a journal file a no-op.  Writes to this journal would
// also be no-ops, and any attempt to read the journal would return
// SQLITE_IOERR.  Or the implementation might recognize that a database
// file will be doing page-aligned sector reads and writes in a random
// order and set up its I/O subsystem accordingly.
//
// SQLite might also add one of the following flags to the xOpen method:
//
// <ul>
// <li> [SQLITE_OPEN_DELETEONCLOSE]
// <li> [SQLITE_OPEN_EXCLUSIVE]
// </ul>
//
// The [SQLITE_OPEN_DELETEONCLOSE] flag means the file should be
// deleted when it is closed.  ^The [SQLITE_OPEN_DELETEONCLOSE]
// will be set for TEMP databases and their journals, transient
// databases, and subjournals.
//
// ^The [SQLITE_OPEN_EXCLUSIVE] flag is always used in conjunction
// with the [SQLITE_OPEN_CREATE] flag, which are both directly
// analogous to the O_EXCL and O_CREAT flags of the POSIX open()
// API.  The SQLITE_OPEN_EXCLUSIVE flag, when paired with the
// SQLITE_OPEN_CREATE, is used to indicate that file should always
// be created, and that it is an error if it already exists.
// It is <i>not</i> used to indicate the file should be opened
// for exclusive access.
//
// ^At least szOsFile bytes of memory are allocated by SQLite
// to hold the [sqlite3_file] structure passed as the third
// argument to xOpen.  The xOpen method does not have to
// allocate the structure; it should just fill it in.  Note that
// the xOpen method must set the sqlite3_file.pMethods to either
// a valid [sqlite3_io_methods] object or to NULL.  xOpen must do
// this even if the open fails.  SQLite expects that the sqlite3_file.pMethods
// element will be valid after xOpen returns regardless of the success
// or failure of the xOpen call.
//
// [[sqlite3_vfs.xAccess]]
// ^The flags argument to xAccess() may be [SQLITE_ACCESS_EXISTS]
// to test for the existence of a file, or [SQLITE_ACCESS_READWRITE] to
// test whether a file is readable and writable, or [SQLITE_ACCESS_READ]
// to test whether a file is at least readable.  The SQLITE_ACCESS_READ
// flag is never actually used and is not implemented in the built-in
// VFSes of SQLite.  The file is named by the second argument and can be a
// directory. The xAccess method returns [SQLITE_OK] on success or some
// non-zero error code if there is an I/O error or if the name of
// the file given in the second argument is illegal.  If SQLITE_OK
// is returned, then non-zero or zero is written into *pResOut to indicate
// whether or not the file is accessible.
//
// ^SQLite will always allocate at least mxPathname+1 bytes for the
// output buffer xFullPathname.  The exact size of the output buffer
// is also passed as a parameter to both  methods. If the output buffer
// is not large enough, [SQLITE_CANTOPEN] should be returned. Since this is
// handled as a fatal error by SQLite, vfs implementations should endeavor
// to prevent this by setting mxPathname to a sufficiently large value.
//
// The xRandomness(), xSleep(), xCurrentTime(), and xCurrentTimeInt64()
// interfaces are not strictly a part of the filesystem, but they are
// included in the VFS structure for completeness.
// The xRandomness() function attempts to return nBytes bytes
// of good-quality randomness into zOut.  The return value is
// the actual number of bytes of randomness obtained.
// The xSleep() method causes the calling thread to sleep for at
// least the number of microseconds given.  ^The xCurrentTime()
// method returns a Julian Day Number for the current date and time as
// a floating point value.
// ^The xCurrentTimeInt64() method returns, as an integer, the Julian
// Day Number multiplied by 86400000 (the number of milliseconds in
// a 24-hour day).
// ^SQLite will use the xCurrentTimeInt64() method to get the current
// date and time if that method is available (if iVersion is 2 or
// greater and the function pointer is not NULL) and will fall back
// to xCurrentTime() if xCurrentTimeInt64() is unavailable.
//
// ^The xSetSystemCall(), xGetSystemCall(), and xNestSystemCall() interfaces
// are not used by the SQLite core.  These optional interfaces are provided
// by some VFSes to facilitate testing of the VFS code. By overriding
// system calls with functions under its control, a test program can
// simulate faults and error conditions that would otherwise be difficult
// or impossible to induce.  The set of system calls that can be overridden
// varies from one VFS to another, and from one version of the same VFS to the
// next.  Applications that use these interfaces must be prepared for any
// or all of these interfaces to be NULL or for their behavior to change
// from one release to the next.  Applications must not attempt to access
// any of these methods if the iVersion of the VFS is less than 3.
type sqlite3_vfs1 = struct {
	iVersion          int32
	szOsFile          int32
	mxPathname        int32
	_                 [4]byte
	pNext             uintptr
	zName             uintptr
	pAppData          uintptr
	xOpen             uintptr
	xDelete           uintptr
	xAccess           uintptr
	xFullPathname     uintptr
	xDlOpen           uintptr
	xDlError          uintptr
	xDlSym            uintptr
	xDlClose          uintptr
	xRandomness       uintptr
	xSleep            uintptr
	xCurrentTime      uintptr
	xGetLastError     uintptr
	xCurrentTimeInt64 uintptr
	xSetSystemCall    uintptr
	xGetSystemCall    uintptr
	xNextSystemCall   uintptr
} /* sqlite3.h:1425:9 */

// CAPI3REF: OS Interface Object
//
// An instance of the sqlite3_vfs object defines the interface between
// the SQLite core and the underlying operating system.  The "vfs"
// in the name of the object stands for "virtual file system".  See
// the [VFS | VFS documentation] for further information.
//
// The VFS interface is sometimes extended by adding new methods onto
// the end.  Each time such an extension occurs, the iVersion field
// is incremented.  The iVersion value started out as 1 in
// SQLite [version 3.5.0] on [dateof:3.5.0], then increased to 2
// with SQLite [version 3.7.0] on [dateof:3.7.0], and then increased
// to 3 with SQLite [version 3.7.6] on [dateof:3.7.6].  Additional fields
// may be appended to the sqlite3_vfs object and the iVersion value
// may increase again in future versions of SQLite.
// Note that due to an oversight, the structure
// of the sqlite3_vfs object changed in the transition from
// SQLite [version 3.5.9] to [version 3.6.0] on [dateof:3.6.0]
// and yet the iVersion field was not increased.
//
// The szOsFile field is the size of the subclassed [sqlite3_file]
// structure used by this VFS.  mxPathname is the maximum length of
// a pathname in this VFS.
//
// Registered sqlite3_vfs objects are kept on a linked list formed by
// the pNext pointer.  The [sqlite3_vfs_register()]
// and [sqlite3_vfs_unregister()] interfaces manage this list
// in a thread-safe way.  The [sqlite3_vfs_find()] interface
// searches the list.  Neither the application code nor the VFS
// implementation should use the pNext pointer.
//
// The pNext field is the only field in the sqlite3_vfs
// structure that SQLite will ever modify.  SQLite will only access
// or modify this field while holding a particular static mutex.
// The application should never modify anything within the sqlite3_vfs
// object once the object has been registered.
//
// The zName field holds the name of the VFS module.  The name must
// be unique across all VFS modules.
//
// [[sqlite3_vfs.xOpen]]
// ^SQLite guarantees that the zFilename parameter to xOpen
// is either a NULL pointer or string obtained
// from xFullPathname() with an optional suffix added.
// ^If a suffix is added to the zFilename parameter, it will
// consist of a single "-" character followed by no more than
// 11 alphanumeric and/or "-" characters.
// ^SQLite further guarantees that
// the string will be valid and unchanged until xClose() is
// called. Because of the previous sentence,
// the [sqlite3_file] can safely store a pointer to the
// filename if it needs to remember the filename for some reason.
// If the zFilename parameter to xOpen is a NULL pointer then xOpen
// must invent its own temporary name for the file.  ^Whenever the
// xFilename parameter is NULL it will also be the case that the
// flags parameter will include [SQLITE_OPEN_DELETEONCLOSE].
//
// The flags argument to xOpen() includes all bits set in
// the flags argument to [sqlite3_open_v2()].  Or if [sqlite3_open()]
// or [sqlite3_open16()] is used, then flags includes at least
// [SQLITE_OPEN_READWRITE] | [SQLITE_OPEN_CREATE].
// If xOpen() opens a file read-only then it sets *pOutFlags to
// include [SQLITE_OPEN_READONLY].  Other bits in *pOutFlags may be set.
//
// ^(SQLite will also add one of the following flags to the xOpen()
// call, depending on the object being opened:
//
// <ul>
// <li>  [SQLITE_OPEN_MAIN_DB]
// <li>  [SQLITE_OPEN_MAIN_JOURNAL]
// <li>  [SQLITE_OPEN_TEMP_DB]
// <li>  [SQLITE_OPEN_TEMP_JOURNAL]
// <li>  [SQLITE_OPEN_TRANSIENT_DB]
// <li>  [SQLITE_OPEN_SUBJOURNAL]
// <li>  [SQLITE_OPEN_SUPER_JOURNAL]
// <li>  [SQLITE_OPEN_WAL]
// </ul>)^
//
// The file I/O implementation can use the object type flags to
// change the way it deals with files.  For example, an application
// that does not care about crash recovery or rollback might make
// the open of a journal file a no-op.  Writes to this journal would
// also be no-ops, and any attempt to read the journal would return
// SQLITE_IOERR.  Or the implementation might recognize that a database
// file will be doing page-aligned sector reads and writes in a random
// order and set up its I/O subsystem accordingly.
//
// SQLite might also add one of the following flags to the xOpen method:
//
// <ul>
// <li> [SQLITE_OPEN_DELETEONCLOSE]
// <li> [SQLITE_OPEN_EXCLUSIVE]
// </ul>
//
// The [SQLITE_OPEN_DELETEONCLOSE] flag means the file should be
// deleted when it is closed.  ^The [SQLITE_OPEN_DELETEONCLOSE]
// will be set for TEMP databases and their journals, transient
// databases, and subjournals.
//
// ^The [SQLITE_OPEN_EXCLUSIVE] flag is always used in conjunction
// with the [SQLITE_OPEN_CREATE] flag, which are both directly
// analogous to the O_EXCL and O_CREAT flags of the POSIX open()
// API.  The SQLITE_OPEN_EXCLUSIVE flag, when paired with the
// SQLITE_OPEN_CREATE, is used to indicate that file should always
// be created, and that it is an error if it already exists.
// It is <i>not</i> used to indicate the file should be opened
// for exclusive access.
//
// ^At least szOsFile bytes of memory are allocated by SQLite
// to hold the [sqlite3_file] structure passed as the third
// argument to xOpen.  The xOpen method does not have to
// allocate the structure; it should just fill it in.  Note that
// the xOpen method must set the sqlite3_file.pMethods to either
// a valid [sqlite3_io_methods] object or to NULL.  xOpen must do
// this even if the open fails.  SQLite expects that the sqlite3_file.pMethods
// element will be valid after xOpen returns regardless of the success
// or failure of the xOpen call.
//
// [[sqlite3_vfs.xAccess]]
// ^The flags argument to xAccess() may be [SQLITE_ACCESS_EXISTS]
// to test for the existence of a file, or [SQLITE_ACCESS_READWRITE] to
// test whether a file is readable and writable, or [SQLITE_ACCESS_READ]
// to test whether a file is at least readable.  The SQLITE_ACCESS_READ
// flag is never actually used and is not implemented in the built-in
// VFSes of SQLite.  The file is named by the second argument and can be a
// directory. The xAccess method returns [SQLITE_OK] on success or some
// non-zero error code if there is an I/O error or if the name of
// the file given in the second argument is illegal.  If SQLITE_OK
// is returned, then non-zero or zero is written into *pResOut to indicate
// whether or not the file is accessible.
//
// ^SQLite will always allocate at least mxPathname+1 bytes for the
// output buffer xFullPathname.  The exact size of the output buffer
// is also passed as a parameter to both  methods. If the output buffer
// is not large enough, [SQLITE_CANTOPEN] should be returned. Since this is
// handled as a fatal error by SQLite, vfs implementations should endeavor
// to prevent this by setting mxPathname to a sufficiently large value.
//
// The xRandomness(), xSleep(), xCurrentTime(), and xCurrentTimeInt64()
// interfaces are not strictly a part of the filesystem, but they are
// included in the VFS structure for completeness.
// The xRandomness() function attempts to return nBytes bytes
// of good-quality randomness into zOut.  The return value is
// the actual number of bytes of randomness obtained.
// The xSleep() method causes the calling thread to sleep for at
// least the number of microseconds given.  ^The xCurrentTime()
// method returns a Julian Day Number for the current date and time as
// a floating point value.
// ^The xCurrentTimeInt64() method returns, as an integer, the Julian
// Day Number multiplied by 86400000 (the number of milliseconds in
// a 24-hour day).
// ^SQLite will use the xCurrentTimeInt64() method to get the current
// date and time if that method is available (if iVersion is 2 or
// greater and the function pointer is not NULL) and will fall back
// to xCurrentTime() if xCurrentTimeInt64() is unavailable.
//
// ^The xSetSystemCall(), xGetSystemCall(), and xNestSystemCall() interfaces
// are not used by the SQLite core.  These optional interfaces are provided
// by some VFSes to facilitate testing of the VFS code. By overriding
// system calls with functions under its control, a test program can
// simulate faults and error conditions that would otherwise be difficult
// or impossible to induce.  The set of system calls that can be overridden
// varies from one VFS to another, and from one version of the same VFS to the
// next.  Applications that use these interfaces must be prepared for any
// or all of these interfaces to be NULL or for their behavior to change
// from one release to the next.  Applications must not attempt to access
// any of these methods if the iVersion of the VFS is less than 3.
type sqlite3_vfs = sqlite3_vfs1    /* sqlite3.h:1425:28 */
type sqlite3_syscall_ptr = uintptr /* sqlite3.h:1426:14 */

// CAPI3REF: Memory Allocation Routines
//
// An instance of this object defines the interface between SQLite
// and low-level memory allocation routines.
//
// This object is used in only one place in the SQLite interface.
// A pointer to an instance of this object is the argument to
// [sqlite3_config()] when the configuration option is
// [SQLITE_CONFIG_MALLOC] or [SQLITE_CONFIG_GETMALLOC].
// By creating an instance of this object
// and passing it to [sqlite3_config]([SQLITE_CONFIG_MALLOC])
// during configuration, an application can specify an alternative
// memory allocation subsystem for SQLite to use for all of its
// dynamic memory needs.
//
// Note that SQLite comes with several [built-in memory allocators]
// that are perfectly adequate for the overwhelming majority of applications
// and that this object is only useful to a tiny minority of applications
// with specialized memory allocation requirements.  This object is
// also used during testing of SQLite in order to specify an alternative
// memory allocator that simulates memory out-of-memory conditions in
// order to verify that SQLite recovers gracefully from such
// conditions.
//
// The xMalloc, xRealloc, and xFree methods must work like the
// malloc(), realloc() and free() functions from the standard C library.
// ^SQLite guarantees that the second argument to
// xRealloc is always a value returned by a prior call to xRoundup.
//
// xSize should return the allocated size of a memory allocation
// previously obtained from xMalloc or xRealloc.  The allocated size
// is always at least as big as the requested size but may be larger.
//
// The xRoundup method returns what would be the allocated size of
// a memory allocation given a particular requested size.  Most memory
// allocators round up memory allocations at least to the next multiple
// of 8.  Some allocators round up to a larger multiple or to a power of 2.
// Every memory allocation request coming in through [sqlite3_malloc()]
// or [sqlite3_realloc()] first calls xRoundup.  If xRoundup returns 0,
// that causes the corresponding memory allocation to fail.
//
// The xInit method initializes the memory allocator.  For example,
// it might allocate any required mutexes or initialize internal data
// structures.  The xShutdown method is invoked (indirectly) by
// [sqlite3_shutdown()] and should deallocate any resources acquired
// by xInit.  The pAppData pointer is used as the only parameter to
// xInit and xShutdown.
//
// SQLite holds the [SQLITE_MUTEX_STATIC_MAIN] mutex when it invokes
// the xInit method, so the xInit method need not be threadsafe.  The
// xShutdown method is only called from [sqlite3_shutdown()] so it does
// not need to be threadsafe either.  For all other methods, SQLite
// holds the [SQLITE_MUTEX_STATIC_MEM] mutex as long as the
// [SQLITE_CONFIG_MEMSTATUS] configuration option is turned on (which
// it is by default) and so the methods are automatically serialized.
// However, if [SQLITE_CONFIG_MEMSTATUS] is disabled, then the other
// methods must be threadsafe or else make their own arrangements for
// serialization.
//
// SQLite will never invoke xInit() more than once without an intervening
// call to xShutdown().
type sqlite3_mem_methods1 = struct {
	xMalloc   uintptr
	xFree     uintptr
	xRealloc  uintptr
	xSize     uintptr
	xRoundup  uintptr
	xInit     uintptr
	xShutdown uintptr
	pAppData  uintptr
} /* sqlite3.h:1723:9 */

// CAPI3REF: Memory Allocation Routines
//
// An instance of this object defines the interface between SQLite
// and low-level memory allocation routines.
//
// This object is used in only one place in the SQLite interface.
// A pointer to an instance of this object is the argument to
// [sqlite3_config()] when the configuration option is
// [SQLITE_CONFIG_MALLOC] or [SQLITE_CONFIG_GETMALLOC].
// By creating an instance of this object
// and passing it to [sqlite3_config]([SQLITE_CONFIG_MALLOC])
// during configuration, an application can specify an alternative
// memory allocation subsystem for SQLite to use for all of its
// dynamic memory needs.
//
// Note that SQLite comes with several [built-in memory allocators]
// that are perfectly adequate for the overwhelming majority of applications
// and that this object is only useful to a tiny minority of applications
// with specialized memory allocation requirements.  This object is
// also used during testing of SQLite in order to specify an alternative
// memory allocator that simulates memory out-of-memory conditions in
// order to verify that SQLite recovers gracefully from such
// conditions.
//
// The xMalloc, xRealloc, and xFree methods must work like the
// malloc(), realloc() and free() functions from the standard C library.
// ^SQLite guarantees that the second argument to
// xRealloc is always a value returned by a prior call to xRoundup.
//
// xSize should return the allocated size of a memory allocation
// previously obtained from xMalloc or xRealloc.  The allocated size
// is always at least as big as the requested size but may be larger.
//
// The xRoundup method returns what would be the allocated size of
// a memory allocation given a particular requested size.  Most memory
// allocators round up memory allocations at least to the next multiple
// of 8.  Some allocators round up to a larger multiple or to a power of 2.
// Every memory allocation request coming in through [sqlite3_malloc()]
// or [sqlite3_realloc()] first calls xRoundup.  If xRoundup returns 0,
// that causes the corresponding memory allocation to fail.
//
// The xInit method initializes the memory allocator.  For example,
// it might allocate any required mutexes or initialize internal data
// structures.  The xShutdown method is invoked (indirectly) by
// [sqlite3_shutdown()] and should deallocate any resources acquired
// by xInit.  The pAppData pointer is used as the only parameter to
// xInit and xShutdown.
//
// SQLite holds the [SQLITE_MUTEX_STATIC_MAIN] mutex when it invokes
// the xInit method, so the xInit method need not be threadsafe.  The
// xShutdown method is only called from [sqlite3_shutdown()] so it does
// not need to be threadsafe either.  For all other methods, SQLite
// holds the [SQLITE_MUTEX_STATIC_MEM] mutex as long as the
// [SQLITE_CONFIG_MEMSTATUS] configuration option is turned on (which
// it is by default) and so the methods are automatically serialized.
// However, if [SQLITE_CONFIG_MEMSTATUS] is disabled, then the other
// methods must be threadsafe or else make their own arrangements for
// serialization.
//
// SQLite will never invoke xInit() more than once without an intervening
// call to xShutdown().
type sqlite3_mem_methods = sqlite3_mem_methods1 /* sqlite3.h:1723:36 */

// CAPI3REF: Constants Defining Special Destructor Behavior
//
// These are special values for the destructor that is passed in as the
// final argument to routines like [sqlite3_result_blob()].  ^If the destructor
// argument is SQLITE_STATIC, it means that the content pointer is constant
// and will never change.  It does not need to be destroyed.  ^The
// SQLITE_TRANSIENT value means that the content will likely change in
// the near future and that SQLite should make its own private copy of
// the content before returning.
//
// The typedef is necessary to work around problems in certain
// C++ compilers.
type sqlite3_destructor_type = uintptr /* sqlite3.h:5752:14 */

// The interface to the virtual-table mechanism is currently considered
// to be experimental.  The interface might change in incompatible ways.
// If this is a problem for you, do not use the interface at this time.
//
// When the virtual-table mechanism stabilizes, we will declare the
// interface fixed, support it indefinitely, and remove this comment.

// Structures used by the virtual table interface
type sqlite3_vtab1 = struct {
	pModule uintptr
	nRef    int32
	_       [4]byte
	zErrMsg uintptr
} /* sqlite3.h:6937:9 */

// The interface to the virtual-table mechanism is currently considered
// to be experimental.  The interface might change in incompatible ways.
// If this is a problem for you, do not use the interface at this time.
//
// When the virtual-table mechanism stabilizes, we will declare the
// interface fixed, support it indefinitely, and remove this comment.

// Structures used by the virtual table interface
type sqlite3_vtab = sqlite3_vtab1 /* sqlite3.h:6937:29 */
type sqlite3_index_info1 = struct {
	nConstraint      int32
	_                [4]byte
	aConstraint      uintptr
	nOrderBy         int32
	_                [4]byte
	aOrderBy         uintptr
	aConstraintUsage uintptr
	idxNum           int32
	_                [4]byte
	idxStr           uintptr
	needToFreeIdxStr int32
	orderByConsumed  int32
	estimatedCost    float64
	estimatedRows    sqlite3_int64
	idxFlags         int32
	_                [4]byte
	colUsed          sqlite3_uint64
} /* sqlite3.h:6938:9 */

type sqlite3_index_info = sqlite3_index_info1       /* sqlite3.h:6938:35 */
type sqlite3_vtab_cursor1 = struct{ pVtab uintptr } /* sqlite3.h:6939:9 */

type sqlite3_vtab_cursor = sqlite3_vtab_cursor1 /* sqlite3.h:6939:36 */
type sqlite3_module1 = struct {
	iVersion      int32
	_             [4]byte
	xCreate       uintptr
	xConnect      uintptr
	xBestIndex    uintptr
	xDisconnect   uintptr
	xDestroy      uintptr
	xOpen         uintptr
	xClose        uintptr
	xFilter       uintptr
	xNext         uintptr
	xEof          uintptr
	xColumn       uintptr
	xRowid        uintptr
	xUpdate       uintptr
	xBegin        uintptr
	xSync         uintptr
	xCommit       uintptr
	xRollback     uintptr
	xFindFunction uintptr
	xRename       uintptr
	xSavepoint    uintptr
	xRelease      uintptr
	xRollbackTo   uintptr
	xShadowName   uintptr
} /* sqlite3.h:6937:9 */

type sqlite3_module = sqlite3_module1 /* sqlite3.h:6940:31 */

// CAPI3REF: Virtual Table Indexing Information
// KEYWORDS: sqlite3_index_info
//
// The sqlite3_index_info structure and its substructures is used as part
// of the [virtual table] interface to
// pass information into and receive the reply from the [xBestIndex]
// method of a [virtual table module].  The fields under **Inputs** are the
// inputs to xBestIndex and are read-only.  xBestIndex inserts its
// results into the **Outputs** fields.
//
// ^(The aConstraint[] array records WHERE clause constraints of the form:
//
// <blockquote>column OP expr</blockquote>
//
// where OP is =, &lt;, &lt;=, &gt;, or &gt;=.)^  ^(The particular operator is
// stored in aConstraint[].op using one of the
// [SQLITE_INDEX_CONSTRAINT_EQ | SQLITE_INDEX_CONSTRAINT_ values].)^
// ^(The index of the column is stored in
// aConstraint[].iColumn.)^  ^(aConstraint[].usable is TRUE if the
// expr on the right-hand side can be evaluated (and thus the constraint
// is usable) and false if it cannot.)^
//
// ^The optimizer automatically inverts terms of the form "expr OP column"
// and makes other simplifications to the WHERE clause in an attempt to
// get as many WHERE clause terms into the form shown above as possible.
// ^The aConstraint[] array only reports WHERE clause terms that are
// relevant to the particular virtual table being queried.
//
// ^Information about the ORDER BY clause is stored in aOrderBy[].
// ^Each term of aOrderBy records a column of the ORDER BY clause.
//
// The colUsed field indicates which columns of the virtual table may be
// required by the current scan. Virtual table columns are numbered from
// zero in the order in which they appear within the CREATE TABLE statement
// passed to sqlite3_declare_vtab(). For the first 63 columns (columns 0-62),
// the corresponding bit is set within the colUsed mask if the column may be
// required by SQLite. If the table has at least 64 columns and any column
// to the right of the first 63 is required, then bit 63 of colUsed is also
// set. In other words, column iCol may be required if the expression
// (colUsed & ((sqlite3_uint64)1 << (iCol>=63 ? 63 : iCol))) evaluates to
// non-zero.
//
// The [xBestIndex] method must fill aConstraintUsage[] with information
// about what parameters to pass to xFilter.  ^If argvIndex>0 then
// the right-hand side of the corresponding aConstraint[] is evaluated
// and becomes the argvIndex-th entry in argv.  ^(If aConstraintUsage[].omit
// is true, then the constraint is assumed to be fully handled by the
// virtual table and might not be checked again by the byte code.)^ ^(The
// aConstraintUsage[].omit flag is an optimization hint. When the omit flag
// is left in its default setting of false, the constraint will always be
// checked separately in byte code.  If the omit flag is change to true, then
// the constraint may or may not be checked in byte code.  In other words,
// when the omit flag is true there is no guarantee that the constraint will
// not be checked again using byte code.)^
//
// ^The idxNum and idxPtr values are recorded and passed into the
// [xFilter] method.
// ^[sqlite3_free()] is used to free idxPtr if and only if
// needToFreeIdxPtr is true.
//
// ^The orderByConsumed means that output from [xFilter]/[xNext] will occur in
// the correct order to satisfy the ORDER BY clause so that no separate
// sorting step is required.
//
// ^The estimatedCost value is an estimate of the cost of a particular
// strategy. A cost of N indicates that the cost of the strategy is similar
// to a linear scan of an SQLite table with N rows. A cost of log(N)
// indicates that the expense of the operation is similar to that of a
// binary search on a unique indexed field of an SQLite table with N rows.
//
// ^The estimatedRows value is an estimate of the number of rows that
// will be returned by the strategy.
//
// The xBestIndex method may optionally populate the idxFlags field with a
// mask of SQLITE_INDEX_SCAN_* flags. Currently there is only one such flag -
// SQLITE_INDEX_SCAN_UNIQUE. If the xBestIndex method sets this flag, SQLite
// assumes that the strategy may visit at most one row.
//
// Additionally, if xBestIndex sets the SQLITE_INDEX_SCAN_UNIQUE flag, then
// SQLite also assumes that if a call to the xUpdate() method is made as
// part of the same statement to delete or update a virtual table row and the
// implementation returns SQLITE_CONSTRAINT, then there is no need to rollback
// any database changes. In other words, if the xUpdate() returns
// SQLITE_CONSTRAINT, the database contents must be exactly as they were
// before xUpdate was called. By contrast, if SQLITE_INDEX_SCAN_UNIQUE is not
// set and xUpdate returns SQLITE_CONSTRAINT, any database changes made by
// the xUpdate method are automatically rolled back by SQLite.
//
// IMPORTANT: The estimatedRows field was added to the sqlite3_index_info
// structure for SQLite [version 3.8.2] ([dateof:3.8.2]).
// If a virtual table extension is
// used with an SQLite version earlier than 3.8.2, the results of attempting
// to read or write the estimatedRows field are undefined (but are likely
// to include crashing the application). The estimatedRows field should
// therefore only be used if [sqlite3_libversion_number()] returns a
// value greater than or equal to 3008002. Similarly, the idxFlags field
// was added for [version 3.9.0] ([dateof:3.9.0]).
// It may therefore only be used if
// sqlite3_libversion_number() returns a value greater than or equal to
// 3009000.
type sqlite3_index_constraint = struct {
	iColumn     int32
	op          uint8
	usable      uint8
	_           [2]byte
	iTermOffset int32
} /* sqlite3.h:6938:9 */

// CAPI3REF: Virtual Table Indexing Information
// KEYWORDS: sqlite3_index_info
//
// The sqlite3_index_info structure and its substructures is used as part
// of the [virtual table] interface to
// pass information into and receive the reply from the [xBestIndex]
// method of a [virtual table module].  The fields under **Inputs** are the
// inputs to xBestIndex and are read-only.  xBestIndex inserts its
// results into the **Outputs** fields.
//
// ^(The aConstraint[] array records WHERE clause constraints of the form:
//
// <blockquote>column OP expr</blockquote>
//
// where OP is =, &lt;, &lt;=, &gt;, or &gt;=.)^  ^(The particular operator is
// stored in aConstraint[].op using one of the
// [SQLITE_INDEX_CONSTRAINT_EQ | SQLITE_INDEX_CONSTRAINT_ values].)^
// ^(The index of the column is stored in
// aConstraint[].iColumn.)^  ^(aConstraint[].usable is TRUE if the
// expr on the right-hand side can be evaluated (and thus the constraint
// is usable) and false if it cannot.)^
//
// ^The optimizer automatically inverts terms of the form "expr OP column"
// and makes other simplifications to the WHERE clause in an attempt to
// get as many WHERE clause terms into the form shown above as possible.
// ^The aConstraint[] array only reports WHERE clause terms that are
// relevant to the particular virtual table being queried.
//
// ^Information about the ORDER BY clause is stored in aOrderBy[].
// ^Each term of aOrderBy records a column of the ORDER BY clause.
//
// The colUsed field indicates which columns of the virtual table may be
// required by the current scan. Virtual table columns are numbered from
// zero in the order in which they appear within the CREATE TABLE statement
// passed to sqlite3_declare_vtab(). For the first 63 columns (columns 0-62),
// the corresponding bit is set within the colUsed mask if the column may be
// required by SQLite. If the table has at least 64 columns and any column
// to the right of the first 63 is required, then bit 63 of colUsed is also
// set. In other words, column iCol may be required if the expression
// (colUsed & ((sqlite3_uint64)1 << (iCol>=63 ? 63 : iCol))) evaluates to
// non-zero.
//
// The [xBestIndex] method must fill aConstraintUsage[] with information
// about what parameters to pass to xFilter.  ^If argvIndex>0 then
// the right-hand side of the corresponding aConstraint[] is evaluated
// and becomes the argvIndex-th entry in argv.  ^(If aConstraintUsage[].omit
// is true, then the constraint is assumed to be fully handled by the
// virtual table and might not be checked again by the byte code.)^ ^(The
// aConstraintUsage[].omit flag is an optimization hint. When the omit flag
// is left in its default setting of false, the constraint will always be
// checked separately in byte code.  If the omit flag is change to true, then
// the constraint may or may not be checked in byte code.  In other words,
// when the omit flag is true there is no guarantee that the constraint will
// not be checked again using byte code.)^
//
// ^The idxNum and idxPtr values are recorded and passed into the
// [xFilter] method.
// ^[sqlite3_free()] is used to free idxPtr if and only if
// needToFreeIdxPtr is true.
//
// ^The orderByConsumed means that output from [xFilter]/[xNext] will occur in
// the correct order to satisfy the ORDER BY clause so that no separate
// sorting step is required.
//
// ^The estimatedCost value is an estimate of the cost of a particular
// strategy. A cost of N indicates that the cost of the strategy is similar
// to a linear scan of an SQLite table with N rows. A cost of log(N)
// indicates that the expense of the operation is similar to that of a
// binary search on a unique indexed field of an SQLite table with N rows.
//
// ^The estimatedRows value is an estimate of the number of rows that
// will be returned by the strategy.
//
// The xBestIndex method may optionally populate the idxFlags field with a
// mask of SQLITE_INDEX_SCAN_* flags. Currently there is only one such flag -
// SQLITE_INDEX_SCAN_UNIQUE. If the xBestIndex method sets this flag, SQLite
// assumes that the strategy may visit at most one row.
//
// Additionally, if xBestIndex sets the SQLITE_INDEX_SCAN_UNIQUE flag, then
// SQLite also assumes that if a call to the xUpdate() method is made as
// part of the same statement to delete or update a virtual table row and the
// implementation returns SQLITE_CONSTRAINT, then there is no need to rollback
// any database changes. In other words, if the xUpdate() returns
// SQLITE_CONSTRAINT, the database contents must be exactly as they were
// before xUpdate was called. By contrast, if SQLITE_INDEX_SCAN_UNIQUE is not
// set and xUpdate returns SQLITE_CONSTRAINT, any database changes made by
// the xUpdate method are automatically rolled back by SQLite.
//
// IMPORTANT: The estimatedRows field was added to the sqlite3_index_info
// structure for SQLite [version 3.8.2] ([dateof:3.8.2]).
// If a virtual table extension is
// used with an SQLite version earlier than 3.8.2, the results of attempting
// to read or write the estimatedRows field are undefined (but are likely
// to include crashing the application). The estimatedRows field should
// therefore only be used if [sqlite3_libversion_number()] returns a
// value greater than or equal to 3008002. Similarly, the idxFlags field
// was added for [version 3.9.0] ([dateof:3.9.0]).
// It may therefore only be used if
// sqlite3_libversion_number() returns a value greater than or equal to
// 3009000.
type sqlite3_index_orderby = struct {
	iColumn int32
	desc    uint8
	_       [3]byte
} /* sqlite3.h:6938:9 */

// CAPI3REF: Virtual Table Indexing Information
// KEYWORDS: sqlite3_index_info
//
// The sqlite3_index_info structure and its substructures is used as part
// of the [virtual table] interface to
// pass information into and receive the reply from the [xBestIndex]
// method of a [virtual table module].  The fields under **Inputs** are the
// inputs to xBestIndex and are read-only.  xBestIndex inserts its
// results into the **Outputs** fields.
//
// ^(The aConstraint[] array records WHERE clause constraints of the form:
//
// <blockquote>column OP expr</blockquote>
//
// where OP is =, &lt;, &lt;=, &gt;, or &gt;=.)^  ^(The particular operator is
// stored in aConstraint[].op using one of the
// [SQLITE_INDEX_CONSTRAINT_EQ | SQLITE_INDEX_CONSTRAINT_ values].)^
// ^(The index of the column is stored in
// aConstraint[].iColumn.)^  ^(aConstraint[].usable is TRUE if the
// expr on the right-hand side can be evaluated (and thus the constraint
// is usable) and false if it cannot.)^
//
// ^The optimizer automatically inverts terms of the form "expr OP column"
// and makes other simplifications to the WHERE clause in an attempt to
// get as many WHERE clause terms into the form shown above as possible.
// ^The aConstraint[] array only reports WHERE clause terms that are
// relevant to the particular virtual table being queried.
//
// ^Information about the ORDER BY clause is stored in aOrderBy[].
// ^Each term of aOrderBy records a column of the ORDER BY clause.
//
// The colUsed field indicates which columns of the virtual table may be
// required by the current scan. Virtual table columns are numbered from
// zero in the order in which they appear within the CREATE TABLE statement
// passed to sqlite3_declare_vtab(). For the first 63 columns (columns 0-62),
// the corresponding bit is set within the colUsed mask if the column may be
// required by SQLite. If the table has at least 64 columns and any column
// to the right of the first 63 is required, then bit 63 of colUsed is also
// set. In other words, column iCol may be required if the expression
// (colUsed & ((sqlite3_uint64)1 << (iCol>=63 ? 63 : iCol))) evaluates to
// non-zero.
//
// The [xBestIndex] method must fill aConstraintUsage[] with information
// about what parameters to pass to xFilter.  ^If argvIndex>0 then
// the right-hand side of the corresponding aConstraint[] is evaluated
// and becomes the argvIndex-th entry in argv.  ^(If aConstraintUsage[].omit
// is true, then the constraint is assumed to be fully handled by the
// virtual table and might not be checked again by the byte code.)^ ^(The
// aConstraintUsage[].omit flag is an optimization hint. When the omit flag
// is left in its default setting of false, the constraint will always be
// checked separately in byte code.  If the omit flag is change to true, then
// the constraint may or may not be checked in byte code.  In other words,
// when the omit flag is true there is no guarantee that the constraint will
// not be checked again using byte code.)^
//
// ^The idxNum and idxPtr values are recorded and passed into the
// [xFilter] method.
// ^[sqlite3_free()] is used to free idxPtr if and only if
// needToFreeIdxPtr is true.
//
// ^The orderByConsumed means that output from [xFilter]/[xNext] will occur in
// the correct order to satisfy the ORDER BY clause so that no separate
// sorting step is required.
//
// ^The estimatedCost value is an estimate of the cost of a particular
// strategy. A cost of N indicates that the cost of the strategy is similar
// to a linear scan of an SQLite table with N rows. A cost of log(N)
// indicates that the expense of the operation is similar to that of a
// binary search on a unique indexed field of an SQLite table with N rows.
//
// ^The estimatedRows value is an estimate of the number of rows that
// will be returned by the strategy.
//
// The xBestIndex method may optionally populate the idxFlags field with a
// mask of SQLITE_INDEX_SCAN_* flags. Currently there is only one such flag -
// SQLITE_INDEX_SCAN_UNIQUE. If the xBestIndex method sets this flag, SQLite
// assumes that the strategy may visit at most one row.
//
// Additionally, if xBestIndex sets the SQLITE_INDEX_SCAN_UNIQUE flag, then
// SQLite also assumes that if a call to the xUpdate() method is made as
// part of the same statement to delete or update a virtual table row and the
// implementation returns SQLITE_CONSTRAINT, then there is no need to rollback
// any database changes. In other words, if the xUpdate() returns
// SQLITE_CONSTRAINT, the database contents must be exactly as they were
// before xUpdate was called. By contrast, if SQLITE_INDEX_SCAN_UNIQUE is not
// set and xUpdate returns SQLITE_CONSTRAINT, any database changes made by
// the xUpdate method are automatically rolled back by SQLite.
//
// IMPORTANT: The estimatedRows field was added to the sqlite3_index_info
// structure for SQLite [version 3.8.2] ([dateof:3.8.2]).
// If a virtual table extension is
// used with an SQLite version earlier than 3.8.2, the results of attempting
// to read or write the estimatedRows field are undefined (but are likely
// to include crashing the application). The estimatedRows field should
// therefore only be used if [sqlite3_libversion_number()] returns a
// value greater than or equal to 3008002. Similarly, the idxFlags field
// was added for [version 3.9.0] ([dateof:3.9.0]).
// It may therefore only be used if
// sqlite3_libversion_number() returns a value greater than or equal to
// 3009000.
type sqlite3_index_constraint_usage = struct {
	argvIndex int32
	omit      uint8
	_         [3]byte
} /* sqlite3.h:6938:9 */

// CAPI3REF: Mutex Methods Object
//
// An instance of this structure defines the low-level routines
// used to allocate and use mutexes.
//
// Usually, the default mutex implementations provided by SQLite are
// sufficient, however the application has the option of substituting a custom
// implementation for specialized deployments or systems for which SQLite
// does not provide a suitable implementation. In this case, the application
// creates and populates an instance of this structure to pass
// to sqlite3_config() along with the [SQLITE_CONFIG_MUTEX] option.
// Additionally, an instance of this structure can be used as an
// output variable when querying the system for the current mutex
// implementation, using the [SQLITE_CONFIG_GETMUTEX] option.
//
// ^The xMutexInit method defined by this structure is invoked as
// part of system initialization by the sqlite3_initialize() function.
// ^The xMutexInit routine is called by SQLite exactly once for each
// effective call to [sqlite3_initialize()].
//
// ^The xMutexEnd method defined by this structure is invoked as
// part of system shutdown by the sqlite3_shutdown() function. The
// implementation of this method is expected to release all outstanding
// resources obtained by the mutex methods implementation, especially
// those obtained by the xMutexInit method.  ^The xMutexEnd()
// interface is invoked exactly once for each call to [sqlite3_shutdown()].
//
// ^(The remaining seven methods defined by this structure (xMutexAlloc,
// xMutexFree, xMutexEnter, xMutexTry, xMutexLeave, xMutexHeld and
// xMutexNotheld) implement the following interfaces (respectively):
//
// <ul>
//
//	<li>  [sqlite3_mutex_alloc()] </li>
//	<li>  [sqlite3_mutex_free()] </li>
//	<li>  [sqlite3_mutex_enter()] </li>
//	<li>  [sqlite3_mutex_try()] </li>
//	<li>  [sqlite3_mutex_leave()] </li>
//	<li>  [sqlite3_mutex_held()] </li>
//	<li>  [sqlite3_mutex_notheld()] </li>
//
// </ul>)^
//
// The only difference is that the public sqlite3_XXX functions enumerated
// above silently ignore any invocations that pass a NULL pointer instead
// of a valid mutex handle. The implementations of the methods defined
// by this structure are not required to handle this case. The results
// of passing a NULL pointer instead of a valid mutex handle are undefined
// (i.e. it is acceptable to provide an implementation that segfaults if
// it is passed a NULL pointer).
//
// The xMutexInit() method must be threadsafe.  It must be harmless to
// invoke xMutexInit() multiple times within the same process and without
// intervening calls to xMutexEnd().  Second and subsequent calls to
// xMutexInit() must be no-ops.
//
// xMutexInit() must not use SQLite memory allocation ([sqlite3_malloc()]
// and its associates).  Similarly, xMutexAlloc() must not use SQLite memory
// allocation for a static mutex.  ^However xMutexAlloc() may use SQLite
// memory allocation for a fast or recursive mutex.
//
// ^SQLite will invoke the xMutexEnd() method when [sqlite3_shutdown()] is
// called, but only if the prior call to xMutexInit returned SQLITE_OK.
// If xMutexInit fails in any way, it is expected to clean up after itself
// prior to returning.
type sqlite3_mutex_methods1 = struct {
	xMutexInit    uintptr
	xMutexEnd     uintptr
	xMutexAlloc   uintptr
	xMutexFree    uintptr
	xMutexEnter   uintptr
	xMutexTry     uintptr
	xMutexLeave   uintptr
	xMutexHeld    uintptr
	xMutexNotheld uintptr
} /* sqlite3.h:7804:9 */

// CAPI3REF: Mutex Methods Object
//
// An instance of this structure defines the low-level routines
// used to allocate and use mutexes.
//
// Usually, the default mutex implementations provided by SQLite are
// sufficient, however the application has the option of substituting a custom
// implementation for specialized deployments or systems for which SQLite
// does not provide a suitable implementation. In this case, the application
// creates and populates an instance of this structure to pass
// to sqlite3_config() along with the [SQLITE_CONFIG_MUTEX] option.
// Additionally, an instance of this structure can be used as an
// output variable when querying the system for the current mutex
// implementation, using the [SQLITE_CONFIG_GETMUTEX] option.
//
// ^The xMutexInit method defined by this structure is invoked as
// part of system initialization by the sqlite3_initialize() function.
// ^The xMutexInit routine is called by SQLite exactly once for each
// effective call to [sqlite3_initialize()].
//
// ^The xMutexEnd method defined by this structure is invoked as
// part of system shutdown by the sqlite3_shutdown() function. The
// implementation of this method is expected to release all outstanding
// resources obtained by the mutex methods implementation, especially
// those obtained by the xMutexInit method.  ^The xMutexEnd()
// interface is invoked exactly once for each call to [sqlite3_shutdown()].
//
// ^(The remaining seven methods defined by this structure (xMutexAlloc,
// xMutexFree, xMutexEnter, xMutexTry, xMutexLeave, xMutexHeld and
// xMutexNotheld) implement the following interfaces (respectively):
//
// <ul>
//
//	<li>  [sqlite3_mutex_alloc()] </li>
//	<li>  [sqlite3_mutex_free()] </li>
//	<li>  [sqlite3_mutex_enter()] </li>
//	<li>  [sqlite3_mutex_try()] </li>
//	<li>  [sqlite3_mutex_leave()] </li>
//	<li>  [sqlite3_mutex_held()] </li>
//	<li>  [sqlite3_mutex_notheld()] </li>
//
// </ul>)^
//
// The only difference is that the public sqlite3_XXX functions enumerated
// above silently ignore any invocations that pass a NULL pointer instead
// of a valid mutex handle. The implementations of the methods defined
// by this structure are not required to handle this case. The results
// of passing a NULL pointer instead of a valid mutex handle are undefined
// (i.e. it is acceptable to provide an implementation that segfaults if
// it is passed a NULL pointer).
//
// The xMutexInit() method must be threadsafe.  It must be harmless to
// invoke xMutexInit() multiple times within the same process and without
// intervening calls to xMutexEnd().  Second and subsequent calls to
// xMutexInit() must be no-ops.
//
// xMutexInit() must not use SQLite memory allocation ([sqlite3_malloc()]
// and its associates).  Similarly, xMutexAlloc() must not use SQLite memory
// allocation for a static mutex.  ^However xMutexAlloc() may use SQLite
// memory allocation for a fast or recursive mutex.
//
// ^SQLite will invoke the xMutexEnd() method when [sqlite3_shutdown()] is
// called, but only if the prior call to xMutexInit returned SQLITE_OK.
// If xMutexInit fails in any way, it is expected to clean up after itself
// prior to returning.
type sqlite3_mutex_methods = sqlite3_mutex_methods1 /* sqlite3.h:7804:38 */

// CAPI3REF: Custom Page Cache Object
//
// The sqlite3_pcache_page object represents a single page in the
// page cache.  The page cache will allocate instances of this
// object.  Various methods of the page cache use pointers to instances
// of this object as parameters or as their return value.
//
// See [sqlite3_pcache_methods2] for additional information.
type sqlite3_pcache_page1 = struct {
	pBuf   uintptr
	pExtra uintptr
} /* sqlite3.h:8573:9 */

// CAPI3REF: Custom Page Cache Object
//
// The sqlite3_pcache_page object represents a single page in the
// page cache.  The page cache will allocate instances of this
// object.  Various methods of the page cache use pointers to instances
// of this object as parameters or as their return value.
//
// See [sqlite3_pcache_methods2] for additional information.
type sqlite3_pcache_page = sqlite3_pcache_page1 /* sqlite3.h:8573:36 */

// CAPI3REF: Application Defined Page Cache.
// KEYWORDS: {page cache}
//
// ^(The [sqlite3_config]([SQLITE_CONFIG_PCACHE2], ...) interface can
// register an alternative page cache implementation by passing in an
// instance of the sqlite3_pcache_methods2 structure.)^
// In many applications, most of the heap memory allocated by
// SQLite is used for the page cache.
// By implementing a
// custom page cache using this API, an application can better control
// the amount of memory consumed by SQLite, the way in which
// that memory is allocated and released, and the policies used to
// determine exactly which parts of a database file are cached and for
// how long.
//
// The alternative page cache mechanism is an
// extreme measure that is only needed by the most demanding applications.
// The built-in page cache is recommended for most uses.
//
// ^(The contents of the sqlite3_pcache_methods2 structure are copied to an
// internal buffer by SQLite within the call to [sqlite3_config].  Hence
// the application may discard the parameter after the call to
// [sqlite3_config()] returns.)^
//
// [[the xInit() page cache method]]
// ^(The xInit() method is called once for each effective
// call to [sqlite3_initialize()])^
// (usually only once during the lifetime of the process). ^(The xInit()
// method is passed a copy of the sqlite3_pcache_methods2.pArg value.)^
// The intent of the xInit() method is to set up global data structures
// required by the custom page cache implementation.
// ^(If the xInit() method is NULL, then the
// built-in default page cache is used instead of the application defined
// page cache.)^
//
// [[the xShutdown() page cache method]]
// ^The xShutdown() method is called by [sqlite3_shutdown()].
// It can be used to clean up
// any outstanding resources before process shutdown, if required.
// ^The xShutdown() method may be NULL.
//
// ^SQLite automatically serializes calls to the xInit method,
// so the xInit method need not be threadsafe.  ^The
// xShutdown method is only called from [sqlite3_shutdown()] so it does
// not need to be threadsafe either.  All other methods must be threadsafe
// in multithreaded applications.
//
// ^SQLite will never invoke xInit() more than once without an intervening
// call to xShutdown().
//
// [[the xCreate() page cache methods]]
// ^SQLite invokes the xCreate() method to construct a new cache instance.
// SQLite will typically create one cache instance for each open database file,
// though this is not guaranteed. ^The
// first parameter, szPage, is the size in bytes of the pages that must
// be allocated by the cache.  ^szPage will always a power of two.  ^The
// second parameter szExtra is a number of bytes of extra storage
// associated with each page cache entry.  ^The szExtra parameter will
// a number less than 250.  SQLite will use the
// extra szExtra bytes on each page to store metadata about the underlying
// database page on disk.  The value passed into szExtra depends
// on the SQLite version, the target platform, and how SQLite was compiled.
// ^The third argument to xCreate(), bPurgeable, is true if the cache being
// created will be used to cache database pages of a file stored on disk, or
// false if it is used for an in-memory database. The cache implementation
// does not have to do anything special based with the value of bPurgeable;
// it is purely advisory.  ^On a cache where bPurgeable is false, SQLite will
// never invoke xUnpin() except to deliberately delete a page.
// ^In other words, calls to xUnpin() on a cache with bPurgeable set to
// false will always have the "discard" flag set to true.
// ^Hence, a cache created with bPurgeable false will
// never contain any unpinned pages.
//
// [[the xCachesize() page cache method]]
// ^(The xCachesize() method may be called at any time by SQLite to set the
// suggested maximum cache-size (number of pages stored by) the cache
// instance passed as the first argument. This is the value configured using
// the SQLite "[PRAGMA cache_size]" command.)^  As with the bPurgeable
// parameter, the implementation is not required to do anything with this
// value; it is advisory only.
//
// [[the xPagecount() page cache methods]]
// The xPagecount() method must return the number of pages currently
// stored in the cache, both pinned and unpinned.
//
// [[the xFetch() page cache methods]]
// The xFetch() method locates a page in the cache and returns a pointer to
// an sqlite3_pcache_page object associated with that page, or a NULL pointer.
// The pBuf element of the returned sqlite3_pcache_page object will be a
// pointer to a buffer of szPage bytes used to store the content of a
// single database page.  The pExtra element of sqlite3_pcache_page will be
// a pointer to the szExtra bytes of extra storage that SQLite has requested
// for each entry in the page cache.
//
// The page to be fetched is determined by the key. ^The minimum key value
// is 1.  After it has been retrieved using xFetch, the page is considered
// to be "pinned".
//
// If the requested page is already in the page cache, then the page cache
// implementation must return a pointer to the page buffer with its content
// intact.  If the requested page is not already in the cache, then the
// cache implementation should use the value of the createFlag
// parameter to help it determined what action to take:
//
// <table border=1 width=85% align=center>
// <tr><th> createFlag <th> Behavior when page is not already in cache
// <tr><td> 0 <td> Do not allocate a new page.  Return NULL.
// <tr><td> 1 <td> Allocate a new page if it easy and convenient to do so.
//
//	Otherwise return NULL.
//
// <tr><td> 2 <td> Make every effort to allocate a new page.  Only return
//
//	NULL if allocating a new page is effectively impossible.
//
// </table>
//
// ^(SQLite will normally invoke xFetch() with a createFlag of 0 or 1.  SQLite
// will only use a createFlag of 2 after a prior call with a createFlag of 1
// failed.)^  In between the xFetch() calls, SQLite may
// attempt to unpin one or more cache pages by spilling the content of
// pinned pages to disk and synching the operating system disk cache.
//
// [[the xUnpin() page cache method]]
// ^xUnpin() is called by SQLite with a pointer to a currently pinned page
// as its second argument.  If the third parameter, discard, is non-zero,
// then the page must be evicted from the cache.
// ^If the discard parameter is
// zero, then the page may be discarded or retained at the discretion of
// page cache implementation. ^The page cache implementation
// may choose to evict unpinned pages at any time.
//
// The cache must not perform any reference counting. A single
// call to xUnpin() unpins the page regardless of the number of prior calls
// to xFetch().
//
// [[the xRekey() page cache methods]]
// The xRekey() method is used to change the key value associated with the
// page passed as the second argument. If the cache
// previously contains an entry associated with newKey, it must be
// discarded. ^Any prior cache entry associated with newKey is guaranteed not
// to be pinned.
//
// When SQLite calls the xTruncate() method, the cache must discard all
// existing cache entries with page numbers (keys) greater than or equal
// to the value of the iLimit parameter passed to xTruncate(). If any
// of these pages are pinned, they are implicitly unpinned, meaning that
// they can be safely discarded.
//
// [[the xDestroy() page cache method]]
// ^The xDestroy() method is used to delete a cache allocated by xCreate().
// All resources associated with the specified cache should be freed. ^After
// calling the xDestroy() method, SQLite considers the [sqlite3_pcache*]
// handle invalid, and will not use it with any other sqlite3_pcache_methods2
// functions.
//
// [[the xShrink() page cache method]]
// ^SQLite invokes the xShrink() method when it wants the page cache to
// free up as much of heap memory as possible.  The page cache implementation
// is not obligated to free any memory, but well-behaved implementations should
// do their best.
type sqlite3_pcache_methods21 = struct {
	iVersion   int32
	_          [4]byte
	pArg       uintptr
	xInit      uintptr
	xShutdown  uintptr
	xCreate    uintptr
	xCachesize uintptr
	xPagecount uintptr
	xFetch     uintptr
	xUnpin     uintptr
	xRekey     uintptr
	xTruncate  uintptr
	xDestroy   uintptr
	xShrink    uintptr
} /* sqlite3.h:8738:9 */

// CAPI3REF: Application Defined Page Cache.
// KEYWORDS: {page cache}
//
// ^(The [sqlite3_config]([SQLITE_CONFIG_PCACHE2], ...) interface can
// register an alternative page cache implementation by passing in an
// instance of the sqlite3_pcache_methods2 structure.)^
// In many applications, most of the heap memory allocated by
// SQLite is used for the page cache.
// By implementing a
// custom page cache using this API, an application can better control
// the amount of memory consumed by SQLite, the way in which
// that memory is allocated and released, and the policies used to
// determine exactly which parts of a database file are cached and for
// how long.
//
// The alternative page cache mechanism is an
// extreme measure that is only needed by the most demanding applications.
// The built-in page cache is recommended for most uses.
//
// ^(The contents of the sqlite3_pcache_methods2 structure are copied to an
// internal buffer by SQLite within the call to [sqlite3_config].  Hence
// the application may discard the parameter after the call to
// [sqlite3_config()] returns.)^
//
// [[the xInit() page cache method]]
// ^(The xInit() method is called once for each effective
// call to [sqlite3_initialize()])^
// (usually only once during the lifetime of the process). ^(The xInit()
// method is passed a copy of the sqlite3_pcache_methods2.pArg value.)^
// The intent of the xInit() method is to set up global data structures
// required by the custom page cache implementation.
// ^(If the xInit() method is NULL, then the
// built-in default page cache is used instead of the application defined
// page cache.)^
//
// [[the xShutdown() page cache method]]
// ^The xShutdown() method is called by [sqlite3_shutdown()].
// It can be used to clean up
// any outstanding resources before process shutdown, if required.
// ^The xShutdown() method may be NULL.
//
// ^SQLite automatically serializes calls to the xInit method,
// so the xInit method need not be threadsafe.  ^The
// xShutdown method is only called from [sqlite3_shutdown()] so it does
// not need to be threadsafe either.  All other methods must be threadsafe
// in multithreaded applications.
//
// ^SQLite will never invoke xInit() more than once without an intervening
// call to xShutdown().
//
// [[the xCreate() page cache methods]]
// ^SQLite invokes the xCreate() method to construct a new cache instance.
// SQLite will typically create one cache instance for each open database file,
// though this is not guaranteed. ^The
// first parameter, szPage, is the size in bytes of the pages that must
// be allocated by the cache.  ^szPage will always a power of two.  ^The
// second parameter szExtra is a number of bytes of extra storage
// associated with each page cache entry.  ^The szExtra parameter will
// a number less than 250.  SQLite will use the
// extra szExtra bytes on each page to store metadata about the underlying
// database page on disk.  The value passed into szExtra depends
// on the SQLite version, the target platform, and how SQLite was compiled.
// ^The third argument to xCreate(), bPurgeable, is true if the cache being
// created will be used to cache database pages of a file stored on disk, or
// false if it is used for an in-memory database. The cache implementation
// does not have to do anything special based with the value of bPurgeable;
// it is purely advisory.  ^On a cache where bPurgeable is false, SQLite will
// never invoke xUnpin() except to deliberately delete a page.
// ^In other words, calls to xUnpin() on a cache with bPurgeable set to
// false will always have the "discard" flag set to true.
// ^Hence, a cache created with bPurgeable false will
// never contain any unpinned pages.
//
// [[the xCachesize() page cache method]]
// ^(The xCachesize() method may be called at any time by SQLite to set the
// suggested maximum cache-size (number of pages stored by) the cache
// instance passed as the first argument. This is the value configured using
// the SQLite "[PRAGMA cache_size]" command.)^  As with the bPurgeable
// parameter, the implementation is not required to do anything with this
// value; it is advisory only.
//
// [[the xPagecount() page cache methods]]
// The xPagecount() method must return the number of pages currently
// stored in the cache, both pinned and unpinned.
//
// [[the xFetch() page cache methods]]
// The xFetch() method locates a page in the cache and returns a pointer to
// an sqlite3_pcache_page object associated with that page, or a NULL pointer.
// The pBuf element of the returned sqlite3_pcache_page object will be a
// pointer to a buffer of szPage bytes used to store the content of a
// single database page.  The pExtra element of sqlite3_pcache_page will be
// a pointer to the szExtra bytes of extra storage that SQLite has requested
// for each entry in the page cache.
//
// The page to be fetched is determined by the key. ^The minimum key value
// is 1.  After it has been retrieved using xFetch, the page is considered
// to be "pinned".
//
// If the requested page is already in the page cache, then the page cache
// implementation must return a pointer to the page buffer with its content
// intact.  If the requested page is not already in the cache, then the
// cache implementation should use the value of the createFlag
// parameter to help it determined what action to take:
//
// <table border=1 width=85% align=center>
// <tr><th> createFlag <th> Behavior when page is not already in cache
// <tr><td> 0 <td> Do not allocate a new page.  Return NULL.
// <tr><td> 1 <td> Allocate a new page if it easy and convenient to do so.
//
//	Otherwise return NULL.
//
// <tr><td> 2 <td> Make every effort to allocate a new page.  Only return
//
//	NULL if allocating a new page is effectively impossible.
//
// </table>
//
// ^(SQLite will normally invoke xFetch() with a createFlag of 0 or 1.  SQLite
// will only use a createFlag of 2 after a prior call with a createFlag of 1
// failed.)^  In between the xFetch() calls, SQLite may
// attempt to unpin one or more cache pages by spilling the content of
// pinned pages to disk and synching the operating system disk cache.
//
// [[the xUnpin() page cache method]]
// ^xUnpin() is called by SQLite with a pointer to a currently pinned page
// as its second argument.  If the third parameter, discard, is non-zero,
// then the page must be evicted from the cache.
// ^If the discard parameter is
// zero, then the page may be discarded or retained at the discretion of
// page cache implementation. ^The page cache implementation
// may choose to evict unpinned pages at any time.
//
// The cache must not perform any reference counting. A single
// call to xUnpin() unpins the page regardless of the number of prior calls
// to xFetch().
//
// [[the xRekey() page cache methods]]
// The xRekey() method is used to change the key value associated with the
// page passed as the second argument. If the cache
// previously contains an entry associated with newKey, it must be
// discarded. ^Any prior cache entry associated with newKey is guaranteed not
// to be pinned.
//
// When SQLite calls the xTruncate() method, the cache must discard all
// existing cache entries with page numbers (keys) greater than or equal
// to the value of the iLimit parameter passed to xTruncate(). If any
// of these pages are pinned, they are implicitly unpinned, meaning that
// they can be safely discarded.
//
// [[the xDestroy() page cache method]]
// ^The xDestroy() method is used to delete a cache allocated by xCreate().
// All resources associated with the specified cache should be freed. ^After
// calling the xDestroy() method, SQLite considers the [sqlite3_pcache*]
// handle invalid, and will not use it with any other sqlite3_pcache_methods2
// functions.
//
// [[the xShrink() page cache method]]
// ^SQLite invokes the xShrink() method when it wants the page cache to
// free up as much of heap memory as possible.  The page cache implementation
// is not obligated to free any memory, but well-behaved implementations should
// do their best.
type sqlite3_pcache_methods2 = sqlite3_pcache_methods21 /* sqlite3.h:8738:40 */

// This is the obsolete pcache_methods object that has now been replaced
// by sqlite3_pcache_methods2.  This object is not used by SQLite.  It is
// retained in the header file for backwards compatibility only.
type sqlite3_pcache_methods1 = struct {
	pArg       uintptr
	xInit      uintptr
	xShutdown  uintptr
	xCreate    uintptr
	xCachesize uintptr
	xPagecount uintptr
	xFetch     uintptr
	xUnpin     uintptr
	xRekey     uintptr
	xTruncate  uintptr
	xDestroy   uintptr
} /* sqlite3.h:8761:9 */

// This is the obsolete pcache_methods object that has now been replaced
// by sqlite3_pcache_methods2.  This object is not used by SQLite.  It is
// retained in the header file for backwards compatibility only.
type sqlite3_pcache_methods = sqlite3_pcache_methods1 /* sqlite3.h:8761:39 */

// CAPI3REF: Database Snapshot
// KEYWORDS: {snapshot} {sqlite3_snapshot}
//
// An instance of the snapshot object records the state of a [WAL mode]
// database for some specific point in history.
//
// In [WAL mode], multiple [database connections] that are open on the
// same database file can each be reading a different historical version
// of the database file.  When a [database connection] begins a read
// transaction, that connection sees an unchanging copy of the database
// as it existed for the point in time when the transaction first started.
// Subsequent changes to the database from other connections are not seen
// by the reader until a new read transaction is started.
//
// The sqlite3_snapshot object records state information about an historical
// version of the database file so that it is possible to later open a new read
// transaction that sees that historical version of the database rather than
// the most recent version.
type sqlite3_snapshot1 = struct{ hidden [48]uint8 } /* sqlite3.h:10079:9 */

// CAPI3REF: Database Snapshot
// KEYWORDS: {snapshot} {sqlite3_snapshot}
//
// An instance of the snapshot object records the state of a [WAL mode]
// database for some specific point in history.
//
// In [WAL mode], multiple [database connections] that are open on the
// same database file can each be reading a different historical version
// of the database file.  When a [database connection] begins a read
// transaction, that connection sees an unchanging copy of the database
// as it existed for the point in time when the transaction first started.
// Subsequent changes to the database from other connections are not seen
// by the reader until a new read transaction is started.
//
// The sqlite3_snapshot object records state information about an historical
// version of the database file so that it is possible to later open a new read
// transaction that sees that historical version of the database rather than
// the most recent version.
type sqlite3_snapshot = sqlite3_snapshot1 /* sqlite3.h:10081:3 */

// CAPI3REF: Flags for sqlite3_deserialize()
//
// The following are allowed values for 6th argument (the F argument) to
// the [sqlite3_deserialize(D,S,P,N,M,F)] interface.
//
// The SQLITE_DESERIALIZE_FREEONCLOSE means that the database serialization
// in the P argument is held in memory obtained from [sqlite3_malloc64()]
// and that SQLite should take ownership of this memory and automatically
// free it when it has finished using it.  Without this flag, the caller
// is responsible for freeing any dynamically allocated memory.
//
// The SQLITE_DESERIALIZE_RESIZEABLE flag means that SQLite is allowed to
// grow the size of the database using calls to [sqlite3_realloc64()].  This
// flag should only be used if SQLITE_DESERIALIZE_FREEONCLOSE is also used.
// Without this flag, the deserialized database cannot increase in size beyond
// the number of bytes specified by the M parameter.
//
// The SQLITE_DESERIALIZE_READONLY flag means that the deserialized database
// should be treated as read-only.

// Undo the hack that converts floating point types to integer for
// builds on processors without floating point support.

//******* Begin file sqlite3rtree.h ********
// 2010 August 30
//
// The author disclaims copyright to this source code.  In place of
// a legal notice, here is a blessing:
//
//    May you do good and not evil.
//    May you find forgiveness for yourself and forgive others.
//    May you share freely, never taking more than you give.
//
//

type sqlite3_rtree_geometry1 = struct {
	pContext uintptr
	nParam   int32
	_        [4]byte
	aParam   uintptr
	pUser    uintptr
	xDelUser uintptr
} /* sqlite3.h:10410:9 */

// CAPI3REF: Flags for sqlite3_deserialize()
//
// The following are allowed values for 6th argument (the F argument) to
// the [sqlite3_deserialize(D,S,P,N,M,F)] interface.
//
// The SQLITE_DESERIALIZE_FREEONCLOSE means that the database serialization
// in the P argument is held in memory obtained from [sqlite3_malloc64()]
// and that SQLite should take ownership of this memory and automatically
// free it when it has finished using it.  Without this flag, the caller
// is responsible for freeing any dynamically allocated memory.
//
// The SQLITE_DESERIALIZE_RESIZEABLE flag means that SQLite is allowed to
// grow the size of the database using calls to [sqlite3_realloc64()].  This
// flag should only be used if SQLITE_DESERIALIZE_FREEONCLOSE is also used.
// Without this flag, the deserialized database cannot increase in size beyond
// the number of bytes specified by the M parameter.
//
// The SQLITE_DESERIALIZE_READONLY flag means that the deserialized database
// should be treated as read-only.

// Undo the hack that converts floating point types to integer for
// builds on processors without floating point support.

//******* Begin file sqlite3rtree.h ********
// 2010 August 30
//
// The author disclaims copyright to this source code.  In place of
// a legal notice, here is a blessing:
//
//    May you do good and not evil.
//    May you find forgiveness for yourself and forgive others.
//    May you share freely, never taking more than you give.
//
//

type sqlite3_rtree_geometry = sqlite3_rtree_geometry1 /* sqlite3.h:10410:39 */
type sqlite3_rtree_query_info1 = struct {
	pContext      uintptr
	nParam        int32
	_             [4]byte
	aParam        uintptr
	pUser         uintptr
	xDelUser      uintptr
	aCoord        uintptr
	anQueue       uintptr
	nCoord        int32
	iLevel        int32
	mxLevel       int32
	_             [4]byte
	iRowid        sqlite3_int64
	rParentScore  sqlite3_rtree_dbl
	eParentWithin int32
	eWithin       int32
	rScore        sqlite3_rtree_dbl
	apSqlParam    uintptr
} /* sqlite3.h:10411:9 */

type sqlite3_rtree_query_info = sqlite3_rtree_query_info1 /* sqlite3.h:10411:41 */

// The double-precision datatype used by RTree depends on the
// SQLITE_RTREE_INT_ONLY compile-time option.
type sqlite3_rtree_dbl = float64 /* sqlite3.h:10419:18 */

// Allowed values for sqlite3_rtree_query.eWithin and .eParentWithin.

//******* End of sqlite3rtree.h ********
//******* Begin file sqlite3session.h ********

//******* End of sqlite3session.h ********
//******* Begin file fts5.h ********
// 2014 May 31
//
// The author disclaims copyright to this source code.  In place of
// a legal notice, here is a blessing:
//
//    May you do good and not evil.
//    May you find forgiveness for yourself and forgive others.
//    May you share freely, never taking more than you give.
//
//
//
// Interfaces to extend FTS5. Using the interfaces defined in this file,
// FTS5 may be extended with:
//
//     * custom tokenizers, and
//     * custom auxiliary functions.

// ************************************************************************
//
// CUSTOM AUXILIARY FUNCTIONS
//
// Virtual table implementations may overload SQL functions by implementing
// the sqlite3_module.xFindFunction() method.

type Fts5ExtensionApi1 = struct {
	iVersion           int32
	_                  [4]byte
	xUserData          uintptr
	xColumnCount       uintptr
	xRowCount          uintptr
	xColumnTotalSize   uintptr
	xTokenize          uintptr
	xPhraseCount       uintptr
	xPhraseSize        uintptr
	xInstCount         uintptr
	xInst              uintptr
	xRowid             uintptr
	xColumnText        uintptr
	xColumnSize        uintptr
	xQueryPhrase       uintptr
	xSetAuxdata        uintptr
	xGetAuxdata        uintptr
	xPhraseFirst       uintptr
	xPhraseNext        uintptr
	xPhraseFirstColumn uintptr
	xPhraseNextColumn  uintptr
} /* sqlite3.h:12266:9 */

// Allowed values for sqlite3_rtree_query.eWithin and .eParentWithin.

//******* End of sqlite3rtree.h ********
//******* Begin file sqlite3session.h ********

//******* End of sqlite3session.h ********
//******* Begin file fts5.h ********
// 2014 May 31
//
// The author disclaims copyright to this source code.  In place of
// a legal notice, here is a blessing:
//
//    May you do good and not evil.
//    May you find forgiveness for yourself and forgive others.
//    May you share freely, never taking more than you give.
//
//
//
// Interfaces to extend FTS5. Using the interfaces defined in this file,
// FTS5 may be extended with:
//
//     * custom tokenizers, and
//     * custom auxiliary functions.

// ************************************************************************
//
// CUSTOM AUXILIARY FUNCTIONS
//
// Virtual table implementations may overload SQL functions by implementing
// the sqlite3_module.xFindFunction() method.

type Fts5ExtensionApi = Fts5ExtensionApi1 /* sqlite3.h:12266:33 */
type Fts5PhraseIter1 = struct {
	a uintptr
	b uintptr
} /* sqlite3.h:12268:9 */

type Fts5PhraseIter = Fts5PhraseIter1 /* sqlite3.h:12268:31 */

type fts5_extension_function = uintptr /* sqlite3.h:12270:14 */
type fts5_tokenizer1 = struct {
	xCreate   uintptr
	xDelete   uintptr
	xTokenize uintptr
} /* sqlite3.h:12729:9 */

type fts5_tokenizer = fts5_tokenizer1 /* sqlite3.h:12729:31 */

// Flags that may be passed as the third argument to xTokenize()

// Flags that may be passed by the tokenizer implementation back to FTS5
// as the third argument to the supplied xToken callback.

//
// END OF CUSTOM TOKENIZERS
//

// ************************************************************************
//
// FTS5 EXTENSION REGISTRATION API
type fts5_api1 = struct {
	iVersion         int32
	_                [4]byte
	xCreateTokenizer uintptr
	xFindTokenizer   uintptr
	xCreateFunction  uintptr
} /* sqlite3.h:12765:9 */

// Flags that may be passed as the third argument to xTokenize()

// Flags that may be passed by the tokenizer implementation back to FTS5
// as the third argument to the supplied xToken callback.

//
// END OF CUSTOM TOKENIZERS
//

// ************************************************************************
//
// FTS5 EXTENSION REGISTRATION API
type fts5_api = fts5_api1 /* sqlite3.h:12765:25 */

type locale_t = uintptr /* strings.h:53:14 */

// Tell sys/endian.h we have MD variants of the swap macros.

// Note that these macros evaluate their arguments several times.

// Public names

// These are specified to be function-like macros to match the spec

// POSIX names

// original BSD names

// these were exposed here before

// ancient stuff

type u_char = uint8   /* types.h:51:23 */
type u_short = uint16 /* types.h:52:24 */
type u_int = uint32   /* types.h:53:22 */
type u_long = uint64  /* types.h:54:23 */

type unchar = uint8  /* types.h:56:23 */ // Sys V compatibility
type ushort = uint16 /* types.h:57:24 */ // Sys V compatibility
type uint = uint32   /* types.h:58:22 */ // Sys V compatibility
type ulong = uint64  /* types.h:59:23 */ // Sys V compatibility

type cpuid_t = uint64   /* types.h:61:19 */ // CPU id
type register_t = int64 /* types.h:62:22 */ // register-sized type

// XXX The exact-width bit types should only be exposed if __BSD_VISIBLE
//     but the rest of the includes are not ready for that yet.

type int8_t = int8 /* types.h:75:19 */

type uint8_t = uint8 /* types.h:80:20 */

type int16_t = int16 /* types.h:85:20 */

type uint16_t = uint16 /* types.h:90:21 */

type int32_t = int32 /* types.h:95:20 */

type uint32_t = uint32 /* types.h:100:21 */

type int64_t = int64 /* types.h:105:20 */

type uint64_t = uint64 /* types.h:110:21 */

// BSD-style unsigned bits types
type u_int8_t = uint8   /* types.h:114:19 */
type u_int16_t = uint16 /* types.h:115:20 */
type u_int32_t = uint32 /* types.h:116:20 */
type u_int64_t = uint64 /* types.h:117:20 */

// quads, deprecated in favor of 64 bit int types
type quad_t = int64    /* types.h:120:19 */
type u_quad_t = uint64 /* types.h:121:20 */

// VM system types
type vaddr_t = uint64 /* types.h:125:19 */
type paddr_t = uint64 /* types.h:126:19 */
type vsize_t = uint64 /* types.h:127:19 */
type psize_t = uint64 /* types.h:128:19 */

// Standard system types
type blkcnt_t = int64    /* types.h:132:20 */ // blocks allocated for file
type blksize_t = int32   /* types.h:133:21 */ // optimal blocksize for I/O
type caddr_t = uintptr   /* types.h:134:14 */ // core address
type daddr32_t = int32   /* types.h:135:19 */ // 32-bit disk address
type daddr_t = int64     /* types.h:136:19 */ // 64-bit disk address
type dev_t = int32       /* types.h:137:18 */ // device number
type fixpt_t = uint32    /* types.h:138:19 */ // fixed point number
type gid_t = uint32      /* types.h:139:18 */ // group id
type id_t = uint32       /* types.h:140:17 */ // may contain pid, uid or gid
type ino_t = uint64      /* types.h:141:18 */ // inode number
type key_t = int64       /* types.h:142:18 */ // IPC key (for Sys V IPC)
type mode_t = uint32     /* types.h:143:18 */ // permissions
type nlink_t = uint32    /* types.h:144:19 */ // link count
type rlim_t = uint64     /* types.h:145:18 */ // resource limit
type segsz_t = int32     /* types.h:146:19 */ // segment size
type swblk_t = int32     /* types.h:147:19 */ // swap offset
type uid_t = uint32      /* types.h:148:18 */ // user id
type useconds_t = uint32 /* types.h:149:22 */ // microseconds
type suseconds_t = int64 /* types.h:150:23 */ // microseconds (signed)
type fsblkcnt_t = uint64 /* types.h:151:22 */ // file system block count
type fsfilcnt_t = uint64 /* types.h:152:22 */ // file system file count

// The following types may be defined in multiple header files.
type clock_t = int64 /* types.h:159:19 */

type clockid_t = int32 /* types.h:164:21 */

type pid_t = int32 /* types.h:169:18 */

type ssize_t = int64 /* types.h:179:19 */

type time_t = int64 /* types.h:184:18 */

type timer_t = int32 /* types.h:189:19 */

type off_t = int64 /* types.h:194:18 */

// Major, minor numbers, dev_t's.

//	$OpenBSD: stat.h,v 1.29 2022/01/11 23:59:55 jsg Exp $
//	$NetBSD: stat.h,v 1.20 1996/05/16 22:17:49 cgd Exp $

// -
// Copyright (c) 1982, 1986, 1989, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)stat.h	8.9 (Berkeley) 8/17/94

//	$OpenBSD: time.h,v 1.61 2021/06/19 13:49:39 cheloha Exp $
//	$NetBSD: time.h,v 1.18 1996/04/23 10:29:33 mycroft Exp $

// Copyright (c) 1982, 1986, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)time.h	8.2 (Berkeley) 7/10/94

//	$OpenBSD: select.h,v 1.17 2016/09/12 19:41:20 guenther Exp $

// -
// Copyright (c) 1992, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)select.h	8.2 (Berkeley) 1/4/94

//	$OpenBSD: types.h,v 1.48 2019/02/09 04:54:11 guenther Exp $
//	$NetBSD: types.h,v 1.29 1996/11/15 22:48:25 jtc Exp $

// -
// Copyright (c) 1982, 1986, 1991, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)types.h	8.4 (Berkeley) 1/21/94

type timeval = struct {
	tv_sec  time_t
	tv_usec suseconds_t
} /* select.h:41:1 */

type timespec = struct {
	tv_sec  time_t
	tv_nsec int64
} /* select.h:49:1 */

type fd_set1 = struct{ fds_bits [32]uint32 } /* select.h:74:9 */

type fd_set = fd_set1 /* select.h:76:3 */

type sigset_t = uint32 /* select.h:122:22 */

type timezone = struct {
	tz_minuteswest int32
	tz_dsttime     int32
} /* time.h:72:1 */

// Operations on timevals.

// Operations on timespecs.

// Names of the interval timers, and structure
// defining a timer setting.

type itimerval = struct {
	it_interval struct {
		tv_sec  time_t
		tv_usec suseconds_t
	}
	it_value struct {
		tv_sec  time_t
		tv_usec suseconds_t
	}
} /* time.h:148:1 */

// clock information structure for sysctl({CTL_KERN, KERN_CLOCKRATE})
type clockinfo = struct {
	hz     int32
	tick   int32
	stathz int32
	profhz int32
} /* time.h:157:1 */

//	$OpenBSD: time.h,v 1.31 2018/10/30 16:28:42 guenther Exp $
//	$NetBSD: time.h,v 1.9 1994/10/26 00:56:35 cgd Exp $

// Copyright (c) 1989 The Regents of the University of California.
// All rights reserved.
//
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)time.h	5.12 (Berkeley) 3/9/91

//	$OpenBSD: cdefs.h,v 1.43 2018/10/29 17:10:40 guenther Exp $
//	$NetBSD: cdefs.h,v 1.16 1996/04/03 20:46:39 christos Exp $

// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.7 (Berkeley) 1/21/94

//	$OpenBSD: _null.h,v 1.2 2016/09/09 22:07:58 millert Exp $

// Written by Todd C. Miller, September 9, 2016
// Public domain.

//	$OpenBSD: _types.h,v 1.9 2014/08/22 23:05:15 krw Exp $

// -
// Copyright (c) 1990, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)types.h	8.3 (Berkeley) 1/5/94

// Frequency of the clock ticks reported by times().  Deprecated - use
// sysconf(_SC_CLK_TCK) instead.  (Removed in 1003.1-2001.)

//	$OpenBSD: _time.h,v 1.9 2017/12/18 05:51:53 cheloha Exp $

// Copyright (c) 1982, 1986, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.

// Per-process and per-thread clocks encode the PID or TID into the
// high bits, with the type in the bottom bits

// Structure defined by POSIX 1003.1b to be like a itimerval,
// but with timespecs. Used in the timer_*() system calls.
type itimerspec = struct {
	it_interval struct {
		tv_sec  time_t
		tv_nsec int64
	}
	it_value struct {
		tv_sec  time_t
		tv_nsec int64
	}
} /* _time.h:56:1 */

type tm = struct {
	tm_sec    int32
	tm_min    int32
	tm_hour   int32
	tm_mday   int32
	tm_mon    int32
	tm_year   int32
	tm_wday   int32
	tm_yday   int32
	tm_isdst  int32
	_         [4]byte
	tm_gmtoff int64
	tm_zone   uintptr
} /* time.h:111:1 */

type stat = struct {
	st_mode  mode_t
	st_dev   dev_t
	st_ino   ino_t
	st_nlink nlink_t
	st_uid   uid_t
	st_gid   gid_t
	st_rdev  dev_t
	st_atim  struct {
		tv_sec  time_t
		tv_nsec int64
	}
	st_mtim struct {
		tv_sec  time_t
		tv_nsec int64
	}
	st_ctim struct {
		tv_sec  time_t
		tv_nsec int64
	}
	st_size       off_t
	st_blocks     blkcnt_t
	st_blksize    blksize_t
	st_flags      u_int32_t
	st_gen        u_int32_t
	_             [4]byte
	__st_birthtim struct {
		tv_sec  time_t
		tv_nsec int64
	}
} /* stat.h:45:1 */

//	$OpenBSD: file.h,v 1.65 2022/01/20 03:43:31 jsg Exp $
//	$NetBSD: file.h,v 1.11 1995/03/26 20:24:13 jtc Exp $

// Copyright (c) 1982, 1986, 1989, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)file.h	8.2 (Berkeley) 8/20/94

//	$OpenBSD: fcntl.h,v 1.22 2019/01/21 18:09:21 anton Exp $
//	$NetBSD: fcntl.h,v 1.8 1995/03/26 20:24:12 jtc Exp $

// -
// Copyright (c) 1983, 1990, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)fcntl.h	8.3 (Berkeley) 1/21/94

// This file includes the definitions for open and fcntl
// described by POSIX for <fcntl.h>; it also includes
// related kernel definitions.

//	$OpenBSD: cdefs.h,v 1.43 2018/10/29 17:10:40 guenther Exp $
//	$NetBSD: cdefs.h,v 1.16 1996/04/03 20:46:39 christos Exp $

// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.7 (Berkeley) 1/21/94

//	$OpenBSD: types.h,v 1.48 2019/02/09 04:54:11 guenther Exp $
//	$NetBSD: types.h,v 1.29 1996/11/15 22:48:25 jtc Exp $

// -
// Copyright (c) 1982, 1986, 1991, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)types.h	8.4 (Berkeley) 1/21/94

// File status flags: these are used by open(2), fcntl(2).
// They are also used (indirectly) in the kernel file structure f_flags,
// which is a superset of the open/fcntl flags.  Open flags and f_flags
// are inter-convertible using OFLAGS(fflags) and FFLAGS(oflags).
// Open/fcntl flags begin with O_; kernel-internal flags begin with F.
// open-only flags

// Kernel encoding of open mode; separate read and write bits that are
// independently testable: 1 greater than the above.
//
// XXX
// FREAD and FWRITE are excluded from the #ifdef _KERNEL so that TIOCFLUSH,
// which was documented to use FREAD/FWRITE, continues to work.

// POSIX 1003.1 specifies a higher granularity for synchronous operations
// than we support.  Since synchronicity is all or nothing in OpenBSD
// we just define these to be the same as O_SYNC.

// defined by POSIX 1003.1; BSD default, this bit is not required

// defined by POSIX Issue 7

// The O_* flags used to have only F* names, which were used in the kernel
// and by fcntl.  We retain the F* names for the kernel f_flags field
// and for backward compatibility for fcntl.

// Constants used for fcntl(2)

// command values

// file descriptor flags (F_GETFD, F_SETFD)

// record locking flags (F_GETLK, F_SETLK, F_SETLKW)

// Advisory file segment locking data type -
// information passed to system by user
type flock = struct {
	l_start  off_t
	l_len    off_t
	l_pid    pid_t
	l_type   int16
	l_whence int16
} /* fcntl.h:180:1 */

//	$OpenBSD: param.h,v 1.138 2022/04/04 21:16:47 deraadt Exp $

// -
// Copyright (c) 1982, 1986, 1989, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.

//	$OpenBSD: _null.h,v 1.2 2016/09/09 22:07:58 millert Exp $

// Written by Todd C. Miller, September 9, 2016
// Public domain.

//	$OpenBSD: types.h,v 1.48 2019/02/09 04:54:11 guenther Exp $
//	$NetBSD: types.h,v 1.29 1996/11/15 22:48:25 jtc Exp $

// -
// Copyright (c) 1982, 1986, 1991, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)types.h	8.4 (Berkeley) 1/21/94

// Machine-independent constants (some used in following include files).
// Redefined constants are from POSIX 1003.1 limits file.
//
// MAXCOMLEN should be >= sizeof(ac_comm) (see <acct.h>)
// MAXLOGNAME should be >= UT_NAMESIZE (see <utmp.h>)
//	$OpenBSD: syslimits.h,v 1.15 2022/02/22 16:58:08 deraadt Exp $
//	$NetBSD: syslimits.h,v 1.12 1995/10/05 05:26:19 thorpej Exp $

// Copyright (c) 1988, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)syslimits.h	8.1 (Berkeley) 6/2/93

//	$OpenBSD: cdefs.h,v 1.43 2018/10/29 17:10:40 guenther Exp $
//	$NetBSD: cdefs.h,v 1.16 1996/04/03 20:46:39 christos Exp $

// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.7 (Berkeley) 1/21/94

// More types and definitions used throughout the kernel.

// Signals.
//	$OpenBSD: signal.h,v 1.29 2018/04/18 16:05:20 deraadt Exp $
//	$NetBSD: signal.h,v 1.21 1996/02/09 18:25:32 christos Exp $

// Copyright (c) 1982, 1986, 1989, 1991, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)signal.h	8.2 (Berkeley) 1/21/94

//	$OpenBSD: signal.h,v 1.9 2016/05/10 18:39:42 deraadt Exp $
//	$NetBSD: signal.h,v 1.2 2003/04/28 23:16:17 bjh21 Exp $

// Copyright (c) 1982, 1986, 1989, 1991 Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)signal.h	7.16 (Berkeley) 3/17/91

//	$OpenBSD: cdefs.h,v 1.43 2018/10/29 17:10:40 guenther Exp $
//	$NetBSD: cdefs.h,v 1.16 1996/04/03 20:46:39 christos Exp $

// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.7 (Berkeley) 1/21/94

type sig_atomic_t = int32 /* signal.h:40:13 */

// Information pushed on stack when a signal is delivered.
// This is used by the kernel to restore state following
// execution of the signal handler.  It is also made available
// to the handler to allow it to restore state properly if
// a non-standard exit is performed.
type sigcontext = struct {
	sc_rdi      int64
	sc_rsi      int64
	sc_rdx      int64
	sc_rcx      int64
	sc_r8       int64
	sc_r9       int64
	sc_r10      int64
	sc_r11      int64
	sc_r12      int64
	sc_r13      int64
	sc_r14      int64
	sc_r15      int64
	sc_rbp      int64
	sc_rbx      int64
	sc_rax      int64
	sc_gs       int64
	sc_fs       int64
	sc_es       int64
	sc_ds       int64
	sc_trapno   int64
	sc_err      int64
	sc_rip      int64
	sc_cs       int64
	sc_rflags   int64
	sc_rsp      int64
	sc_ss       int64
	sc_fpstate  uintptr
	__sc_unused int32
	sc_mask     int32
	sc_cookie   int64
} /* signal.h:54:1 */

// Language spec says we must list exactly one parameter, even though we
// actually supply three.  Ugh!

//	$OpenBSD: siginfo.h,v 1.12 2017/04/07 04:48:44 guenther Exp $

// Copyright (c) 1997 Theo de Raadt
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

//	$OpenBSD: cdefs.h,v 1.43 2018/10/29 17:10:40 guenther Exp $
//	$NetBSD: cdefs.h,v 1.16 1996/04/03 20:46:39 christos Exp $

// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.7 (Berkeley) 1/21/94

type sigval = struct {
	_         [0]uint64
	sival_int int32
	_         [4]byte
} /* siginfo.h:33:1 */

// Negative signal codes are reserved for future use for
// user generated signals.

// The machine dependent signal codes (SIGILL, SIGFPE,
// SIGSEGV, and SIGBUS)

// SIGTRAP signal codes

// SIGCHLD signal codes

//	$OpenBSD: time.h,v 1.61 2021/06/19 13:49:39 cheloha Exp $
//	$NetBSD: time.h,v 1.18 1996/04/23 10:29:33 mycroft Exp $

// Copyright (c) 1982, 1986, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)time.h	8.2 (Berkeley) 7/10/94

type siginfo_t = struct {
	si_signo int32
	si_code  int32
	si_errno int32
	_        [4]byte
	_data    struct {
		_    [0]uint64
		_pad [29]int32
		_    [4]byte
	}
} /* siginfo.h:173:3 */

// Signal vector "template" used in sigaction call.
type sigaction = struct {
	__sigaction_u struct{ __sa_handler uintptr }
	sa_mask       sigset_t
	sa_flags      int32
} /* signal.h:112:1 */

// if SA_SIGINFO is set, sa_sigaction is to be used instead of sa_handler.

// Flags for sigprocmask:

type sig_t = uintptr /* signal.h:146:14 */ // type of signal function

// 4.3 compatibility:
// Signal vector "template" used in sigvec call.
type sigvec = struct {
	sv_handler uintptr
	sv_mask    int32
	sv_flags   int32
} /* signal.h:152:1 */

// Macro for converting signal number to a mask suitable for
// sigblock().

// Structure used in sigaltstack call.
type sigaltstack = struct {
	ss_sp    uintptr
	ss_size  size_t
	ss_flags int32
	_        [4]byte
} /* signal.h:176:9 */

// Macro for converting signal number to a mask suitable for
// sigblock().

// Structure used in sigaltstack call.
type stack_t = sigaltstack /* signal.h:180:3 */

type ucontext_t = sigcontext /* signal.h:190:27 */

// Machine type dependent parameters.
// $OpenBSD: limits.h,v 1.10 2012/06/30 20:21:10 guenther Exp $
// Copyright (c) 2002 Marc Espie.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE OPENBSD PROJECT AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OPENBSD
// PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

//	$OpenBSD: cdefs.h,v 1.43 2018/10/29 17:10:40 guenther Exp $
//	$NetBSD: cdefs.h,v 1.16 1996/04/03 20:46:39 christos Exp $

// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.7 (Berkeley) 1/21/94

// Common definitions for limits.h.

// Legacy
//	$OpenBSD: limits.h,v 1.6 2015/04/30 13:42:08 millert Exp $

// Copyright (c) 1988 The Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)limits.h	7.2 (Berkeley) 6/28/90

//	$OpenBSD: cdefs.h,v 1.43 2018/10/29 17:10:40 guenther Exp $
//	$NetBSD: cdefs.h,v 1.16 1996/04/03 20:46:39 christos Exp $

// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.7 (Berkeley) 1/21/94

// max value for unsigned long
// max value for a signed long
// min value for a signed long

// max value for unsigned long long
// max value for a signed long long
// min value for a signed long long

//	$OpenBSD: param.h,v 1.28 2019/12/23 21:42:01 bluhm Exp $

// -
// Copyright (c) 1990 The Regents of the University of California.
// All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// William Jolitz.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.

// File system parameters and macros.
//
// The file system is made out of blocks of at most MAXBSIZE units, with
// smaller units (fragments) only in the last direct block.  MAXBSIZE
// primarily determines the size of buffers in the buffer pool.  It may be
// made larger without any effect on existing file systems; however making
// it smaller makes some file systems unmountable.

// pages to disk blocks

// bytes to disk blocks

// MAXPATHLEN defines the longest permissible path length after expanding
// symbolic links. It is used to allocate a temporary buffer from the buffer
// pool in which to do the name expansion, hence should be a power of two,
// and must be less than or equal to MAXBSIZE.  MAXSYMLINKS defines the
// maximum number of symbolic links that may be expanded in a path name.
// It should be set high enough to allow all legitimate uses, but halt
// infinite loops reasonably quickly.

// Macros to set/clear/test flags.

// Bit map related macros.

// Macros for counting and rounding.

// Macros for min/max.

// Macros for calculating the offset of a field

// Scale factor for scaled integers used to count %cpu time and load avgs.
//
// The number of CPU `tick's that map to a unique `%age' can be expressed
// by the formula (1 / (2 ^ (FSHIFT - 11))).  The maximum load average that
// can be calculated (assuming 32 bits) can be closely approximated using
// the formula (2 ^ (2 * (16 - FSHIFT))) for (FSHIFT < 15).
//
// For the scheduler to maintain a 1:1 mapping of CPU `tick' to `%age',
// FSHIFT must be at least 11; this gives us a maximum load avg of ~1024.

//	$OpenBSD: unistd.h,v 1.106 2018/07/13 09:25:22 beck Exp $
//	$NetBSD: unistd.h,v 1.26.4.1 1996/05/28 02:31:51 mrg Exp $

// -
// Copyright (c) 1991 The Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)unistd.h	5.13 (Berkeley) 6/17/91

//	$OpenBSD: _null.h,v 1.2 2016/09/09 22:07:58 millert Exp $

// Written by Todd C. Miller, September 9, 2016
// Public domain.

//	$OpenBSD: types.h,v 1.48 2019/02/09 04:54:11 guenther Exp $
//	$NetBSD: types.h,v 1.29 1996/11/15 22:48:25 jtc Exp $

// -
// Copyright (c) 1982, 1986, 1991, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)types.h	8.4 (Berkeley) 1/21/94

//	$OpenBSD: unistd.h,v 1.31 2015/07/20 00:56:10 guenther Exp $
//	$NetBSD: unistd.h,v 1.10 1994/06/29 06:46:06 cgd Exp $

// Copyright (c) 1989, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)unistd.h	8.2 (Berkeley) 1/7/94

//	$OpenBSD: cdefs.h,v 1.43 2018/10/29 17:10:40 guenther Exp $
//	$NetBSD: cdefs.h,v 1.16 1996/04/03 20:46:39 christos Exp $

// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.7 (Berkeley) 1/21/94

// Define the POSIX.1 version we target for compliance.

// access function

// whence values for lseek(2)

// old BSD whence values for lseek(2); renamed by POSIX 1003.1

// the parameters argument passed to the __tfork() syscall
type __tfork = struct {
	tf_tcb   uintptr
	tf_tid   uintptr
	tf_stack uintptr
} /* unistd.h:66:1 */

// the parameters argument for the kbind() syscall
type __kbind = struct {
	kb_addr uintptr
	kb_size size_t
} /* unistd.h:73:1 */

// the pathconf(2) variable values are part of the ABI

// configurable pathname variables

// POSIX options and option groups we unconditionally do or don't
// implement.  Please keep this list in alphabetical order.
//
// Anything which is defined as zero below **must** have an
// implementation for the corresponding sysconf() which is able to
// determine conclusively whether or not the feature is supported.
// Anything which is defined as other than -1 below **must** have
// complete headers, types, and function declarations as specified by
// the POSIX standard; however, if the relevant sysconf() function
// returns -1, the functions may be stubbed out.

// Define the POSIX.2 version we target for compliance.

// the sysconf(3) variable values are part of the ABI

// configurable system variables

// configurable system strings

type intptr_t = int64 /* unistd.h:320:21 */

//	$OpenBSD: fcntl.h,v 1.22 2019/01/21 18:09:21 anton Exp $
//	$NetBSD: fcntl.h,v 1.8 1995/03/26 20:24:12 jtc Exp $

// -
// Copyright (c) 1983, 1990, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)fcntl.h	8.3 (Berkeley) 1/21/94

// #define hook __builtin_printf("TRC %s:%i:\n", __func__, __LINE__);

// Size of the write buffer used by journal files in bytes.

// The maximum pathname length supported by this VFS.

// When using this VFS, the sqlite3_file* handles that SQLite uses are
// actually pointers to instances of type VFSFile.
type VFSFile1 = struct {
	base        sqlite3_file
	fsFile      uintptr
	fd          int32
	_           [4]byte
	aBuffer     uintptr
	nBuffer     int32
	_           [4]byte
	iBufferOfst sqlite3_int64
} /* vfs.c:154:9 */

//	$OpenBSD: fcntl.h,v 1.22 2019/01/21 18:09:21 anton Exp $
//	$NetBSD: fcntl.h,v 1.8 1995/03/26 20:24:12 jtc Exp $

// -
// Copyright (c) 1983, 1990, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)fcntl.h	8.3 (Berkeley) 1/21/94

// #define hook __builtin_printf("TRC %s:%i:\n", __func__, __LINE__);

// Size of the write buffer used by journal files in bytes.

// The maximum pathname length supported by this VFS.

// When using this VFS, the sqlite3_file* handles that SQLite uses are
// actually pointers to instances of type VFSFile.
type VFSFile = VFSFile1 /* vfs.c:154:24 */

// Write directly to the file passed as the first argument. Even if the
// file has a write-buffer (VFSFile.aBuffer), ignore it.
func vfsDirectWrite(tls *libc.TLS, p uintptr, zBuf uintptr, iAmt int32, iOfst sqlite_int64) int32 { /* vfs.c:169:12: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	var ofst off_t    // Return value from lseek()
	var nWrite size_t // Return value from write()

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__)), 178))
	libc.X__builtin_abort(tls)
	ofst = libc.Xlseek(tls, (*VFSFile)(unsafe.Pointer(p)).fd, iOfst, 0)
	if ofst != iOfst {
		return 10 | int32(3)<<8
	}

	nWrite = size_t(libc.Xwrite(tls, (*VFSFile)(unsafe.Pointer(p)).fd, zBuf, uint64(iAmt)))
	if nWrite != size_t(iAmt) {
		return 10 | int32(3)<<8
	}

	return 0
}

var __func__ = *(*[15]int8)(unsafe.Pointer(ts + 13)) /* vfs.c:174:2 */

// Flush the contents of the VFSFile.aBuffer buffer to disk. This is a
// no-op if this particular file does not have a buffer (i.e. it is not
// a journal file) or if the buffer is currently empty.
func vfsFlushBuffer(tls *libc.TLS, p uintptr) int32 { /* vfs.c:197:12: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__1)), 198))
	libc.X__builtin_abort(tls)
	var rc int32 = 0
	if (*VFSFile)(unsafe.Pointer(p)).nBuffer != 0 {
		rc = vfsDirectWrite(tls, p, (*VFSFile)(unsafe.Pointer(p)).aBuffer, (*VFSFile)(unsafe.Pointer(p)).nBuffer, (*VFSFile)(unsafe.Pointer(p)).iBufferOfst)
		(*VFSFile)(unsafe.Pointer(p)).nBuffer = 0
	}
	return rc
}

var __func__1 = *(*[15]int8)(unsafe.Pointer(ts + 28)) /* vfs.c:197:38 */

// Write data to a crash-file.
func vfsWrite(tls *libc.TLS, pFile uintptr, zBuf uintptr, iAmt int32, iOfst sqlite_int64) int32 { /* vfs.c:267:12: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__4)), 273))
	libc.X__builtin_abort(tls)
	var p uintptr = pFile

	if (*VFSFile)(unsafe.Pointer(p)).aBuffer != 0 {
		var z uintptr = zBuf        // Pointer to remaining data to write
		var n int32 = iAmt          // Number of bytes at z
		var i sqlite3_int64 = iOfst // File offset to write to

		for n > 0 {
			var nCopy int32 // Number of bytes to copy into buffer

			// If the buffer is full, or if this data is not being written directly
			// following the data already buffered, flush the buffer. Flushing
			// the buffer is a no-op if it is empty.
			if (*VFSFile)(unsafe.Pointer(p)).nBuffer == 8192 || (*VFSFile)(unsafe.Pointer(p)).iBufferOfst+sqlite3_int64((*VFSFile)(unsafe.Pointer(p)).nBuffer) != i {
				var rc int32 = vfsFlushBuffer(tls, p)
				if rc != 0 {
					return rc
				}
			}
			if !((*VFSFile)(unsafe.Pointer(p)).nBuffer == 0 || (*VFSFile)(unsafe.Pointer(p)).iBufferOfst+sqlite3_int64((*VFSFile)(unsafe.Pointer(p)).nBuffer) == i) {
				libc.X__assert2(tls, ts+43, 294, uintptr(unsafe.Pointer(&__func__4)), ts+51)
			}
			(*VFSFile)(unsafe.Pointer(p)).iBufferOfst = i - sqlite3_int64((*VFSFile)(unsafe.Pointer(p)).nBuffer)

			// Copy as much data as possible into the buffer.
			nCopy = 8192 - (*VFSFile)(unsafe.Pointer(p)).nBuffer
			if nCopy > n {
				nCopy = n
			}
			libc.Xmemcpy(tls, (*VFSFile)(unsafe.Pointer(p)).aBuffer+uintptr((*VFSFile)(unsafe.Pointer(p)).nBuffer), z, uint64(nCopy))
			*(*int32)(unsafe.Pointer(p + 32)) += nCopy

			n = n - nCopy
			i = i + sqlite3_int64(nCopy)
			z += uintptr(nCopy)
		}
	} else {
		return vfsDirectWrite(tls, p, zBuf, iAmt, iOfst)
	}

	return 0
}

var __func__4 = *(*[9]int8)(unsafe.Pointer(ts + 97)) /* vfs.c:272:2 */

// Truncate a file. This is a no-op for this VFS (see header comments at
// the top of the file).
func vfsTruncate(tls *libc.TLS, pFile uintptr, size sqlite_int64) int32 { /* vfs.c:320:12: */
	return 0
}

// Sync the contents of the file to the persistent media.
func vfsSync(tls *libc.TLS, pFile uintptr, flags int32) int32 { /* vfs.c:330:12: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__5)), 331))
	libc.X__builtin_abort(tls)
	var p uintptr = pFile
	var rc int32

	rc = vfsFlushBuffer(tls, p)
	if rc != 0 {
		return rc
	}

	rc = libc.Xfsync(tls, (*VFSFile)(unsafe.Pointer(p)).fd)
	return func() int32 {
		if rc == 0 {
			return 0
		}
		return 10 | int32(4)<<8
	}()
}

var __func__5 = *(*[8]int8)(unsafe.Pointer(ts + 106)) /* vfs.c:330:51 */

// Locking functions. The xLock() and xUnlock() methods are both no-ops.
// The xCheckReservedLock() always indicates that no other process holds
// a reserved lock on the database file. This ensures that if a hot-journal
// file is found in the file-system it is rolled back.
func vfsLock(tls *libc.TLS, pFile uintptr, eLock int32) int32 { /* vfs.c:375:12: */
	return 0
}

func vfsUnlock(tls *libc.TLS, pFile uintptr, eLock int32) int32 { /* vfs.c:378:12: */
	return 0
}

func vfsCheckReservedLock(tls *libc.TLS, pFile uintptr, pResOut uintptr) int32 { /* vfs.c:381:12: */
	*(*int32)(unsafe.Pointer(pResOut)) = 0
	return 0
}

// No xFileControl() verbs are implemented by this VFS.
func vfsFileControl(tls *libc.TLS, pFile uintptr, op int32, pArg uintptr) int32 { /* vfs.c:389:12: */
	return 12
}

// The xSectorSize() and xDeviceCharacteristics() methods. These two
// may return special values allowing SQLite to optimize file-system
// access to some extent. But it is also safe to simply return 0.
func vfsSectorSize(tls *libc.TLS, pFile uintptr) int32 { /* vfs.c:398:12: */
	return 0
}

func vfsDeviceCharacteristics(tls *libc.TLS, pFile uintptr) int32 { /* vfs.c:401:12: */
	return 0
}

// Delete the file identified by argument zPath. If the dirSync parameter
// is non-zero, then ensure the file-system modification to delete the
// file has been synced to disk before returning.
func vfsDelete(tls *libc.TLS, pVfs uintptr, zPath uintptr, dirSync int32) int32 { /* vfs.c:472:12: */
	bp := tls.Alloc(4129)
	defer tls.Free(4129)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__8)), 473))
	libc.X__builtin_abort(tls)
	var rc int32 // Return code

	rc = libc.Xunlink(tls, zPath)
	if rc != 0 && *(*int32)(unsafe.Pointer(libc.X__errno(tls))) == 2 {
		return 0
	}

	if rc == 0 && dirSync != 0 {
		var dfd int32 // File descriptor open on directory
		var i int32   // Iterator variable
		// var zDir [4097]int8 at bp+32, 4097
		// Name of directory containing file zPath

		// Figure out the directory name from the path of the file deleted.
		sqlite3.Xsqlite3_snprintf(tls, 4096, bp+32, ts+114, libc.VaList(bp+16, zPath))
		*(*int8)(unsafe.Pointer(bp + 32 + 4096)) = int8(0)
		for i = int32(libc.Xstrlen(tls, bp+32)); i > 1 && int32(*(*int8)(unsafe.Pointer(bp + 32 /* &zDir[0] */ + uintptr(i)))) != '/'; i++ {
		}
		*(*int8)(unsafe.Pointer(bp + 32 + uintptr(i))) = int8(0)

		// Open a file-descriptor on the directory. Sync. Close.
		dfd = libc.Xopen(tls, bp+32, 0x0000, libc.VaList(bp+24, 0))
		if dfd < 0 {
			rc = -1
		} else {
			rc = libc.Xfsync(tls, dfd)
			libc.Xclose(tls, dfd)
		}
	}
	return func() int32 {
		if rc == 0 {
			return 0
		}
		return 10 | int32(10)<<8
	}()
}

var __func__8 = *(*[10]int8)(unsafe.Pointer(ts + 117)) /* vfs.c:472:72 */

// The following four VFS methods:
//
//	xDlOpen
//	xDlError
//	xDlSym
//	xDlClose
//
// are supposed to implement the functionality needed by SQLite to load
// extensions compiled as shared objects. This simple VFS does not support
// this functionality, so the following functions are no-ops.
func vfsDlOpen(tls *libc.TLS, pVfs uintptr, zPath uintptr) uintptr { /* vfs.c:583:13: */
	return uintptr(0)
}

func vfsDlError(tls *libc.TLS, pVfs uintptr, nByte int32, zErrMsg uintptr) { /* vfs.c:586:13: */
	sqlite3.Xsqlite3_snprintf(tls, nByte, zErrMsg, ts+127, 0)
	*(*int8)(unsafe.Pointer(zErrMsg + uintptr(nByte-1))) = int8(0)
}

func vfsDlSym(tls *libc.TLS, pVfs uintptr, pH uintptr, z uintptr) uintptr { /* vfs.c:590:13: */
	return uintptr(0)
}

func vfsDlClose(tls *libc.TLS, pVfs uintptr, pHandle uintptr) { /* vfs.c:593:13: */
	return
}

// Parameter zByte points to a buffer nByte bytes in size. Populate this
// buffer with pseudo-random data.
func vfsRandomness(tls *libc.TLS, pVfs uintptr, nByte int32, zByte uintptr) int32 { /* vfs.c:601:12: */
	return 0
}

// Sleep for at least nMicro microseconds. Return the (approximate) number
// of microseconds slept for.
func vfsSleep(tls *libc.TLS, pVfs uintptr, nMicro int32) int32 { /* vfs.c:609:12: */
	libc.Xsleep(tls, uint32(nMicro/1000000))
	libc.Xusleep(tls, uint32(nMicro%1000000))
	return nMicro
}

// Set *pTime to the current UTC time expressed as a Julian day. Return
// SQLITE_OK if successful, or an error code otherwise.
//
//	http://en.wikipedia.org/wiki/Julian_day
//
// This implementation is not very good. The current time is rounded to
// an integer number of seconds. Also, assuming time_t is a signed 32-bit
// value, it will stop working some time in the year 2038 AD (the so-called
// "year 2038" problem that afflicts systems that store time this way).
func vfsCurrentTime(tls *libc.TLS, pVfs uintptr, pTime uintptr) int32 { /* vfs.c:626:12: */
	var t time_t = libc.Xtime(tls, uintptr(0))
	*(*float64)(unsafe.Pointer(pTime)) = float64(t)/86400.0 + 2440587.5
	return 0
}

// This function returns a pointer to the VFS implemented in this file.
// To make the VFS available to SQLite:
//
//	sqlite3_vfs_register(sqlite3_fsFS(), 0);
func Xsqlite3_fsFS(tls *libc.TLS, zName uintptr, pAppData uintptr) uintptr { /* vfs.c:638:13: */
	var p uintptr = sqlite3.Xsqlite3_malloc(tls, int32(unsafe.Sizeof(sqlite3_vfs{})))
	if !(p != 0) {
		return uintptr(0)
	}

	*(*sqlite3_vfs)(unsafe.Pointer(p)) = sqlite3_vfs{
		iVersion:   1,                               // iVersion
		szOsFile:   int32(unsafe.Sizeof(VFSFile{})), // szOsFile
		mxPathname: 4096,                            // pNext
		zName:      zName,                           // zName
		pAppData:   pAppData,                        // pAppData
		xOpen: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, uintptr, int32, uintptr) int32
		}{vfsOpen})), // xOpen
		xDelete: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, int32) int32
		}{vfsDelete})), // xDelete
		xAccess: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, int32, uintptr) int32
		}{vfsAccess})), // xAccess
		xFullPathname: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, int32, uintptr) int32
		}{vfsFullPathname})), // xFullPathname
		xDlOpen: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr) uintptr
		}{vfsDlOpen})), // xDlOpen
		xDlError: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, int32, uintptr)
		}{vfsDlError})), // xDlError
		xDlSym: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, uintptr) uintptr
		}{vfsDlSym})), // xDlSym
		xDlClose: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr)
		}{vfsDlClose})), // xDlClose
		xRandomness: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, int32, uintptr) int32
		}{vfsRandomness})), // xRandomness
		xSleep: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, int32) int32
		}{vfsSleep})), // xSleep
		xCurrentTime: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr) int32
		}{vfsCurrentTime}))}
	return p
}

var ts1 = "TODO %s:%i:\n\x00vfsDirectWrite\x00vfsFlushBuffer\x00c/vfs.c\x00p->nBuffer==0 || p->iBufferOfst+p->nBuffer==i\x00vfsWrite\x00vfsSync\x00%s\x00vfsDelete\x00Loadable extensions are not supported\x00"
var ts = (*reflect.StringHeader)(unsafe.Pointer(&ts1)).Data
