/*
Package utestschema is a generated package which contains definitions
of structs which represent a YANG schema. The generated schema can be
compressed by a series of transformations (compression was false
in this case).

This package was generated by /usr/local/google/home/wenbli/gocode/src/github.com/openconfig/ygot/genutil/names.go
using the following YANG input files:
  - ../yang/utestschema.yang
  - ../yang/refschema.yang
  - ../yang/ctestschema.yang
  - ../yang/ctestschema-rootmod.yang

Imported modules were sourced from:
  - ...
*/
package utestschema

import (
	"encoding/json"
	"fmt"
	"reflect"

	"github.com/openconfig/goyang/pkg/yang"
	"github.com/openconfig/ygot/ygot"
	"github.com/openconfig/ygot/ytypes"
)

// Binary is a type that is used for fields that have a YANG type of
// binary. It is used such that binary fields can be distinguished from
// leaf-lists of uint8s (which are mapped to []uint8, equivalent to
// []byte in reflection).
type Binary []byte

// YANGEmpty is a type that is used for fields that have a YANG type of
// empty. It is used such that empty fields can be distinguished from boolean fields
// in the generated code.
type YANGEmpty bool

// UnionInt8 is an int8 type assignable to unions of which it is a subtype.
type UnionInt8 int8

// UnionInt16 is an int16 type assignable to unions of which it is a subtype.
type UnionInt16 int16

// UnionInt32 is an int32 type assignable to unions of which it is a subtype.
type UnionInt32 int32

// UnionInt64 is an int64 type assignable to unions of which it is a subtype.
type UnionInt64 int64

// UnionUint8 is a uint8 type assignable to unions of which it is a subtype.
type UnionUint8 uint8

// UnionUint16 is a uint16 type assignable to unions of which it is a subtype.
type UnionUint16 uint16

// UnionUint32 is a uint32 type assignable to unions of which it is a subtype.
type UnionUint32 uint32

// UnionUint64 is a uint64 type assignable to unions of which it is a subtype.
type UnionUint64 uint64

// UnionFloat64 is a float64 type assignable to unions of which it is a subtype.
type UnionFloat64 float64

// UnionString is a string type assignable to unions of which it is a subtype.
type UnionString string

// UnionBool is a bool type assignable to unions of which it is a subtype.
type UnionBool bool

// UnionUnsupported is an interface{} wrapper type for unsupported types. It is
// assignable to unions of which it is a subtype.
type UnionUnsupported struct {
	Value interface{}
}

var (
	SchemaTree map[string]*yang.Entry
	ΛEnumTypes map[string][]reflect.Type
)

func init() {
	var err error
	initΛEnumTypes()
	if SchemaTree, err = UnzipSchema(); err != nil {
		panic("schema error: " + err.Error())
	}
}

// Schema returns the details of the generated schema.
func Schema() (*ytypes.Schema, error) {
	uzp, err := UnzipSchema()
	if err != nil {
		return nil, fmt.Errorf("cannot unzip schema, %v", err)
	}

	return &ytypes.Schema{
		Root:       &Device{},
		SchemaTree: uzp,
		Unmarshal:  Unmarshal,
	}, nil
}

// UnzipSchema unzips the zipped schema and returns a map of yang.Entry nodes,
// keyed by the name of the struct that the yang.Entry describes the schema for.
func UnzipSchema() (map[string]*yang.Entry, error) {
	var schemaTree map[string]*yang.Entry
	var err error
	if schemaTree, err = ygot.GzipToSchema(ySchema); err != nil {
		return nil, fmt.Errorf("could not unzip the schema; %v", err)
	}
	return schemaTree, nil
}

// Unmarshal unmarshals data, which must be RFC7951 JSON format, into
// destStruct, which must be non-nil and the correct GoStruct type. It returns
// an error if the destStruct is not found in the schema or the data cannot be
// unmarshaled. The supplied options (opts) are used to control the behaviour
// of the unmarshal function - for example, determining whether errors are
// thrown for unknown fields in the input JSON.
func Unmarshal(data []byte, destStruct ygot.GoStruct, opts ...ytypes.UnmarshalOpt) error {
	tn := reflect.TypeOf(destStruct).Elem().Name()
	schema, ok := SchemaTree[tn]
	if !ok {
		return fmt.Errorf("could not find schema for type %s", tn)
	}
	var jsonTree interface{}
	if err := json.Unmarshal([]byte(data), &jsonTree); err != nil {
		return err
	}
	return ytypes.Unmarshal(schema, destStruct, jsonTree, opts...)
}

// CtestschemaRootmod_OrderedMultikeyedLists represents the /ctestschema-rootmod/ordered-multikeyed-lists YANG schema element.
type CtestschemaRootmod_OrderedMultikeyedLists struct {
	ΛMetadata              []ygot.Annotation                                                           `path:"@" ygotAnnotation:"true"`
	OrderedMultikeyedList  *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap `path:"ordered-multikeyed-list" module:"ctestschema"`
	ΛOrderedMultikeyedList []ygot.Annotation                                                           `path:"@ordered-multikeyed-list" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that CtestschemaRootmod_OrderedMultikeyedLists implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*CtestschemaRootmod_OrderedMultikeyedLists) IsYANGGoStruct() {}

// CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key represents the key for list OrderedMultikeyedList of element /ctestschema-rootmod/ordered-multikeyed-lists.
type CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key struct {
	Key1 string `path:"key1"`
	Key2 uint64 `path:"key2"`
}

// IsYANGGoKeyStruct ensures that CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key key struct.
func (t CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"key1": t.Key1,
		"key2": t.Key2,
	}, nil
}

// GetOrCreateOrderedMultikeyedListMap returns the ordered map field
// OrderedMultikeyedList from CtestschemaRootmod_OrderedMultikeyedLists.
//
// It initializes the field if not already initialized.
func (s *CtestschemaRootmod_OrderedMultikeyedLists) GetOrCreateOrderedMultikeyedListMap() *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap {
	if s.OrderedMultikeyedList == nil {
		s.OrderedMultikeyedList = &CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap{}
	}
	return s.OrderedMultikeyedList
}

// AppendNewOrderedMultikeyedList creates a new entry in the OrderedMultikeyedList
// ordered map of the CtestschemaRootmod_OrderedMultikeyedLists struct. The keys of the list are
// populated from the input arguments.
func (s *CtestschemaRootmod_OrderedMultikeyedLists) AppendNewOrderedMultikeyedList(Key1 string, Key2 uint64) (*CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList, error) {
	if s.OrderedMultikeyedList == nil {
		s.OrderedMultikeyedList = &CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap{}
	}
	return s.OrderedMultikeyedList.AppendNew(Key1, Key2)
}

// AppendOrderedMultikeyedList appends the supplied CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList struct
// to the list OrderedMultikeyedList of CtestschemaRootmod_OrderedMultikeyedLists. If the key value(s)
// specified in the supplied CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList already exist in the list, an
// error is returned.
func (s *CtestschemaRootmod_OrderedMultikeyedLists) AppendOrderedMultikeyedList(v *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList) error {
	if s.OrderedMultikeyedList == nil {
		s.OrderedMultikeyedList = &CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap{}
	}
	return s.OrderedMultikeyedList.Append(v)
}

// GetOrderedMultikeyedList retrieves the value with the specified key from the
// OrderedMultikeyedList map field of CtestschemaRootmod_OrderedMultikeyedLists. If the receiver
// is nil, or the specified key is not present in the list, nil is returned
// such that Get* methods may be safely chained.
func (s *CtestschemaRootmod_OrderedMultikeyedLists) GetOrderedMultikeyedList(Key1 string, Key2 uint64) *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList {
	if s == nil {
		return nil
	}
	key := CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key{
		Key1: Key1,
		Key2: Key2,
	}
	return s.OrderedMultikeyedList.Get(key)
}

// DeleteOrderedMultikeyedList deletes the value with the specified keys from
// the receiver CtestschemaRootmod_OrderedMultikeyedLists. If there is no such element, the
// function is a no-op.
func (s *CtestschemaRootmod_OrderedMultikeyedLists) DeleteOrderedMultikeyedList(Key1 string, Key2 uint64) bool {
	key := CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key{
		Key1: Key1,
		Key2: Key2,
	}
	return s.OrderedMultikeyedList.Delete(key)
}

// CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap is an ordered map that represents the "ordered-by user"
// list elements at /ctestschema-rootmod/ordered-multikeyed-lists/ordered-multikeyed-list.
type CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap struct {
	keys     []CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key
	valueMap map[CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key]*CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList
}

// IsYANGOrderedList ensures that CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap implements the
// ygot.GoOrderedMap interface.
func (*CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap) IsYANGOrderedList() {
}

// init initializes any uninitialized values.
func (o *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap) init() {
	if o == nil {
		return
	}
	if o.valueMap == nil {
		o.valueMap = map[CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key]*CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList{}
	}
}

// Keys returns a copy of the list's keys.
func (o *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap) Keys() []CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key {
	if o == nil {
		return nil
	}
	return append([]CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key{}, o.keys...)
}

// Values returns the current set of the list's values in order.
func (o *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap) Values() []*CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList {
	if o == nil {
		return nil
	}
	var values []*CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList
	for _, key := range o.keys {
		values = append(values, o.valueMap[key])
	}
	return values
}

// Len returns a size of CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap
func (o *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap) Len() int {
	if o == nil {
		return 0
	}
	return len(o.keys)
}

// Get returns the value corresponding to the key. If the key is not found, nil
// is returned.
func (o *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap) Get(key CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key) *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList {
	if o == nil {
		return nil
	}
	val, _ := o.valueMap[key]
	return val
}

// Delete deletes an element.
func (o *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap) Delete(key CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key) bool {
	if o == nil {
		return false
	}
	if _, ok := o.valueMap[key]; !ok {
		return false
	}
	for i, k := range o.keys {
		if k == key {
			o.keys = append(o.keys[:i], o.keys[i+1:]...)
			delete(o.valueMap, key)
			return true
		}
	}
	return false
}

// Append appends a CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList, returning an error if the key
// already exists in the ordered list or if the key is unspecified.
func (o *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap) Append(v *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList) error {
	if o == nil {
		return fmt.Errorf("nil ordered map, cannot append CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList")
	}
	if v == nil {
		return fmt.Errorf("nil CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList")
	}
	if v.Key1 == nil {
		return fmt.Errorf("invalid nil key for Key1")
	}
	if v.Key2 == nil {
		return fmt.Errorf("invalid nil key for Key2")
	}
	key := CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key{
		Key1: *v.Key1,
		Key2: *v.Key2,
	}

	if _, ok := o.valueMap[key]; ok {
		return fmt.Errorf("duplicate key for list Statement %v", key)
	}
	o.keys = append(o.keys, key)
	o.init()
	o.valueMap[key] = v
	return nil
}

// AppendNew creates and appends a new CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList, returning the
// newly-initialized v. It returns an error if the v already exists.
func (o *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_OrderedMap) AppendNew(Key1 string, Key2 uint64) (*CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList, error) {
	if o == nil {
		return nil, fmt.Errorf("nil ordered map, cannot append CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList")
	}
	key := CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Key{
		Key1: Key1,
		Key2: Key2,
	}

	if _, ok := o.valueMap[key]; ok {
		return nil, fmt.Errorf("duplicate key for list Statement %v", key)
	}
	o.keys = append(o.keys, key)
	newElement := &CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList{
		Key1: &Key1,
		Key2: &Key2,
	}
	o.init()
	o.valueMap[key] = newElement
	return newElement, nil
}

// PopulateDefaults recursively populates unset leaf fields in the CtestschemaRootmod_OrderedMultikeyedLists
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *CtestschemaRootmod_OrderedMultikeyedLists) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.OrderedMultikeyedList.Values() {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *CtestschemaRootmod_OrderedMultikeyedLists) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["CtestschemaRootmod_OrderedMultikeyedLists"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *CtestschemaRootmod_OrderedMultikeyedLists) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *CtestschemaRootmod_OrderedMultikeyedLists) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of CtestschemaRootmod_OrderedMultikeyedLists.
func (*CtestschemaRootmod_OrderedMultikeyedLists) ΛBelongingModule() string {
	return "ctestschema-rootmod"
}

// CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList represents the /ctestschema-rootmod/ordered-multikeyed-lists/ordered-multikeyed-list YANG schema element.
type CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList struct {
	ΛMetadata []ygot.Annotation                                                       `path:"@" ygotAnnotation:"true"`
	Config    *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config `path:"config" module:"ctestschema"`
	ΛConfig   []ygot.Annotation                                                       `path:"@config" ygotAnnotation:"true"`
	Key1      *string                                                                 `path:"key1" module:"ctestschema"`
	ΛKey1     []ygot.Annotation                                                       `path:"@key1" ygotAnnotation:"true"`
	Key2      *uint64                                                                 `path:"key2" module:"ctestschema"`
	ΛKey2     []ygot.Annotation                                                       `path:"@key2" ygotAnnotation:"true"`
	State     *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State  `path:"state" module:"ctestschema"`
	ΛState    []ygot.Annotation                                                       `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList) GetOrCreateConfig() *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList) GetOrCreateState() *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State {
	if t.State != nil {
		return t.State
	}
	t.State = &CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList) GetConfig() *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList) GetState() *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetKey1 retrieves the value of the leaf Key1 from the CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key1 is set, it can
// safely use t.GetKey1() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key1 == nil' before retrieving the leaf's value.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList) GetKey1() string {
	if t == nil || t.Key1 == nil {
		return ""
	}
	return *t.Key1
}

// GetKey2 retrieves the value of the leaf Key2 from the CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key2 is set, it can
// safely use t.GetKey2() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key2 == nil' before retrieving the leaf's value.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList) GetKey2() uint64 {
	if t == nil || t.Key2 == nil {
		return 0
	}
	return *t.Key2
}

// PopulateDefaults recursively populates unset leaf fields in the CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList struct, which is a YANG list entry.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Key1 == nil {
		return nil, fmt.Errorf("nil value for key Key1")
	}

	if t.Key2 == nil {
		return nil, fmt.Errorf("nil value for key Key2")
	}

	return map[string]interface{}{
		"key1": *t.Key1,
		"key2": *t.Key2,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList.
func (*CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList) ΛBelongingModule() string {
	return "ctestschema"
}

// CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config represents the /ctestschema-rootmod/ordered-multikeyed-lists/ordered-multikeyed-list/config YANG schema element.
type CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Key1      *string           `path:"key1" module:"ctestschema"`
	ΛKey1     []ygot.Annotation `path:"@key1" ygotAnnotation:"true"`
	Key2      *uint64           `path:"key2" module:"ctestschema"`
	ΛKey2     []ygot.Annotation `path:"@key2" ygotAnnotation:"true"`
	Value     *string           `path:"value" module:"ctestschema"`
	ΛValue    []ygot.Annotation `path:"@value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config) IsYANGGoStruct() {}

// GetKey1 retrieves the value of the leaf Key1 from the CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key1 is set, it can
// safely use t.GetKey1() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key1 == nil' before retrieving the leaf's value.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config) GetKey1() string {
	if t == nil || t.Key1 == nil {
		return ""
	}
	return *t.Key1
}

// GetKey2 retrieves the value of the leaf Key2 from the CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key2 is set, it can
// safely use t.GetKey2() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key2 == nil' before retrieving the leaf's value.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config) GetKey2() uint64 {
	if t == nil || t.Key2 == nil {
		return 0
	}
	return *t.Key2
}

// GetValue retrieves the value of the leaf Value from the CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Value is set, it can
// safely use t.GetValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Value == nil' before retrieving the leaf's value.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config) GetValue() string {
	if t == nil || t.Value == nil {
		return "default-multikeyed-value"
	}
	return *t.Value
}

// PopulateDefaults recursively populates unset leaf fields in the CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Value == nil {
		var v string = "default-multikeyed-value"
		t.Value = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config.
func (*CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_Config) ΛBelongingModule() string {
	return "ctestschema"
}

// CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State represents the /ctestschema-rootmod/ordered-multikeyed-lists/ordered-multikeyed-list/state YANG schema element.
type CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Key1      *string           `path:"key1" module:"ctestschema"`
	ΛKey1     []ygot.Annotation `path:"@key1" ygotAnnotation:"true"`
	Key2      *uint64           `path:"key2" module:"ctestschema"`
	ΛKey2     []ygot.Annotation `path:"@key2" ygotAnnotation:"true"`
	RoValue   *string           `path:"ro-value" module:"ctestschema"`
	ΛRoValue  []ygot.Annotation `path:"@ro-value" ygotAnnotation:"true"`
	Value     *string           `path:"value" module:"ctestschema"`
	ΛValue    []ygot.Annotation `path:"@value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State) IsYANGGoStruct() {}

// GetKey1 retrieves the value of the leaf Key1 from the CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key1 is set, it can
// safely use t.GetKey1() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key1 == nil' before retrieving the leaf's value.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State) GetKey1() string {
	if t == nil || t.Key1 == nil {
		return ""
	}
	return *t.Key1
}

// GetKey2 retrieves the value of the leaf Key2 from the CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key2 is set, it can
// safely use t.GetKey2() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key2 == nil' before retrieving the leaf's value.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State) GetKey2() uint64 {
	if t == nil || t.Key2 == nil {
		return 0
	}
	return *t.Key2
}

// GetRoValue retrieves the value of the leaf RoValue from the CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RoValue is set, it can
// safely use t.GetRoValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RoValue == nil' before retrieving the leaf's value.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State) GetRoValue() string {
	if t == nil || t.RoValue == nil {
		return ""
	}
	return *t.RoValue
}

// GetValue retrieves the value of the leaf Value from the CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Value is set, it can
// safely use t.GetValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Value == nil' before retrieving the leaf's value.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State) GetValue() string {
	if t == nil || t.Value == nil {
		return "default-multikeyed-value"
	}
	return *t.Value
}

// PopulateDefaults recursively populates unset leaf fields in the CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Value == nil {
		var v string = "default-multikeyed-value"
		t.Value = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State.
func (*CtestschemaRootmod_OrderedMultikeyedLists_OrderedMultikeyedList_State) ΛBelongingModule() string {
	return "ctestschema"
}

// Ctestschema_OrderedLists represents the /ctestschema/ordered-lists YANG schema element.
type Ctestschema_OrderedLists struct {
	ΛMetadata    []ygot.Annotation                                `path:"@" ygotAnnotation:"true"`
	OrderedList  *Ctestschema_OrderedLists_OrderedList_OrderedMap `path:"ordered-list" module:"ctestschema"`
	ΛOrderedList []ygot.Annotation                                `path:"@ordered-list" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Ctestschema_OrderedLists implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Ctestschema_OrderedLists) IsYANGGoStruct() {}

// GetOrCreateOrderedListMap returns the ordered map field
// OrderedList from Ctestschema_OrderedLists.
//
// It initializes the field if not already initialized.
func (s *Ctestschema_OrderedLists) GetOrCreateOrderedListMap() *Ctestschema_OrderedLists_OrderedList_OrderedMap {
	if s.OrderedList == nil {
		s.OrderedList = &Ctestschema_OrderedLists_OrderedList_OrderedMap{}
	}
	return s.OrderedList
}

// AppendNewOrderedList creates a new entry in the OrderedList
// ordered map of the Ctestschema_OrderedLists struct. The keys of the list are
// populated from the input arguments.
func (s *Ctestschema_OrderedLists) AppendNewOrderedList(Key string) (*Ctestschema_OrderedLists_OrderedList, error) {
	if s.OrderedList == nil {
		s.OrderedList = &Ctestschema_OrderedLists_OrderedList_OrderedMap{}
	}
	return s.OrderedList.AppendNew(Key)
}

// AppendOrderedList appends the supplied Ctestschema_OrderedLists_OrderedList struct
// to the list OrderedList of Ctestschema_OrderedLists. If the key value(s)
// specified in the supplied Ctestschema_OrderedLists_OrderedList already exist in the list, an
// error is returned.
func (s *Ctestschema_OrderedLists) AppendOrderedList(v *Ctestschema_OrderedLists_OrderedList) error {
	if s.OrderedList == nil {
		s.OrderedList = &Ctestschema_OrderedLists_OrderedList_OrderedMap{}
	}
	return s.OrderedList.Append(v)
}

// GetOrderedList retrieves the value with the specified key from the
// OrderedList map field of Ctestschema_OrderedLists. If the receiver
// is nil, or the specified key is not present in the list, nil is returned
// such that Get* methods may be safely chained.
func (s *Ctestschema_OrderedLists) GetOrderedList(Key string) *Ctestschema_OrderedLists_OrderedList {
	if s == nil {
		return nil
	}
	key := Key
	return s.OrderedList.Get(key)
}

// DeleteOrderedList deletes the value with the specified keys from
// the receiver Ctestschema_OrderedLists. If there is no such element, the
// function is a no-op.
func (s *Ctestschema_OrderedLists) DeleteOrderedList(Key string) bool {
	key := Key
	return s.OrderedList.Delete(key)
}

// Ctestschema_OrderedLists_OrderedList_OrderedMap is an ordered map that represents the "ordered-by user"
// list elements at /ctestschema/ordered-lists/ordered-list.
type Ctestschema_OrderedLists_OrderedList_OrderedMap struct {
	keys     []string
	valueMap map[string]*Ctestschema_OrderedLists_OrderedList
}

// IsYANGOrderedList ensures that Ctestschema_OrderedLists_OrderedList_OrderedMap implements the
// ygot.GoOrderedMap interface.
func (*Ctestschema_OrderedLists_OrderedList_OrderedMap) IsYANGOrderedList() {}

// init initializes any uninitialized values.
func (o *Ctestschema_OrderedLists_OrderedList_OrderedMap) init() {
	if o == nil {
		return
	}
	if o.valueMap == nil {
		o.valueMap = map[string]*Ctestschema_OrderedLists_OrderedList{}
	}
}

// Keys returns a copy of the list's keys.
func (o *Ctestschema_OrderedLists_OrderedList_OrderedMap) Keys() []string {
	if o == nil {
		return nil
	}
	return append([]string{}, o.keys...)
}

// Values returns the current set of the list's values in order.
func (o *Ctestschema_OrderedLists_OrderedList_OrderedMap) Values() []*Ctestschema_OrderedLists_OrderedList {
	if o == nil {
		return nil
	}
	var values []*Ctestschema_OrderedLists_OrderedList
	for _, key := range o.keys {
		values = append(values, o.valueMap[key])
	}
	return values
}

// Len returns a size of Ctestschema_OrderedLists_OrderedList_OrderedMap
func (o *Ctestschema_OrderedLists_OrderedList_OrderedMap) Len() int {
	if o == nil {
		return 0
	}
	return len(o.keys)
}

// Get returns the value corresponding to the key. If the key is not found, nil
// is returned.
func (o *Ctestschema_OrderedLists_OrderedList_OrderedMap) Get(key string) *Ctestschema_OrderedLists_OrderedList {
	if o == nil {
		return nil
	}
	val, _ := o.valueMap[key]
	return val
}

// Delete deletes an element.
func (o *Ctestschema_OrderedLists_OrderedList_OrderedMap) Delete(key string) bool {
	if o == nil {
		return false
	}
	if _, ok := o.valueMap[key]; !ok {
		return false
	}
	for i, k := range o.keys {
		if k == key {
			o.keys = append(o.keys[:i], o.keys[i+1:]...)
			delete(o.valueMap, key)
			return true
		}
	}
	return false
}

// Append appends a Ctestschema_OrderedLists_OrderedList, returning an error if the key
// already exists in the ordered list or if the key is unspecified.
func (o *Ctestschema_OrderedLists_OrderedList_OrderedMap) Append(v *Ctestschema_OrderedLists_OrderedList) error {
	if o == nil {
		return fmt.Errorf("nil ordered map, cannot append Ctestschema_OrderedLists_OrderedList")
	}
	if v == nil {
		return fmt.Errorf("nil Ctestschema_OrderedLists_OrderedList")
	}
	if v.Key == nil {
		return fmt.Errorf("invalid nil key received for Key")
	}

	key := *v.Key

	if _, ok := o.valueMap[key]; ok {
		return fmt.Errorf("duplicate key for list Statement %v", key)
	}
	o.keys = append(o.keys, key)
	o.init()
	o.valueMap[key] = v
	return nil
}

// AppendNew creates and appends a new Ctestschema_OrderedLists_OrderedList, returning the
// newly-initialized v. It returns an error if the v already exists.
func (o *Ctestschema_OrderedLists_OrderedList_OrderedMap) AppendNew(Key string) (*Ctestschema_OrderedLists_OrderedList, error) {
	if o == nil {
		return nil, fmt.Errorf("nil ordered map, cannot append Ctestschema_OrderedLists_OrderedList")
	}
	key := Key

	if _, ok := o.valueMap[key]; ok {
		return nil, fmt.Errorf("duplicate key for list Statement %v", key)
	}
	o.keys = append(o.keys, key)
	newElement := &Ctestschema_OrderedLists_OrderedList{
		Key: &Key,
	}
	o.init()
	o.valueMap[key] = newElement
	return newElement, nil
}

// PopulateDefaults recursively populates unset leaf fields in the Ctestschema_OrderedLists
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Ctestschema_OrderedLists) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.OrderedList.Values() {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Ctestschema_OrderedLists"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Ctestschema_OrderedLists) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Ctestschema_OrderedLists.
func (*Ctestschema_OrderedLists) ΛBelongingModule() string {
	return "ctestschema"
}

// Ctestschema_OrderedLists_OrderedList represents the /ctestschema/ordered-lists/ordered-list YANG schema element.
type Ctestschema_OrderedLists_OrderedList struct {
	ΛMetadata     []ygot.Annotation                                  `path:"@" ygotAnnotation:"true"`
	Config        *Ctestschema_OrderedLists_OrderedList_Config       `path:"config" module:"ctestschema"`
	ΛConfig       []ygot.Annotation                                  `path:"@config" ygotAnnotation:"true"`
	Key           *string                                            `path:"key" module:"ctestschema"`
	ΛKey          []ygot.Annotation                                  `path:"@key" ygotAnnotation:"true"`
	OrderedLists  *Ctestschema_OrderedLists_OrderedList_OrderedLists `path:"ordered-lists" module:"ctestschema"`
	ΛOrderedLists []ygot.Annotation                                  `path:"@ordered-lists" ygotAnnotation:"true"`
	State         *Ctestschema_OrderedLists_OrderedList_State        `path:"state" module:"ctestschema"`
	ΛState        []ygot.Annotation                                  `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Ctestschema_OrderedLists_OrderedList implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Ctestschema_OrderedLists_OrderedList) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *Ctestschema_OrderedLists_OrderedList) GetOrCreateConfig() *Ctestschema_OrderedLists_OrderedList_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &Ctestschema_OrderedLists_OrderedList_Config{}
	return t.Config
}

// GetOrCreateOrderedLists retrieves the value of the OrderedLists field
// or returns the existing field if it already exists.
func (t *Ctestschema_OrderedLists_OrderedList) GetOrCreateOrderedLists() *Ctestschema_OrderedLists_OrderedList_OrderedLists {
	if t.OrderedLists != nil {
		return t.OrderedLists
	}
	t.OrderedLists = &Ctestschema_OrderedLists_OrderedList_OrderedLists{}
	return t.OrderedLists
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *Ctestschema_OrderedLists_OrderedList) GetOrCreateState() *Ctestschema_OrderedLists_OrderedList_State {
	if t.State != nil {
		return t.State
	}
	t.State = &Ctestschema_OrderedLists_OrderedList_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from Ctestschema_OrderedLists_OrderedList. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Ctestschema_OrderedLists_OrderedList) GetConfig() *Ctestschema_OrderedLists_OrderedList_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetOrderedLists returns the value of the OrderedLists struct pointer
// from Ctestschema_OrderedLists_OrderedList. If the receiver or the field OrderedLists is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Ctestschema_OrderedLists_OrderedList) GetOrderedLists() *Ctestschema_OrderedLists_OrderedList_OrderedLists {
	if t != nil && t.OrderedLists != nil {
		return t.OrderedLists
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from Ctestschema_OrderedLists_OrderedList. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Ctestschema_OrderedLists_OrderedList) GetState() *Ctestschema_OrderedLists_OrderedList_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetKey retrieves the value of the leaf Key from the Ctestschema_OrderedLists_OrderedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key is set, it can
// safely use t.GetKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key == nil' before retrieving the leaf's value.
func (t *Ctestschema_OrderedLists_OrderedList) GetKey() string {
	if t == nil || t.Key == nil {
		return ""
	}
	return *t.Key
}

// PopulateDefaults recursively populates unset leaf fields in the Ctestschema_OrderedLists_OrderedList
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Ctestschema_OrderedLists_OrderedList) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.OrderedLists.PopulateDefaults()
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the Ctestschema_OrderedLists_OrderedList struct, which is a YANG list entry.
func (t *Ctestschema_OrderedLists_OrderedList) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Key == nil {
		return nil, fmt.Errorf("nil value for key Key")
	}

	return map[string]interface{}{
		"key": *t.Key,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists_OrderedList) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Ctestschema_OrderedLists_OrderedList"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists_OrderedList) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Ctestschema_OrderedLists_OrderedList) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Ctestschema_OrderedLists_OrderedList.
func (*Ctestschema_OrderedLists_OrderedList) ΛBelongingModule() string {
	return "ctestschema"
}

// Ctestschema_OrderedLists_OrderedList_Config represents the /ctestschema/ordered-lists/ordered-list/config YANG schema element.
type Ctestschema_OrderedLists_OrderedList_Config struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Key       *string           `path:"key" module:"ctestschema"`
	ΛKey      []ygot.Annotation `path:"@key" ygotAnnotation:"true"`
	Value     *string           `path:"value" module:"ctestschema"`
	ΛValue    []ygot.Annotation `path:"@value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Ctestschema_OrderedLists_OrderedList_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Ctestschema_OrderedLists_OrderedList_Config) IsYANGGoStruct() {}

// GetKey retrieves the value of the leaf Key from the Ctestschema_OrderedLists_OrderedList_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key is set, it can
// safely use t.GetKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key == nil' before retrieving the leaf's value.
func (t *Ctestschema_OrderedLists_OrderedList_Config) GetKey() string {
	if t == nil || t.Key == nil {
		return ""
	}
	return *t.Key
}

// GetValue retrieves the value of the leaf Value from the Ctestschema_OrderedLists_OrderedList_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Value is set, it can
// safely use t.GetValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Value == nil' before retrieving the leaf's value.
func (t *Ctestschema_OrderedLists_OrderedList_Config) GetValue() string {
	if t == nil || t.Value == nil {
		return "default-value"
	}
	return *t.Value
}

// PopulateDefaults recursively populates unset leaf fields in the Ctestschema_OrderedLists_OrderedList_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Ctestschema_OrderedLists_OrderedList_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Value == nil {
		var v string = "default-value"
		t.Value = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists_OrderedList_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Ctestschema_OrderedLists_OrderedList_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists_OrderedList_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Ctestschema_OrderedLists_OrderedList_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Ctestschema_OrderedLists_OrderedList_Config.
func (*Ctestschema_OrderedLists_OrderedList_Config) ΛBelongingModule() string {
	return "ctestschema"
}

// Ctestschema_OrderedLists_OrderedList_OrderedLists represents the /ctestschema/ordered-lists/ordered-list/ordered-lists YANG schema element.
type Ctestschema_OrderedLists_OrderedList_OrderedLists struct {
	ΛMetadata    []ygot.Annotation                                                         `path:"@" ygotAnnotation:"true"`
	OrderedList  *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap `path:"ordered-list" module:"ctestschema"`
	ΛOrderedList []ygot.Annotation                                                         `path:"@ordered-list" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Ctestschema_OrderedLists_OrderedList_OrderedLists implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Ctestschema_OrderedLists_OrderedList_OrderedLists) IsYANGGoStruct() {}

// GetOrCreateOrderedListMap returns the ordered map field
// OrderedList from Ctestschema_OrderedLists_OrderedList_OrderedLists.
//
// It initializes the field if not already initialized.
func (s *Ctestschema_OrderedLists_OrderedList_OrderedLists) GetOrCreateOrderedListMap() *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap {
	if s.OrderedList == nil {
		s.OrderedList = &Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap{}
	}
	return s.OrderedList
}

// AppendNewOrderedList creates a new entry in the OrderedList
// ordered map of the Ctestschema_OrderedLists_OrderedList_OrderedLists struct. The keys of the list are
// populated from the input arguments.
func (s *Ctestschema_OrderedLists_OrderedList_OrderedLists) AppendNewOrderedList(Key string) (*Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList, error) {
	if s.OrderedList == nil {
		s.OrderedList = &Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap{}
	}
	return s.OrderedList.AppendNew(Key)
}

// AppendOrderedList appends the supplied Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList struct
// to the list OrderedList of Ctestschema_OrderedLists_OrderedList_OrderedLists. If the key value(s)
// specified in the supplied Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList already exist in the list, an
// error is returned.
func (s *Ctestschema_OrderedLists_OrderedList_OrderedLists) AppendOrderedList(v *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList) error {
	if s.OrderedList == nil {
		s.OrderedList = &Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap{}
	}
	return s.OrderedList.Append(v)
}

// GetOrderedList retrieves the value with the specified key from the
// OrderedList map field of Ctestschema_OrderedLists_OrderedList_OrderedLists. If the receiver
// is nil, or the specified key is not present in the list, nil is returned
// such that Get* methods may be safely chained.
func (s *Ctestschema_OrderedLists_OrderedList_OrderedLists) GetOrderedList(Key string) *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList {
	if s == nil {
		return nil
	}
	key := Key
	return s.OrderedList.Get(key)
}

// DeleteOrderedList deletes the value with the specified keys from
// the receiver Ctestschema_OrderedLists_OrderedList_OrderedLists. If there is no such element, the
// function is a no-op.
func (s *Ctestschema_OrderedLists_OrderedList_OrderedLists) DeleteOrderedList(Key string) bool {
	key := Key
	return s.OrderedList.Delete(key)
}

// Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap is an ordered map that represents the "ordered-by user"
// list elements at /ctestschema/ordered-lists/ordered-list/ordered-lists/ordered-list.
type Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap struct {
	keys     []string
	valueMap map[string]*Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList
}

// IsYANGOrderedList ensures that Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap implements the
// ygot.GoOrderedMap interface.
func (*Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap) IsYANGOrderedList() {
}

// init initializes any uninitialized values.
func (o *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap) init() {
	if o == nil {
		return
	}
	if o.valueMap == nil {
		o.valueMap = map[string]*Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList{}
	}
}

// Keys returns a copy of the list's keys.
func (o *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap) Keys() []string {
	if o == nil {
		return nil
	}
	return append([]string{}, o.keys...)
}

// Values returns the current set of the list's values in order.
func (o *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap) Values() []*Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList {
	if o == nil {
		return nil
	}
	var values []*Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList
	for _, key := range o.keys {
		values = append(values, o.valueMap[key])
	}
	return values
}

// Len returns a size of Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap
func (o *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap) Len() int {
	if o == nil {
		return 0
	}
	return len(o.keys)
}

// Get returns the value corresponding to the key. If the key is not found, nil
// is returned.
func (o *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap) Get(key string) *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList {
	if o == nil {
		return nil
	}
	val, _ := o.valueMap[key]
	return val
}

// Delete deletes an element.
func (o *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap) Delete(key string) bool {
	if o == nil {
		return false
	}
	if _, ok := o.valueMap[key]; !ok {
		return false
	}
	for i, k := range o.keys {
		if k == key {
			o.keys = append(o.keys[:i], o.keys[i+1:]...)
			delete(o.valueMap, key)
			return true
		}
	}
	return false
}

// Append appends a Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList, returning an error if the key
// already exists in the ordered list or if the key is unspecified.
func (o *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap) Append(v *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList) error {
	if o == nil {
		return fmt.Errorf("nil ordered map, cannot append Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList")
	}
	if v == nil {
		return fmt.Errorf("nil Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList")
	}
	if v.Key == nil {
		return fmt.Errorf("invalid nil key received for Key")
	}

	key := *v.Key

	if _, ok := o.valueMap[key]; ok {
		return fmt.Errorf("duplicate key for list Statement %v", key)
	}
	o.keys = append(o.keys, key)
	o.init()
	o.valueMap[key] = v
	return nil
}

// AppendNew creates and appends a new Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList, returning the
// newly-initialized v. It returns an error if the v already exists.
func (o *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_OrderedMap) AppendNew(Key string) (*Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList, error) {
	if o == nil {
		return nil, fmt.Errorf("nil ordered map, cannot append Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList")
	}
	key := Key

	if _, ok := o.valueMap[key]; ok {
		return nil, fmt.Errorf("duplicate key for list Statement %v", key)
	}
	o.keys = append(o.keys, key)
	newElement := &Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList{
		Key: &Key,
	}
	o.init()
	o.valueMap[key] = newElement
	return newElement, nil
}

// PopulateDefaults recursively populates unset leaf fields in the Ctestschema_OrderedLists_OrderedList_OrderedLists
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.OrderedList.Values() {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Ctestschema_OrderedLists_OrderedList_OrderedLists"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Ctestschema_OrderedLists_OrderedList_OrderedLists.
func (*Ctestschema_OrderedLists_OrderedList_OrderedLists) ΛBelongingModule() string {
	return "ctestschema"
}

// Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList represents the /ctestschema/ordered-lists/ordered-list/ordered-lists/ordered-list YANG schema element.
type Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList struct {
	ΛMetadata []ygot.Annotation                                                     `path:"@" ygotAnnotation:"true"`
	Config    *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config `path:"config" module:"ctestschema"`
	ΛConfig   []ygot.Annotation                                                     `path:"@config" ygotAnnotation:"true"`
	Key       *string                                                               `path:"key" module:"ctestschema"`
	ΛKey      []ygot.Annotation                                                     `path:"@key" ygotAnnotation:"true"`
	State     *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State  `path:"state" module:"ctestschema"`
	ΛState    []ygot.Annotation                                                     `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList) GetOrCreateConfig() *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList) GetOrCreateState() *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State {
	if t.State != nil {
		return t.State
	}
	t.State = &Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList) GetConfig() *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList) GetState() *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetKey retrieves the value of the leaf Key from the Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key is set, it can
// safely use t.GetKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key == nil' before retrieving the leaf's value.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList) GetKey() string {
	if t == nil || t.Key == nil {
		return ""
	}
	return *t.Key
}

// PopulateDefaults recursively populates unset leaf fields in the Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList struct, which is a YANG list entry.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Key == nil {
		return nil, fmt.Errorf("nil value for key Key")
	}

	return map[string]interface{}{
		"key": *t.Key,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList.
func (*Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList) ΛBelongingModule() string {
	return "ctestschema"
}

// Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config represents the /ctestschema/ordered-lists/ordered-list/ordered-lists/ordered-list/config YANG schema element.
type Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Key       *string           `path:"key" module:"ctestschema"`
	ΛKey      []ygot.Annotation `path:"@key" ygotAnnotation:"true"`
	Value     *string           `path:"value" module:"ctestschema"`
	ΛValue    []ygot.Annotation `path:"@value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config) IsYANGGoStruct() {}

// GetKey retrieves the value of the leaf Key from the Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key is set, it can
// safely use t.GetKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key == nil' before retrieving the leaf's value.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config) GetKey() string {
	if t == nil || t.Key == nil {
		return ""
	}
	return *t.Key
}

// GetValue retrieves the value of the leaf Value from the Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Value is set, it can
// safely use t.GetValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Value == nil' before retrieving the leaf's value.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config) GetValue() string {
	if t == nil || t.Value == nil {
		return "default-value"
	}
	return *t.Value
}

// PopulateDefaults recursively populates unset leaf fields in the Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Value == nil {
		var v string = "default-value"
		t.Value = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config.
func (*Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_Config) ΛBelongingModule() string {
	return "ctestschema"
}

// Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State represents the /ctestschema/ordered-lists/ordered-list/ordered-lists/ordered-list/state YANG schema element.
type Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State struct {
	ΛMetadata  []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Key        *string           `path:"key" module:"ctestschema"`
	ΛKey       []ygot.Annotation `path:"@key" ygotAnnotation:"true"`
	ParentKey  *string           `path:"parent-key" module:"ctestschema"`
	ΛParentKey []ygot.Annotation `path:"@parent-key" ygotAnnotation:"true"`
	Value      *string           `path:"value" module:"ctestschema"`
	ΛValue     []ygot.Annotation `path:"@value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State) IsYANGGoStruct() {}

// GetKey retrieves the value of the leaf Key from the Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key is set, it can
// safely use t.GetKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key == nil' before retrieving the leaf's value.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State) GetKey() string {
	if t == nil || t.Key == nil {
		return ""
	}
	return *t.Key
}

// GetParentKey retrieves the value of the leaf ParentKey from the Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ParentKey is set, it can
// safely use t.GetParentKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ParentKey == nil' before retrieving the leaf's value.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State) GetParentKey() string {
	if t == nil || t.ParentKey == nil {
		return ""
	}
	return *t.ParentKey
}

// GetValue retrieves the value of the leaf Value from the Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Value is set, it can
// safely use t.GetValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Value == nil' before retrieving the leaf's value.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State) GetValue() string {
	if t == nil || t.Value == nil {
		return "default-value"
	}
	return *t.Value
}

// PopulateDefaults recursively populates unset leaf fields in the Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Value == nil {
		var v string = "default-value"
		t.Value = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State.
func (*Ctestschema_OrderedLists_OrderedList_OrderedLists_OrderedList_State) ΛBelongingModule() string {
	return "ctestschema"
}

// Ctestschema_OrderedLists_OrderedList_State represents the /ctestschema/ordered-lists/ordered-list/state YANG schema element.
type Ctestschema_OrderedLists_OrderedList_State struct {
	ΛMetadata  []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Key        *string           `path:"key" module:"ctestschema"`
	ΛKey       []ygot.Annotation `path:"@key" ygotAnnotation:"true"`
	ParentKey  *string           `path:"parent-key" module:"ctestschema"`
	ΛParentKey []ygot.Annotation `path:"@parent-key" ygotAnnotation:"true"`
	RoValue    *string           `path:"ro-value" module:"ctestschema"`
	ΛRoValue   []ygot.Annotation `path:"@ro-value" ygotAnnotation:"true"`
	Value      *string           `path:"value" module:"ctestschema"`
	ΛValue     []ygot.Annotation `path:"@value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Ctestschema_OrderedLists_OrderedList_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Ctestschema_OrderedLists_OrderedList_State) IsYANGGoStruct() {}

// GetKey retrieves the value of the leaf Key from the Ctestschema_OrderedLists_OrderedList_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key is set, it can
// safely use t.GetKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key == nil' before retrieving the leaf's value.
func (t *Ctestschema_OrderedLists_OrderedList_State) GetKey() string {
	if t == nil || t.Key == nil {
		return ""
	}
	return *t.Key
}

// GetParentKey retrieves the value of the leaf ParentKey from the Ctestschema_OrderedLists_OrderedList_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ParentKey is set, it can
// safely use t.GetParentKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ParentKey == nil' before retrieving the leaf's value.
func (t *Ctestschema_OrderedLists_OrderedList_State) GetParentKey() string {
	if t == nil || t.ParentKey == nil {
		return ""
	}
	return *t.ParentKey
}

// GetRoValue retrieves the value of the leaf RoValue from the Ctestschema_OrderedLists_OrderedList_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RoValue is set, it can
// safely use t.GetRoValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RoValue == nil' before retrieving the leaf's value.
func (t *Ctestschema_OrderedLists_OrderedList_State) GetRoValue() string {
	if t == nil || t.RoValue == nil {
		return ""
	}
	return *t.RoValue
}

// GetValue retrieves the value of the leaf Value from the Ctestschema_OrderedLists_OrderedList_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Value is set, it can
// safely use t.GetValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Value == nil' before retrieving the leaf's value.
func (t *Ctestschema_OrderedLists_OrderedList_State) GetValue() string {
	if t == nil || t.Value == nil {
		return "default-value"
	}
	return *t.Value
}

// PopulateDefaults recursively populates unset leaf fields in the Ctestschema_OrderedLists_OrderedList_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Ctestschema_OrderedLists_OrderedList_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Value == nil {
		var v string = "default-value"
		t.Value = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists_OrderedList_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Ctestschema_OrderedLists_OrderedList_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OrderedLists_OrderedList_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Ctestschema_OrderedLists_OrderedList_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Ctestschema_OrderedLists_OrderedList_State.
func (*Ctestschema_OrderedLists_OrderedList_State) ΛBelongingModule() string {
	return "ctestschema"
}

// Ctestschema_OtherData represents the /ctestschema/other-data YANG schema element.
type Ctestschema_OtherData struct {
	ΛMetadata []ygot.Annotation             `path:"@" ygotAnnotation:"true"`
	Config    *Ctestschema_OtherData_Config `path:"config" module:"ctestschema"`
	ΛConfig   []ygot.Annotation             `path:"@config" ygotAnnotation:"true"`
	State     *Ctestschema_OtherData_State  `path:"state" module:"ctestschema"`
	ΛState    []ygot.Annotation             `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Ctestschema_OtherData implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Ctestschema_OtherData) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *Ctestschema_OtherData) GetOrCreateConfig() *Ctestschema_OtherData_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &Ctestschema_OtherData_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *Ctestschema_OtherData) GetOrCreateState() *Ctestschema_OtherData_State {
	if t.State != nil {
		return t.State
	}
	t.State = &Ctestschema_OtherData_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from Ctestschema_OtherData. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Ctestschema_OtherData) GetConfig() *Ctestschema_OtherData_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from Ctestschema_OtherData. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Ctestschema_OtherData) GetState() *Ctestschema_OtherData_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the Ctestschema_OtherData
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Ctestschema_OtherData) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OtherData) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Ctestschema_OtherData"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OtherData) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Ctestschema_OtherData) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Ctestschema_OtherData.
func (*Ctestschema_OtherData) ΛBelongingModule() string {
	return "ctestschema"
}

// Ctestschema_OtherData_Config represents the /ctestschema/other-data/config YANG schema element.
type Ctestschema_OtherData_Config struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Motd      *string           `path:"motd" module:"ctestschema"`
	ΛMotd     []ygot.Annotation `path:"@motd" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Ctestschema_OtherData_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Ctestschema_OtherData_Config) IsYANGGoStruct() {}

// GetMotd retrieves the value of the leaf Motd from the Ctestschema_OtherData_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Motd is set, it can
// safely use t.GetMotd() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Motd == nil' before retrieving the leaf's value.
func (t *Ctestschema_OtherData_Config) GetMotd() string {
	if t == nil || t.Motd == nil {
		return ""
	}
	return *t.Motd
}

// PopulateDefaults recursively populates unset leaf fields in the Ctestschema_OtherData_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Ctestschema_OtherData_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OtherData_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Ctestschema_OtherData_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OtherData_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Ctestschema_OtherData_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Ctestschema_OtherData_Config.
func (*Ctestschema_OtherData_Config) ΛBelongingModule() string {
	return "ctestschema"
}

// Ctestschema_OtherData_State represents the /ctestschema/other-data/state YANG schema element.
type Ctestschema_OtherData_State struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Motd      *string           `path:"motd" module:"ctestschema"`
	ΛMotd     []ygot.Annotation `path:"@motd" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Ctestschema_OtherData_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Ctestschema_OtherData_State) IsYANGGoStruct() {}

// GetMotd retrieves the value of the leaf Motd from the Ctestschema_OtherData_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Motd is set, it can
// safely use t.GetMotd() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Motd == nil' before retrieving the leaf's value.
func (t *Ctestschema_OtherData_State) GetMotd() string {
	if t == nil || t.Motd == nil {
		return ""
	}
	return *t.Motd
}

// PopulateDefaults recursively populates unset leaf fields in the Ctestschema_OtherData_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Ctestschema_OtherData_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OtherData_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Ctestschema_OtherData_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_OtherData_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Ctestschema_OtherData_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Ctestschema_OtherData_State.
func (*Ctestschema_OtherData_State) ΛBelongingModule() string {
	return "ctestschema"
}

// Ctestschema_UnorderedLists represents the /ctestschema/unordered-lists YANG schema element.
type Ctestschema_UnorderedLists struct {
	ΛMetadata      []ygot.Annotation                                    `path:"@" ygotAnnotation:"true"`
	UnorderedList  map[string]*Ctestschema_UnorderedLists_UnorderedList `path:"unordered-list" module:"ctestschema"`
	ΛUnorderedList []ygot.Annotation                                    `path:"@unordered-list" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Ctestschema_UnorderedLists implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Ctestschema_UnorderedLists) IsYANGGoStruct() {}

// NewUnorderedList creates a new entry in the UnorderedList list of the
// Ctestschema_UnorderedLists struct. The keys of the list are populated from the input
// arguments.
func (t *Ctestschema_UnorderedLists) NewUnorderedList(Key string) (*Ctestschema_UnorderedLists_UnorderedList, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnorderedList == nil {
		t.UnorderedList = make(map[string]*Ctestschema_UnorderedLists_UnorderedList)
	}

	key := Key

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.UnorderedList[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list UnorderedList", key)
	}

	t.UnorderedList[key] = &Ctestschema_UnorderedLists_UnorderedList{
		Key: &Key,
	}

	return t.UnorderedList[key], nil
}

// RenameUnorderedList renames an entry in the list UnorderedList within
// the Ctestschema_UnorderedLists struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Ctestschema_UnorderedLists) RenameUnorderedList(oldK, newK string) error {
	if _, ok := t.UnorderedList[newK]; ok {
		return fmt.Errorf("key %v already exists in UnorderedList", newK)
	}

	e, ok := t.UnorderedList[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in UnorderedList", oldK)
	}
	e.Key = &newK

	t.UnorderedList[newK] = e
	delete(t.UnorderedList, oldK)
	return nil
}

// GetOrCreateUnorderedListMap returns the list (map) from Ctestschema_UnorderedLists.
//
// It initializes the field if not already initialized.
func (t *Ctestschema_UnorderedLists) GetOrCreateUnorderedListMap() map[string]*Ctestschema_UnorderedLists_UnorderedList {
	if t.UnorderedList == nil {
		t.UnorderedList = make(map[string]*Ctestschema_UnorderedLists_UnorderedList)
	}
	return t.UnorderedList
}

// GetOrCreateUnorderedList retrieves the value with the specified keys from
// the receiver Ctestschema_UnorderedLists. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Ctestschema_UnorderedLists) GetOrCreateUnorderedList(Key string) *Ctestschema_UnorderedLists_UnorderedList {

	key := Key

	if v, ok := t.UnorderedList[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewUnorderedList(Key)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateUnorderedList got unexpected error: %v", err))
	}
	return v
}

// GetUnorderedList retrieves the value with the specified key from
// the UnorderedList map field of Ctestschema_UnorderedLists. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Ctestschema_UnorderedLists) GetUnorderedList(Key string) *Ctestschema_UnorderedLists_UnorderedList {

	if t == nil {
		return nil
	}

	key := Key

	if lm, ok := t.UnorderedList[key]; ok {
		return lm
	}
	return nil
}

// AppendUnorderedList appends the supplied Ctestschema_UnorderedLists_UnorderedList struct to the
// list UnorderedList of Ctestschema_UnorderedLists. If the key value(s) specified in
// the supplied Ctestschema_UnorderedLists_UnorderedList already exist in the list, an error is
// returned.
func (t *Ctestschema_UnorderedLists) AppendUnorderedList(v *Ctestschema_UnorderedLists_UnorderedList) error {
	if v.Key == nil {
		return fmt.Errorf("invalid nil key received for Key")
	}

	key := *v.Key

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnorderedList == nil {
		t.UnorderedList = make(map[string]*Ctestschema_UnorderedLists_UnorderedList)
	}

	if _, ok := t.UnorderedList[key]; ok {
		return fmt.Errorf("duplicate key for list UnorderedList %v", key)
	}

	t.UnorderedList[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the Ctestschema_UnorderedLists
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Ctestschema_UnorderedLists) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.UnorderedList {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_UnorderedLists) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Ctestschema_UnorderedLists"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_UnorderedLists) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Ctestschema_UnorderedLists) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Ctestschema_UnorderedLists.
func (*Ctestschema_UnorderedLists) ΛBelongingModule() string {
	return "ctestschema"
}

// Ctestschema_UnorderedLists_UnorderedList represents the /ctestschema/unordered-lists/unordered-list YANG schema element.
type Ctestschema_UnorderedLists_UnorderedList struct {
	ΛMetadata []ygot.Annotation                                `path:"@" ygotAnnotation:"true"`
	Config    *Ctestschema_UnorderedLists_UnorderedList_Config `path:"config" module:"ctestschema"`
	ΛConfig   []ygot.Annotation                                `path:"@config" ygotAnnotation:"true"`
	Key       *string                                          `path:"key" module:"ctestschema"`
	ΛKey      []ygot.Annotation                                `path:"@key" ygotAnnotation:"true"`
	State     *Ctestschema_UnorderedLists_UnorderedList_State  `path:"state" module:"ctestschema"`
	ΛState    []ygot.Annotation                                `path:"@state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Ctestschema_UnorderedLists_UnorderedList implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Ctestschema_UnorderedLists_UnorderedList) IsYANGGoStruct() {}

// GetOrCreateConfig retrieves the value of the Config field
// or returns the existing field if it already exists.
func (t *Ctestschema_UnorderedLists_UnorderedList) GetOrCreateConfig() *Ctestschema_UnorderedLists_UnorderedList_Config {
	if t.Config != nil {
		return t.Config
	}
	t.Config = &Ctestschema_UnorderedLists_UnorderedList_Config{}
	return t.Config
}

// GetOrCreateState retrieves the value of the State field
// or returns the existing field if it already exists.
func (t *Ctestschema_UnorderedLists_UnorderedList) GetOrCreateState() *Ctestschema_UnorderedLists_UnorderedList_State {
	if t.State != nil {
		return t.State
	}
	t.State = &Ctestschema_UnorderedLists_UnorderedList_State{}
	return t.State
}

// GetConfig returns the value of the Config struct pointer
// from Ctestschema_UnorderedLists_UnorderedList. If the receiver or the field Config is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Ctestschema_UnorderedLists_UnorderedList) GetConfig() *Ctestschema_UnorderedLists_UnorderedList_Config {
	if t != nil && t.Config != nil {
		return t.Config
	}
	return nil
}

// GetState returns the value of the State struct pointer
// from Ctestschema_UnorderedLists_UnorderedList. If the receiver or the field State is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Ctestschema_UnorderedLists_UnorderedList) GetState() *Ctestschema_UnorderedLists_UnorderedList_State {
	if t != nil && t.State != nil {
		return t.State
	}
	return nil
}

// GetKey retrieves the value of the leaf Key from the Ctestschema_UnorderedLists_UnorderedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key is set, it can
// safely use t.GetKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key == nil' before retrieving the leaf's value.
func (t *Ctestschema_UnorderedLists_UnorderedList) GetKey() string {
	if t == nil || t.Key == nil {
		return ""
	}
	return *t.Key
}

// PopulateDefaults recursively populates unset leaf fields in the Ctestschema_UnorderedLists_UnorderedList
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Ctestschema_UnorderedLists_UnorderedList) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.Config.PopulateDefaults()
	t.State.PopulateDefaults()
}

// ΛListKeyMap returns the keys of the Ctestschema_UnorderedLists_UnorderedList struct, which is a YANG list entry.
func (t *Ctestschema_UnorderedLists_UnorderedList) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Key == nil {
		return nil, fmt.Errorf("nil value for key Key")
	}

	return map[string]interface{}{
		"key": *t.Key,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_UnorderedLists_UnorderedList) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Ctestschema_UnorderedLists_UnorderedList"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_UnorderedLists_UnorderedList) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Ctestschema_UnorderedLists_UnorderedList) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Ctestschema_UnorderedLists_UnorderedList.
func (*Ctestschema_UnorderedLists_UnorderedList) ΛBelongingModule() string {
	return "ctestschema"
}

// Ctestschema_UnorderedLists_UnorderedList_Config represents the /ctestschema/unordered-lists/unordered-list/config YANG schema element.
type Ctestschema_UnorderedLists_UnorderedList_Config struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Key       *string           `path:"key" module:"ctestschema"`
	ΛKey      []ygot.Annotation `path:"@key" ygotAnnotation:"true"`
	Value     *string           `path:"value" module:"ctestschema"`
	ΛValue    []ygot.Annotation `path:"@value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Ctestschema_UnorderedLists_UnorderedList_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Ctestschema_UnorderedLists_UnorderedList_Config) IsYANGGoStruct() {}

// GetKey retrieves the value of the leaf Key from the Ctestschema_UnorderedLists_UnorderedList_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key is set, it can
// safely use t.GetKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key == nil' before retrieving the leaf's value.
func (t *Ctestschema_UnorderedLists_UnorderedList_Config) GetKey() string {
	if t == nil || t.Key == nil {
		return ""
	}
	return *t.Key
}

// GetValue retrieves the value of the leaf Value from the Ctestschema_UnorderedLists_UnorderedList_Config
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Value is set, it can
// safely use t.GetValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Value == nil' before retrieving the leaf's value.
func (t *Ctestschema_UnorderedLists_UnorderedList_Config) GetValue() string {
	if t == nil || t.Value == nil {
		return "default-value"
	}
	return *t.Value
}

// PopulateDefaults recursively populates unset leaf fields in the Ctestschema_UnorderedLists_UnorderedList_Config
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Ctestschema_UnorderedLists_UnorderedList_Config) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Value == nil {
		var v string = "default-value"
		t.Value = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_UnorderedLists_UnorderedList_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Ctestschema_UnorderedLists_UnorderedList_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_UnorderedLists_UnorderedList_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Ctestschema_UnorderedLists_UnorderedList_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Ctestschema_UnorderedLists_UnorderedList_Config.
func (*Ctestschema_UnorderedLists_UnorderedList_Config) ΛBelongingModule() string {
	return "ctestschema"
}

// Ctestschema_UnorderedLists_UnorderedList_State represents the /ctestschema/unordered-lists/unordered-list/state YANG schema element.
type Ctestschema_UnorderedLists_UnorderedList_State struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Key       *string           `path:"key" module:"ctestschema"`
	ΛKey      []ygot.Annotation `path:"@key" ygotAnnotation:"true"`
	Value     *string           `path:"value" module:"ctestschema"`
	ΛValue    []ygot.Annotation `path:"@value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Ctestschema_UnorderedLists_UnorderedList_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Ctestschema_UnorderedLists_UnorderedList_State) IsYANGGoStruct() {}

// GetKey retrieves the value of the leaf Key from the Ctestschema_UnorderedLists_UnorderedList_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key is set, it can
// safely use t.GetKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key == nil' before retrieving the leaf's value.
func (t *Ctestschema_UnorderedLists_UnorderedList_State) GetKey() string {
	if t == nil || t.Key == nil {
		return ""
	}
	return *t.Key
}

// GetValue retrieves the value of the leaf Value from the Ctestschema_UnorderedLists_UnorderedList_State
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Value is set, it can
// safely use t.GetValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Value == nil' before retrieving the leaf's value.
func (t *Ctestschema_UnorderedLists_UnorderedList_State) GetValue() string {
	if t == nil || t.Value == nil {
		return "default-value"
	}
	return *t.Value
}

// PopulateDefaults recursively populates unset leaf fields in the Ctestschema_UnorderedLists_UnorderedList_State
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Ctestschema_UnorderedLists_UnorderedList_State) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Value == nil {
		var v string = "default-value"
		t.Value = &v
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_UnorderedLists_UnorderedList_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Ctestschema_UnorderedLists_UnorderedList_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Ctestschema_UnorderedLists_UnorderedList_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Ctestschema_UnorderedLists_UnorderedList_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Ctestschema_UnorderedLists_UnorderedList_State.
func (*Ctestschema_UnorderedLists_UnorderedList_State) ΛBelongingModule() string {
	return "ctestschema"
}

// Device represents the /device YANG schema element.
type Device struct {
	ΛMetadata               []ygot.Annotation                          `path:"@" ygotAnnotation:"true"`
	OrderedLists            *Ctestschema_OrderedLists                  `path:"ordered-lists" module:"ctestschema"`
	ΛOrderedLists           []ygot.Annotation                          `path:"@ordered-lists" ygotAnnotation:"true"`
	OrderedMultikeyedLists  *CtestschemaRootmod_OrderedMultikeyedLists `path:"ordered-multikeyed-lists" module:"ctestschema-rootmod"`
	ΛOrderedMultikeyedLists []ygot.Annotation                          `path:"@ordered-multikeyed-lists" ygotAnnotation:"true"`
	OtherData               *Ctestschema_OtherData                     `path:"other-data" module:"ctestschema"`
	ΛOtherData              []ygot.Annotation                          `path:"@other-data" ygotAnnotation:"true"`
	Ref                     *Refschema_Ref                             `path:"ref" module:"refschema"`
	ΛRef                    []ygot.Annotation                          `path:"@ref" ygotAnnotation:"true"`
	Target                  *Utestschema_Target                        `path:"target" module:"utestschema"`
	ΛTarget                 []ygot.Annotation                          `path:"@target" ygotAnnotation:"true"`
	UnorderedLists          *Ctestschema_UnorderedLists                `path:"unordered-lists" module:"ctestschema"`
	ΛUnorderedLists         []ygot.Annotation                          `path:"@unordered-lists" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Device implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Device) IsYANGGoStruct() {}

// GetOrCreateOrderedLists retrieves the value of the OrderedLists field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateOrderedLists() *Ctestschema_OrderedLists {
	if t.OrderedLists != nil {
		return t.OrderedLists
	}
	t.OrderedLists = &Ctestschema_OrderedLists{}
	return t.OrderedLists
}

// GetOrCreateOrderedMultikeyedLists retrieves the value of the OrderedMultikeyedLists field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateOrderedMultikeyedLists() *CtestschemaRootmod_OrderedMultikeyedLists {
	if t.OrderedMultikeyedLists != nil {
		return t.OrderedMultikeyedLists
	}
	t.OrderedMultikeyedLists = &CtestschemaRootmod_OrderedMultikeyedLists{}
	return t.OrderedMultikeyedLists
}

// GetOrCreateOtherData retrieves the value of the OtherData field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateOtherData() *Ctestschema_OtherData {
	if t.OtherData != nil {
		return t.OtherData
	}
	t.OtherData = &Ctestschema_OtherData{}
	return t.OtherData
}

// GetOrCreateRef retrieves the value of the Ref field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateRef() *Refschema_Ref {
	if t.Ref != nil {
		return t.Ref
	}
	t.Ref = &Refschema_Ref{}
	return t.Ref
}

// GetOrCreateTarget retrieves the value of the Target field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateTarget() *Utestschema_Target {
	if t.Target != nil {
		return t.Target
	}
	t.Target = &Utestschema_Target{}
	return t.Target
}

// GetOrCreateUnorderedLists retrieves the value of the UnorderedLists field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateUnorderedLists() *Ctestschema_UnorderedLists {
	if t.UnorderedLists != nil {
		return t.UnorderedLists
	}
	t.UnorderedLists = &Ctestschema_UnorderedLists{}
	return t.UnorderedLists
}

// GetOrderedLists returns the value of the OrderedLists struct pointer
// from Device. If the receiver or the field OrderedLists is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetOrderedLists() *Ctestschema_OrderedLists {
	if t != nil && t.OrderedLists != nil {
		return t.OrderedLists
	}
	return nil
}

// GetOrderedMultikeyedLists returns the value of the OrderedMultikeyedLists struct pointer
// from Device. If the receiver or the field OrderedMultikeyedLists is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetOrderedMultikeyedLists() *CtestschemaRootmod_OrderedMultikeyedLists {
	if t != nil && t.OrderedMultikeyedLists != nil {
		return t.OrderedMultikeyedLists
	}
	return nil
}

// GetOtherData returns the value of the OtherData struct pointer
// from Device. If the receiver or the field OtherData is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetOtherData() *Ctestschema_OtherData {
	if t != nil && t.OtherData != nil {
		return t.OtherData
	}
	return nil
}

// GetRef returns the value of the Ref struct pointer
// from Device. If the receiver or the field Ref is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetRef() *Refschema_Ref {
	if t != nil && t.Ref != nil {
		return t.Ref
	}
	return nil
}

// GetTarget returns the value of the Target struct pointer
// from Device. If the receiver or the field Target is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetTarget() *Utestschema_Target {
	if t != nil && t.Target != nil {
		return t.Target
	}
	return nil
}

// GetUnorderedLists returns the value of the UnorderedLists struct pointer
// from Device. If the receiver or the field UnorderedLists is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetUnorderedLists() *Ctestschema_UnorderedLists {
	if t != nil && t.UnorderedLists != nil {
		return t.UnorderedLists
	}
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the Device
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Device) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.OrderedLists.PopulateDefaults()
	t.OrderedMultikeyedLists.PopulateDefaults()
	t.OtherData.PopulateDefaults()
	t.Ref.PopulateDefaults()
	t.Target.PopulateDefaults()
	t.UnorderedLists.PopulateDefaults()
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Device"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Device) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Device.
func (*Device) ΛBelongingModule() string {
	return ""
}

// Refschema_Ref represents the /refschema/ref YANG schema element.
type Refschema_Ref struct {
	ΛMetadata  []ygot.Annotation                   `path:"@" ygotAnnotation:"true"`
	Reference  map[string]*Refschema_Ref_Reference `path:"reference" module:"refschema"`
	ΛReference []ygot.Annotation                   `path:"@reference" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Refschema_Ref implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Refschema_Ref) IsYANGGoStruct() {}

// NewReference creates a new entry in the Reference list of the
// Refschema_Ref struct. The keys of the list are populated from the input
// arguments.
func (t *Refschema_Ref) NewReference(Name string) (*Refschema_Ref_Reference, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Reference == nil {
		t.Reference = make(map[string]*Refschema_Ref_Reference)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Reference[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Reference", key)
	}

	t.Reference[key] = &Refschema_Ref_Reference{
		Name: &Name,
	}

	return t.Reference[key], nil
}

// RenameReference renames an entry in the list Reference within
// the Refschema_Ref struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Refschema_Ref) RenameReference(oldK, newK string) error {
	if _, ok := t.Reference[newK]; ok {
		return fmt.Errorf("key %v already exists in Reference", newK)
	}

	e, ok := t.Reference[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Reference", oldK)
	}
	e.Name = &newK

	t.Reference[newK] = e
	delete(t.Reference, oldK)
	return nil
}

// GetOrCreateReferenceMap returns the list (map) from Refschema_Ref.
//
// It initializes the field if not already initialized.
func (t *Refschema_Ref) GetOrCreateReferenceMap() map[string]*Refschema_Ref_Reference {
	if t.Reference == nil {
		t.Reference = make(map[string]*Refschema_Ref_Reference)
	}
	return t.Reference
}

// GetOrCreateReference retrieves the value with the specified keys from
// the receiver Refschema_Ref. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Refschema_Ref) GetOrCreateReference(Name string) *Refschema_Ref_Reference {

	key := Name

	if v, ok := t.Reference[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewReference(Name)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateReference got unexpected error: %v", err))
	}
	return v
}

// GetReference retrieves the value with the specified key from
// the Reference map field of Refschema_Ref. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Refschema_Ref) GetReference(Name string) *Refschema_Ref_Reference {

	if t == nil {
		return nil
	}

	key := Name

	if lm, ok := t.Reference[key]; ok {
		return lm
	}
	return nil
}

// AppendReference appends the supplied Refschema_Ref_Reference struct to the
// list Reference of Refschema_Ref. If the key value(s) specified in
// the supplied Refschema_Ref_Reference already exist in the list, an error is
// returned.
func (t *Refschema_Ref) AppendReference(v *Refschema_Ref_Reference) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key received for Name")
	}

	key := *v.Name

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Reference == nil {
		t.Reference = make(map[string]*Refschema_Ref_Reference)
	}

	if _, ok := t.Reference[key]; ok {
		return fmt.Errorf("duplicate key for list Reference %v", key)
	}

	t.Reference[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the Refschema_Ref
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Refschema_Ref) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.Reference {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Refschema_Ref) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Refschema_Ref"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Refschema_Ref) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Refschema_Ref) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Refschema_Ref.
func (*Refschema_Ref) ΛBelongingModule() string {
	return "refschema"
}

// Refschema_Ref_Reference represents the /refschema/ref/reference YANG schema element.
type Refschema_Ref_Reference struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Name      *string           `path:"name" module:"refschema"`
	ΛName     []ygot.Annotation `path:"@name" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Refschema_Ref_Reference implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Refschema_Ref_Reference) IsYANGGoStruct() {}

// GetName retrieves the value of the leaf Name from the Refschema_Ref_Reference
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *Refschema_Ref_Reference) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// PopulateDefaults recursively populates unset leaf fields in the Refschema_Ref_Reference
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Refschema_Ref_Reference) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// ΛListKeyMap returns the keys of the Refschema_Ref_Reference struct, which is a YANG list entry.
func (t *Refschema_Ref_Reference) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Refschema_Ref_Reference) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Refschema_Ref_Reference"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Refschema_Ref_Reference) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Refschema_Ref_Reference) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Refschema_Ref_Reference.
func (*Refschema_Ref_Reference) ΛBelongingModule() string {
	return "refschema"
}

// Utestschema_Target represents the /utestschema/target YANG schema element.
type Utestschema_Target struct {
	ΛMetadata []ygot.Annotation                     `path:"@" ygotAnnotation:"true"`
	Entity    map[string]*Utestschema_Target_Entity `path:"entity" module:"utestschema"`
	ΛEntity   []ygot.Annotation                     `path:"@entity" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Utestschema_Target implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Utestschema_Target) IsYANGGoStruct() {}

// NewEntity creates a new entry in the Entity list of the
// Utestschema_Target struct. The keys of the list are populated from the input
// arguments.
func (t *Utestschema_Target) NewEntity(Name string) (*Utestschema_Target_Entity, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Entity == nil {
		t.Entity = make(map[string]*Utestschema_Target_Entity)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Entity[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Entity", key)
	}

	t.Entity[key] = &Utestschema_Target_Entity{
		Name: &Name,
	}

	return t.Entity[key], nil
}

// RenameEntity renames an entry in the list Entity within
// the Utestschema_Target struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Utestschema_Target) RenameEntity(oldK, newK string) error {
	if _, ok := t.Entity[newK]; ok {
		return fmt.Errorf("key %v already exists in Entity", newK)
	}

	e, ok := t.Entity[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Entity", oldK)
	}
	e.Name = &newK

	t.Entity[newK] = e
	delete(t.Entity, oldK)
	return nil
}

// GetOrCreateEntityMap returns the list (map) from Utestschema_Target.
//
// It initializes the field if not already initialized.
func (t *Utestschema_Target) GetOrCreateEntityMap() map[string]*Utestschema_Target_Entity {
	if t.Entity == nil {
		t.Entity = make(map[string]*Utestschema_Target_Entity)
	}
	return t.Entity
}

// GetOrCreateEntity retrieves the value with the specified keys from
// the receiver Utestschema_Target. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Utestschema_Target) GetOrCreateEntity(Name string) *Utestschema_Target_Entity {

	key := Name

	if v, ok := t.Entity[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewEntity(Name)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateEntity got unexpected error: %v", err))
	}
	return v
}

// GetEntity retrieves the value with the specified key from
// the Entity map field of Utestschema_Target. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Utestschema_Target) GetEntity(Name string) *Utestschema_Target_Entity {

	if t == nil {
		return nil
	}

	key := Name

	if lm, ok := t.Entity[key]; ok {
		return lm
	}
	return nil
}

// AppendEntity appends the supplied Utestschema_Target_Entity struct to the
// list Entity of Utestschema_Target. If the key value(s) specified in
// the supplied Utestschema_Target_Entity already exist in the list, an error is
// returned.
func (t *Utestschema_Target) AppendEntity(v *Utestschema_Target_Entity) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key received for Name")
	}

	key := *v.Name

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Entity == nil {
		t.Entity = make(map[string]*Utestschema_Target_Entity)
	}

	if _, ok := t.Entity[key]; ok {
		return fmt.Errorf("duplicate key for list Entity %v", key)
	}

	t.Entity[key] = v
	return nil
}

// PopulateDefaults recursively populates unset leaf fields in the Utestschema_Target
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Utestschema_Target) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	for _, e := range t.Entity {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Utestschema_Target) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Utestschema_Target"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Utestschema_Target) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Utestschema_Target) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Utestschema_Target.
func (*Utestschema_Target) ΛBelongingModule() string {
	return "utestschema"
}

// Utestschema_Target_Entity represents the /utestschema/target/entity YANG schema element.
type Utestschema_Target_Entity struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Name      *string           `path:"name" module:"utestschema"`
	ΛName     []ygot.Annotation `path:"@name" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Utestschema_Target_Entity implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Utestschema_Target_Entity) IsYANGGoStruct() {}

// GetName retrieves the value of the leaf Name from the Utestschema_Target_Entity
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *Utestschema_Target_Entity) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// PopulateDefaults recursively populates unset leaf fields in the Utestschema_Target_Entity
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Utestschema_Target_Entity) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// ΛListKeyMap returns the keys of the Utestschema_Target_Entity struct, which is a YANG list entry.
func (t *Utestschema_Target_Entity) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Utestschema_Target_Entity) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Utestschema_Target_Entity"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Utestschema_Target_Entity) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Utestschema_Target_Entity) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Utestschema_Target_Entity.
func (*Utestschema_Target_Entity) ΛBelongingModule() string {
	return "utestschema"
}

var (
	// ySchema is a byte slice contain a gzip compressed representation of the
	// YANG schema from which the Go code was generated. When uncompressed the
	// contents of the byte slice is a JSON document containing an object, keyed
	// on the name of the generated struct, and containing the JSON marshalled
	// contents of a goyang yang.Entry struct, which defines the schema for the
	// fields within the struct.
	ySchema = []byte{
		0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x5d, 0x5f, 0x6f, 0xda, 0x48,
		0x10, 0x7f, 0xcf, 0xa7, 0xb0, 0xfc, 0x5c, 0x4a, 0xe0, 0xd2, 0xa6, 0xc7, 0x5b, 0xaf, 0x69, 0x75,
		0x52, 0x2f, 0x77, 0x55, 0xda, 0xde, 0xcb, 0x29, 0x8a, 0x5c, 0x58, 0xa8, 0x15, 0x30, 0xd1, 0x7a,
		0x9d, 0x4b, 0x74, 0xe2, 0xbb, 0x9f, 0x8c, 0x8d, 0x83, 0xc1, 0x7f, 0x66, 0x66, 0xc7, 0xc6, 0x09,
		0x73, 0xba, 0x4a, 0x01, 0xd6, 0xf6, 0xee, 0xce, 0xff, 0xdf, 0xec, 0x8c, 0xff, 0x3b, 0x71, 0x1c,
		0xc7, 0x71, 0xff, 0xf4, 0x16, 0xca, 0x1d, 0x39, 0xee, 0x44, 0xdd, 0xfb, 0x63, 0xe5, 0xbe, 0x4a,
		0xbe, 0xfd, 0xec, 0x07, 0x13, 0x77, 0xe4, 0x0c, 0xd2, 0x8f, 0x1f, 0x96, 0xc1, 0xd4, 0x9f, 0xb9,
		0x23, 0xe7, 0x34, 0xfd, 0xe2, 0xc2, 0xd7, 0xee, 0xc8, 0x49, 0x6e, 0xb1, 0xfe, 0x62, 0xa9, 0x27,
		0x4a, 0xab, 0x49, 0x6f, 0xee, 0x87, 0x26, 0xcc, 0xfd, 0x94, 0x7b, 0x4a, 0x7e, 0xd8, 0xab, 0xfc,
		0xa0, 0xfc, 0x43, 0xb3, 0xaf, 0x77, 0x1f, 0x9e, 0xfd, 0xf0, 0x45, 0xab, 0xa9, 0xff, 0xb0, 0xf7,
		0xb0, 0xdc, 0x03, 0xc7, 0x7b, 0x8f, 0x59, 0xff, 0xfc, 0x75, 0x19, 0xe9, 0xb1, 0x2a, 0xbc, 0x34,
		0x99, 0x8a, 0x7a, 0xfc, 0x77, 0xa9, 0xe3, 0xd9, 0xb8, 0x77, 0xc9, 0x53, 0x5e, 0x15, 0x0f, 0xfc,
		0xdd, 0x0b, 0xdf, 0xeb, 0x59, 0xb4, 0x50, 0x81, 0x71, 0x47, 0x8e, 0xd1, 0x91, 0x2a, 0x19, 0xb8,
		0x35, 0x6a, 0x3d, 0xa9, 0xbd, 0x51, 0xab, 0xdc, 0x37, 0xab, 0x9d, 0xb5, 0xee, 0x6e, 0x78, 0xe1,
		0xc6, 0x97, 0xaf, 0xa7, 0x68, 0xff, 0xcb, 0x96, 0x54, 0x4c, 0x86, 0x5a, 0x72, 0x40, 0xc8, 0x02,
		0x24, 0x0f, 0x94, 0x4c, 0x68, 0x72, 0xa1, 0xc9, 0x06, 0x27, 0x5f, 0x31, 0x19, 0x4b, 0xc8, 0x59,
		0x4b, 0xd6, 0x6c, 0xc0, 0x78, 0xb3, 0xdb, 0x35, 0x3b, 0x90, 0x6d, 0x68, 0x32, 0xbe, 0x66, 0x35,
		0xd5, 0x24, 0x06, 0x93, 0x1a, 0x43, 0x72, 0x24, 0xe9, 0xb1, 0x2c, 0x40, 0x66, 0x05, 0x32, 0x4b,
		0xe0, 0x59, 0xa3, 0x9a, 0x45, 0x6a, 0x58, 0x05, 0xcc, 0x32, 0xd9, 0xc0, 0x5b, 0xf5, 0x08, 0xdf,
		0xb6, 0x0d, 0x55, 0xe2, 0x8b, 0x80, 0xeb, 0x4e, 0x99, 0xe8, 0x14, 0x38, 0x1c, 0xca, 0x4c, 0x14,
		0xa6, 0x22, 0x32, 0x17, 0x95, 0xc9, 0xac, 0x99, 0xcd, 0x9a, 0xe9, 0xe8, 0xcc, 0x07, 0x63, 0x42,
		0x20, 0x33, 0x66, 0xd3, 0xf8, 0xf6, 0x78, 0xa7, 0x68, 0x94, 0x0a, 0x8d, 0xf6, 0x83, 0x19, 0x86,
		0x58, 0x1b, 0xe5, 0xf5, 0xee, 0x84, 0x67, 0x9d, 0x80, 0x35, 0xba, 0xf7, 0xde, 0x3c, 0x52, 0x78,
		0x69, 0x4a, 0x2e, 0x03, 0xee, 0xe1, 0x85, 0x9a, 0x7a, 0xd1, 0x3c, 0xa6, 0xe4, 0x3f, 0xf0, 0xcd,
		0x98, 0x24, 0x17, 0xf5, 0x92, 0x27, 0x81, 0xae, 0xbb, 0x16, 0xf9, 0x16, 0xf9, 0x3e, 0x26, 0xf9,
		0xb6, 0x32, 0xb7, 0xef, 0x83, 0x60, 0x69, 0x3c, 0xe3, 0x2f, 0x03, 0x98, 0xd5, 0x0d, 0xc7, 0x3f,
		0xd5, 0xc2, 0xbb, 0xf3, 0xcc, 0xcf, 0x78, 0xf5, 0xfd, 0xb1, 0x51, 0xa1, 0x49, 0xbe, 0xeb, 0xe7,
		0x82, 0x9f, 0xdc, 0xa7, 0x3e, 0xc8, 0x6d, 0x4b, 0xee, 0x6f, 0x74, 0x34, 0x36, 0x41, 0xba, 0xbb,
		0x1f, 0x9e, 0x6e, 0x7f, 0xf3, 0x57, 0x72, 0xc3, 0x3f, 0xe2, 0xbb, 0x6f, 0x7f, 0xb8, 0x49, 0x25,
		0xf3, 0x84, 0xb6, 0x49, 0x15, 0x1b, 0x04, 0x72, 0x31, 0x10, 0xae, 0x05, 0x50, 0xe5, 0x88, 0x5f,
		0xda, 0x45, 0xbf, 0x14, 0xac, 0x22, 0xb2, 0x9d, 0x9e, 0x2b, 0x6f, 0xaa, 0xd5, 0x14, 0xb2, 0xdb,
		0x1b, 0x9d, 0x70, 0x0e, 0x18, 0xfb, 0x25, 0x95, 0xbd, 0xd7, 0xaf, 0x53, 0xb1, 0xea, 0xc7, 0x9c,
		0xd7, 0x00, 0xf7, 0x57, 0x63, 0x1e, 0xa0, 0x18, 0x3c, 0x94, 0x48, 0x4d, 0x22, 0x35, 0x18, 0x86,
		0x63, 0x83, 0xe9, 0x10, 0xd9, 0x4a, 0x7c, 0xbb, 0x63, 0xf0, 0xed, 0xa0, 0x6c, 0x8a, 0xc5, 0xa4,
		0xec, 0x30, 0x2a, 0x4b, 0x96, 0x25, 0xb3, 0xae, 0x0d, 0x0b, 0x5b, 0xb2, 0xb2, 0x2d, 0x4b, 0xb3,
		0xb1, 0x36, 0x1b, 0x8b, 0xdb, 0xb3, 0x3a, 0x8e, 0xe5, 0x91, 0xac, 0x4f, 0x16, 0x01, 0x12, 0xc6,
		0xc6, 0x80, 0xb9, 0x59, 0xc6, 0xe8, 0x6c, 0xc2, 0xc1, 0x21, 0x24, 0x4c, 0xc2, 0xc2, 0x25, 0x34,
		0xec, 0xc2, 0xc3, 0x2e, 0x44, 0x7c, 0xc2, 0x44, 0x13, 0x2a, 0xa2, 0x70, 0xd1, 0x31, 0x04, 0x3e,
		0x4c, 0xc1, 0x12, 0x63, 0xb0, 0xdf, 0x37, 0xc2, 0x9e, 0x21, 0x31, 0x47, 0x16, 0x0c, 0x92, 0x05,
		0x93, 0xe4, 0xc0, 0x28, 0x89, 0x98, 0xa5, 0xe8, 0x47, 0xd1, 0x8f, 0xa2, 0x1f, 0x9f, 0xa3, 0x7e,
		0x6c, 0xd4, 0xbd, 0x43, 0x62, 0xb8, 0x4c, 0x98, 0x2e, 0x07, 0xdc, 0xcb, 0x01, 0xff, 0x5a, 0xe1,
		0xc2, 0x74, 0x42, 0x21, 0x88, 0x44, 0x72, 0xa3, 0x2d, 0xdc, 0x67, 0xa2, 0x59, 0x90, 0x58, 0x52,
		0x62, 0xc9, 0x06, 0xd5, 0x38, 0x01, 0x17, 0x2f, 0xd5, 0xdb, 0xe7, 0x84, 0x6b, 0x09, 0xb8, 0x79,
		0x3b, 0xda, 0x21, 0x34, 0x9e, 0x51, 0x74, 0xfd, 0x90, 0x5c, 0xde, 0x32, 0xda, 0x34, 0x14, 0x0d,
		0x21, 0x1a, 0x42, 0xd0, 0x26, 0x89, 0xa6, 0x24, 0x9a, 0x92, 0x68, 0xea, 0x39, 0xa0, 0x4d, 0x77,
		0x9e, 0x56, 0x81, 0xe9, 0xb1, 0xa8, 0x98, 0xad, 0x7b, 0x89, 0xa6, 0x11, 0x4d, 0x23, 0x9a, 0xa6,
		0x71, 0xc7, 0x9f, 0x23, 0x00, 0x28, 0x0a, 0x04, 0xb2, 0xff, 0xa9, 0x11, 0x41, 0xbb, 0x4a, 0x4c,
		0x20, 0xf3, 0xa7, 0xff, 0x04, 0x32, 0x17, 0xd5, 0x2b, 0xaa, 0xf7, 0x05, 0x3b, 0x79, 0xc7, 0x05,
		0x99, 0x53, 0x50, 0x1c, 0x87, 0x1b, 0x31, 0xff, 0xba, 0x9e, 0x44, 0x53, 0x90, 0x18, 0xeb, 0xa9,
		0xae, 0xcf, 0x6b, 0x47, 0x1e, 0x53, 0xcf, 0x15, 0xaf, 0xf0, 0xbd, 0x31, 0xc8, 0xc3, 0x60, 0x97,
		0x7e, 0xf0, 0x71, 0xae, 0x62, 0xdd, 0x11, 0xe2, 0x94, 0xbe, 0x7b, 0xe9, 0x3d, 0x6c, 0x5d, 0x39,
		0x78, 0x77, 0x76, 0xf6, 0xf6, 0xfc, 0xec, 0xec, 0xf4, 0xfc, 0x97, 0xf3, 0xd3, 0x5f, 0xdf, 0xbc,
		0x19, 0xbc, 0x1d, 0xbc, 0x41, 0xdc, 0x2c, 0xa5, 0xd2, 0x6f, 0x16, 0x79, 0x84, 0x28, 0x54, 0x1a,
		0x0b, 0x13, 0x5a, 0x58, 0x88, 0x6d, 0xab, 0xb0, 0xe1, 0xf4, 0x1f, 0x94, 0x80, 0x89, 0xc5, 0x1a,
		0xe4, 0x2c, 0xc0, 0x7a, 0x27, 0x3a, 0x00, 0xfc, 0x66, 0x44, 0xfd, 0x1e, 0x4f, 0x28, 0x59, 0x1a,
		0xab, 0x90, 0xa8, 0x07, 0xa3, 0xbd, 0x5e, 0x14, 0x84, 0xc6, 0xfb, 0x31, 0x47, 0x16, 0xb8, 0x6c,
		0xd1, 0x0c, 0xeb, 0xea, 0x59, 0x60, 0xbc, 0x04, 0x26, 0x75, 0x98, 0x41, 0x5e, 0x2b, 0x66, 0x75,
		0x1a, 0x03, 0x7a, 0xf1, 0x4c, 0x4b, 0xb0, 0xa2, 0xe0, 0xd1, 0xd7, 0xac, 0x7c, 0x4a, 0xb4, 0xc6,
		0xec, 0x56, 0xd8, 0x45, 0x65, 0x6d, 0xd8, 0xec, 0xae, 0x7b, 0x44, 0x95, 0x60, 0x98, 0xea, 0x10,
		0x8e, 0x7d, 0x6e, 0xa2, 0x30, 0x06, 0x96, 0xb0, 0x43, 0x25, 0xe8, 0xd0, 0x85, 0x30, 0x43, 0x29,
		0x84, 0x61, 0x0c, 0xf7, 0xa4, 0x65, 0x41, 0x53, 0xd8, 0x85, 0x94, 0xbd, 0x48, 0x49, 0x33, 0xde,
		0x90, 0x01, 0xb4, 0x10, 0x21, 0xa1, 0x43, 0x4f, 0xe0, 0x88, 0x64, 0x89, 0x64, 0x31, 0x48, 0x16,
		0x3e, 0x01, 0x42, 0x49, 0x78, 0xec, 0x27, 0x38, 0x72, 0x1e, 0x18, 0x38, 0xc7, 0xc1, 0x23, 0xa7,
		0x7a, 0xd9, 0x23, 0x76, 0x17, 0xc9, 0xae, 0x14, 0x19, 0x15, 0x19, 0x15, 0xeb, 0x97, 0x7b, 0xa6,
		0x34, 0xec, 0x11, 0xf9, 0x16, 0xf9, 0x96, 0x86, 0x3d, 0x4d, 0xc1, 0x34, 0xd0, 0x74, 0x14, 0x05,
		0x9e, 0x01, 0x64, 0x99, 0x56, 0x4c, 0xfd, 0x27, 0x6b, 0xb3, 0x44, 0xb0, 0xac, 0x10, 0x3c, 0x0b,
		0xb4, 0x93, 0xf5, 0xa9, 0x48, 0xf1, 0x20, 0x52, 0x3a, 0x18, 0x74, 0x1c, 0xa3, 0x5a, 0xc8, 0xa8,
		0x37, 0x49, 0x8d, 0x20, 0xd1, 0x6c, 0x1a, 0x34, 0x07, 0x4e, 0xa9, 0x94, 0x71, 0x0c, 0x22, 0x65,
		0x82, 0x49, 0x91, 0x20, 0x50, 0x38, 0x60, 0x0a, 0xc4, 0x06, 0x86, 0x43, 0xa7, 0x38, 0x78, 0xa0,
		0x38, 0x58, 0x0a, 0x63, 0x45, 0x64, 0x8b, 0x6b, 0x14, 0x9d, 0x81, 0x6a, 0x94, 0xa6, 0x3e, 0xdd,
		0x4a, 0xf0, 0x18, 0xab, 0x30, 0x8b, 0xb7, 0x6c, 0x85, 0xec, 0xb0, 0x5c, 0xb3, 0x60, 0xf0, 0x42,
		0x8b, 0xda, 0x4d, 0xc3, 0xd6, 0x94, 0x5f, 0xc7, 0xd3, 0x6c, 0xb7, 0x66, 0x9a, 0x71, 0xe6, 0x22,
		0x9a, 0x1b, 0xff, 0x56, 0x3d, 0xc2, 0x5b, 0x6e, 0xef, 0x5d, 0xd1, 0x4e, 0xf7, 0x6d, 0xdd, 0xc9,
		0xf6, 0xdb, 0x9a, 0xbd, 0xff, 0xf6, 0xce, 0xf6, 0xc2, 0x5b, 0x71, 0xef, 0x5e, 0x28, 0x5d, 0xb9,
		0xa5, 0x2b, 0x37, 0x4b, 0xdc, 0x26, 0x29, 0xae, 0x8e, 0xa6, 0xb8, 0x06, 0xa4, 0x1c, 0xd7, 0x40,
		0x60, 0x3e, 0x81, 0x01, 0x04, 0xe6, 0xdb, 0x93, 0xa6, 0x21, 0x49, 0x9a, 0x86, 0x22, 0x4d, 0x22,
		0x4d, 0xed, 0x49, 0x53, 0xe4, 0x07, 0xe6, 0xed, 0x19, 0x41, 0x9a, 0xde, 0x21, 0x2e, 0xb9, 0xf2,
		0x82, 0x99, 0x6a, 0xe3, 0x30, 0xe2, 0xa5, 0x1f, 0xd0, 0x4f, 0x12, 0xfe, 0x9d, 0x22, 0xf3, 0xd4,
		0xfa, 0x90, 0x4f, 0xda, 0x1b, 0xc7, 0x51, 0xda, 0x85, 0x3f, 0xf3, 0xb1, 0x67, 0x8e, 0xf3, 0xb4,
		0x51, 0x33, 0xcf, 0xf8, 0xf7, 0xf1, 0x5c, 0xa6, 0xde, 0x3c, 0x54, 0xad, 0x54, 0x28, 0x5d, 0x7a,
		0x0f, 0xf6, 0x5b, 0x67, 0x77, 0x56, 0xba, 0xab, 0xbb, 0x79, 0xd8, 0x93, 0x98, 0xc7, 0x91, 0x75,
		0xda, 0x0a, 0x36, 0x25, 0x01, 0x25, 0xb6, 0x52, 0x3c, 0xcf, 0x06, 0x42, 0x41, 0xbe, 0x04, 0x54,
		0x4f, 0x2f, 0x97, 0x66, 0xb1, 0x9c, 0xf4, 0xcb, 0x30, 0xbc, 0xb2, 0x1f, 0x38, 0xde, 0x27, 0x71,
		0x95, 0x3c, 0x7b, 0x83, 0x50, 0x5e, 0x66, 0x4f, 0xc8, 0xe1, 0xaf, 0xf9, 0xaf, 0x9b, 0x7d, 0xd5,
		0xc4, 0x00, 0xf5, 0xae, 0x89, 0x81, 0xbc, 0x6c, 0x42, 0x5e, 0x36, 0x71, 0x98, 0x97, 0x4d, 0x0c,
		0x1a, 0x12, 0x80, 0x21, 0x4a, 0x00, 0x86, 0x22, 0x00, 0x22, 0x00, 0x87, 0x11, 0x80, 0xa1, 0x54,
		0x95, 0x88, 0x08, 0x08, 0xe4, 0x2e, 0x81, 0x8f, 0x04, 0x3e, 0x02, 0xb9, 0x0b, 0xe4, 0x2e, 0xd2,
		0x24, 0x90, 0xbb, 0x40, 0xee, 0x02, 0xb9, 0x0b, 0xe4, 0xce, 0x6f, 0x8e, 0xa4, 0x7c, 0x4a, 0xcc,
		0x92, 0x38, 0x79, 0xdc, 0x52, 0x25, 0x89, 0x2c, 0x11, 0x75, 0x11, 0x75, 0x47, 0x12, 0x59, 0x87,
		0x4e, 0x64, 0xd9, 0xd7, 0x59, 0x91, 0xf2, 0x58, 0x07, 0x29, 0xc1, 0x1a, 0x38, 0x15, 0x51, 0x72,
		0xc3, 0x85, 0x58, 0x38, 0xff, 0x56, 0x6a, 0xb3, 0xa4, 0x36, 0x8b, 0x4a, 0x64, 0x47, 0x6a, 0xb3,
		0xa0, 0x11, 0x53, 0x73, 0xb5, 0x59, 0x64, 0x85, 0x4c, 0xaa, 0xdc, 0xa2, 0xa8, 0x60, 0xa6, 0xa2,
		0xae, 0x68, 0x16, 0x13, 0x50, 0x4d, 0x0a, 0x99, 0xbc, 0xa6, 0x42, 0xa7, 0xaf, 0x17, 0x23, 0x60,
		0xf5, 0xd4, 0x9e, 0x05, 0x97, 0x32, 0x1d, 0x8a, 0x27, 0xc7, 0x5c, 0xa6, 0x83, 0xad, 0xcd, 0xda,
		0xdb, 0x61, 0xbc, 0x10, 0x38, 0x52, 0xc8, 0xd3, 0xa0, 0x12, 0x6e, 0x21, 0xab, 0x08, 0x74, 0xc7,
		0x70, 0x6e, 0x19, 0xde, 0x3d, 0x63, 0x71, 0xd3, 0x08, 0xee, 0x1a, 0xd5, 0xa2, 0x53, 0x63, 0x4d,
		0xeb, 0xc6, 0xb2, 0x56, 0x71, 0x26, 0xb1, 0x81, 0x2c, 0x0f, 0xc6, 0x82, 0xee, 0x6e, 0x5c, 0xc7,
		0xba, 0x84, 0x6e, 0xc6, 0x94, 0x2e, 0xc6, 0x94, 0x5c, 0x0c, 0xae, 0x6b, 0x31, 0x07, 0x68, 0x41,
		0xee, 0x52, 0xcc, 0x0b, 0x5c, 0xe0, 0xba, 0x12, 0xaf, 0x98, 0xd8, 0xef, 0x9a, 0x37, 0x72, 0xad,
		0x71, 0xba, 0xae, 0xd9, 0x2a, 0xe9, 0x6b, 0xdd, 0x52, 0x54, 0x71, 0x7d, 0xb5, 0xdb, 0x09, 0xaa,
		0xb6, 0x37, 0x3f, 0x95, 0xee, 0x4d, 0x3c, 0xe3, 0x55, 0xd4, 0xd7, 0x3f, 0x8d, 0x69, 0xa7, 0xa2,
		0xbe, 0x93, 0x05, 0xf5, 0x6c, 0xf5, 0xf4, 0x35, 0xa5, 0xd5, 0xb0, 0x92, 0x6a, 0x71, 0xc3, 0xbb,
		0xe4, 0x86, 0x2f, 0x96, 0x66, 0x02, 0xf7, 0xb9, 0xd7, 0xa3, 0xe5, 0xe4, 0xaa, 0x9c, 0x5c, 0xc5,
		0xe3, 0xe8, 0x40, 0xfc, 0x9c, 0x0b, 0xb9, 0xe5, 0x68, 0x91, 0x93, 0x19, 0x8f, 0xfa, 0x92, 0x8d,
		0xaa, 0x2e, 0x32, 0xf1, 0x6d, 0x2e, 0x3c, 0xe3, 0x55, 0x16, 0x60, 0x14, 0xd8, 0xf1, 0x42, 0x73,
		0x5a, 0x75, 0xcc, 0x16, 0x74, 0xbc, 0x16, 0xac, 0x7e, 0x87, 0xa2, 0x7e, 0x45, 0xfd, 0x8a, 0xfa,
		0x15, 0xf5, 0x7b, 0x78, 0xf5, 0x5b, 0x97, 0x68, 0x04, 0x69, 0xdf, 0x8a, 0xb4, 0x61, 0x9b, 0xed,
		0xc8, 0xca, 0x22, 0x12, 0xe8, 0x3a, 0x20, 0xa1, 0x91, 0x56, 0xd3, 0xf2, 0x98, 0x68, 0xbf, 0xce,
		0xa4, 0x91, 0x60, 0x48, 0x77, 0x30, 0x16, 0xd2, 0x7c, 0xa1, 0x90, 0x56, 0x53, 0xa5, 0x55, 0x30,
		0x06, 0x58, 0xe3, 0xa7, 0xa1, 0x1d, 0x08, 0x88, 0xf4, 0x33, 0x34, 0xc8, 0xba, 0x3d, 0x7b, 0x9c,
		0x8a, 0x1e, 0xd0, 0x1e, 0xaf, 0x47, 0x3f, 0x03, 0x7b, 0xac, 0x5f, 0xa0, 0x39, 0xd6, 0xc7, 0x57,
		0xc6, 0xd7, 0x37, 0xe1, 0xc8, 0x78, 0x7a, 0xa6, 0x4c, 0xfc, 0x97, 0x0a, 0x8c, 0x6f, 0x1e, 0xe3,
		0xbf, 0xd6, 0x6c, 0xd8, 0xe6, 0x79, 0x98, 0x0a, 0xbe, 0xef, 0xee, 0x51, 0x98, 0x20, 0x9a, 0xcf,
		0x11, 0x07, 0x3c, 0xca, 0x4f, 0x6d, 0x33, 0xfb, 0x3c, 0x5a, 0x4d, 0x53, 0xdf, 0x40, 0xab, 0x69,
		0xbf, 0xce, 0x58, 0x14, 0xb8, 0x09, 0x57, 0x9b, 0x1b, 0xdc, 0x5c, 0xa9, 0x69, 0xfc, 0x2f, 0xbd,
		0xc1, 0x21, 0x5c, 0x9d, 0xdc, 0x62, 0xea, 0x3d, 0x9c, 0xdc, 0xd4, 0x21, 0x9e, 0x4d, 0xc2, 0xfe,
		0xe5, 0xce, 0x4d, 0xfa, 0x7b, 0x0b, 0xfe, 0x4d, 0xd4, 0x45, 0xb0, 0x37, 0x62, 0x04, 0x7b, 0x13,
		0xfd, 0x52, 0xef, 0xde, 0xa4, 0xe3, 0x3a, 0xe0, 0xdb, 0x44, 0xcf, 0x11, 0x6d, 0x88, 0x8c, 0x78,
		0x37, 0x76, 0xde, 0x4d, 0xf4, 0x12, 0xd1, 0x86, 0x48, 0xd0, 0x06, 0x71, 0x4b, 0x0e, 0xe9, 0x96,
		0x44, 0x5b, 0xa0, 0x45, 0xea, 0x74, 0x56, 0x6a, 0xfa, 0x02, 0xeb, 0xfe, 0x7d, 0x0b, 0xbf, 0xf8,
		0xb6, 0xbe, 0xc5, 0xcd, 0xc7, 0xe4, 0x16, 0x87, 0x70, 0x4d, 0xf6, 0x17, 0x54, 0xef, 0x9f, 0xec,
		0xaf, 0x00, 0xe2, 0xa4, 0x44, 0x41, 0xbe, 0xe9, 0x7c, 0xa9, 0xb7, 0xb2, 0x3b, 0x50, 0x72, 0xd4,
		0xf6, 0x6e, 0x4b, 0x7e, 0x4f, 0xeb, 0xdd, 0x97, 0x9d, 0xf1, 0x92, 0xb3, 0x96, 0x0e, 0xef, 0x92,
		0x38, 0x79, 0x6e, 0x89, 0x13, 0x79, 0x89, 0x31, 0x1b, 0x73, 0x51, 0x99, 0xcc, 0x9a, 0xd9, 0xac,
		0x99, 0x8e, 0xce, 0x7c, 0x30, 0x26, 0x04, 0x32, 0x23, 0xde, 0xbf, 0xa6, 0xfb, 0xd9, 0x48, 0x7f,
		0x1b, 0xbe, 0x4e, 0x79, 0x8d, 0xa3, 0xc8, 0xb7, 0xc8, 0xf7, 0x0b, 0x96, 0xef, 0xae, 0xbc, 0xc6,
		0x71, 0x27, 0x04, 0xda, 0xf9, 0xcc, 0xd1, 0x2b, 0xf7, 0xe6, 0xfb, 0xe6, 0x96, 0x49, 0x45, 0x5b,
		0xee, 0x63, 0xb3, 0x4d, 0x71, 0x51, 0x2d, 0x41, 0xe5, 0x60, 0x8f, 0x1c, 0xec, 0x39, 0x4c, 0x47,
		0x50, 0x69, 0x08, 0x2a, 0x12, 0x20, 0x11, 0x9a, 0x78, 0x70, 0xe2, 0xc1, 0x49, 0x84, 0x26, 0x11,
		0x9a, 0xc8, 0xb7, 0xc8, 0xb7, 0x44, 0x68, 0xe0, 0x08, 0x8d, 0xe1, 0x65, 0xfb, 0x95, 0x01, 0xda,
		0x11, 0xbd, 0x70, 0xff, 0x05, 0x66, 0x91, 0xe1, 0x8c, 0x44, 0x3b, 0xde, 0x5f, 0xc5, 0x3a, 0x07,
		0x3f, 0xeb, 0x5f, 0x9d, 0xde, 0x45, 0xad, 0xac, 0x34, 0xed, 0x7c, 0xb2, 0x35, 0xe7, 0xb2, 0xb9,
		0xba, 0x7e, 0xf8, 0xc9, 0xbb, 0x55, 0x57, 0xcb, 0xe5, 0xbe, 0x3a, 0xdf, 0x9d, 0xbf, 0xbb, 0xfd,
		0x53, 0x6e, 0x72, 0x17, 0xea, 0xde, 0xdf, 0x9c, 0x2a, 0x5c, 0x9d, 0xac, 0xfe, 0x07, 0x00, 0x00,
		0xff, 0xff, 0x01, 0x00, 0x00, 0xff, 0xff, 0x36, 0xd5, 0xe4, 0xf9, 0xa3, 0xd8, 0x00, 0x00,
	}
)

// ΛEnumTypes is a map, keyed by a YANG schema path, of the enumerated types that
// correspond with the leaf. The type is represented as a reflect.Type. The naming
// of the map ensures that there are no clashes with valid YANG identifiers.
func initΛEnumTypes() {
	ΛEnumTypes = map[string][]reflect.Type{}
}
