/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.vpn;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.model.api.vpn.ImmutableWireguardUserDto;
import com.ubnt.net.v2.validation.constraints.Ip;
import com.ubnt.net.v2.validation.constraints.IpCidrNetwork;
import com.ubnt.net.v2.validation.constraints.WireguardKey;
import com.ubnt.return.F;
import com.ubnt.service.vpn.WireguardUserDocument;
import jakarta.validation.constraints.NotEmpty;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableWireguardUserDto.class)
@JsonDeserialize(as=ImmutableWireguardUserDto.class)
@Value.Immutable
@F
public interface WireguardUserDto {
    @JsonProperty(value="_id")
    public Optional<String> id();

    @JsonProperty(value="network_id")
    public String networkId();

    @JsonProperty(value="name")
    @NotEmpty
    public String name();

    @JsonProperty(value="interface_ip")
    @NotEmpty
    @Ip
    public String interfaceIp();

    @JsonProperty(value="allowed_ips")
    @IpCidrNetwork
    public List<String> allowedIps();

    @JsonProperty(value="public_key")
    @NotEmpty
    @WireguardKey
    public String publicKey();

    @JsonProperty(value="preshared_key")
    public Optional<@WireguardKey String> presharedKey();

    default public WireguardUserDto withEmptyId() {
        return ImmutableWireguardUserDto.builder().from(this).id(Optional.empty()).build();
    }

    default public WireguardUserDocument toDocument(String string, String string2) {
        return WireguardUserDocument.builder().\u00d200000(this.id().orElse(null)).\u00f400000(string).\u00f600000(string2).float(this.name()).\u00f500000(this.interfaceIp()).Object(Optional.ofNullable(this.allowedIps()).orElse(Collections.emptyList())).o00000(this.publicKey()).void(this.presharedKey().filter(StringUtils::isNotBlank).orElse(null)).\u00d500000();
    }

    public static WireguardUserDto fromDocument(WireguardUserDocument wireguardUserDocument) {
        return WireguardUserDto.builder().id(wireguardUserDocument.getId()).networkId(wireguardUserDocument.getNetworkId()).name(wireguardUserDocument.getName()).interfaceIp(wireguardUserDocument.getInterfaceIp()).allowedIps(Optional.ofNullable(wireguardUserDocument.getAllowedIps()).orElse(Collections.emptyList())).publicKey(wireguardUserDocument.getPublicKey()).presharedKey(wireguardUserDocument.getPreSharedKey()).build();
    }

    public static ImmutableWireguardUserDto.Builder builder() {
        return ImmutableWireguardUserDto.builder();
    }
}

