/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoClientException;
import com.mongodb.connection.NettyTransportSettings;
import com.mongodb.connection.TransportSettings;
import com.mongodb.internal.connection.StreamFactoryFactory;
import com.mongodb.internal.connection.netty.NettyStreamFactoryFactory;
import com.mongodb.spi.dns.InetAddressResolver;

public final class StreamFactoryHelper {
    public static StreamFactoryFactory getStreamFactoryFactoryFromSettings(TransportSettings transportSettings, InetAddressResolver inetAddressResolver) {
        if (transportSettings instanceof NettyTransportSettings) {
            return NettyStreamFactoryFactory.builder().applySettings((NettyTransportSettings)transportSettings).inetAddressResolver(inetAddressResolver).build();
        }
        throw new MongoClientException("Unsupported transport settings: " + transportSettings.getClass().getName());
    }

    private StreamFactoryHelper() {
    }
}

