// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package keymanagement

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListHsmPartitionsRequest wrapper for the ListHsmPartitions operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/keymanagement/ListHsmPartitions.go.html to see an example of how to use ListHsmPartitionsRequest.
type ListHsmPartitionsRequest struct {

	// The OCID of the HSM Cluster. This is a unique identifier assigned to each hsmCluster.
	HsmClusterId *string `mandatory:"true" contributesTo:"path" name:"hsmClusterId"`

	// The maximum number of items to return in a paginated "List" call.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The value of the `opc-next-page` response header
	// from the previous "List" call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// Unique identifier for the request. If provided, the returned request ID
	// will include this value. Otherwise, a random request ID will be
	// generated by the service.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// The field to sort by. You can specify only one sort order. The default
	// order for `TIMECREATED` is descending. The default order for `DISPLAYNAME`
	// is ascending.
	SortBy ListHsmPartitionsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The sort order to use, either ascending (`ASC`) or descending (`DESC`).
	SortOrder ListHsmPartitionsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// A filter that returns only resources that match the specified lifecycle state. The state value is case-insensitive.
	LifecycleState HsmPartitionLifecycleStateEnum `mandatory:"false" contributesTo:"query" name:"lifecycleState" omitEmpty:"true"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListHsmPartitionsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListHsmPartitionsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListHsmPartitionsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListHsmPartitionsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListHsmPartitionsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListHsmPartitionsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListHsmPartitionsSortByEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHsmPartitionsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListHsmPartitionsSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingHsmPartitionLifecycleStateEnum(string(request.LifecycleState)); !ok && request.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", request.LifecycleState, strings.Join(GetHsmPartitionLifecycleStateEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListHsmPartitionsResponse wrapper for the ListHsmPartitions operation
type ListHsmPartitionsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of HsmPartitionCollection instances
	HsmPartitionCollection `presentIn:"body"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then there are additional items still to get. Include this value as the `page` parameter for the
	// subsequent GET request. For information about pagination, see
	// List Pagination (https://docs.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine).
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`

	// Unique Oracle-assigned identifier for the request. If you need to contact Oracle about
	// a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`
}

func (response ListHsmPartitionsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListHsmPartitionsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListHsmPartitionsSortByEnum Enum with underlying type: string
type ListHsmPartitionsSortByEnum string

// Set of constants representing the allowable values for ListHsmPartitionsSortByEnum
const (
	ListHsmPartitionsSortByTimecreated ListHsmPartitionsSortByEnum = "TIMECREATED"
	ListHsmPartitionsSortByDisplayname ListHsmPartitionsSortByEnum = "DISPLAYNAME"
)

var mappingListHsmPartitionsSortByEnum = map[string]ListHsmPartitionsSortByEnum{
	"TIMECREATED": ListHsmPartitionsSortByTimecreated,
	"DISPLAYNAME": ListHsmPartitionsSortByDisplayname,
}

var mappingListHsmPartitionsSortByEnumLowerCase = map[string]ListHsmPartitionsSortByEnum{
	"timecreated": ListHsmPartitionsSortByTimecreated,
	"displayname": ListHsmPartitionsSortByDisplayname,
}

// GetListHsmPartitionsSortByEnumValues Enumerates the set of values for ListHsmPartitionsSortByEnum
func GetListHsmPartitionsSortByEnumValues() []ListHsmPartitionsSortByEnum {
	values := make([]ListHsmPartitionsSortByEnum, 0)
	for _, v := range mappingListHsmPartitionsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListHsmPartitionsSortByEnumStringValues Enumerates the set of values in String for ListHsmPartitionsSortByEnum
func GetListHsmPartitionsSortByEnumStringValues() []string {
	return []string{
		"TIMECREATED",
		"DISPLAYNAME",
	}
}

// GetMappingListHsmPartitionsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHsmPartitionsSortByEnum(val string) (ListHsmPartitionsSortByEnum, bool) {
	enum, ok := mappingListHsmPartitionsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHsmPartitionsSortOrderEnum Enum with underlying type: string
type ListHsmPartitionsSortOrderEnum string

// Set of constants representing the allowable values for ListHsmPartitionsSortOrderEnum
const (
	ListHsmPartitionsSortOrderAsc  ListHsmPartitionsSortOrderEnum = "ASC"
	ListHsmPartitionsSortOrderDesc ListHsmPartitionsSortOrderEnum = "DESC"
)

var mappingListHsmPartitionsSortOrderEnum = map[string]ListHsmPartitionsSortOrderEnum{
	"ASC":  ListHsmPartitionsSortOrderAsc,
	"DESC": ListHsmPartitionsSortOrderDesc,
}

var mappingListHsmPartitionsSortOrderEnumLowerCase = map[string]ListHsmPartitionsSortOrderEnum{
	"asc":  ListHsmPartitionsSortOrderAsc,
	"desc": ListHsmPartitionsSortOrderDesc,
}

// GetListHsmPartitionsSortOrderEnumValues Enumerates the set of values for ListHsmPartitionsSortOrderEnum
func GetListHsmPartitionsSortOrderEnumValues() []ListHsmPartitionsSortOrderEnum {
	values := make([]ListHsmPartitionsSortOrderEnum, 0)
	for _, v := range mappingListHsmPartitionsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListHsmPartitionsSortOrderEnumStringValues Enumerates the set of values in String for ListHsmPartitionsSortOrderEnum
func GetListHsmPartitionsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListHsmPartitionsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHsmPartitionsSortOrderEnum(val string) (ListHsmPartitionsSortOrderEnum, bool) {
	enum, ok := mappingListHsmPartitionsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
