// Code generated by go-swagger; DO NOT EDIT.

package product_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-billing/preview/2020-11-05/models"
)

// ProductServiceEstimateCostReader is a Reader for the ProductServiceEstimateCost structure.
type ProductServiceEstimateCostReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ProductServiceEstimateCostReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewProductServiceEstimateCostOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewProductServiceEstimateCostDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewProductServiceEstimateCostOK creates a ProductServiceEstimateCostOK with default headers values
func NewProductServiceEstimateCostOK() *ProductServiceEstimateCostOK {
	return &ProductServiceEstimateCostOK{}
}

/*
ProductServiceEstimateCostOK describes a response with status code 200, with default header values.

A successful response.
*/
type ProductServiceEstimateCostOK struct {
	Payload *models.Billing20201105EstimateCostResponse
}

// IsSuccess returns true when this product service estimate cost o k response has a 2xx status code
func (o *ProductServiceEstimateCostOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this product service estimate cost o k response has a 3xx status code
func (o *ProductServiceEstimateCostOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this product service estimate cost o k response has a 4xx status code
func (o *ProductServiceEstimateCostOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this product service estimate cost o k response has a 5xx status code
func (o *ProductServiceEstimateCostOK) IsServerError() bool {
	return false
}

// IsCode returns true when this product service estimate cost o k response a status code equal to that given
func (o *ProductServiceEstimateCostOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the product service estimate cost o k response
func (o *ProductServiceEstimateCostOK) Code() int {
	return 200
}

func (o *ProductServiceEstimateCostOK) Error() string {
	return fmt.Sprintf("[PUT /billing/2020-11-05/organizations/{organization_id}/estimateCost][%d] productServiceEstimateCostOK  %+v", 200, o.Payload)
}

func (o *ProductServiceEstimateCostOK) String() string {
	return fmt.Sprintf("[PUT /billing/2020-11-05/organizations/{organization_id}/estimateCost][%d] productServiceEstimateCostOK  %+v", 200, o.Payload)
}

func (o *ProductServiceEstimateCostOK) GetPayload() *models.Billing20201105EstimateCostResponse {
	return o.Payload
}

func (o *ProductServiceEstimateCostOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Billing20201105EstimateCostResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProductServiceEstimateCostDefault creates a ProductServiceEstimateCostDefault with default headers values
func NewProductServiceEstimateCostDefault(code int) *ProductServiceEstimateCostDefault {
	return &ProductServiceEstimateCostDefault{
		_statusCode: code,
	}
}

/*
ProductServiceEstimateCostDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ProductServiceEstimateCostDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this product service estimate cost default response has a 2xx status code
func (o *ProductServiceEstimateCostDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this product service estimate cost default response has a 3xx status code
func (o *ProductServiceEstimateCostDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this product service estimate cost default response has a 4xx status code
func (o *ProductServiceEstimateCostDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this product service estimate cost default response has a 5xx status code
func (o *ProductServiceEstimateCostDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this product service estimate cost default response a status code equal to that given
func (o *ProductServiceEstimateCostDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the product service estimate cost default response
func (o *ProductServiceEstimateCostDefault) Code() int {
	return o._statusCode
}

func (o *ProductServiceEstimateCostDefault) Error() string {
	return fmt.Sprintf("[PUT /billing/2020-11-05/organizations/{organization_id}/estimateCost][%d] ProductService_EstimateCost default  %+v", o._statusCode, o.Payload)
}

func (o *ProductServiceEstimateCostDefault) String() string {
	return fmt.Sprintf("[PUT /billing/2020-11-05/organizations/{organization_id}/estimateCost][%d] ProductService_EstimateCost default  %+v", o._statusCode, o.Payload)
}

func (o *ProductServiceEstimateCostDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *ProductServiceEstimateCostDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
