// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Billing20201105Contract NOTE: The private Contract represents an entitlement contract specifically.
// Contract represents a contract backed by a flex consumption pool or entitlement contract.
//
// swagger:model billing_20201105Contract
type Billing20201105Contract struct {

	// active_from is the timestamp of when the contract became active.
	// Format: date-time
	ActiveFrom strfmt.DateTime `json:"active_from,omitempty"`

	// active_until is the timestamp of when the contract became inactive.
	// Format: date-time
	ActiveUntil strfmt.DateTime `json:"active_until,omitempty"`

	// billing_account_id is the public ID of the billing account this
	// contract is belongs to.
	BillingAccountID string `json:"billing_account_id,omitempty"`

	// created_at is when the contract was created.
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// entitlement contains all information related to the entitlement contract.
	EntitlementDetails ContractEntitlementDetails `json:"entitlement_details,omitempty"`

	// flex contains all information related to the flex consumption contract.
	FlexDetails *ContractFlexDetails `json:"flex_details,omitempty"`

	// id is the public identifier of the flex consumption pool or entitlement contract.
	ID string `json:"id,omitempty"`

	// organization_id is the organization where the billing account belongs to.
	OrganizationID string `json:"organization_id,omitempty"`

	// status represents the status of a given contract.
	Status *Billing20201105ContractStatus `json:"status,omitempty"`

	// updated_at is the last time the contract has been updated.
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`

	// updates contain a list of any updates made to the contract.
	Updates []*Billing20201105ContractUpdate `json:"updates"`
}

// Validate validates this billing 20201105 contract
func (m *Billing20201105Contract) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActiveFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateActiveUntil(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlexDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdates(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105Contract) validateActiveFrom(formats strfmt.Registry) error {
	if swag.IsZero(m.ActiveFrom) { // not required
		return nil
	}

	if err := validate.FormatOf("active_from", "body", "date-time", m.ActiveFrom.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105Contract) validateActiveUntil(formats strfmt.Registry) error {
	if swag.IsZero(m.ActiveUntil) { // not required
		return nil
	}

	if err := validate.FormatOf("active_until", "body", "date-time", m.ActiveUntil.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105Contract) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105Contract) validateFlexDetails(formats strfmt.Registry) error {
	if swag.IsZero(m.FlexDetails) { // not required
		return nil
	}

	if m.FlexDetails != nil {
		if err := m.FlexDetails.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flex_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("flex_details")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105Contract) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105Contract) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105Contract) validateUpdates(formats strfmt.Registry) error {
	if swag.IsZero(m.Updates) { // not required
		return nil
	}

	for i := 0; i < len(m.Updates); i++ {
		if swag.IsZero(m.Updates[i]) { // not required
			continue
		}

		if m.Updates[i] != nil {
			if err := m.Updates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("updates" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("updates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this billing 20201105 contract based on the context it is used
func (m *Billing20201105Contract) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFlexDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105Contract) contextValidateFlexDetails(ctx context.Context, formats strfmt.Registry) error {

	if m.FlexDetails != nil {

		if swag.IsZero(m.FlexDetails) { // not required
			return nil
		}

		if err := m.FlexDetails.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flex_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("flex_details")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105Contract) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {

		if swag.IsZero(m.Status) { // not required
			return nil
		}

		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105Contract) contextValidateUpdates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Updates); i++ {

		if m.Updates[i] != nil {

			if swag.IsZero(m.Updates[i]) { // not required
				return nil
			}

			if err := m.Updates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("updates" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("updates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *Billing20201105Contract) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Billing20201105Contract) UnmarshalBinary(b []byte) error {
	var res Billing20201105Contract
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
