// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// GetPricingModelTransitionsResponseTransition Transition represent a pricing model transition where the pricing_model is the value of the pricing model
// between the start (inclusive) and end (exclusively) date.
// Example using [12:00, 13:00) [start, end)
//   - 12:00 to 13:59:59 is part of the transition.
//   - 13:00 and up is not part of the transition.
//
// swagger:model GetPricingModelTransitionsResponseTransition
type GetPricingModelTransitionsResponseTransition struct {

	// end is the exclusive upper bound timestamp of this transition.
	// The value is always rounded up to the start of the hour that follows the transition.
	// Format: date-time
	End strfmt.DateTime `json:"end,omitempty"`

	// pricing_model is the value of the pricing model for the transition.
	PricingModel *Billing20201105PricingModel `json:"pricing_model,omitempty"`

	// start is the inclusive upper bound timestamp of this transition.
	// The value is always rounded up to the start of the hour starting the transition.
	// Format: date-time
	Start strfmt.DateTime `json:"start,omitempty"`
}

// Validate validates this get pricing model transitions response transition
func (m *GetPricingModelTransitionsResponseTransition) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEnd(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePricingModel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStart(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GetPricingModelTransitionsResponseTransition) validateEnd(formats strfmt.Registry) error {
	if swag.IsZero(m.End) { // not required
		return nil
	}

	if err := validate.FormatOf("end", "body", "date-time", m.End.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *GetPricingModelTransitionsResponseTransition) validatePricingModel(formats strfmt.Registry) error {
	if swag.IsZero(m.PricingModel) { // not required
		return nil
	}

	if m.PricingModel != nil {
		if err := m.PricingModel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pricing_model")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pricing_model")
			}
			return err
		}
	}

	return nil
}

func (m *GetPricingModelTransitionsResponseTransition) validateStart(formats strfmt.Registry) error {
	if swag.IsZero(m.Start) { // not required
		return nil
	}

	if err := validate.FormatOf("start", "body", "date-time", m.Start.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this get pricing model transitions response transition based on the context it is used
func (m *GetPricingModelTransitionsResponseTransition) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePricingModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GetPricingModelTransitionsResponseTransition) contextValidatePricingModel(ctx context.Context, formats strfmt.Registry) error {

	if m.PricingModel != nil {

		if swag.IsZero(m.PricingModel) { // not required
			return nil
		}

		if err := m.PricingModel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pricing_model")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pricing_model")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GetPricingModelTransitionsResponseTransition) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GetPricingModelTransitionsResponseTransition) UnmarshalBinary(b []byte) error {
	var res GetPricingModelTransitionsResponseTransition
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
