// Code generated by go-swagger; DO NOT EDIT.

package consul_telemetry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetServiceTopologyParams creates a new GetServiceTopologyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetServiceTopologyParams() *GetServiceTopologyParams {
	return &GetServiceTopologyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetServiceTopologyParamsWithTimeout creates a new GetServiceTopologyParams object
// with the ability to set a timeout on a request.
func NewGetServiceTopologyParamsWithTimeout(timeout time.Duration) *GetServiceTopologyParams {
	return &GetServiceTopologyParams{
		timeout: timeout,
	}
}

// NewGetServiceTopologyParamsWithContext creates a new GetServiceTopologyParams object
// with the ability to set a context for a request.
func NewGetServiceTopologyParamsWithContext(ctx context.Context) *GetServiceTopologyParams {
	return &GetServiceTopologyParams{
		Context: ctx,
	}
}

// NewGetServiceTopologyParamsWithHTTPClient creates a new GetServiceTopologyParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetServiceTopologyParamsWithHTTPClient(client *http.Client) *GetServiceTopologyParams {
	return &GetServiceTopologyParams{
		HTTPClient: client,
	}
}

/*
GetServiceTopologyParams contains all the parameters to send to the API endpoint

	for the get service topology operation.

	Typically these are written to a http.Request.
*/
type GetServiceTopologyParams struct {

	/* Duration.

	     duration is the length of time, from start, to include in the query for metrics from the mesh.
	The returned graph will not include requests/connections between services that happened
	after start + duration.
	*/
	Duration *string

	/* IncludesClusterID.

	   Cluster ID is the name of the cluster in GNM. This is the user settable name.
	*/
	IncludesClusterID *string

	/* IncludesClusterInternalID.

	   The internal id the Consul cluster the service is registered with. This is from global-network-manager.
	*/
	IncludesClusterInternalID *string

	/* IncludesName.

	   Name of the service.
	*/
	IncludesName *string

	/* IncludesNamespace.

	   Namespace where the service is deployed.
	*/
	IncludesNamespace *string

	/* IncludesPartition.

	   Partition where the service is deployed.
	*/
	IncludesPartition *string

	/* IncludesTrustDomain.

	     trust_domain of the cluster. This is a globally unique UUID created by the Consul cluster on startup
	for its certificate authority if connect is enabled: https://developer.hashicorp.com/consul/api-docs/connect/ca#sample-request.
	*/
	IncludesTrustDomain *string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	/* RootClusterID.

	   Cluster ID is the name of the cluster in GNM. This is the user settable name.
	*/
	RootClusterID *string

	/* RootClusterInternalID.

	   The internal id the Consul cluster the service is registered with. This is from global-network-manager.
	*/
	RootClusterInternalID *string

	/* RootName.

	   Name of the service.
	*/
	RootName *string

	/* RootNamespace.

	   Namespace where the service is deployed.
	*/
	RootNamespace *string

	/* RootPartition.

	   Partition where the service is deployed.
	*/
	RootPartition *string

	/* RootTrustDomain.

	     trust_domain of the cluster. This is a globally unique UUID created by the Consul cluster on startup
	for its certificate authority if connect is enabled: https://developer.hashicorp.com/consul/api-docs/connect/ca#sample-request.
	*/
	RootTrustDomain *string

	/* Start.

	     start is the beginning of the time range over which metrics are queried from the mesh.
	The returned graph will not include requests/connections between services that happened
	before this.

	     Format: date-time
	*/
	Start *strfmt.DateTime

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get service topology params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetServiceTopologyParams) WithDefaults() *GetServiceTopologyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get service topology params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetServiceTopologyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get service topology params
func (o *GetServiceTopologyParams) WithTimeout(timeout time.Duration) *GetServiceTopologyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get service topology params
func (o *GetServiceTopologyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get service topology params
func (o *GetServiceTopologyParams) WithContext(ctx context.Context) *GetServiceTopologyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get service topology params
func (o *GetServiceTopologyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get service topology params
func (o *GetServiceTopologyParams) WithHTTPClient(client *http.Client) *GetServiceTopologyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get service topology params
func (o *GetServiceTopologyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDuration adds the duration to the get service topology params
func (o *GetServiceTopologyParams) WithDuration(duration *string) *GetServiceTopologyParams {
	o.SetDuration(duration)
	return o
}

// SetDuration adds the duration to the get service topology params
func (o *GetServiceTopologyParams) SetDuration(duration *string) {
	o.Duration = duration
}

// WithIncludesClusterID adds the includesClusterID to the get service topology params
func (o *GetServiceTopologyParams) WithIncludesClusterID(includesClusterID *string) *GetServiceTopologyParams {
	o.SetIncludesClusterID(includesClusterID)
	return o
}

// SetIncludesClusterID adds the includesClusterId to the get service topology params
func (o *GetServiceTopologyParams) SetIncludesClusterID(includesClusterID *string) {
	o.IncludesClusterID = includesClusterID
}

// WithIncludesClusterInternalID adds the includesClusterInternalID to the get service topology params
func (o *GetServiceTopologyParams) WithIncludesClusterInternalID(includesClusterInternalID *string) *GetServiceTopologyParams {
	o.SetIncludesClusterInternalID(includesClusterInternalID)
	return o
}

// SetIncludesClusterInternalID adds the includesClusterInternalId to the get service topology params
func (o *GetServiceTopologyParams) SetIncludesClusterInternalID(includesClusterInternalID *string) {
	o.IncludesClusterInternalID = includesClusterInternalID
}

// WithIncludesName adds the includesName to the get service topology params
func (o *GetServiceTopologyParams) WithIncludesName(includesName *string) *GetServiceTopologyParams {
	o.SetIncludesName(includesName)
	return o
}

// SetIncludesName adds the includesName to the get service topology params
func (o *GetServiceTopologyParams) SetIncludesName(includesName *string) {
	o.IncludesName = includesName
}

// WithIncludesNamespace adds the includesNamespace to the get service topology params
func (o *GetServiceTopologyParams) WithIncludesNamespace(includesNamespace *string) *GetServiceTopologyParams {
	o.SetIncludesNamespace(includesNamespace)
	return o
}

// SetIncludesNamespace adds the includesNamespace to the get service topology params
func (o *GetServiceTopologyParams) SetIncludesNamespace(includesNamespace *string) {
	o.IncludesNamespace = includesNamespace
}

// WithIncludesPartition adds the includesPartition to the get service topology params
func (o *GetServiceTopologyParams) WithIncludesPartition(includesPartition *string) *GetServiceTopologyParams {
	o.SetIncludesPartition(includesPartition)
	return o
}

// SetIncludesPartition adds the includesPartition to the get service topology params
func (o *GetServiceTopologyParams) SetIncludesPartition(includesPartition *string) {
	o.IncludesPartition = includesPartition
}

// WithIncludesTrustDomain adds the includesTrustDomain to the get service topology params
func (o *GetServiceTopologyParams) WithIncludesTrustDomain(includesTrustDomain *string) *GetServiceTopologyParams {
	o.SetIncludesTrustDomain(includesTrustDomain)
	return o
}

// SetIncludesTrustDomain adds the includesTrustDomain to the get service topology params
func (o *GetServiceTopologyParams) SetIncludesTrustDomain(includesTrustDomain *string) {
	o.IncludesTrustDomain = includesTrustDomain
}

// WithLocationOrganizationID adds the locationOrganizationID to the get service topology params
func (o *GetServiceTopologyParams) WithLocationOrganizationID(locationOrganizationID string) *GetServiceTopologyParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get service topology params
func (o *GetServiceTopologyParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get service topology params
func (o *GetServiceTopologyParams) WithLocationProjectID(locationProjectID string) *GetServiceTopologyParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get service topology params
func (o *GetServiceTopologyParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get service topology params
func (o *GetServiceTopologyParams) WithLocationRegionProvider(locationRegionProvider *string) *GetServiceTopologyParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get service topology params
func (o *GetServiceTopologyParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get service topology params
func (o *GetServiceTopologyParams) WithLocationRegionRegion(locationRegionRegion *string) *GetServiceTopologyParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get service topology params
func (o *GetServiceTopologyParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithRootClusterID adds the rootClusterID to the get service topology params
func (o *GetServiceTopologyParams) WithRootClusterID(rootClusterID *string) *GetServiceTopologyParams {
	o.SetRootClusterID(rootClusterID)
	return o
}

// SetRootClusterID adds the rootClusterId to the get service topology params
func (o *GetServiceTopologyParams) SetRootClusterID(rootClusterID *string) {
	o.RootClusterID = rootClusterID
}

// WithRootClusterInternalID adds the rootClusterInternalID to the get service topology params
func (o *GetServiceTopologyParams) WithRootClusterInternalID(rootClusterInternalID *string) *GetServiceTopologyParams {
	o.SetRootClusterInternalID(rootClusterInternalID)
	return o
}

// SetRootClusterInternalID adds the rootClusterInternalId to the get service topology params
func (o *GetServiceTopologyParams) SetRootClusterInternalID(rootClusterInternalID *string) {
	o.RootClusterInternalID = rootClusterInternalID
}

// WithRootName adds the rootName to the get service topology params
func (o *GetServiceTopologyParams) WithRootName(rootName *string) *GetServiceTopologyParams {
	o.SetRootName(rootName)
	return o
}

// SetRootName adds the rootName to the get service topology params
func (o *GetServiceTopologyParams) SetRootName(rootName *string) {
	o.RootName = rootName
}

// WithRootNamespace adds the rootNamespace to the get service topology params
func (o *GetServiceTopologyParams) WithRootNamespace(rootNamespace *string) *GetServiceTopologyParams {
	o.SetRootNamespace(rootNamespace)
	return o
}

// SetRootNamespace adds the rootNamespace to the get service topology params
func (o *GetServiceTopologyParams) SetRootNamespace(rootNamespace *string) {
	o.RootNamespace = rootNamespace
}

// WithRootPartition adds the rootPartition to the get service topology params
func (o *GetServiceTopologyParams) WithRootPartition(rootPartition *string) *GetServiceTopologyParams {
	o.SetRootPartition(rootPartition)
	return o
}

// SetRootPartition adds the rootPartition to the get service topology params
func (o *GetServiceTopologyParams) SetRootPartition(rootPartition *string) {
	o.RootPartition = rootPartition
}

// WithRootTrustDomain adds the rootTrustDomain to the get service topology params
func (o *GetServiceTopologyParams) WithRootTrustDomain(rootTrustDomain *string) *GetServiceTopologyParams {
	o.SetRootTrustDomain(rootTrustDomain)
	return o
}

// SetRootTrustDomain adds the rootTrustDomain to the get service topology params
func (o *GetServiceTopologyParams) SetRootTrustDomain(rootTrustDomain *string) {
	o.RootTrustDomain = rootTrustDomain
}

// WithStart adds the start to the get service topology params
func (o *GetServiceTopologyParams) WithStart(start *strfmt.DateTime) *GetServiceTopologyParams {
	o.SetStart(start)
	return o
}

// SetStart adds the start to the get service topology params
func (o *GetServiceTopologyParams) SetStart(start *strfmt.DateTime) {
	o.Start = start
}

// WriteToRequest writes these params to a swagger request
func (o *GetServiceTopologyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Duration != nil {

		// query param duration
		var qrDuration string

		if o.Duration != nil {
			qrDuration = *o.Duration
		}
		qDuration := qrDuration
		if qDuration != "" {

			if err := r.SetQueryParam("duration", qDuration); err != nil {
				return err
			}
		}
	}

	if o.IncludesClusterID != nil {

		// query param includes.cluster_id
		var qrIncludesClusterID string

		if o.IncludesClusterID != nil {
			qrIncludesClusterID = *o.IncludesClusterID
		}
		qIncludesClusterID := qrIncludesClusterID
		if qIncludesClusterID != "" {

			if err := r.SetQueryParam("includes.cluster_id", qIncludesClusterID); err != nil {
				return err
			}
		}
	}

	if o.IncludesClusterInternalID != nil {

		// query param includes.cluster_internal_id
		var qrIncludesClusterInternalID string

		if o.IncludesClusterInternalID != nil {
			qrIncludesClusterInternalID = *o.IncludesClusterInternalID
		}
		qIncludesClusterInternalID := qrIncludesClusterInternalID
		if qIncludesClusterInternalID != "" {

			if err := r.SetQueryParam("includes.cluster_internal_id", qIncludesClusterInternalID); err != nil {
				return err
			}
		}
	}

	if o.IncludesName != nil {

		// query param includes.name
		var qrIncludesName string

		if o.IncludesName != nil {
			qrIncludesName = *o.IncludesName
		}
		qIncludesName := qrIncludesName
		if qIncludesName != "" {

			if err := r.SetQueryParam("includes.name", qIncludesName); err != nil {
				return err
			}
		}
	}

	if o.IncludesNamespace != nil {

		// query param includes.namespace
		var qrIncludesNamespace string

		if o.IncludesNamespace != nil {
			qrIncludesNamespace = *o.IncludesNamespace
		}
		qIncludesNamespace := qrIncludesNamespace
		if qIncludesNamespace != "" {

			if err := r.SetQueryParam("includes.namespace", qIncludesNamespace); err != nil {
				return err
			}
		}
	}

	if o.IncludesPartition != nil {

		// query param includes.partition
		var qrIncludesPartition string

		if o.IncludesPartition != nil {
			qrIncludesPartition = *o.IncludesPartition
		}
		qIncludesPartition := qrIncludesPartition
		if qIncludesPartition != "" {

			if err := r.SetQueryParam("includes.partition", qIncludesPartition); err != nil {
				return err
			}
		}
	}

	if o.IncludesTrustDomain != nil {

		// query param includes.trust_domain
		var qrIncludesTrustDomain string

		if o.IncludesTrustDomain != nil {
			qrIncludesTrustDomain = *o.IncludesTrustDomain
		}
		qIncludesTrustDomain := qrIncludesTrustDomain
		if qIncludesTrustDomain != "" {

			if err := r.SetQueryParam("includes.trust_domain", qIncludesTrustDomain); err != nil {
				return err
			}
		}
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.RootClusterID != nil {

		// query param root.cluster_id
		var qrRootClusterID string

		if o.RootClusterID != nil {
			qrRootClusterID = *o.RootClusterID
		}
		qRootClusterID := qrRootClusterID
		if qRootClusterID != "" {

			if err := r.SetQueryParam("root.cluster_id", qRootClusterID); err != nil {
				return err
			}
		}
	}

	if o.RootClusterInternalID != nil {

		// query param root.cluster_internal_id
		var qrRootClusterInternalID string

		if o.RootClusterInternalID != nil {
			qrRootClusterInternalID = *o.RootClusterInternalID
		}
		qRootClusterInternalID := qrRootClusterInternalID
		if qRootClusterInternalID != "" {

			if err := r.SetQueryParam("root.cluster_internal_id", qRootClusterInternalID); err != nil {
				return err
			}
		}
	}

	if o.RootName != nil {

		// query param root.name
		var qrRootName string

		if o.RootName != nil {
			qrRootName = *o.RootName
		}
		qRootName := qrRootName
		if qRootName != "" {

			if err := r.SetQueryParam("root.name", qRootName); err != nil {
				return err
			}
		}
	}

	if o.RootNamespace != nil {

		// query param root.namespace
		var qrRootNamespace string

		if o.RootNamespace != nil {
			qrRootNamespace = *o.RootNamespace
		}
		qRootNamespace := qrRootNamespace
		if qRootNamespace != "" {

			if err := r.SetQueryParam("root.namespace", qRootNamespace); err != nil {
				return err
			}
		}
	}

	if o.RootPartition != nil {

		// query param root.partition
		var qrRootPartition string

		if o.RootPartition != nil {
			qrRootPartition = *o.RootPartition
		}
		qRootPartition := qrRootPartition
		if qRootPartition != "" {

			if err := r.SetQueryParam("root.partition", qRootPartition); err != nil {
				return err
			}
		}
	}

	if o.RootTrustDomain != nil {

		// query param root.trust_domain
		var qrRootTrustDomain string

		if o.RootTrustDomain != nil {
			qrRootTrustDomain = *o.RootTrustDomain
		}
		qRootTrustDomain := qrRootTrustDomain
		if qRootTrustDomain != "" {

			if err := r.SetQueryParam("root.trust_domain", qRootTrustDomain); err != nil {
				return err
			}
		}
	}

	if o.Start != nil {

		// query param start
		var qrStart strfmt.DateTime

		if o.Start != nil {
			qrStart = *o.Start
		}
		qStart := qrStart.String()
		if qStart != "" {

			if err := r.SetQueryParam("start", qStart); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
