// Code generated by go-swagger; DO NOT EDIT.

package nodes

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2023-10-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ListNodesReader is a Reader for the ListNodes structure.
type ListNodesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListNodesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListNodesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListNodesDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListNodesOK creates a ListNodesOK with default headers values
func NewListNodesOK() *ListNodesOK {
	return &ListNodesOK{}
}

/*
ListNodesOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListNodesOK struct {
	Payload *models.HashicorpCloudConsulCloudManager20231010ListNodesResponse
}

// IsSuccess returns true when this list nodes o k response has a 2xx status code
func (o *ListNodesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list nodes o k response has a 3xx status code
func (o *ListNodesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list nodes o k response has a 4xx status code
func (o *ListNodesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list nodes o k response has a 5xx status code
func (o *ListNodesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list nodes o k response a status code equal to that given
func (o *ListNodesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list nodes o k response
func (o *ListNodesOK) Code() int {
	return 200
}

func (o *ListNodesOK) Error() string {
	return fmt.Sprintf("[GET /2023-10-10/consul/{project_resource_name}/nodes][%d] listNodesOK  %+v", 200, o.Payload)
}

func (o *ListNodesOK) String() string {
	return fmt.Sprintf("[GET /2023-10-10/consul/{project_resource_name}/nodes][%d] listNodesOK  %+v", 200, o.Payload)
}

func (o *ListNodesOK) GetPayload() *models.HashicorpCloudConsulCloudManager20231010ListNodesResponse {
	return o.Payload
}

func (o *ListNodesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudConsulCloudManager20231010ListNodesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListNodesDefault creates a ListNodesDefault with default headers values
func NewListNodesDefault(code int) *ListNodesDefault {
	return &ListNodesDefault{
		_statusCode: code,
	}
}

/*
ListNodesDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListNodesDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this list nodes default response has a 2xx status code
func (o *ListNodesDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list nodes default response has a 3xx status code
func (o *ListNodesDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list nodes default response has a 4xx status code
func (o *ListNodesDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list nodes default response has a 5xx status code
func (o *ListNodesDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list nodes default response a status code equal to that given
func (o *ListNodesDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list nodes default response
func (o *ListNodesDefault) Code() int {
	return o._statusCode
}

func (o *ListNodesDefault) Error() string {
	return fmt.Sprintf("[GET /2023-10-10/consul/{project_resource_name}/nodes][%d] List Nodes default  %+v", o._statusCode, o.Payload)
}

func (o *ListNodesDefault) String() string {
	return fmt.Sprintf("[GET /2023-10-10/consul/{project_resource_name}/nodes][%d] List Nodes default  %+v", o._statusCode, o.Payload)
}

func (o *ListNodesDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ListNodesDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
