// Code generated by go-swagger; DO NOT EDIT.

package service_instances

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2023-10-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GetServiceInstanceReader is a Reader for the GetServiceInstance structure.
type GetServiceInstanceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetServiceInstanceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetServiceInstanceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetServiceInstanceDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetServiceInstanceOK creates a GetServiceInstanceOK with default headers values
func NewGetServiceInstanceOK() *GetServiceInstanceOK {
	return &GetServiceInstanceOK{}
}

/*
GetServiceInstanceOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetServiceInstanceOK struct {
	Payload *models.HashicorpCloudConsulCloudManager20231010GetServiceInstanceResponse
}

// IsSuccess returns true when this get service instance o k response has a 2xx status code
func (o *GetServiceInstanceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get service instance o k response has a 3xx status code
func (o *GetServiceInstanceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get service instance o k response has a 4xx status code
func (o *GetServiceInstanceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get service instance o k response has a 5xx status code
func (o *GetServiceInstanceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get service instance o k response a status code equal to that given
func (o *GetServiceInstanceOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get service instance o k response
func (o *GetServiceInstanceOK) Code() int {
	return 200
}

func (o *GetServiceInstanceOK) Error() string {
	return fmt.Sprintf("[GET /2023-10-10/{cluster_resource_name}/node/{node}/service/{service_name}/instance/{instance_id}][%d] getServiceInstanceOK  %+v", 200, o.Payload)
}

func (o *GetServiceInstanceOK) String() string {
	return fmt.Sprintf("[GET /2023-10-10/{cluster_resource_name}/node/{node}/service/{service_name}/instance/{instance_id}][%d] getServiceInstanceOK  %+v", 200, o.Payload)
}

func (o *GetServiceInstanceOK) GetPayload() *models.HashicorpCloudConsulCloudManager20231010GetServiceInstanceResponse {
	return o.Payload
}

func (o *GetServiceInstanceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudConsulCloudManager20231010GetServiceInstanceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetServiceInstanceDefault creates a GetServiceInstanceDefault with default headers values
func NewGetServiceInstanceDefault(code int) *GetServiceInstanceDefault {
	return &GetServiceInstanceDefault{
		_statusCode: code,
	}
}

/*
GetServiceInstanceDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetServiceInstanceDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this get service instance default response has a 2xx status code
func (o *GetServiceInstanceDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get service instance default response has a 3xx status code
func (o *GetServiceInstanceDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get service instance default response has a 4xx status code
func (o *GetServiceInstanceDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get service instance default response has a 5xx status code
func (o *GetServiceInstanceDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get service instance default response a status code equal to that given
func (o *GetServiceInstanceDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get service instance default response
func (o *GetServiceInstanceDefault) Code() int {
	return o._statusCode
}

func (o *GetServiceInstanceDefault) Error() string {
	return fmt.Sprintf("[GET /2023-10-10/{cluster_resource_name}/node/{node}/service/{service_name}/instance/{instance_id}][%d] Get Service Instance default  %+v", o._statusCode, o.Payload)
}

func (o *GetServiceInstanceDefault) String() string {
	return fmt.Sprintf("[GET /2023-10-10/{cluster_resource_name}/node/{node}/service/{service_name}/instance/{instance_id}][%d] Get Service Instance default  %+v", o._statusCode, o.Payload)
}

func (o *GetServiceInstanceDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GetServiceInstanceDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
