// Code generated by go-swagger; DO NOT EDIT.

package groups_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GroupsServiceCreateGroupReader is a Reader for the GroupsServiceCreateGroup structure.
type GroupsServiceCreateGroupReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GroupsServiceCreateGroupReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGroupsServiceCreateGroupOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGroupsServiceCreateGroupDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGroupsServiceCreateGroupOK creates a GroupsServiceCreateGroupOK with default headers values
func NewGroupsServiceCreateGroupOK() *GroupsServiceCreateGroupOK {
	return &GroupsServiceCreateGroupOK{}
}

/*
GroupsServiceCreateGroupOK describes a response with status code 200, with default header values.

A successful response.
*/
type GroupsServiceCreateGroupOK struct {
	Payload *models.HashicorpCloudIamCreateGroupResponse
}

// IsSuccess returns true when this groups service create group o k response has a 2xx status code
func (o *GroupsServiceCreateGroupOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this groups service create group o k response has a 3xx status code
func (o *GroupsServiceCreateGroupOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this groups service create group o k response has a 4xx status code
func (o *GroupsServiceCreateGroupOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this groups service create group o k response has a 5xx status code
func (o *GroupsServiceCreateGroupOK) IsServerError() bool {
	return false
}

// IsCode returns true when this groups service create group o k response a status code equal to that given
func (o *GroupsServiceCreateGroupOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the groups service create group o k response
func (o *GroupsServiceCreateGroupOK) Code() int {
	return 200
}

func (o *GroupsServiceCreateGroupOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/iam/{parent_resource_name}/groups][%d] groupsServiceCreateGroupOK %s", 200, payload)
}

func (o *GroupsServiceCreateGroupOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/iam/{parent_resource_name}/groups][%d] groupsServiceCreateGroupOK %s", 200, payload)
}

func (o *GroupsServiceCreateGroupOK) GetPayload() *models.HashicorpCloudIamCreateGroupResponse {
	return o.Payload
}

func (o *GroupsServiceCreateGroupOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamCreateGroupResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGroupsServiceCreateGroupDefault creates a GroupsServiceCreateGroupDefault with default headers values
func NewGroupsServiceCreateGroupDefault(code int) *GroupsServiceCreateGroupDefault {
	return &GroupsServiceCreateGroupDefault{
		_statusCode: code,
	}
}

/*
GroupsServiceCreateGroupDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GroupsServiceCreateGroupDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this groups service create group default response has a 2xx status code
func (o *GroupsServiceCreateGroupDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this groups service create group default response has a 3xx status code
func (o *GroupsServiceCreateGroupDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this groups service create group default response has a 4xx status code
func (o *GroupsServiceCreateGroupDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this groups service create group default response has a 5xx status code
func (o *GroupsServiceCreateGroupDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this groups service create group default response a status code equal to that given
func (o *GroupsServiceCreateGroupDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the groups service create group default response
func (o *GroupsServiceCreateGroupDefault) Code() int {
	return o._statusCode
}

func (o *GroupsServiceCreateGroupDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/iam/{parent_resource_name}/groups][%d] GroupsService_CreateGroup default %s", o._statusCode, payload)
}

func (o *GroupsServiceCreateGroupDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/iam/{parent_resource_name}/groups][%d] GroupsService_CreateGroup default %s", o._statusCode, payload)
}

func (o *GroupsServiceCreateGroupDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GroupsServiceCreateGroupDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
GroupsServiceCreateGroupBody groups service create group body
swagger:model GroupsServiceCreateGroupBody
*/
type GroupsServiceCreateGroupBody struct {

	// description is a description of the group.
	Description string `json:"description,omitempty"`

	// member_principal_ids is a list of the ids of the principals that should belong to this group.
	MemberPrincipalIds []string `json:"member_principal_ids"`

	// name is the name part of the group resource_name.
	Name string `json:"name,omitempty"`
}

// Validate validates this groups service create group body
func (o *GroupsServiceCreateGroupBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this groups service create group body based on context it is used
func (o *GroupsServiceCreateGroupBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *GroupsServiceCreateGroupBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GroupsServiceCreateGroupBody) UnmarshalBinary(b []byte) error {
	var res GroupsServiceCreateGroupBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
