// Code generated by go-swagger; DO NOT EDIT.

package groups_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GroupsServiceListGroupMembersReader is a Reader for the GroupsServiceListGroupMembers structure.
type GroupsServiceListGroupMembersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GroupsServiceListGroupMembersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGroupsServiceListGroupMembersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGroupsServiceListGroupMembersDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGroupsServiceListGroupMembersOK creates a GroupsServiceListGroupMembersOK with default headers values
func NewGroupsServiceListGroupMembersOK() *GroupsServiceListGroupMembersOK {
	return &GroupsServiceListGroupMembersOK{}
}

/*
GroupsServiceListGroupMembersOK describes a response with status code 200, with default header values.

A successful response.
*/
type GroupsServiceListGroupMembersOK struct {
	Payload *models.HashicorpCloudIamListGroupMembersResponse
}

// IsSuccess returns true when this groups service list group members o k response has a 2xx status code
func (o *GroupsServiceListGroupMembersOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this groups service list group members o k response has a 3xx status code
func (o *GroupsServiceListGroupMembersOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this groups service list group members o k response has a 4xx status code
func (o *GroupsServiceListGroupMembersOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this groups service list group members o k response has a 5xx status code
func (o *GroupsServiceListGroupMembersOK) IsServerError() bool {
	return false
}

// IsCode returns true when this groups service list group members o k response a status code equal to that given
func (o *GroupsServiceListGroupMembersOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the groups service list group members o k response
func (o *GroupsServiceListGroupMembersOK) Code() int {
	return 200
}

func (o *GroupsServiceListGroupMembersOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/{resource_name}/members][%d] groupsServiceListGroupMembersOK %s", 200, payload)
}

func (o *GroupsServiceListGroupMembersOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/{resource_name}/members][%d] groupsServiceListGroupMembersOK %s", 200, payload)
}

func (o *GroupsServiceListGroupMembersOK) GetPayload() *models.HashicorpCloudIamListGroupMembersResponse {
	return o.Payload
}

func (o *GroupsServiceListGroupMembersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamListGroupMembersResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGroupsServiceListGroupMembersDefault creates a GroupsServiceListGroupMembersDefault with default headers values
func NewGroupsServiceListGroupMembersDefault(code int) *GroupsServiceListGroupMembersDefault {
	return &GroupsServiceListGroupMembersDefault{
		_statusCode: code,
	}
}

/*
GroupsServiceListGroupMembersDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GroupsServiceListGroupMembersDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this groups service list group members default response has a 2xx status code
func (o *GroupsServiceListGroupMembersDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this groups service list group members default response has a 3xx status code
func (o *GroupsServiceListGroupMembersDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this groups service list group members default response has a 4xx status code
func (o *GroupsServiceListGroupMembersDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this groups service list group members default response has a 5xx status code
func (o *GroupsServiceListGroupMembersDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this groups service list group members default response a status code equal to that given
func (o *GroupsServiceListGroupMembersDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the groups service list group members default response
func (o *GroupsServiceListGroupMembersDefault) Code() int {
	return o._statusCode
}

func (o *GroupsServiceListGroupMembersDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/{resource_name}/members][%d] GroupsService_ListGroupMembers default %s", o._statusCode, payload)
}

func (o *GroupsServiceListGroupMembersDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/{resource_name}/members][%d] GroupsService_ListGroupMembers default %s", o._statusCode, payload)
}

func (o *GroupsServiceListGroupMembersDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GroupsServiceListGroupMembersDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
