// Code generated by go-swagger; DO NOT EDIT.

package streaming_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-log-service/preview/2021-03-30/models"
)

// StreamingServiceDeleteDestinationReader is a Reader for the StreamingServiceDeleteDestination structure.
type StreamingServiceDeleteDestinationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StreamingServiceDeleteDestinationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStreamingServiceDeleteDestinationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStreamingServiceDeleteDestinationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStreamingServiceDeleteDestinationOK creates a StreamingServiceDeleteDestinationOK with default headers values
func NewStreamingServiceDeleteDestinationOK() *StreamingServiceDeleteDestinationOK {
	return &StreamingServiceDeleteDestinationOK{}
}

/*
StreamingServiceDeleteDestinationOK describes a response with status code 200, with default header values.

A successful response.
*/
type StreamingServiceDeleteDestinationOK struct {
	Payload models.LogService20210330DeleteDestinationResponse
}

// IsSuccess returns true when this streaming service delete destination o k response has a 2xx status code
func (o *StreamingServiceDeleteDestinationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this streaming service delete destination o k response has a 3xx status code
func (o *StreamingServiceDeleteDestinationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this streaming service delete destination o k response has a 4xx status code
func (o *StreamingServiceDeleteDestinationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this streaming service delete destination o k response has a 5xx status code
func (o *StreamingServiceDeleteDestinationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this streaming service delete destination o k response a status code equal to that given
func (o *StreamingServiceDeleteDestinationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the streaming service delete destination o k response
func (o *StreamingServiceDeleteDestinationOK) Code() int {
	return 200
}

func (o *StreamingServiceDeleteDestinationOK) Error() string {
	return fmt.Sprintf("[DELETE /logs/2021-03-30/organizations/{organization_id}/destinations/{destination_id}][%d] streamingServiceDeleteDestinationOK  %+v", 200, o.Payload)
}

func (o *StreamingServiceDeleteDestinationOK) String() string {
	return fmt.Sprintf("[DELETE /logs/2021-03-30/organizations/{organization_id}/destinations/{destination_id}][%d] streamingServiceDeleteDestinationOK  %+v", 200, o.Payload)
}

func (o *StreamingServiceDeleteDestinationOK) GetPayload() models.LogService20210330DeleteDestinationResponse {
	return o.Payload
}

func (o *StreamingServiceDeleteDestinationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStreamingServiceDeleteDestinationDefault creates a StreamingServiceDeleteDestinationDefault with default headers values
func NewStreamingServiceDeleteDestinationDefault(code int) *StreamingServiceDeleteDestinationDefault {
	return &StreamingServiceDeleteDestinationDefault{
		_statusCode: code,
	}
}

/*
StreamingServiceDeleteDestinationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type StreamingServiceDeleteDestinationDefault struct {
	_statusCode int

	Payload *models.RuntimeError
}

// IsSuccess returns true when this streaming service delete destination default response has a 2xx status code
func (o *StreamingServiceDeleteDestinationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this streaming service delete destination default response has a 3xx status code
func (o *StreamingServiceDeleteDestinationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this streaming service delete destination default response has a 4xx status code
func (o *StreamingServiceDeleteDestinationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this streaming service delete destination default response has a 5xx status code
func (o *StreamingServiceDeleteDestinationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this streaming service delete destination default response a status code equal to that given
func (o *StreamingServiceDeleteDestinationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the streaming service delete destination default response
func (o *StreamingServiceDeleteDestinationDefault) Code() int {
	return o._statusCode
}

func (o *StreamingServiceDeleteDestinationDefault) Error() string {
	return fmt.Sprintf("[DELETE /logs/2021-03-30/organizations/{organization_id}/destinations/{destination_id}][%d] StreamingService_DeleteDestination default  %+v", o._statusCode, o.Payload)
}

func (o *StreamingServiceDeleteDestinationDefault) String() string {
	return fmt.Sprintf("[DELETE /logs/2021-03-30/organizations/{organization_id}/destinations/{destination_id}][%d] StreamingService_DeleteDestination default  %+v", o._statusCode, o.Payload)
}

func (o *StreamingServiceDeleteDestinationDefault) GetPayload() *models.RuntimeError {
	return o.Payload
}

func (o *StreamingServiceDeleteDestinationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
