// Code generated by go-swagger; DO NOT EDIT.

package streaming_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-log-service/preview/2021-03-30/models"
)

// StreamingServiceTestDestinationReader is a Reader for the StreamingServiceTestDestination structure.
type StreamingServiceTestDestinationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StreamingServiceTestDestinationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStreamingServiceTestDestinationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStreamingServiceTestDestinationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStreamingServiceTestDestinationOK creates a StreamingServiceTestDestinationOK with default headers values
func NewStreamingServiceTestDestinationOK() *StreamingServiceTestDestinationOK {
	return &StreamingServiceTestDestinationOK{}
}

/*
StreamingServiceTestDestinationOK describes a response with status code 200, with default header values.

A successful response.
*/
type StreamingServiceTestDestinationOK struct {
	Payload *models.LogService20210330TestDestinationResponse
}

// IsSuccess returns true when this streaming service test destination o k response has a 2xx status code
func (o *StreamingServiceTestDestinationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this streaming service test destination o k response has a 3xx status code
func (o *StreamingServiceTestDestinationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this streaming service test destination o k response has a 4xx status code
func (o *StreamingServiceTestDestinationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this streaming service test destination o k response has a 5xx status code
func (o *StreamingServiceTestDestinationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this streaming service test destination o k response a status code equal to that given
func (o *StreamingServiceTestDestinationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the streaming service test destination o k response
func (o *StreamingServiceTestDestinationOK) Code() int {
	return 200
}

func (o *StreamingServiceTestDestinationOK) Error() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{organization_id}/destinations/test][%d] streamingServiceTestDestinationOK  %+v", 200, o.Payload)
}

func (o *StreamingServiceTestDestinationOK) String() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{organization_id}/destinations/test][%d] streamingServiceTestDestinationOK  %+v", 200, o.Payload)
}

func (o *StreamingServiceTestDestinationOK) GetPayload() *models.LogService20210330TestDestinationResponse {
	return o.Payload
}

func (o *StreamingServiceTestDestinationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LogService20210330TestDestinationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStreamingServiceTestDestinationDefault creates a StreamingServiceTestDestinationDefault with default headers values
func NewStreamingServiceTestDestinationDefault(code int) *StreamingServiceTestDestinationDefault {
	return &StreamingServiceTestDestinationDefault{
		_statusCode: code,
	}
}

/*
StreamingServiceTestDestinationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type StreamingServiceTestDestinationDefault struct {
	_statusCode int

	Payload *models.RuntimeError
}

// IsSuccess returns true when this streaming service test destination default response has a 2xx status code
func (o *StreamingServiceTestDestinationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this streaming service test destination default response has a 3xx status code
func (o *StreamingServiceTestDestinationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this streaming service test destination default response has a 4xx status code
func (o *StreamingServiceTestDestinationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this streaming service test destination default response has a 5xx status code
func (o *StreamingServiceTestDestinationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this streaming service test destination default response a status code equal to that given
func (o *StreamingServiceTestDestinationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the streaming service test destination default response
func (o *StreamingServiceTestDestinationDefault) Code() int {
	return o._statusCode
}

func (o *StreamingServiceTestDestinationDefault) Error() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{organization_id}/destinations/test][%d] StreamingService_TestDestination default  %+v", o._statusCode, o.Payload)
}

func (o *StreamingServiceTestDestinationDefault) String() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{organization_id}/destinations/test][%d] StreamingService_TestDestination default  %+v", o._statusCode, o.Payload)
}

func (o *StreamingServiceTestDestinationDefault) GetPayload() *models.RuntimeError {
	return o.Payload
}

func (o *StreamingServiceTestDestinationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
