// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2021-04-30/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceGetRegistryReader is a Reader for the PackerServiceGetRegistry structure.
type PackerServiceGetRegistryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceGetRegistryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceGetRegistryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceGetRegistryDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceGetRegistryOK creates a PackerServiceGetRegistryOK with default headers values
func NewPackerServiceGetRegistryOK() *PackerServiceGetRegistryOK {
	return &PackerServiceGetRegistryOK{}
}

/*
PackerServiceGetRegistryOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceGetRegistryOK struct {
	Payload *models.HashicorpCloudPackerGetRegistryResponse
}

// IsSuccess returns true when this packer service get registry o k response has a 2xx status code
func (o *PackerServiceGetRegistryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service get registry o k response has a 3xx status code
func (o *PackerServiceGetRegistryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service get registry o k response has a 4xx status code
func (o *PackerServiceGetRegistryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service get registry o k response has a 5xx status code
func (o *PackerServiceGetRegistryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service get registry o k response a status code equal to that given
func (o *PackerServiceGetRegistryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service get registry o k response
func (o *PackerServiceGetRegistryOK) Code() int {
	return 200
}

func (o *PackerServiceGetRegistryOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] packerServiceGetRegistryOK %s", 200, payload)
}

func (o *PackerServiceGetRegistryOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] packerServiceGetRegistryOK %s", 200, payload)
}

func (o *PackerServiceGetRegistryOK) GetPayload() *models.HashicorpCloudPackerGetRegistryResponse {
	return o.Payload
}

func (o *PackerServiceGetRegistryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPackerGetRegistryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceGetRegistryDefault creates a PackerServiceGetRegistryDefault with default headers values
func NewPackerServiceGetRegistryDefault(code int) *PackerServiceGetRegistryDefault {
	return &PackerServiceGetRegistryDefault{
		_statusCode: code,
	}
}

/*
PackerServiceGetRegistryDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceGetRegistryDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service get registry default response has a 2xx status code
func (o *PackerServiceGetRegistryDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service get registry default response has a 3xx status code
func (o *PackerServiceGetRegistryDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service get registry default response has a 4xx status code
func (o *PackerServiceGetRegistryDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service get registry default response has a 5xx status code
func (o *PackerServiceGetRegistryDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service get registry default response a status code equal to that given
func (o *PackerServiceGetRegistryDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service get registry default response
func (o *PackerServiceGetRegistryDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceGetRegistryDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] PackerService_GetRegistry default %s", o._statusCode, payload)
}

func (o *PackerServiceGetRegistryDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] PackerService_GetRegistry default %s", o._statusCode, payload)
}

func (o *PackerServiceGetRegistryDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceGetRegistryDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
