// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2023-01-01/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceUpdateBucketReader is a Reader for the PackerServiceUpdateBucket structure.
type PackerServiceUpdateBucketReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceUpdateBucketReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceUpdateBucketOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceUpdateBucketDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceUpdateBucketOK creates a PackerServiceUpdateBucketOK with default headers values
func NewPackerServiceUpdateBucketOK() *PackerServiceUpdateBucketOK {
	return &PackerServiceUpdateBucketOK{}
}

/*
PackerServiceUpdateBucketOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceUpdateBucketOK struct {
	Payload *models.HashicorpCloudPacker20230101UpdateBucketResponse
}

// IsSuccess returns true when this packer service update bucket o k response has a 2xx status code
func (o *PackerServiceUpdateBucketOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service update bucket o k response has a 3xx status code
func (o *PackerServiceUpdateBucketOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service update bucket o k response has a 4xx status code
func (o *PackerServiceUpdateBucketOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service update bucket o k response has a 5xx status code
func (o *PackerServiceUpdateBucketOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service update bucket o k response a status code equal to that given
func (o *PackerServiceUpdateBucketOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service update bucket o k response
func (o *PackerServiceUpdateBucketOK) Code() int {
	return 200
}

func (o *PackerServiceUpdateBucketOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}][%d] packerServiceUpdateBucketOK %s", 200, payload)
}

func (o *PackerServiceUpdateBucketOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}][%d] packerServiceUpdateBucketOK %s", 200, payload)
}

func (o *PackerServiceUpdateBucketOK) GetPayload() *models.HashicorpCloudPacker20230101UpdateBucketResponse {
	return o.Payload
}

func (o *PackerServiceUpdateBucketOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20230101UpdateBucketResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceUpdateBucketDefault creates a PackerServiceUpdateBucketDefault with default headers values
func NewPackerServiceUpdateBucketDefault(code int) *PackerServiceUpdateBucketDefault {
	return &PackerServiceUpdateBucketDefault{
		_statusCode: code,
	}
}

/*
PackerServiceUpdateBucketDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceUpdateBucketDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service update bucket default response has a 2xx status code
func (o *PackerServiceUpdateBucketDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service update bucket default response has a 3xx status code
func (o *PackerServiceUpdateBucketDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service update bucket default response has a 4xx status code
func (o *PackerServiceUpdateBucketDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service update bucket default response has a 5xx status code
func (o *PackerServiceUpdateBucketDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service update bucket default response a status code equal to that given
func (o *PackerServiceUpdateBucketDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service update bucket default response
func (o *PackerServiceUpdateBucketDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceUpdateBucketDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}][%d] PackerService_UpdateBucket default %s", o._statusCode, payload)
}

func (o *PackerServiceUpdateBucketDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}][%d] PackerService_UpdateBucket default %s", o._statusCode, payload)
}

func (o *PackerServiceUpdateBucketDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceUpdateBucketDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
