// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2023-01-01/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceUpdateRegistryReader is a Reader for the PackerServiceUpdateRegistry structure.
type PackerServiceUpdateRegistryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceUpdateRegistryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceUpdateRegistryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceUpdateRegistryDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceUpdateRegistryOK creates a PackerServiceUpdateRegistryOK with default headers values
func NewPackerServiceUpdateRegistryOK() *PackerServiceUpdateRegistryOK {
	return &PackerServiceUpdateRegistryOK{}
}

/*
PackerServiceUpdateRegistryOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceUpdateRegistryOK struct {
	Payload *models.HashicorpCloudPacker20230101UpdateRegistryResponse
}

// IsSuccess returns true when this packer service update registry o k response has a 2xx status code
func (o *PackerServiceUpdateRegistryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service update registry o k response has a 3xx status code
func (o *PackerServiceUpdateRegistryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service update registry o k response has a 4xx status code
func (o *PackerServiceUpdateRegistryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service update registry o k response has a 5xx status code
func (o *PackerServiceUpdateRegistryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service update registry o k response a status code equal to that given
func (o *PackerServiceUpdateRegistryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service update registry o k response
func (o *PackerServiceUpdateRegistryOK) Code() int {
	return 200
}

func (o *PackerServiceUpdateRegistryOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] packerServiceUpdateRegistryOK %s", 200, payload)
}

func (o *PackerServiceUpdateRegistryOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] packerServiceUpdateRegistryOK %s", 200, payload)
}

func (o *PackerServiceUpdateRegistryOK) GetPayload() *models.HashicorpCloudPacker20230101UpdateRegistryResponse {
	return o.Payload
}

func (o *PackerServiceUpdateRegistryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20230101UpdateRegistryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceUpdateRegistryDefault creates a PackerServiceUpdateRegistryDefault with default headers values
func NewPackerServiceUpdateRegistryDefault(code int) *PackerServiceUpdateRegistryDefault {
	return &PackerServiceUpdateRegistryDefault{
		_statusCode: code,
	}
}

/*
PackerServiceUpdateRegistryDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceUpdateRegistryDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service update registry default response has a 2xx status code
func (o *PackerServiceUpdateRegistryDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service update registry default response has a 3xx status code
func (o *PackerServiceUpdateRegistryDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service update registry default response has a 4xx status code
func (o *PackerServiceUpdateRegistryDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service update registry default response has a 5xx status code
func (o *PackerServiceUpdateRegistryDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service update registry default response a status code equal to that given
func (o *PackerServiceUpdateRegistryDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service update registry default response
func (o *PackerServiceUpdateRegistryDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceUpdateRegistryDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] PackerService_UpdateRegistry default %s", o._statusCode, payload)
}

func (o *PackerServiceUpdateRegistryDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] PackerService_UpdateRegistry default %s", o._statusCode, payload)
}

func (o *PackerServiceUpdateRegistryDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceUpdateRegistryDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
