// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// NewCreateArchitectureParams creates a new CreateArchitectureParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateArchitectureParams() *CreateArchitectureParams {
	return &CreateArchitectureParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateArchitectureParamsWithTimeout creates a new CreateArchitectureParams object
// with the ability to set a timeout on a request.
func NewCreateArchitectureParamsWithTimeout(timeout time.Duration) *CreateArchitectureParams {
	return &CreateArchitectureParams{
		timeout: timeout,
	}
}

// NewCreateArchitectureParamsWithContext creates a new CreateArchitectureParams object
// with the ability to set a context for a request.
func NewCreateArchitectureParamsWithContext(ctx context.Context) *CreateArchitectureParams {
	return &CreateArchitectureParams{
		Context: ctx,
	}
}

// NewCreateArchitectureParamsWithHTTPClient creates a new CreateArchitectureParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateArchitectureParamsWithHTTPClient(client *http.Client) *CreateArchitectureParams {
	return &CreateArchitectureParams{
		HTTPClient: client,
	}
}

/*
CreateArchitectureParams contains all the parameters to send to the API endpoint

	for the create architecture operation.

	Typically these are written to a http.Request.
*/
type CreateArchitectureParams struct {

	/* Box.

	     The name segment of the Box. As an example, this field would represent the
	"vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* Data.

	   Details of the Architecture to create.
	*/
	Data *models.HashicorpCloudVagrant20220930Architecture

	/* Provider.

	   The name of the Provider to create the Architecture in.
	*/
	Provider string

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	/* Version.

	   The name of the Version.
	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create architecture params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateArchitectureParams) WithDefaults() *CreateArchitectureParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create architecture params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateArchitectureParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create architecture params
func (o *CreateArchitectureParams) WithTimeout(timeout time.Duration) *CreateArchitectureParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create architecture params
func (o *CreateArchitectureParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create architecture params
func (o *CreateArchitectureParams) WithContext(ctx context.Context) *CreateArchitectureParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create architecture params
func (o *CreateArchitectureParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create architecture params
func (o *CreateArchitectureParams) WithHTTPClient(client *http.Client) *CreateArchitectureParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create architecture params
func (o *CreateArchitectureParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBox adds the box to the create architecture params
func (o *CreateArchitectureParams) WithBox(box string) *CreateArchitectureParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the create architecture params
func (o *CreateArchitectureParams) SetBox(box string) {
	o.Box = box
}

// WithData adds the data to the create architecture params
func (o *CreateArchitectureParams) WithData(data *models.HashicorpCloudVagrant20220930Architecture) *CreateArchitectureParams {
	o.SetData(data)
	return o
}

// SetData adds the data to the create architecture params
func (o *CreateArchitectureParams) SetData(data *models.HashicorpCloudVagrant20220930Architecture) {
	o.Data = data
}

// WithProvider adds the provider to the create architecture params
func (o *CreateArchitectureParams) WithProvider(provider string) *CreateArchitectureParams {
	o.SetProvider(provider)
	return o
}

// SetProvider adds the provider to the create architecture params
func (o *CreateArchitectureParams) SetProvider(provider string) {
	o.Provider = provider
}

// WithRegistry adds the registry to the create architecture params
func (o *CreateArchitectureParams) WithRegistry(registry string) *CreateArchitectureParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the create architecture params
func (o *CreateArchitectureParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WithVersion adds the version to the create architecture params
func (o *CreateArchitectureParams) WithVersion(version string) *CreateArchitectureParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the create architecture params
func (o *CreateArchitectureParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *CreateArchitectureParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}
	if o.Data != nil {
		if err := r.SetBodyParam(o.Data); err != nil {
			return err
		}
	}

	// path param provider
	if err := r.SetPathParam("provider", o.Provider); err != nil {
		return err
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
