// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListBoxesParams creates a new ListBoxesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListBoxesParams() *ListBoxesParams {
	return &ListBoxesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListBoxesParamsWithTimeout creates a new ListBoxesParams object
// with the ability to set a timeout on a request.
func NewListBoxesParamsWithTimeout(timeout time.Duration) *ListBoxesParams {
	return &ListBoxesParams{
		timeout: timeout,
	}
}

// NewListBoxesParamsWithContext creates a new ListBoxesParams object
// with the ability to set a context for a request.
func NewListBoxesParamsWithContext(ctx context.Context) *ListBoxesParams {
	return &ListBoxesParams{
		Context: ctx,
	}
}

// NewListBoxesParamsWithHTTPClient creates a new ListBoxesParams object
// with the ability to set a custom HTTPClient for a request.
func NewListBoxesParamsWithHTTPClient(client *http.Client) *ListBoxesParams {
	return &ListBoxesParams{
		HTTPClient: client,
	}
}

/*
ListBoxesParams contains all the parameters to send to the API endpoint

	for the list boxes operation.

	Typically these are written to a http.Request.
*/
type ListBoxesParams struct {

	/* Expanded.

	   Expand the box child elements.
	*/
	Expanded *bool

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	/* Registry.

	   The name of the Registry to list boxes in.
	*/
	Registry string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list boxes params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListBoxesParams) WithDefaults() *ListBoxesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list boxes params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListBoxesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list boxes params
func (o *ListBoxesParams) WithTimeout(timeout time.Duration) *ListBoxesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list boxes params
func (o *ListBoxesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list boxes params
func (o *ListBoxesParams) WithContext(ctx context.Context) *ListBoxesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list boxes params
func (o *ListBoxesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list boxes params
func (o *ListBoxesParams) WithHTTPClient(client *http.Client) *ListBoxesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list boxes params
func (o *ListBoxesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithExpanded adds the expanded to the list boxes params
func (o *ListBoxesParams) WithExpanded(expanded *bool) *ListBoxesParams {
	o.SetExpanded(expanded)
	return o
}

// SetExpanded adds the expanded to the list boxes params
func (o *ListBoxesParams) SetExpanded(expanded *bool) {
	o.Expanded = expanded
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the list boxes params
func (o *ListBoxesParams) WithPaginationNextPageToken(paginationNextPageToken *string) *ListBoxesParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the list boxes params
func (o *ListBoxesParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the list boxes params
func (o *ListBoxesParams) WithPaginationPageSize(paginationPageSize *int64) *ListBoxesParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the list boxes params
func (o *ListBoxesParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the list boxes params
func (o *ListBoxesParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *ListBoxesParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the list boxes params
func (o *ListBoxesParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithRegistry adds the registry to the list boxes params
func (o *ListBoxesParams) WithRegistry(registry string) *ListBoxesParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the list boxes params
func (o *ListBoxesParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WriteToRequest writes these params to a swagger request
func (o *ListBoxesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Expanded != nil {

		// query param expanded
		var qrExpanded bool

		if o.Expanded != nil {
			qrExpanded = *o.Expanded
		}
		qExpanded := swag.FormatBool(qrExpanded)
		if qExpanded != "" {

			if err := r.SetQueryParam("expanded", qExpanded); err != nil {
				return err
			}
		}
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
