// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-06-13/models"
)

// ForceSyncReader is a Reader for the ForceSync structure.
type ForceSyncReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ForceSyncReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewForceSyncOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewForceSyncDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewForceSyncOK creates a ForceSyncOK with default headers values
func NewForceSyncOK() *ForceSyncOK {
	return &ForceSyncOK{}
}

/*
ForceSyncOK describes a response with status code 200, with default header values.

A successful response.
*/
type ForceSyncOK struct {
	Payload models.Secrets20230613ForceSyncResponse
}

// IsSuccess returns true when this force sync o k response has a 2xx status code
func (o *ForceSyncOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this force sync o k response has a 3xx status code
func (o *ForceSyncOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this force sync o k response has a 4xx status code
func (o *ForceSyncOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this force sync o k response has a 5xx status code
func (o *ForceSyncOK) IsServerError() bool {
	return false
}

// IsCode returns true when this force sync o k response a status code equal to that given
func (o *ForceSyncOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the force sync o k response
func (o *ForceSyncOK) Code() int {
	return 200
}

func (o *ForceSyncOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/force][%d] forceSyncOK %s", 200, payload)
}

func (o *ForceSyncOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/force][%d] forceSyncOK %s", 200, payload)
}

func (o *ForceSyncOK) GetPayload() models.Secrets20230613ForceSyncResponse {
	return o.Payload
}

func (o *ForceSyncOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewForceSyncDefault creates a ForceSyncDefault with default headers values
func NewForceSyncDefault(code int) *ForceSyncDefault {
	return &ForceSyncDefault{
		_statusCode: code,
	}
}

/*
ForceSyncDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ForceSyncDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this force sync default response has a 2xx status code
func (o *ForceSyncDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this force sync default response has a 3xx status code
func (o *ForceSyncDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this force sync default response has a 4xx status code
func (o *ForceSyncDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this force sync default response has a 5xx status code
func (o *ForceSyncDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this force sync default response a status code equal to that given
func (o *ForceSyncDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the force sync default response
func (o *ForceSyncDefault) Code() int {
	return o._statusCode
}

func (o *ForceSyncDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/force][%d] ForceSync default %s", o._statusCode, payload)
}

func (o *ForceSyncDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/force][%d] ForceSync default %s", o._statusCode, payload)
}

func (o *ForceSyncDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *ForceSyncDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ForceSyncBody force sync body
swagger:model ForceSyncBody
*/
type ForceSyncBody struct {

	// app name
	AppName string `json:"app_name,omitempty"`

	// location
	Location *ForceSyncParamsBodyLocation `json:"location,omitempty"`

	// operation
	Operation *models.ForceSyncRequestOPERATION `json:"operation,omitempty"`

	// sync integration name
	SyncIntegrationName string `json:"sync_integration_name,omitempty"`
}

// Validate validates this force sync body
func (o *ForceSyncBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOperation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ForceSyncBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *ForceSyncBody) validateOperation(formats strfmt.Registry) error {
	if swag.IsZero(o.Operation) { // not required
		return nil
	}

	if o.Operation != nil {
		if err := o.Operation.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "operation")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "operation")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this force sync body based on the context it is used
func (o *ForceSyncBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOperation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ForceSyncBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *ForceSyncBody) contextValidateOperation(ctx context.Context, formats strfmt.Registry) error {

	if o.Operation != nil {

		if swag.IsZero(o.Operation) { // not required
			return nil
		}

		if err := o.Operation.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "operation")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "operation")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ForceSyncBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ForceSyncBody) UnmarshalBinary(b []byte) error {
	var res ForceSyncBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ForceSyncParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model ForceSyncParamsBodyLocation
*/
type ForceSyncParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this force sync params body location
func (o *ForceSyncParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ForceSyncParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this force sync params body location based on the context it is used
func (o *ForceSyncParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ForceSyncParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ForceSyncParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ForceSyncParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res ForceSyncParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
