// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetAppSecretParams creates a new GetAppSecretParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetAppSecretParams() *GetAppSecretParams {
	return &GetAppSecretParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetAppSecretParamsWithTimeout creates a new GetAppSecretParams object
// with the ability to set a timeout on a request.
func NewGetAppSecretParamsWithTimeout(timeout time.Duration) *GetAppSecretParams {
	return &GetAppSecretParams{
		timeout: timeout,
	}
}

// NewGetAppSecretParamsWithContext creates a new GetAppSecretParams object
// with the ability to set a context for a request.
func NewGetAppSecretParamsWithContext(ctx context.Context) *GetAppSecretParams {
	return &GetAppSecretParams{
		Context: ctx,
	}
}

// NewGetAppSecretParamsWithHTTPClient creates a new GetAppSecretParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetAppSecretParamsWithHTTPClient(client *http.Client) *GetAppSecretParams {
	return &GetAppSecretParams{
		HTTPClient: client,
	}
}

/*
GetAppSecretParams contains all the parameters to send to the API endpoint

	for the get app secret operation.

	Typically these are written to a http.Request.
*/
type GetAppSecretParams struct {

	// AppName.
	AppName string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	// SecretName.
	SecretName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get app secret params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAppSecretParams) WithDefaults() *GetAppSecretParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get app secret params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAppSecretParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get app secret params
func (o *GetAppSecretParams) WithTimeout(timeout time.Duration) *GetAppSecretParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get app secret params
func (o *GetAppSecretParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get app secret params
func (o *GetAppSecretParams) WithContext(ctx context.Context) *GetAppSecretParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get app secret params
func (o *GetAppSecretParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get app secret params
func (o *GetAppSecretParams) WithHTTPClient(client *http.Client) *GetAppSecretParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get app secret params
func (o *GetAppSecretParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAppName adds the appName to the get app secret params
func (o *GetAppSecretParams) WithAppName(appName string) *GetAppSecretParams {
	o.SetAppName(appName)
	return o
}

// SetAppName adds the appName to the get app secret params
func (o *GetAppSecretParams) SetAppName(appName string) {
	o.AppName = appName
}

// WithLocationOrganizationID adds the locationOrganizationID to the get app secret params
func (o *GetAppSecretParams) WithLocationOrganizationID(locationOrganizationID string) *GetAppSecretParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get app secret params
func (o *GetAppSecretParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get app secret params
func (o *GetAppSecretParams) WithLocationProjectID(locationProjectID string) *GetAppSecretParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get app secret params
func (o *GetAppSecretParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get app secret params
func (o *GetAppSecretParams) WithLocationRegionProvider(locationRegionProvider *string) *GetAppSecretParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get app secret params
func (o *GetAppSecretParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get app secret params
func (o *GetAppSecretParams) WithLocationRegionRegion(locationRegionRegion *string) *GetAppSecretParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get app secret params
func (o *GetAppSecretParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithSecretName adds the secretName to the get app secret params
func (o *GetAppSecretParams) WithSecretName(secretName string) *GetAppSecretParams {
	o.SetSecretName(secretName)
	return o
}

// SetSecretName adds the secretName to the get app secret params
func (o *GetAppSecretParams) SetSecretName(secretName string) {
	o.SecretName = secretName
}

// WriteToRequest writes these params to a swagger request
func (o *GetAppSecretParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param app_name
	if err := r.SetPathParam("app_name", o.AppName); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	// path param secret_name
	if err := r.SetPathParam("secret_name", o.SecretName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
