// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// CreateAppDynamicSecretReader is a Reader for the CreateAppDynamicSecret structure.
type CreateAppDynamicSecretReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateAppDynamicSecretReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateAppDynamicSecretOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateAppDynamicSecretDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateAppDynamicSecretOK creates a CreateAppDynamicSecretOK with default headers values
func NewCreateAppDynamicSecretOK() *CreateAppDynamicSecretOK {
	return &CreateAppDynamicSecretOK{}
}

/*
CreateAppDynamicSecretOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateAppDynamicSecretOK struct {
	Payload *models.Secrets20231128CreateAppDynamicSecretResponse
}

// IsSuccess returns true when this create app dynamic secret o k response has a 2xx status code
func (o *CreateAppDynamicSecretOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create app dynamic secret o k response has a 3xx status code
func (o *CreateAppDynamicSecretOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create app dynamic secret o k response has a 4xx status code
func (o *CreateAppDynamicSecretOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create app dynamic secret o k response has a 5xx status code
func (o *CreateAppDynamicSecretOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create app dynamic secret o k response a status code equal to that given
func (o *CreateAppDynamicSecretOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create app dynamic secret o k response
func (o *CreateAppDynamicSecretOK) Code() int {
	return 200
}

func (o *CreateAppDynamicSecretOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/dynamic][%d] createAppDynamicSecretOK %s", 200, payload)
}

func (o *CreateAppDynamicSecretOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/dynamic][%d] createAppDynamicSecretOK %s", 200, payload)
}

func (o *CreateAppDynamicSecretOK) GetPayload() *models.Secrets20231128CreateAppDynamicSecretResponse {
	return o.Payload
}

func (o *CreateAppDynamicSecretOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128CreateAppDynamicSecretResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateAppDynamicSecretDefault creates a CreateAppDynamicSecretDefault with default headers values
func NewCreateAppDynamicSecretDefault(code int) *CreateAppDynamicSecretDefault {
	return &CreateAppDynamicSecretDefault{
		_statusCode: code,
	}
}

/*
CreateAppDynamicSecretDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateAppDynamicSecretDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this create app dynamic secret default response has a 2xx status code
func (o *CreateAppDynamicSecretDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create app dynamic secret default response has a 3xx status code
func (o *CreateAppDynamicSecretDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create app dynamic secret default response has a 4xx status code
func (o *CreateAppDynamicSecretDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create app dynamic secret default response has a 5xx status code
func (o *CreateAppDynamicSecretDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create app dynamic secret default response a status code equal to that given
func (o *CreateAppDynamicSecretDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create app dynamic secret default response
func (o *CreateAppDynamicSecretDefault) Code() int {
	return o._statusCode
}

func (o *CreateAppDynamicSecretDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/dynamic][%d] CreateAppDynamicSecret default %s", o._statusCode, payload)
}

func (o *CreateAppDynamicSecretDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/dynamic][%d] CreateAppDynamicSecret default %s", o._statusCode, payload)
}

func (o *CreateAppDynamicSecretDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *CreateAppDynamicSecretDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
