// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewCreateGcpIntegrationParams creates a new CreateGcpIntegrationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateGcpIntegrationParams() *CreateGcpIntegrationParams {
	return &CreateGcpIntegrationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateGcpIntegrationParamsWithTimeout creates a new CreateGcpIntegrationParams object
// with the ability to set a timeout on a request.
func NewCreateGcpIntegrationParamsWithTimeout(timeout time.Duration) *CreateGcpIntegrationParams {
	return &CreateGcpIntegrationParams{
		timeout: timeout,
	}
}

// NewCreateGcpIntegrationParamsWithContext creates a new CreateGcpIntegrationParams object
// with the ability to set a context for a request.
func NewCreateGcpIntegrationParamsWithContext(ctx context.Context) *CreateGcpIntegrationParams {
	return &CreateGcpIntegrationParams{
		Context: ctx,
	}
}

// NewCreateGcpIntegrationParamsWithHTTPClient creates a new CreateGcpIntegrationParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateGcpIntegrationParamsWithHTTPClient(client *http.Client) *CreateGcpIntegrationParams {
	return &CreateGcpIntegrationParams{
		HTTPClient: client,
	}
}

/*
CreateGcpIntegrationParams contains all the parameters to send to the API endpoint

	for the create gcp integration operation.

	Typically these are written to a http.Request.
*/
type CreateGcpIntegrationParams struct {

	// Body.
	Body *models.SecretServiceCreateGcpIntegrationBody

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create gcp integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateGcpIntegrationParams) WithDefaults() *CreateGcpIntegrationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create gcp integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateGcpIntegrationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create gcp integration params
func (o *CreateGcpIntegrationParams) WithTimeout(timeout time.Duration) *CreateGcpIntegrationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create gcp integration params
func (o *CreateGcpIntegrationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create gcp integration params
func (o *CreateGcpIntegrationParams) WithContext(ctx context.Context) *CreateGcpIntegrationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create gcp integration params
func (o *CreateGcpIntegrationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create gcp integration params
func (o *CreateGcpIntegrationParams) WithHTTPClient(client *http.Client) *CreateGcpIntegrationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create gcp integration params
func (o *CreateGcpIntegrationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create gcp integration params
func (o *CreateGcpIntegrationParams) WithBody(body *models.SecretServiceCreateGcpIntegrationBody) *CreateGcpIntegrationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create gcp integration params
func (o *CreateGcpIntegrationParams) SetBody(body *models.SecretServiceCreateGcpIntegrationBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the create gcp integration params
func (o *CreateGcpIntegrationParams) WithOrganizationID(organizationID string) *CreateGcpIntegrationParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the create gcp integration params
func (o *CreateGcpIntegrationParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the create gcp integration params
func (o *CreateGcpIntegrationParams) WithProjectID(projectID string) *CreateGcpIntegrationParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the create gcp integration params
func (o *CreateGcpIntegrationParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateGcpIntegrationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
