// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewUpdateAppRotatingSecretParams creates a new UpdateAppRotatingSecretParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateAppRotatingSecretParams() *UpdateAppRotatingSecretParams {
	return &UpdateAppRotatingSecretParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateAppRotatingSecretParamsWithTimeout creates a new UpdateAppRotatingSecretParams object
// with the ability to set a timeout on a request.
func NewUpdateAppRotatingSecretParamsWithTimeout(timeout time.Duration) *UpdateAppRotatingSecretParams {
	return &UpdateAppRotatingSecretParams{
		timeout: timeout,
	}
}

// NewUpdateAppRotatingSecretParamsWithContext creates a new UpdateAppRotatingSecretParams object
// with the ability to set a context for a request.
func NewUpdateAppRotatingSecretParamsWithContext(ctx context.Context) *UpdateAppRotatingSecretParams {
	return &UpdateAppRotatingSecretParams{
		Context: ctx,
	}
}

// NewUpdateAppRotatingSecretParamsWithHTTPClient creates a new UpdateAppRotatingSecretParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateAppRotatingSecretParamsWithHTTPClient(client *http.Client) *UpdateAppRotatingSecretParams {
	return &UpdateAppRotatingSecretParams{
		HTTPClient: client,
	}
}

/*
UpdateAppRotatingSecretParams contains all the parameters to send to the API endpoint

	for the update app rotating secret operation.

	Typically these are written to a http.Request.
*/
type UpdateAppRotatingSecretParams struct {

	// AppName.
	AppName string

	// Body.
	Body *models.SecretServiceUpdateAppRotatingSecretBody

	// Name.
	Name string

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update app rotating secret params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateAppRotatingSecretParams) WithDefaults() *UpdateAppRotatingSecretParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update app rotating secret params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateAppRotatingSecretParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) WithTimeout(timeout time.Duration) *UpdateAppRotatingSecretParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) WithContext(ctx context.Context) *UpdateAppRotatingSecretParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) WithHTTPClient(client *http.Client) *UpdateAppRotatingSecretParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAppName adds the appName to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) WithAppName(appName string) *UpdateAppRotatingSecretParams {
	o.SetAppName(appName)
	return o
}

// SetAppName adds the appName to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) SetAppName(appName string) {
	o.AppName = appName
}

// WithBody adds the body to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) WithBody(body *models.SecretServiceUpdateAppRotatingSecretBody) *UpdateAppRotatingSecretParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) SetBody(body *models.SecretServiceUpdateAppRotatingSecretBody) {
	o.Body = body
}

// WithName adds the name to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) WithName(name string) *UpdateAppRotatingSecretParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) SetName(name string) {
	o.Name = name
}

// WithOrganizationID adds the organizationID to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) WithOrganizationID(organizationID string) *UpdateAppRotatingSecretParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) WithProjectID(projectID string) *UpdateAppRotatingSecretParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the update app rotating secret params
func (o *UpdateAppRotatingSecretParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateAppRotatingSecretParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param app_name
	if err := r.SetPathParam("app_name", o.AppName); err != nil {
		return err
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
