// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWaypointServiceCheckNamespaceActivationParams creates a new WaypointServiceCheckNamespaceActivationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceCheckNamespaceActivationParams() *WaypointServiceCheckNamespaceActivationParams {
	return &WaypointServiceCheckNamespaceActivationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceCheckNamespaceActivationParamsWithTimeout creates a new WaypointServiceCheckNamespaceActivationParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceCheckNamespaceActivationParamsWithTimeout(timeout time.Duration) *WaypointServiceCheckNamespaceActivationParams {
	return &WaypointServiceCheckNamespaceActivationParams{
		timeout: timeout,
	}
}

// NewWaypointServiceCheckNamespaceActivationParamsWithContext creates a new WaypointServiceCheckNamespaceActivationParams object
// with the ability to set a context for a request.
func NewWaypointServiceCheckNamespaceActivationParamsWithContext(ctx context.Context) *WaypointServiceCheckNamespaceActivationParams {
	return &WaypointServiceCheckNamespaceActivationParams{
		Context: ctx,
	}
}

// NewWaypointServiceCheckNamespaceActivationParamsWithHTTPClient creates a new WaypointServiceCheckNamespaceActivationParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceCheckNamespaceActivationParamsWithHTTPClient(client *http.Client) *WaypointServiceCheckNamespaceActivationParams {
	return &WaypointServiceCheckNamespaceActivationParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceCheckNamespaceActivationParams contains all the parameters to send to the API endpoint

	for the waypoint service check namespace activation operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceCheckNamespaceActivationParams struct {

	/* Force.

	     If true, will force a recheck of the namespace even if it was recently
	checked.
	*/
	Force *bool

	// NamespaceID.
	NamespaceID string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID *string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID *string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service check namespace activation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceCheckNamespaceActivationParams) WithDefaults() *WaypointServiceCheckNamespaceActivationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service check namespace activation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceCheckNamespaceActivationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) WithTimeout(timeout time.Duration) *WaypointServiceCheckNamespaceActivationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) WithContext(ctx context.Context) *WaypointServiceCheckNamespaceActivationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) WithHTTPClient(client *http.Client) *WaypointServiceCheckNamespaceActivationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithForce adds the force to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) WithForce(force *bool) *WaypointServiceCheckNamespaceActivationParams {
	o.SetForce(force)
	return o
}

// SetForce adds the force to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) SetForce(force *bool) {
	o.Force = force
}

// WithNamespaceID adds the namespaceID to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) WithNamespaceID(namespaceID string) *WaypointServiceCheckNamespaceActivationParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) SetNamespaceID(namespaceID string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) *WaypointServiceCheckNamespaceActivationParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) WithNamespaceLocationProjectID(namespaceLocationProjectID *string) *WaypointServiceCheckNamespaceActivationParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) SetNamespaceLocationProjectID(namespaceLocationProjectID *string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceCheckNamespaceActivationParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceCheckNamespaceActivationParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service check namespace activation params
func (o *WaypointServiceCheckNamespaceActivationParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceCheckNamespaceActivationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Force != nil {

		// query param force
		var qrForce bool

		if o.Force != nil {
			qrForce = *o.Force
		}
		qForce := swag.FormatBool(qrForce)
		if qForce != "" {

			if err := r.SetQueryParam("force", qForce); err != nil {
				return err
			}
		}
	}

	// path param namespace.id
	if err := r.SetPathParam("namespace.id", o.NamespaceID); err != nil {
		return err
	}

	if o.NamespaceLocationOrganizationID != nil {

		// query param namespace.location.organization_id
		var qrNamespaceLocationOrganizationID string

		if o.NamespaceLocationOrganizationID != nil {
			qrNamespaceLocationOrganizationID = *o.NamespaceLocationOrganizationID
		}
		qNamespaceLocationOrganizationID := qrNamespaceLocationOrganizationID
		if qNamespaceLocationOrganizationID != "" {

			if err := r.SetQueryParam("namespace.location.organization_id", qNamespaceLocationOrganizationID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationProjectID != nil {

		// query param namespace.location.project_id
		var qrNamespaceLocationProjectID string

		if o.NamespaceLocationProjectID != nil {
			qrNamespaceLocationProjectID = *o.NamespaceLocationProjectID
		}
		qNamespaceLocationProjectID := qrNamespaceLocationProjectID
		if qNamespaceLocationProjectID != "" {

			if err := r.SetQueryParam("namespace.location.project_id", qNamespaceLocationProjectID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
