// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceListTFAgentPoolsReader is a Reader for the WaypointServiceListTFAgentPools structure.
type WaypointServiceListTFAgentPoolsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceListTFAgentPoolsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceListTFAgentPoolsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceListTFAgentPoolsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceListTFAgentPoolsOK creates a WaypointServiceListTFAgentPoolsOK with default headers values
func NewWaypointServiceListTFAgentPoolsOK() *WaypointServiceListTFAgentPoolsOK {
	return &WaypointServiceListTFAgentPoolsOK{}
}

/*
WaypointServiceListTFAgentPoolsOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceListTFAgentPoolsOK struct {
	Payload *models.HashicorpCloudWaypointListTFAgentPoolsResponse
}

// IsSuccess returns true when this waypoint service list t f agent pools o k response has a 2xx status code
func (o *WaypointServiceListTFAgentPoolsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service list t f agent pools o k response has a 3xx status code
func (o *WaypointServiceListTFAgentPoolsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service list t f agent pools o k response has a 4xx status code
func (o *WaypointServiceListTFAgentPoolsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service list t f agent pools o k response has a 5xx status code
func (o *WaypointServiceListTFAgentPoolsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service list t f agent pools o k response a status code equal to that given
func (o *WaypointServiceListTFAgentPoolsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service list t f agent pools o k response
func (o *WaypointServiceListTFAgentPoolsOK) Code() int {
	return 200
}

func (o *WaypointServiceListTFAgentPoolsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tf-agent-pools][%d] waypointServiceListTFAgentPoolsOK %s", 200, payload)
}

func (o *WaypointServiceListTFAgentPoolsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tf-agent-pools][%d] waypointServiceListTFAgentPoolsOK %s", 200, payload)
}

func (o *WaypointServiceListTFAgentPoolsOK) GetPayload() *models.HashicorpCloudWaypointListTFAgentPoolsResponse {
	return o.Payload
}

func (o *WaypointServiceListTFAgentPoolsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointListTFAgentPoolsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceListTFAgentPoolsDefault creates a WaypointServiceListTFAgentPoolsDefault with default headers values
func NewWaypointServiceListTFAgentPoolsDefault(code int) *WaypointServiceListTFAgentPoolsDefault {
	return &WaypointServiceListTFAgentPoolsDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceListTFAgentPoolsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceListTFAgentPoolsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service list t f agent pools default response has a 2xx status code
func (o *WaypointServiceListTFAgentPoolsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service list t f agent pools default response has a 3xx status code
func (o *WaypointServiceListTFAgentPoolsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service list t f agent pools default response has a 4xx status code
func (o *WaypointServiceListTFAgentPoolsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service list t f agent pools default response has a 5xx status code
func (o *WaypointServiceListTFAgentPoolsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service list t f agent pools default response a status code equal to that given
func (o *WaypointServiceListTFAgentPoolsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service list t f agent pools default response
func (o *WaypointServiceListTFAgentPoolsDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceListTFAgentPoolsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tf-agent-pools][%d] WaypointService_ListTFAgentPools default %s", o._statusCode, payload)
}

func (o *WaypointServiceListTFAgentPoolsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tf-agent-pools][%d] WaypointService_ListTFAgentPools default %s", o._statusCode, payload)
}

func (o *WaypointServiceListTFAgentPoolsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceListTFAgentPoolsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
