// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceUICreateActionConfigWithVarsReader is a Reader for the WaypointServiceUICreateActionConfigWithVars structure.
type WaypointServiceUICreateActionConfigWithVarsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceUICreateActionConfigWithVarsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceUICreateActionConfigWithVarsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceUICreateActionConfigWithVarsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceUICreateActionConfigWithVarsOK creates a WaypointServiceUICreateActionConfigWithVarsOK with default headers values
func NewWaypointServiceUICreateActionConfigWithVarsOK() *WaypointServiceUICreateActionConfigWithVarsOK {
	return &WaypointServiceUICreateActionConfigWithVarsOK{}
}

/*
WaypointServiceUICreateActionConfigWithVarsOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceUICreateActionConfigWithVarsOK struct {
	Payload *models.HashicorpCloudWaypointUICreateActionConfigWithVarsResponse
}

// IsSuccess returns true when this waypoint service Ui create action config with vars o k response has a 2xx status code
func (o *WaypointServiceUICreateActionConfigWithVarsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service Ui create action config with vars o k response has a 3xx status code
func (o *WaypointServiceUICreateActionConfigWithVarsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service Ui create action config with vars o k response has a 4xx status code
func (o *WaypointServiceUICreateActionConfigWithVarsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service Ui create action config with vars o k response has a 5xx status code
func (o *WaypointServiceUICreateActionConfigWithVarsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service Ui create action config with vars o k response a status code equal to that given
func (o *WaypointServiceUICreateActionConfigWithVarsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service Ui create action config with vars o k response
func (o *WaypointServiceUICreateActionConfigWithVarsOK) Code() int {
	return 200
}

func (o *WaypointServiceUICreateActionConfigWithVarsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/ui/actionconfigwithvars][%d] waypointServiceUiCreateActionConfigWithVarsOK %s", 200, payload)
}

func (o *WaypointServiceUICreateActionConfigWithVarsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/ui/actionconfigwithvars][%d] waypointServiceUiCreateActionConfigWithVarsOK %s", 200, payload)
}

func (o *WaypointServiceUICreateActionConfigWithVarsOK) GetPayload() *models.HashicorpCloudWaypointUICreateActionConfigWithVarsResponse {
	return o.Payload
}

func (o *WaypointServiceUICreateActionConfigWithVarsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointUICreateActionConfigWithVarsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceUICreateActionConfigWithVarsDefault creates a WaypointServiceUICreateActionConfigWithVarsDefault with default headers values
func NewWaypointServiceUICreateActionConfigWithVarsDefault(code int) *WaypointServiceUICreateActionConfigWithVarsDefault {
	return &WaypointServiceUICreateActionConfigWithVarsDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceUICreateActionConfigWithVarsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceUICreateActionConfigWithVarsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service UI create action config with vars default response has a 2xx status code
func (o *WaypointServiceUICreateActionConfigWithVarsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service UI create action config with vars default response has a 3xx status code
func (o *WaypointServiceUICreateActionConfigWithVarsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service UI create action config with vars default response has a 4xx status code
func (o *WaypointServiceUICreateActionConfigWithVarsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service UI create action config with vars default response has a 5xx status code
func (o *WaypointServiceUICreateActionConfigWithVarsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service UI create action config with vars default response a status code equal to that given
func (o *WaypointServiceUICreateActionConfigWithVarsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service UI create action config with vars default response
func (o *WaypointServiceUICreateActionConfigWithVarsDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceUICreateActionConfigWithVarsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/ui/actionconfigwithvars][%d] WaypointService_UI_CreateActionConfigWithVars default %s", o._statusCode, payload)
}

func (o *WaypointServiceUICreateActionConfigWithVarsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/ui/actionconfigwithvars][%d] WaypointService_UI_CreateActionConfigWithVars default %s", o._statusCode, payload)
}

func (o *WaypointServiceUICreateActionConfigWithVarsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceUICreateActionConfigWithVarsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
