// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBody CreateAddOnDefinitionRequest is the request used to create an Add-on
// definition
//
// swagger:model hashicorp.cloud.waypoint.WaypointService.CreateAddOnDefinitionBody
type HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBody struct {

	// Add-on definition to be created
	AddOnDefinition *HashicorpCloudWaypointAddOnDefinition `json:"add_on_definition,omitempty"`

	// DEPRECATED: Use add_on_definition instead.
	Description string `json:"description,omitempty"`

	// DEPRECATED: Use add_on_definition instead.
	Labels []string `json:"labels"`

	// DEPRECATED: Use add_on_definition instead.
	ModuleSource string `json:"module_source,omitempty"`

	// DEPRECATED: Use add_on_definition instead.
	Name string `json:"name,omitempty"`

	// namespace
	Namespace *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBodyNamespace `json:"namespace,omitempty"`

	// DEPRECATED: Use add_on_definition instead.
	// Format: byte
	ReadmeMarkdownTemplate strfmt.Base64 `json:"readme_markdown_template,omitempty"`

	// DEPRECATED: Use add_on_definition instead.
	ReadmeTemplate string `json:"readme_template,omitempty"`

	// DEPRECATED: Use add_on_definition instead.
	Summary string `json:"summary,omitempty"`

	// DEPRECATED: Use add_on_definition instead.
	TerraformCloudWorkspaceDetails *HashicorpCloudWaypointTerraformCloudWorkspaceDetails `json:"terraform_cloud_workspace_details,omitempty"`

	// DEPRECATED: Use add_on_definition instead.
	TfAgentPoolID string `json:"tf_agent_pool_id,omitempty"`

	// DEPRECATED: Use add_on_definition instead.
	TfExecutionMode string `json:"tf_execution_mode,omitempty"`

	// DEPRECATED: Use add_on_definition instead.
	VariableOptions []*HashicorpCloudWaypointTFModuleVariable `json:"variable_options"`
}

// Validate validates this hashicorp cloud waypoint waypoint service create add on definition body
func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddOnDefinition(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNamespace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTerraformCloudWorkspaceDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVariableOptions(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBody) validateAddOnDefinition(formats strfmt.Registry) error {
	if swag.IsZero(m.AddOnDefinition) { // not required
		return nil
	}

	if m.AddOnDefinition != nil {
		if err := m.AddOnDefinition.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("add_on_definition")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("add_on_definition")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBody) validateNamespace(formats strfmt.Registry) error {
	if swag.IsZero(m.Namespace) { // not required
		return nil
	}

	if m.Namespace != nil {
		if err := m.Namespace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBody) validateTerraformCloudWorkspaceDetails(formats strfmt.Registry) error {
	if swag.IsZero(m.TerraformCloudWorkspaceDetails) { // not required
		return nil
	}

	if m.TerraformCloudWorkspaceDetails != nil {
		if err := m.TerraformCloudWorkspaceDetails.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("terraform_cloud_workspace_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("terraform_cloud_workspace_details")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBody) validateVariableOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.VariableOptions) { // not required
		return nil
	}

	for i := 0; i < len(m.VariableOptions); i++ {
		if swag.IsZero(m.VariableOptions[i]) { // not required
			continue
		}

		if m.VariableOptions[i] != nil {
			if err := m.VariableOptions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variable_options" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variable_options" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint waypoint service create add on definition body based on the context it is used
func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddOnDefinition(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNamespace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTerraformCloudWorkspaceDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVariableOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBody) contextValidateAddOnDefinition(ctx context.Context, formats strfmt.Registry) error {

	if m.AddOnDefinition != nil {

		if swag.IsZero(m.AddOnDefinition) { // not required
			return nil
		}

		if err := m.AddOnDefinition.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("add_on_definition")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("add_on_definition")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBody) contextValidateNamespace(ctx context.Context, formats strfmt.Registry) error {

	if m.Namespace != nil {

		if swag.IsZero(m.Namespace) { // not required
			return nil
		}

		if err := m.Namespace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBody) contextValidateTerraformCloudWorkspaceDetails(ctx context.Context, formats strfmt.Registry) error {

	if m.TerraformCloudWorkspaceDetails != nil {

		if swag.IsZero(m.TerraformCloudWorkspaceDetails) { // not required
			return nil
		}

		if err := m.TerraformCloudWorkspaceDetails.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("terraform_cloud_workspace_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("terraform_cloud_workspace_details")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBody) contextValidateVariableOptions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VariableOptions); i++ {

		if m.VariableOptions[i] != nil {

			if swag.IsZero(m.VariableOptions[i]) { // not required
				return nil
			}

			if err := m.VariableOptions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variable_options" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variable_options" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBody) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBody) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBodyNamespace Global references the entire server. This is used in some APIs
// as a way to read/write values that are server-global.
//
// swagger:model HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBodyNamespace
type HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBodyNamespace struct {

	// When used via an API request, this is populated and used to populate id.
	Location *cloud.HashicorpCloudLocationLocation `json:"location,omitempty"`
}

// Validate validates this hashicorp cloud waypoint waypoint service create add on definition body namespace
func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBodyNamespace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBodyNamespace) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint waypoint service create add on definition body namespace based on the context it is used
func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBodyNamespace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBodyNamespace) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {

		if swag.IsZero(m.Location) { // not required
			return nil
		}

		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBodyNamespace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBodyNamespace) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointWaypointServiceCreateAddOnDefinitionBodyNamespace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
