// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudWaypointWaypointServiceUpdateApplicationBody hashicorp cloud waypoint waypoint service update application body
//
// swagger:model hashicorp.cloud.waypoint.WaypointService.UpdateApplicationBody
type HashicorpCloudWaypointWaypointServiceUpdateApplicationBody struct {

	// Any action assignments for this application. To update, you must specify the
	// field mask for the action_cfg_refs field. Additionally, if you specify the
	// field mask, but this array is null, it means clearing out any assignments.
	ActionCfgRefs []*HashicorpCloudWaypointActionCfgRef `json:"action_cfg_refs"`

	// application
	Application *HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyApplication `json:"application,omitempty"`

	// Updated application name
	Name string `json:"name,omitempty"`

	// namespace
	Namespace *HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyNamespace `json:"namespace,omitempty"`

	// readme is markdown formatted instructions on how to operate the application.
	// This may be populated from a application template.
	// This field is favored over readme_markdown and support for both is transitional.
	Readme string `json:"readme,omitempty"`

	// readme_markdown is markdown formatted instructions on how to operate the application.
	// This may be populated from a application template.
	// Format: byte
	ReadmeMarkdown strfmt.Base64 `json:"readme_markdown,omitempty"`

	// Field mask to update only specific fields. I.e. if you want a field updated,
	// you must include it in the field mask. For now, we only use this for
	// clearing out action assignments.
	UpdateMask string `json:"update_mask,omitempty"`
}

// Validate validates this hashicorp cloud waypoint waypoint service update application body
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActionCfgRefs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNamespace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBody) validateActionCfgRefs(formats strfmt.Registry) error {
	if swag.IsZero(m.ActionCfgRefs) { // not required
		return nil
	}

	for i := 0; i < len(m.ActionCfgRefs); i++ {
		if swag.IsZero(m.ActionCfgRefs[i]) { // not required
			continue
		}

		if m.ActionCfgRefs[i] != nil {
			if err := m.ActionCfgRefs[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("action_cfg_refs" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("action_cfg_refs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBody) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	if m.Application != nil {
		if err := m.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBody) validateNamespace(formats strfmt.Registry) error {
	if swag.IsZero(m.Namespace) { // not required
		return nil
	}

	if m.Namespace != nil {
		if err := m.Namespace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint waypoint service update application body based on the context it is used
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateActionCfgRefs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNamespace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBody) contextValidateActionCfgRefs(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ActionCfgRefs); i++ {

		if m.ActionCfgRefs[i] != nil {

			if swag.IsZero(m.ActionCfgRefs[i]) { // not required
				return nil
			}

			if err := m.ActionCfgRefs[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("action_cfg_refs" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("action_cfg_refs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBody) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Application != nil {

		if swag.IsZero(m.Application) { // not required
			return nil
		}

		if err := m.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBody) contextValidateNamespace(ctx context.Context, formats strfmt.Registry) error {

	if m.Namespace != nil {

		if swag.IsZero(m.Namespace) { // not required
			return nil
		}

		if err := m.Namespace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBody) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBody) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointWaypointServiceUpdateApplicationBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyApplication Application Ref Without ID
//
// # Reference to an existing Application
//
// swagger:model HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyApplication
type HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyApplication struct {

	// id
	ID string `json:"id,omitempty"`
}

// Validate validates this hashicorp cloud waypoint waypoint service update application body application
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyApplication) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this hashicorp cloud waypoint waypoint service update application body application based on context it is used
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyApplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyApplication) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyApplication) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyApplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyNamespace Global references the entire server. This is used in some APIs
// as a way to read/write values that are server-global.
//
// swagger:model HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyNamespace
type HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyNamespace struct {

	// When used via an API request, this is populated and used to populate id.
	Location *cloud.HashicorpCloudLocationLocation `json:"location,omitempty"`
}

// Validate validates this hashicorp cloud waypoint waypoint service update application body namespace
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyNamespace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyNamespace) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint waypoint service update application body namespace based on the context it is used
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyNamespace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyNamespace) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {

		if swag.IsZero(m.Location) { // not required
			return nil
		}

		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyNamespace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyNamespace) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointWaypointServiceUpdateApplicationBodyNamespace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
