// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceCreateApplicationTemplateReader is a Reader for the WaypointServiceCreateApplicationTemplate structure.
type WaypointServiceCreateApplicationTemplateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceCreateApplicationTemplateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceCreateApplicationTemplateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceCreateApplicationTemplateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceCreateApplicationTemplateOK creates a WaypointServiceCreateApplicationTemplateOK with default headers values
func NewWaypointServiceCreateApplicationTemplateOK() *WaypointServiceCreateApplicationTemplateOK {
	return &WaypointServiceCreateApplicationTemplateOK{}
}

/*
WaypointServiceCreateApplicationTemplateOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceCreateApplicationTemplateOK struct {
	Payload *models.HashicorpCloudWaypointCreateApplicationTemplateResponse
}

// IsSuccess returns true when this waypoint service create application template o k response has a 2xx status code
func (o *WaypointServiceCreateApplicationTemplateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service create application template o k response has a 3xx status code
func (o *WaypointServiceCreateApplicationTemplateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service create application template o k response has a 4xx status code
func (o *WaypointServiceCreateApplicationTemplateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service create application template o k response has a 5xx status code
func (o *WaypointServiceCreateApplicationTemplateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service create application template o k response a status code equal to that given
func (o *WaypointServiceCreateApplicationTemplateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service create application template o k response
func (o *WaypointServiceCreateApplicationTemplateOK) Code() int {
	return 200
}

func (o *WaypointServiceCreateApplicationTemplateOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/application-templates][%d] waypointServiceCreateApplicationTemplateOK %s", 200, payload)
}

func (o *WaypointServiceCreateApplicationTemplateOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/application-templates][%d] waypointServiceCreateApplicationTemplateOK %s", 200, payload)
}

func (o *WaypointServiceCreateApplicationTemplateOK) GetPayload() *models.HashicorpCloudWaypointCreateApplicationTemplateResponse {
	return o.Payload
}

func (o *WaypointServiceCreateApplicationTemplateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointCreateApplicationTemplateResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceCreateApplicationTemplateDefault creates a WaypointServiceCreateApplicationTemplateDefault with default headers values
func NewWaypointServiceCreateApplicationTemplateDefault(code int) *WaypointServiceCreateApplicationTemplateDefault {
	return &WaypointServiceCreateApplicationTemplateDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceCreateApplicationTemplateDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceCreateApplicationTemplateDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service create application template default response has a 2xx status code
func (o *WaypointServiceCreateApplicationTemplateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service create application template default response has a 3xx status code
func (o *WaypointServiceCreateApplicationTemplateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service create application template default response has a 4xx status code
func (o *WaypointServiceCreateApplicationTemplateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service create application template default response has a 5xx status code
func (o *WaypointServiceCreateApplicationTemplateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service create application template default response a status code equal to that given
func (o *WaypointServiceCreateApplicationTemplateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service create application template default response
func (o *WaypointServiceCreateApplicationTemplateDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceCreateApplicationTemplateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/application-templates][%d] WaypointService_CreateApplicationTemplate default %s", o._statusCode, payload)
}

func (o *WaypointServiceCreateApplicationTemplateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/application-templates][%d] WaypointService_CreateApplicationTemplate default %s", o._statusCode, payload)
}

func (o *WaypointServiceCreateApplicationTemplateDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceCreateApplicationTemplateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
