// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceStartingActionReader is a Reader for the WaypointServiceStartingAction structure.
type WaypointServiceStartingActionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceStartingActionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceStartingActionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceStartingActionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceStartingActionOK creates a WaypointServiceStartingActionOK with default headers values
func NewWaypointServiceStartingActionOK() *WaypointServiceStartingActionOK {
	return &WaypointServiceStartingActionOK{}
}

/*
WaypointServiceStartingActionOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceStartingActionOK struct {
	Payload *models.HashicorpCloudWaypointStartingActionResponse
}

// IsSuccess returns true when this waypoint service starting action o k response has a 2xx status code
func (o *WaypointServiceStartingActionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service starting action o k response has a 3xx status code
func (o *WaypointServiceStartingActionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service starting action o k response has a 4xx status code
func (o *WaypointServiceStartingActionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service starting action o k response has a 5xx status code
func (o *WaypointServiceStartingActionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service starting action o k response a status code equal to that given
func (o *WaypointServiceStartingActionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service starting action o k response
func (o *WaypointServiceStartingActionOK) Code() int {
	return 200
}

func (o *WaypointServiceStartingActionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/agent/operation:startAction][%d] waypointServiceStartingActionOK %s", 200, payload)
}

func (o *WaypointServiceStartingActionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/agent/operation:startAction][%d] waypointServiceStartingActionOK %s", 200, payload)
}

func (o *WaypointServiceStartingActionOK) GetPayload() *models.HashicorpCloudWaypointStartingActionResponse {
	return o.Payload
}

func (o *WaypointServiceStartingActionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointStartingActionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceStartingActionDefault creates a WaypointServiceStartingActionDefault with default headers values
func NewWaypointServiceStartingActionDefault(code int) *WaypointServiceStartingActionDefault {
	return &WaypointServiceStartingActionDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceStartingActionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceStartingActionDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service starting action default response has a 2xx status code
func (o *WaypointServiceStartingActionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service starting action default response has a 3xx status code
func (o *WaypointServiceStartingActionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service starting action default response has a 4xx status code
func (o *WaypointServiceStartingActionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service starting action default response has a 5xx status code
func (o *WaypointServiceStartingActionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service starting action default response a status code equal to that given
func (o *WaypointServiceStartingActionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service starting action default response
func (o *WaypointServiceStartingActionDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceStartingActionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/agent/operation:startAction][%d] WaypointService_StartingAction default %s", o._statusCode, payload)
}

func (o *WaypointServiceStartingActionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/agent/operation:startAction][%d] WaypointService_StartingAction default %s", o._statusCode, payload)
}

func (o *WaypointServiceStartingActionDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceStartingActionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
