// Code generated by go-swagger; DO NOT EDIT.

package webhook_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-webhook/stable/2023-05-31/models"
)

// WebhookServiceDeleteWebhookReader is a Reader for the WebhookServiceDeleteWebhook structure.
type WebhookServiceDeleteWebhookReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WebhookServiceDeleteWebhookReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWebhookServiceDeleteWebhookOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWebhookServiceDeleteWebhookDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWebhookServiceDeleteWebhookOK creates a WebhookServiceDeleteWebhookOK with default headers values
func NewWebhookServiceDeleteWebhookOK() *WebhookServiceDeleteWebhookOK {
	return &WebhookServiceDeleteWebhookOK{}
}

/*
WebhookServiceDeleteWebhookOK describes a response with status code 200, with default header values.

A successful response.
*/
type WebhookServiceDeleteWebhookOK struct {
	Payload models.HashicorpCloudWebhookDeleteWebhookResponse
}

// IsSuccess returns true when this webhook service delete webhook o k response has a 2xx status code
func (o *WebhookServiceDeleteWebhookOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this webhook service delete webhook o k response has a 3xx status code
func (o *WebhookServiceDeleteWebhookOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this webhook service delete webhook o k response has a 4xx status code
func (o *WebhookServiceDeleteWebhookOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this webhook service delete webhook o k response has a 5xx status code
func (o *WebhookServiceDeleteWebhookOK) IsServerError() bool {
	return false
}

// IsCode returns true when this webhook service delete webhook o k response a status code equal to that given
func (o *WebhookServiceDeleteWebhookOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the webhook service delete webhook o k response
func (o *WebhookServiceDeleteWebhookOK) Code() int {
	return 200
}

func (o *WebhookServiceDeleteWebhookOK) Error() string {
	return fmt.Sprintf("[DELETE /2023-05-31/{resource_name}][%d] webhookServiceDeleteWebhookOK  %+v", 200, o.Payload)
}

func (o *WebhookServiceDeleteWebhookOK) String() string {
	return fmt.Sprintf("[DELETE /2023-05-31/{resource_name}][%d] webhookServiceDeleteWebhookOK  %+v", 200, o.Payload)
}

func (o *WebhookServiceDeleteWebhookOK) GetPayload() models.HashicorpCloudWebhookDeleteWebhookResponse {
	return o.Payload
}

func (o *WebhookServiceDeleteWebhookOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWebhookServiceDeleteWebhookDefault creates a WebhookServiceDeleteWebhookDefault with default headers values
func NewWebhookServiceDeleteWebhookDefault(code int) *WebhookServiceDeleteWebhookDefault {
	return &WebhookServiceDeleteWebhookDefault{
		_statusCode: code,
	}
}

/*
WebhookServiceDeleteWebhookDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WebhookServiceDeleteWebhookDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this webhook service delete webhook default response has a 2xx status code
func (o *WebhookServiceDeleteWebhookDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this webhook service delete webhook default response has a 3xx status code
func (o *WebhookServiceDeleteWebhookDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this webhook service delete webhook default response has a 4xx status code
func (o *WebhookServiceDeleteWebhookDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this webhook service delete webhook default response has a 5xx status code
func (o *WebhookServiceDeleteWebhookDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this webhook service delete webhook default response a status code equal to that given
func (o *WebhookServiceDeleteWebhookDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the webhook service delete webhook default response
func (o *WebhookServiceDeleteWebhookDefault) Code() int {
	return o._statusCode
}

func (o *WebhookServiceDeleteWebhookDefault) Error() string {
	return fmt.Sprintf("[DELETE /2023-05-31/{resource_name}][%d] WebhookService_DeleteWebhook default  %+v", o._statusCode, o.Payload)
}

func (o *WebhookServiceDeleteWebhookDefault) String() string {
	return fmt.Sprintf("[DELETE /2023-05-31/{resource_name}][%d] WebhookService_DeleteWebhook default  %+v", o._statusCode, o.Payload)
}

func (o *WebhookServiceDeleteWebhookDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WebhookServiceDeleteWebhookDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
