/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.templates;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.netbeans.api.templates.TemplateRegistration;
import org.netbeans.api.templates.TemplateRegistrations;
import org.netbeans.modules.templates.HTMLWizard;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.util.BaseUtilities;

public class TemplateProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(TemplateRegistration.class.getCanonicalName(), TemplateRegistrations.class.getCanonicalName()));
    }

    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        Annotation annotation;
        if (roundEnvironment.processingOver()) {
            return false;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(TemplateRegistration.class)) {
            annotation = element.getAnnotation(TemplateRegistration.class);
            if (annotation == null) continue;
            this.process(element, (TemplateRegistration)annotation, roundEnvironment);
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(TemplateRegistrations.class)) {
            annotation = element.getAnnotation(TemplateRegistrations.class);
            if (annotation == null) continue;
            for (TemplateRegistration templateRegistration : annotation.value()) {
                this.process(element, templateRegistration, roundEnvironment);
            }
        }
        return true;
    }

    private void checkPublicAbstract(Element element, TypeMirror typeMirror, TypeMirror typeMirror2) throws LayerGenerationException {
        if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new LayerGenerationException(typeMirror + " must not be abstract", element, this.processingEnv, null, null);
        }
        boolean bl = false;
        for (ExecutableElement executableElement : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            if (!executableElement.getParameters().isEmpty()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new LayerGenerationException(typeMirror + " must have a no-argument constructor", element, this.processingEnv, null, null);
        }
        if (typeMirror2 != null && !this.processingEnv.getTypeUtils().isAssignable(element.asType(), typeMirror2)) {
            throw new LayerGenerationException(typeMirror + " is not assignable to " + typeMirror2, element, this.processingEnv, null, null);
        }
        if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new LayerGenerationException(typeMirror + " is not public", element, this.processingEnv, null, null);
        }
        if (((TypeElement)element).getNestingKind().isNested() && !element.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new LayerGenerationException(typeMirror + " is nested but not static", element, this.processingEnv, null, null);
        }
    }

    private void process(Element element, TemplateRegistration templateRegistration, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        Object object;
        String[] stringArray;
        boolean bl;
        LayerBuilder.File file;
        String string;
        LayerBuilder layerBuilder;
        block32: {
            String string2;
            layerBuilder = this.layer(new Element[]{element});
            boolean bl2 = false;
            if (!templateRegistration.id().isEmpty()) {
                if (templateRegistration.content().length > 0) {
                    throw new LayerGenerationException("Cannot specify both id and content", element, this.processingEnv, (Annotation)templateRegistration);
                }
                string2 = templateRegistration.id();
                if (string2.endsWith("/")) {
                    string2 = string2.substring(0, string2.length() - 1);
                    bl2 = true;
                }
            } else if (templateRegistration.content().length > 0) {
                string2 = TemplateProcessor.basename(templateRegistration.content()[0]);
            } else if (element.getKind() == ElementKind.CLASS) {
                string2 = ((TypeElement)element).getQualifiedName().toString().replace('.', '-');
            } else if (element.getKind() == ElementKind.METHOD) {
                string2 = ((TypeElement)element.getEnclosingElement()).getQualifiedName().toString().replace('.', '-') + '-' + element.getSimpleName();
            } else {
                throw new LayerGenerationException("cannot use @Template on a package without specifying content", element, this.processingEnv, (Annotation)templateRegistration);
            }
            string = "Templates/" + templateRegistration.folder() + '/';
            file = bl2 ? layerBuilder.folder(string + string2) : layerBuilder.file(string + string2);
            file.boolvalue("template", true);
            file.position(templateRegistration.position());
            if (!templateRegistration.displayName().isEmpty()) {
                file.bundlevalue("displayName", templateRegistration.displayName());
            }
            if (!templateRegistration.iconBase().isEmpty()) {
                layerBuilder.validateResource(templateRegistration.iconBase(), element, (Annotation)templateRegistration, "iconBase", true);
                file.stringvalue("iconBase", templateRegistration.iconBase());
            } else if (templateRegistration.content().length == 0) {
                throw new LayerGenerationException("Must specify iconBase if content is not specified", element, this.processingEnv, (Annotation)templateRegistration);
            }
            if (!templateRegistration.description().isEmpty()) {
                file.urlvalue("instantiatingWizardURL", this.contentURI(element, templateRegistration.description(), layerBuilder, templateRegistration, "description"));
            }
            bl = false;
            try {
                templateRegistration.createHandlerClass();
            }
            catch (MirroredTypeException mirroredTypeException) {
                stringArray = mirroredTypeException.getTypeMirror();
                if (!(stringArray instanceof DeclaredType)) break block32;
                object = this.processingEnv.getElementUtils().getTypeElement(CreateFromTemplateHandler.class.getName());
                TypeMirror typeMirror = object.asType();
                if (this.processingEnv.getTypeUtils().isSameType(typeMirror, (TypeMirror)stringArray)) break block32;
                this.checkPublicAbstract(((DeclaredType)stringArray).asElement(), (TypeMirror)stringArray, typeMirror);
                String string3 = this.processingEnv.getElementUtils().getBinaryName((TypeElement)((DeclaredType)stringArray).asElement()).toString();
                file.newvalue("template.createTemplateHandler", string3);
                bl = true;
            }
        }
        if (element.getKind() != ElementKind.PACKAGE) {
            if (templateRegistration.page().isEmpty()) {
                try {
                    Class<?> clazz = Class.forName("org.openide.WizardDescriptor$InstantiatingIterator");
                    file.instanceAttribute("instantiatingIterator", clazz);
                }
                catch (LayerGenerationException layerGenerationException) {
                    if (!bl) {
                        file.instanceAttribute("template.createTemplateHandler", CreateFromTemplateHandler.class);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    stringArray = this.processingEnv.getMessager();
                    stringArray.printMessage(Diagnostic.Kind.ERROR, "Either specify 'page' value or implement or return WizardDescriptor.InstantiatingIterator", element);
                }
            } else {
                this.registerHTMLWizard(element, layerBuilder, file, templateRegistration);
            }
        }
        if (templateRegistration.content().length > 0) {
            file.url(this.contentURI(element, templateRegistration.content()[0], layerBuilder, templateRegistration, "content").toString());
            for (int i = 1; i < templateRegistration.content().length; ++i) {
                layerBuilder.file(string + TemplateProcessor.basename(templateRegistration.content()[i])).url(this.contentURI(element, templateRegistration.content()[i], layerBuilder, templateRegistration, "content").toString()).position(0).write();
            }
        }
        if (!templateRegistration.scriptEngine().isEmpty()) {
            file.stringvalue("javax.script.ScriptEngine", templateRegistration.scriptEngine());
        }
        if (templateRegistration.category().length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : templateRegistration.category()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string3);
            }
            file.stringvalue("templateCategory", stringBuilder.toString());
        }
        file.boolvalue("requireProject", templateRegistration.requireProject());
        if (!templateRegistration.targetName().trim().isEmpty()) {
            file.bundlevalue("targetName", templateRegistration.targetName());
        }
        String[] stringArray2 = templateRegistration.techIds();
        for (int i = 0; i < stringArray2.length; ++i) {
            object = stringArray2[i];
            file.stringvalue("techId." + i, (String)object);
        }
        file.write();
    }

    private static String basename(String string) {
        return string.replaceFirst(".+/", "").replaceFirst("[.]template$", "");
    }

    private URI contentURI(Element element, String string, LayerBuilder layerBuilder, TemplateRegistration templateRegistration, String string2) throws LayerGenerationException {
        String string3 = LayerBuilder.absolutizeResource((Element)element, (String)string);
        layerBuilder.validateResource(string3, element, (Annotation)templateRegistration, string2, false);
        try {
            return BaseUtilities.normalizeURI((URI)new URI("nbresloc", "/" + string3, null));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new LayerGenerationException("could not translate " + string3, element, this.processingEnv, (Annotation)templateRegistration);
        }
    }

    private void registerHTMLWizard(Element element, LayerBuilder layerBuilder, LayerBuilder.File file, TemplateRegistration templateRegistration) throws LayerGenerationException {
        String string;
        try {
            layerBuilder.validateResource(templateRegistration.page(), element, (Annotation)templateRegistration, "page", true);
            string = templateRegistration.page();
        }
        catch (LayerGenerationException layerGenerationException) {
            string = LayerBuilder.absolutizeResource((Element)element, (String)templateRegistration.page());
        }
        layerBuilder.validateResource(string, element, (Annotation)templateRegistration, "page", true);
        file.stringvalue("page", string);
        if (element.getKind() != ElementKind.METHOD) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "page() attribute can be used only on static method", element);
            return;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        if (!executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "page() attribute can be used only on static method", element);
            return;
        }
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement("java.lang.String");
        if (!this.processingEnv.getTypeUtils().isSameType(typeElement.asType(), executableElement.getReturnType()) && !this.isModel(this.processingEnv.getTypeUtils().asElement(executableElement.getReturnType()))) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "page() attribute requires its method to return String or class generated by @Model annotation", element);
            return;
        }
        if (!executableElement.getParameters().isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "page() attribute requires its method to take no arguments", element);
            return;
        }
        file.methodvalue("instantiatingIterator", HTMLWizard.class.getName(), "create");
        TypeElement typeElement2 = (TypeElement)element.getEnclosingElement();
        Name name = this.processingEnv.getElementUtils().getBinaryName(typeElement2);
        file.stringvalue("class", name.toString());
        file.stringvalue("method", executableElement.getSimpleName().toString());
    }

    private boolean isModel(Element element) {
        for (Element element2 : element.getEnclosedElements()) {
            if (!"modelFor".equals(element2.getSimpleName().toString())) continue;
            return true;
        }
        return false;
    }
}

