/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.charts;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.charts.ChartComponent;
import org.graalvm.visualvm.lib.charts.ChartConfigurationListener;
import org.graalvm.visualvm.lib.charts.ChartItem;
import org.graalvm.visualvm.lib.charts.ChartSelectionListener;
import org.graalvm.visualvm.lib.charts.ChartSelectionModel;
import org.graalvm.visualvm.lib.charts.ItemPainter;
import org.graalvm.visualvm.lib.charts.ItemSelection;
import org.graalvm.visualvm.lib.charts.ItemsModel;
import org.graalvm.visualvm.lib.charts.PaintersModel;

class ChartSelectionManager
implements ChartSelectionModel {
    private ChartComponent chart;
    private ChartListener chartListener = new ChartListener();
    private MouseListener mouseListener = new MouseListener();
    private int selectionMode;
    private int moveMode;
    private int dragMode;
    private int hoverMode;
    private int hoverDistanceLimit;
    private int mouseX = -1;
    private int mouseY = -1;
    private boolean inChart = false;
    private Rectangle selectionBounds;
    private List<ItemSelection> highlightedSelection;
    private List<ItemSelection> selectedSelection;
    private boolean mousePanningBackup;
    private List<ChartSelectionListener> selectionListeners;

    ChartSelectionManager() {
        this.setMoveMode(0);
        this.setDragMode(0);
        this.setSelectionMode(this.moveMode);
        this.setHoverMode(100);
        this.setHoverDistanceLimit(-1);
    }

    void registerChart(ChartComponent chart) {
        this.unregisterListener();
        this.chart = chart;
        this.registerListener();
    }

    void unregisterChart(ChartComponent chart) {
        this.unregisterListener();
        this.chart = null;
    }

    @Override
    public final void setMoveMode(int mode) {
        this.moveMode = mode;
        if (this.selectionMode != this.moveMode) {
            this.setSelectionMode(this.moveMode);
        }
    }

    @Override
    public final int getMoveMode() {
        return this.moveMode;
    }

    @Override
    public final void setDragMode(int mode) {
        this.dragMode = mode;
    }

    @Override
    public final int getDragMode() {
        return this.dragMode;
    }

    @Override
    public final int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public final void setHoverMode(int mode) {
        this.hoverMode = mode;
        this.updateHighlightedItems();
    }

    @Override
    public final int getHoverMode() {
        return this.hoverMode;
    }

    @Override
    public final void setHoverDistanceLimit(int limit) {
        this.hoverDistanceLimit = limit;
    }

    @Override
    public final int getHoverDistanceLimit() {
        return this.hoverDistanceLimit;
    }

    public final void setSelectionBounds(int x, int y, int w, int h) {
        this.setSelectionBounds(new Rectangle(x, y, w, h));
    }

    @Override
    public final void setSelectionBounds(Rectangle selectionBounds) {
        Rectangle oldSelectionBounds;
        if (selectionBounds == null && this.selectionBounds == null) {
            return;
        }
        if (this.selectionBounds != null && this.selectionBounds.equals(selectionBounds) || selectionBounds != null && selectionBounds.equals(this.selectionBounds)) {
            return;
        }
        Rectangle rectangle = oldSelectionBounds = this.selectionBounds == null ? null : new Rectangle(this.selectionBounds);
        if (selectionBounds == null) {
            this.selectionBounds = null;
        } else if (this.selectionBounds == null) {
            this.selectionBounds = new Rectangle(selectionBounds);
        } else {
            this.selectionBounds.setBounds(selectionBounds);
        }
        this.fireSelectionBoundsChanged(this.selectionBounds, oldSelectionBounds);
    }

    @Override
    public final Rectangle getSelectionBounds() {
        return new Rectangle(this.selectionBounds);
    }

    @Override
    public final void setHighlightedItems(List<ItemSelection> items) {
        if (this.highlightedSelection == null) {
            if (items.isEmpty()) {
                return;
            }
            this.highlightedSelection = new ArrayList<ItemSelection>(items);
            this.fireHighlightedItemsChanged(items, items, Collections.emptyList());
        } else {
            ArrayList<ItemSelection> addedItems = new ArrayList<ItemSelection>();
            ArrayList<ItemSelection> removedItems = new ArrayList<ItemSelection>();
            for (ItemSelection item : items) {
                if (this.highlightedSelection.contains(item)) continue;
                addedItems.add(item);
            }
            for (ItemSelection item : this.highlightedSelection) {
                if (items.contains(item)) continue;
                removedItems.add(item);
            }
            if (addedItems.isEmpty() && removedItems.isEmpty()) {
                return;
            }
            this.highlightedSelection = new ArrayList<ItemSelection>(items);
            this.fireHighlightedItemsChanged(items, addedItems, removedItems);
        }
    }

    @Override
    public final List<ItemSelection> getHighlightedItems() {
        return this.highlightedSelection == null ? Collections.emptyList() : new ArrayList<ItemSelection>(this.highlightedSelection);
    }

    @Override
    public final void setSelectedItems(List<ItemSelection> items) {
        if (this.selectedSelection == null) {
            if (items.isEmpty()) {
                return;
            }
            this.selectedSelection = new ArrayList<ItemSelection>(items);
            this.fireSelectedItemsChanged(items, items, Collections.emptyList());
        } else {
            ArrayList<ItemSelection> addedItems = new ArrayList<ItemSelection>();
            ArrayList<ItemSelection> removedItems = new ArrayList<ItemSelection>();
            for (ItemSelection item : items) {
                if (this.selectedSelection.contains(item)) continue;
                addedItems.add(item);
            }
            for (ItemSelection item : this.selectedSelection) {
                if (items.contains(item)) continue;
                removedItems.add(item);
            }
            if (addedItems.isEmpty() && removedItems.isEmpty()) {
                return;
            }
            this.selectedSelection = new ArrayList<ItemSelection>(items);
            this.fireSelectedItemsChanged(items, addedItems, removedItems);
        }
    }

    @Override
    public final List<ItemSelection> getSelectedItems() {
        return this.selectedSelection == null ? Collections.emptyList() : new ArrayList<ItemSelection>(this.selectedSelection);
    }

    @Override
    public final void addSelectionListener(ChartSelectionListener listener) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<ChartSelectionListener>();
        }
        this.selectionListeners.add(listener);
    }

    @Override
    public final void removeSelectionListener(ChartSelectionListener listener) {
        if (this.selectionListeners == null) {
            return;
        }
        this.selectionListeners.remove(listener);
    }

    private void setSelectionMode(int selectionMode) {
        if (this.selectionMode == selectionMode) {
            return;
        }
        int oldSelectionMode = this.selectionMode;
        this.selectionMode = selectionMode;
        this.fireSelectionModeChanged(this.selectionMode, oldSelectionMode);
    }

    private void registerListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.addMouseListener(this.mouseListener);
        this.chart.addMouseMotionListener(this.mouseListener);
        this.chart.addConfigurationListener(this.chartListener);
    }

    private void unregisterListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.removeMouseListener(this.mouseListener);
        this.chart.removeMouseMotionListener(this.mouseListener);
        this.chart.removeConfigurationListener(this.chartListener);
    }

    private void updateHighlightedItems() {
        final int x = this.mouseX;
        final int y = this.mouseY;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ChartSelectionManager.this.hoverMode == 100 || !ChartSelectionManager.this.inChart) {
                    ChartSelectionManager.this.setHighlightedItems(Collections.emptyList());
                    return;
                }
                ItemsModel itemsModel = ChartSelectionManager.this.chart.getItemsModel();
                PaintersModel paintersModel = ChartSelectionManager.this.chart.getPaintersModel();
                int itemsCount = itemsModel.getItemsCount();
                ArrayList<ItemSelection> closestSelection = new ArrayList<ItemSelection>(itemsCount);
                for (int i = 0; i < itemsCount; ++i) {
                    ChartItem item = itemsModel.getItem(i);
                    ItemPainter painter = paintersModel.getPainter(item);
                    ItemSelection selection = painter.getClosestSelection(item, x, y, ChartSelectionManager.this.chart.getChartContext());
                    if (selection == null) continue;
                    int distance = selection.getDistance();
                    if (ChartSelectionManager.this.hoverMode == 102 || closestSelection.isEmpty()) {
                        if (ChartSelectionManager.this.hoverDistanceLimit != -1 && distance > ChartSelectionManager.this.hoverDistanceLimit) continue;
                        closestSelection.add(selection);
                        continue;
                    }
                    if (((ItemSelection)closestSelection.get(0)).getDistance() <= distance || ChartSelectionManager.this.hoverDistanceLimit != -1 && distance > ChartSelectionManager.this.hoverDistanceLimit) continue;
                    closestSelection.set(0, selection);
                }
                ChartSelectionManager.this.setHighlightedItems(closestSelection);
            }
        });
    }

    private void fireSelectionModeChanged(int newMode, int oldMode) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener listener : this.selectionListeners) {
            listener.selectionModeChanged(newMode, oldMode);
        }
    }

    private void fireSelectionBoundsChanged(Rectangle newBounds, Rectangle oldBounds) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener listener : this.selectionListeners) {
            listener.selectionBoundsChanged(newBounds, oldBounds);
        }
    }

    private void fireHighlightedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener listener : this.selectionListeners) {
            listener.highlightedItemsChanged(currentItems, addedItems, removedItems);
        }
    }

    private void fireSelectedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener listener : this.selectionListeners) {
            listener.selectedItemsChanged(currentItems, addedItems, removedItems);
        }
    }

    private class MouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private MouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ChartSelectionManager.this.mousePanningBackup = ChartSelectionManager.this.chart.isMousePanningEnabled();
            ChartSelectionManager.this.setSelectionMode(ChartSelectionManager.this.dragMode);
            if (ChartSelectionManager.this.selectionMode != 0) {
                ChartSelectionManager.this.chart.disableMousePanning();
                ChartSelectionManager.this.setSelectionBounds(e.getX(), e.getY(), 0, 0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ChartSelectionManager.this.setSelectionBounds(null);
            ChartSelectionManager.this.setSelectionMode(ChartSelectionManager.this.moveMode);
            if (ChartSelectionManager.this.selectionMode == 0) {
                ChartSelectionManager.this.chart.setMousePanningEnabled(ChartSelectionManager.this.mousePanningBackup);
            }
            if (ChartSelectionManager.this.selectionMode != 0) {
                ChartSelectionManager.this.setSelectionBounds(e.getX(), e.getY(), 0, 0);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ChartSelectionManager.this.inChart = true;
            ChartSelectionManager.this.mouseX = e.getX();
            ChartSelectionManager.this.mouseY = e.getY();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ChartSelectionManager.this.inChart = false;
            if (ChartSelectionManager.this.selectionMode == 1 || ChartSelectionManager.this.selectionMode == 2 || ChartSelectionManager.this.selectionMode == 3) {
                ChartSelectionManager.this.setSelectionBounds(null);
            }
            ChartSelectionManager.this.updateHighlightedItems();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (ChartSelectionManager.this.selectionMode == 4) {
                ChartSelectionManager.this.setSelectionBounds(((ChartSelectionManager)ChartSelectionManager.this).selectionBounds.x, ((ChartSelectionManager)ChartSelectionManager.this).selectionBounds.y, e.getX() - ((ChartSelectionManager)ChartSelectionManager.this).selectionBounds.x, e.getY() - ((ChartSelectionManager)ChartSelectionManager.this).selectionBounds.y);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ChartSelectionManager.this.mouseX = e.getX();
            ChartSelectionManager.this.mouseY = e.getY();
            if (ChartSelectionManager.this.selectionMode == 0) {
                ChartSelectionManager.this.setSelectionBounds(null);
            } else {
                ChartSelectionManager.this.setSelectionBounds(ChartSelectionManager.this.mouseX, ChartSelectionManager.this.mouseY, 0, 0);
            }
            ChartSelectionManager.this.updateHighlightedItems();
        }
    }

    private class ChartListener
    extends ChartConfigurationListener.Adapter {
        private ChartListener() {
        }

        @Override
        public void contentsWillBeUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY) {
            ChartSelectionManager.this.updateHighlightedItems();
        }
    }
}

