// Code generated by go-swagger; DO NOT EDIT.

package service_accounts

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeleteServiceAccountReader is a Reader for the DeleteServiceAccount structure.
type DeleteServiceAccountReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteServiceAccountReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteServiceAccountOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteServiceAccountBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewDeleteServiceAccountUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteServiceAccountForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteServiceAccountInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /serviceaccounts/{serviceAccountId}] deleteServiceAccount", response, response.Code())
	}
}

// NewDeleteServiceAccountOK creates a DeleteServiceAccountOK with default headers values
func NewDeleteServiceAccountOK() *DeleteServiceAccountOK {
	return &DeleteServiceAccountOK{}
}

/*
DeleteServiceAccountOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type DeleteServiceAccountOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this delete service account Ok response has a 2xx status code
func (o *DeleteServiceAccountOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete service account Ok response has a 3xx status code
func (o *DeleteServiceAccountOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete service account Ok response has a 4xx status code
func (o *DeleteServiceAccountOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete service account Ok response has a 5xx status code
func (o *DeleteServiceAccountOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete service account Ok response a status code equal to that given
func (o *DeleteServiceAccountOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete service account Ok response
func (o *DeleteServiceAccountOK) Code() int {
	return 200
}

func (o *DeleteServiceAccountOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /serviceaccounts/{serviceAccountId}][%d] deleteServiceAccountOk %s", 200, payload)
}

func (o *DeleteServiceAccountOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /serviceaccounts/{serviceAccountId}][%d] deleteServiceAccountOk %s", 200, payload)
}

func (o *DeleteServiceAccountOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *DeleteServiceAccountOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteServiceAccountBadRequest creates a DeleteServiceAccountBadRequest with default headers values
func NewDeleteServiceAccountBadRequest() *DeleteServiceAccountBadRequest {
	return &DeleteServiceAccountBadRequest{}
}

/*
DeleteServiceAccountBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type DeleteServiceAccountBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete service account bad request response has a 2xx status code
func (o *DeleteServiceAccountBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete service account bad request response has a 3xx status code
func (o *DeleteServiceAccountBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete service account bad request response has a 4xx status code
func (o *DeleteServiceAccountBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete service account bad request response has a 5xx status code
func (o *DeleteServiceAccountBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete service account bad request response a status code equal to that given
func (o *DeleteServiceAccountBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete service account bad request response
func (o *DeleteServiceAccountBadRequest) Code() int {
	return 400
}

func (o *DeleteServiceAccountBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /serviceaccounts/{serviceAccountId}][%d] deleteServiceAccountBadRequest %s", 400, payload)
}

func (o *DeleteServiceAccountBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /serviceaccounts/{serviceAccountId}][%d] deleteServiceAccountBadRequest %s", 400, payload)
}

func (o *DeleteServiceAccountBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteServiceAccountBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteServiceAccountUnauthorized creates a DeleteServiceAccountUnauthorized with default headers values
func NewDeleteServiceAccountUnauthorized() *DeleteServiceAccountUnauthorized {
	return &DeleteServiceAccountUnauthorized{}
}

/*
DeleteServiceAccountUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type DeleteServiceAccountUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete service account unauthorized response has a 2xx status code
func (o *DeleteServiceAccountUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete service account unauthorized response has a 3xx status code
func (o *DeleteServiceAccountUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete service account unauthorized response has a 4xx status code
func (o *DeleteServiceAccountUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete service account unauthorized response has a 5xx status code
func (o *DeleteServiceAccountUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete service account unauthorized response a status code equal to that given
func (o *DeleteServiceAccountUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete service account unauthorized response
func (o *DeleteServiceAccountUnauthorized) Code() int {
	return 401
}

func (o *DeleteServiceAccountUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /serviceaccounts/{serviceAccountId}][%d] deleteServiceAccountUnauthorized %s", 401, payload)
}

func (o *DeleteServiceAccountUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /serviceaccounts/{serviceAccountId}][%d] deleteServiceAccountUnauthorized %s", 401, payload)
}

func (o *DeleteServiceAccountUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteServiceAccountUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteServiceAccountForbidden creates a DeleteServiceAccountForbidden with default headers values
func NewDeleteServiceAccountForbidden() *DeleteServiceAccountForbidden {
	return &DeleteServiceAccountForbidden{}
}

/*
DeleteServiceAccountForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type DeleteServiceAccountForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete service account forbidden response has a 2xx status code
func (o *DeleteServiceAccountForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete service account forbidden response has a 3xx status code
func (o *DeleteServiceAccountForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete service account forbidden response has a 4xx status code
func (o *DeleteServiceAccountForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete service account forbidden response has a 5xx status code
func (o *DeleteServiceAccountForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete service account forbidden response a status code equal to that given
func (o *DeleteServiceAccountForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete service account forbidden response
func (o *DeleteServiceAccountForbidden) Code() int {
	return 403
}

func (o *DeleteServiceAccountForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /serviceaccounts/{serviceAccountId}][%d] deleteServiceAccountForbidden %s", 403, payload)
}

func (o *DeleteServiceAccountForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /serviceaccounts/{serviceAccountId}][%d] deleteServiceAccountForbidden %s", 403, payload)
}

func (o *DeleteServiceAccountForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteServiceAccountForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteServiceAccountInternalServerError creates a DeleteServiceAccountInternalServerError with default headers values
func NewDeleteServiceAccountInternalServerError() *DeleteServiceAccountInternalServerError {
	return &DeleteServiceAccountInternalServerError{}
}

/*
DeleteServiceAccountInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type DeleteServiceAccountInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete service account internal server error response has a 2xx status code
func (o *DeleteServiceAccountInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete service account internal server error response has a 3xx status code
func (o *DeleteServiceAccountInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete service account internal server error response has a 4xx status code
func (o *DeleteServiceAccountInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete service account internal server error response has a 5xx status code
func (o *DeleteServiceAccountInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete service account internal server error response a status code equal to that given
func (o *DeleteServiceAccountInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete service account internal server error response
func (o *DeleteServiceAccountInternalServerError) Code() int {
	return 500
}

func (o *DeleteServiceAccountInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /serviceaccounts/{serviceAccountId}][%d] deleteServiceAccountInternalServerError %s", 500, payload)
}

func (o *DeleteServiceAccountInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /serviceaccounts/{serviceAccountId}][%d] deleteServiceAccountInternalServerError %s", 500, payload)
}

func (o *DeleteServiceAccountInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteServiceAccountInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
