// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// OrgUserDTO org user DTO
//
// swagger:model OrgUserDTO
type OrgUserDTO struct {

	// access control
	AccessControl map[string]bool `json:"accessControl,omitempty"`

	// auth labels
	AuthLabels []string `json:"authLabels"`

	// avatar Url
	AvatarURL string `json:"avatarUrl,omitempty"`

	// email
	Email string `json:"email,omitempty"`

	// is disabled
	IsDisabled bool `json:"isDisabled,omitempty"`

	// is externally synced
	IsExternallySynced bool `json:"isExternallySynced,omitempty"`

	// last seen at
	// Format: date-time
	LastSeenAt strfmt.DateTime `json:"lastSeenAt,omitempty"`

	// last seen at age
	LastSeenAtAge string `json:"lastSeenAtAge,omitempty"`

	// login
	Login string `json:"login,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// org Id
	OrgID int64 `json:"orgId,omitempty"`

	// role
	Role string `json:"role,omitempty"`

	// uid
	UID string `json:"uid,omitempty"`

	// user Id
	UserID int64 `json:"userId,omitempty"`
}

// Validate validates this org user DTO
func (m *OrgUserDTO) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLastSeenAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OrgUserDTO) validateLastSeenAt(formats strfmt.Registry) error {
	if swag.IsZero(m.LastSeenAt) { // not required
		return nil
	}

	if err := validate.FormatOf("lastSeenAt", "body", "date-time", m.LastSeenAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this org user DTO based on context it is used
func (m *OrgUserDTO) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OrgUserDTO) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OrgUserDTO) UnmarshalBinary(b []byte) error {
	var res OrgUserDTO
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
