// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetRoleReader is a Reader for the GetRole structure.
type GetRoleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetRoleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetRoleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetRoleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetRoleInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /access-control/roles/{roleUID}] getRole", response, response.Code())
	}
}

// NewGetRoleOK creates a GetRoleOK with default headers values
func NewGetRoleOK() *GetRoleOK {
	return &GetRoleOK{}
}

/*
GetRoleOK describes a response with status code 200, with default header values.

(empty)
*/
type GetRoleOK struct {
	Payload *models.RoleDTO
}

// IsSuccess returns true when this get role Ok response has a 2xx status code
func (o *GetRoleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get role Ok response has a 3xx status code
func (o *GetRoleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get role Ok response has a 4xx status code
func (o *GetRoleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get role Ok response has a 5xx status code
func (o *GetRoleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get role Ok response a status code equal to that given
func (o *GetRoleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get role Ok response
func (o *GetRoleOK) Code() int {
	return 200
}

func (o *GetRoleOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/roles/{roleUID}][%d] getRoleOk %s", 200, payload)
}

func (o *GetRoleOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/roles/{roleUID}][%d] getRoleOk %s", 200, payload)
}

func (o *GetRoleOK) GetPayload() *models.RoleDTO {
	return o.Payload
}

func (o *GetRoleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RoleDTO)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRoleForbidden creates a GetRoleForbidden with default headers values
func NewGetRoleForbidden() *GetRoleForbidden {
	return &GetRoleForbidden{}
}

/*
GetRoleForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetRoleForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get role forbidden response has a 2xx status code
func (o *GetRoleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get role forbidden response has a 3xx status code
func (o *GetRoleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get role forbidden response has a 4xx status code
func (o *GetRoleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get role forbidden response has a 5xx status code
func (o *GetRoleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get role forbidden response a status code equal to that given
func (o *GetRoleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get role forbidden response
func (o *GetRoleForbidden) Code() int {
	return 403
}

func (o *GetRoleForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/roles/{roleUID}][%d] getRoleForbidden %s", 403, payload)
}

func (o *GetRoleForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/roles/{roleUID}][%d] getRoleForbidden %s", 403, payload)
}

func (o *GetRoleForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetRoleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRoleInternalServerError creates a GetRoleInternalServerError with default headers values
func NewGetRoleInternalServerError() *GetRoleInternalServerError {
	return &GetRoleInternalServerError{}
}

/*
GetRoleInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetRoleInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get role internal server error response has a 2xx status code
func (o *GetRoleInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get role internal server error response has a 3xx status code
func (o *GetRoleInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get role internal server error response has a 4xx status code
func (o *GetRoleInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get role internal server error response has a 5xx status code
func (o *GetRoleInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get role internal server error response a status code equal to that given
func (o *GetRoleInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get role internal server error response
func (o *GetRoleInternalServerError) Code() int {
	return 500
}

func (o *GetRoleInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/roles/{roleUID}][%d] getRoleInternalServerError %s", 500, payload)
}

func (o *GetRoleInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/roles/{roleUID}][%d] getRoleInternalServerError %s", 500, payload)
}

func (o *GetRoleInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetRoleInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
